/* System-dependent definitions of various files, spool directories, etc */

#if (defined(LATTICE) || defined(MAC) || defined(ATARI) )
/* These compilers require special open modes when reading binary files
 * 
 * "The single most brilliant design decision in all of UNIX was the
 * choice of a SINGLE character as the end-of-line indicator" -- M. O'Dell
 *
 * "Whoever picked the end-of-line conventions for MS-DOS and the Macintosh
 * should be shot!" -- P. Karn's corollary to O'Dells' declaration
 *
 * Index definitions for this array are in global.h
 */
char *binmode[] = {
        "rb",   /* Read binary */
        "wb"    /* Write binary */
};
#else
/* fopen modes for binary files under Aztec -- same as UNIX */
char *binmode[] = {
        "r",    /* Read */
        "w"     /* Write */
};
#endif

char *startupname = "autoexec.net";    /* Initialization file */
char startup[128];
char *userfilename = "ftpusers";       /* Authorized FTP users and passwords */
char userfile[128];
char *hostsname = "hosts.net";         /* Network host table */
char hosts[128];
#ifdef SMTP
char mailspool[] = "\\spool\\mail\\";   /* Incoming mail */
char mailqdir[] = "\\spool\\mqueue\\";          /* Outgoing mail spool */
char mailqueue[] = "\\spool\\mqueue\\*.wrk";    /* Outgoing mail work files */
char baddir[] = "\\spool\\badjobs\\";           /* Undeliverable jobs */
#endif

