/* FTP client (interactive user) code */

/* Changes:
 *
 * Herbert Thielen @ LPR
 * 20 Feb 91  HT1  dotype checks now 2nd arg of 'type l ...'
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <tos.h>
#include "main.h"
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "icmp.h"
#include "ip.h"
#include "iface.h"
#include "atari.h"
#include "timer.h"
#include "tcp.h"
#include "ftp.h"
#include "session.h"
#include "cmdparse.h"
#include "ftpcli.h"

#define l_tmpnam 30

extern struct session *current;
extern char nospace[];
extern char badhost[];
extern char startup[];
static char notsess[] = "Not an FTP session!\n";
static char cantwrite[] = "Can't write %s\n";
static char cantread[] = "Can't read %s\n";
char fprompt[] = "ftp> ";

static FILE *mp_dat[16]; /* 16 Pointer auf Files mit Eingabedaten fr mput */
int mput_state = 0;
int p_num = 0;         /* Parameter Nummer mit Null initieren */
#define MPUT_PASSIV 0
#define MPUT_AKTIV 1
#define MPUT_DONE  2

char *mget_masks[10];
static FILE *mg_dir, *mg_get;
char dir_name[l_tmpnam], get_name[l_tmpnam];
int mget_state = 0;
int anz_masks;
#define MGET_PASSIV 0
#define MGET_GETDIR 1
#define MGET_GETDIR_AKTIV 2
#define MGET_AKTIV 3
#define MGET_DONE 4
#define MGET_ERROR 5

int logflag = 0;

struct cmds ftpabort[] = {
        "abort",     doabort, 0, NULLCHAR, NULLCHAR, 0,
        NULLCHAR,    NULLFP,  0, "Only valid command is \"abort\"", NULLCHAR, 0
};

struct cmds ftpcmds[] = {
        "",             donothing,      0,      NULLCHAR,               NULLCHAR,       0,
        "cd",           doftpcd,        2,      "usage: cd <directory>",        NULLCHAR,       0,
        "dir",          dolist,         0,      NULLCHAR,               NULLCHAR,       0,
        "get",          doget,          2,      "usage: get remotefile <localfile>",    NULLCHAR,       0,
        "lcd",          docd,           0,      NULLCHAR,    NULLCHAR,       0,
        "ldir",         dodir,          0,      NULLCHAR,    NULLCHAR,       0,
        "lhelp",        dolhelp,        0,      NULLCHAR,               NULLCHAR,       0,
        "lpwd",         docd,           0,      NULLCHAR,    NULLCHAR,       0,
        "ls",           dols,           0,      NULLCHAR,               NULLCHAR,       0,
        "mget",         domget,         2,  " mget <file>[<file> .. ]",  "mget fails",    0,
        "mkdir",        domkdir,        2,  " mkdir <directory>",     NULLCHAR,       0,
        "mput",         domput,         2,  " mput <file>[<file> .. ]",  "mput fails",    0,
        "nlst",         dols,           0,      NULLCHAR,               NULLCHAR,       0,
        "put",          doput,          2,      " put localfile <remotefile>",    NULLCHAR,       0,
        "rmdir",        dormdir,        2,      " rmdir <directory>",     NULLCHAR,       0,
        "type",         dotype,         0,      NULLCHAR,               NULLCHAR,       0,
        "?",            dolhelp,        0,      NULLCHAR,               NULLCHAR,       0,
        NULLCHAR,       NULLFP,         0,      NULLCHAR,               NULLCHAR,       0
};

/* Handle top-level FTP command */
int 
doftp(int argc,char *argv[])
{
        struct session *s;
        struct ftp *ftp;
        struct tcb *tcb;
        struct socket lsocket,fsocket;

        lsocket.address = ip_addr;
        lsocket.port = lport++;
        if((fsocket.address = resolve(argv[1])) == 0){
                printf(badhost,argv[1]);
                return 1;
        }
        if(argc < 3)
                fsocket.port = FTP_PORT;
        else
                fsocket.port = atoi(argv[2]);

        /* Allocate a session control block */
        if((s = newsession()) == NULLSESSION){
                printf("Too many sessions\n");
                return 1;
        }
        current = s;
        if((s->name = malloc((unsigned)strlen(argv[1])+1)) != NULLCHAR)
                strcpy(s->name,argv[1]);
        s->type = FTP;
        s->parse = ftpparse;

        /* Allocate an FTP control block */
        if((ftp = ftp_create(0)) == NULLFTP){ /* neue Session anlegen  */
                s->type = FREE;   /* Pech kein Platz fr neue Session */
                printf(nospace);
                return 1;
        }
        ftp->state = COMMAND_STATE;
        s->cb.ftp = ftp;        /* Downward link */
        ftp->session = s;       /* Upward link */

        /* Now open the control connection */
        tcb = open_tcp(&lsocket,&fsocket,TCP_ACTIVE,
                0,ftpccr,NULLVFP,ftpccs,0,(char *)ftp);
        ftp->control = tcb;
        go(0,(char**)0);

		/* ergnzt 10/94 MR */
		ftp->type = IMAGE_TYPE;
        sndftpmsg(ftp,"TYPE I\r\n","");

        return 0;
}




/* Parse user FTP commands */
int
ftpparse(char *line,int16 len)
{
        struct mbuf *bp;
        char *d_p;
        int leng;

        if(current->cb.ftp->state != COMMAND_STATE){
                /* The only command allowed in data transfer state is ABORT */
                if(cmdparse(ftpabort,line) == -1){
                  printf("Transfer in progress; only ABORT is acceptable\n");
                  printf(fprompt,1); 
                }
                fflush(stdout);
                return 0;
        }

        /* Save it now because cmdparse modifies the original */
        if(logflag){
                leng = len + 5;
                bp = alloc_mbuf(leng);
                d_p = bp->data;
                switch(logflag){
                case 1:
                case 3:
                        memcpy(d_p, "user ", 5);
                        break;
                case 2:
                        memcpy(d_p, "pass ", 5);
                        break;
                }
                d_p += 5;
                memcpy(d_p, line, len);
                bp->cnt =leng;
        }
        else {
                bp = qdata(line,len);
        }

        if( logflag){
                if( bp != NULLBUF)
                        send_tcp( current->cb.ftp->control, bp);
                else {
                        printf(nospace);
                        printf(fprompt,2);
                }
        }
        else{
                if(cmdparse(ftpcmds,line) == -1){
                        /* Send it direct */
                        if(bp != NULLBUF)
                                send_tcp(current->cb.ftp->control,bp);
                        else {
                                printf(nospace);
                                printf(fprompt,3);
                        }
                } else {
                        free_p(bp);
                }
        }
        fflush(stdout);
		return 0;
}
/* Handle null line to avoid trapping on first command in table */
static 
int 
donothing(int argc,char *argv[])
{
        if( current->cb.ftp->state == COMMAND_STATE)
                printf(fprompt,4);
        return 0;
}

/* local help */
int 
dolhelp()
{
        register struct cmds *cmdp;
        int i, j;

        printf("ftp commands:\n");
        for(i=0, cmdp=ftpcmds; cmdp->name != NULL; cmdp++, i++){
                printf("%s",cmdp->name);
                if((i % 4) == 3)
                        printf("\n");
                else {
                        for(j=(int)strlen(cmdp->name);j < 16; j++)
                                putchar(' ');
                }
        }
        if((i % 4) != 0) {
                printf("\n");
                printf(fprompt,5);
        }
        return 0;
}

/* Translate 'cd' to 'cwd' for convenience */
static 
int 
doftpcd(int argc,char *argv[])
{
        register struct ftp *ftp;

        ftp = current->cb.ftp;
        return sndftpmsg(ftp,"CWD %s\r\n",argv[1]);
}

/* Translate 'mkdir' to 'xmkd' for convenience */
static 
int 
domkdir(int argc,char *argv[])
{
        register struct ftp *ftp;

        ftp = current->cb.ftp;
        return sndftpmsg(ftp,"XMKD %s\r\n",argv[1]);
}

/* Translate 'rmdir' to 'xrmd' for convenience */
static
int
dormdir(int argc,char *argv[])
{
        register struct ftp *ftp;

        ftp = current->cb.ftp;
        return sndftpmsg(ftp,"XRMD %s\r\n",argv[1]);
}

/* Handle "type" command from user */
static
int
dotype(int argc,char *argv[])
{
        register struct ftp *ftp;

        ftp = current->cb.ftp;
        if(argc < 2){
                switch(ftp->type){
                case IMAGE_TYPE:
                        printf("Image\n");
                        break;
                case ASCII_TYPE:
                        printf("Ascii\n");
                        break;
                }
                printf(fprompt,6);
                fflush(stdout);
                return 0;
        }
        switch(*argv[1]){
        case 'i':
        case 'b':
                ftp->type = IMAGE_TYPE;
                sndftpmsg(ftp,"TYPE I\r\n","");
                break;
        case 'a':
                ftp->type = ASCII_TYPE;
                sndftpmsg(ftp,"TYPE A\r\n","");
                break;
        case 'l':
                ftp->type = IMAGE_TYPE;
                                               /* HT1 */
                sndftpmsg(ftp,"TYPE L %s\r\n",(argc==3) ? argv[2] : "8");
                break;
        default:
                printf("Invalid type %s\n",argv[1]);
                printf(fprompt,8);
                return 1;
        }
        return 0;
}

/* Start receive transfer. Syntax: get <remote name> [<local name>] */
static
doget(int argc,char *argv[])
{
        char *remotename,*localname;
        register struct ftp *ftp;
        char *mode;

        ftp = current->cb.ftp;
        if(ftp == NULLFTP){
                printf(notsess);
                printf(fprompt,9);
                return 1;
        }
        remotename = argv[1];
        if(argc < 3)
                localname = remotename;
        else
                localname = argv[2];

        if((ftp->fp != NULLFILE) && (ftp->fp != stdout))
                fclose(ftp->fp);
        ftp->fp = NULLFILE;

        if(ftp->type == IMAGE_TYPE)
                mode = binmode[WRITE_BINARY];
        else
                mode = "w";

        if ( ! strcmp (localname, "stdout") )
                ftp->fp = stdout;
        else
                if ( (ftp->fp = fopen(localname, mode)) == NULLFILE )
                {
                        printf(cantwrite,localname);
                        printf(fprompt,10);
                        return 1;
                }

        ftp->state = RECEIVING_STATE;
        ftpsetup(ftp,ftpdr,NULLVFP,ftpcds);

        /* Generate the command to start the transfer */
        return sndftpmsg(ftp,"RETR %s\r\n",remotename);
}

/* List remote directory. Syntax: dir <remote directory/file> [<local name>] */
static
dolist(int argc,char *argv[])
{
        register struct ftp *ftp;

        ftp = current->cb.ftp;
        if(ftp == NULLFTP){
                printf(notsess);
                printf(fprompt,11);
                return 1;
        }
        if((ftp->fp != NULLFILE) && (ftp->fp != stdout))
                fclose(ftp->fp);
        ftp->fp = NULLFILE;

        if(argc < 3){
                ftp->fp = stdout;
        } else if((ftp->fp = fopen(argv[2],"w")) == NULLFILE){
                printf(cantwrite,argv[2]);
                printf(fprompt,12);
                return 1;
        }
        ftp->state = RECEIVING_STATE;
        ftpsetup(ftp,ftpdr,NULLVFP,ftpcds);
        /* Generate the command to start the transfer
         * It's done this way to avoid confusing the 4.2 FTP server
         * if there's no argument
         */
        if(argc > 1)
                return sndftpmsg(ftp,"LIST %s\r\n",argv[1]);
        else
                return sndftpmsg(ftp,"LIST\r\n","");
}

/* Abbreviated (name only) list of remote directory.
 * Syntax: ls <remote directory/file> [<local name>] */
static
dols(int argc,char *argv[])
{
        register struct ftp *ftp;

        ftp = current->cb.ftp;
        if(ftp == NULLFTP){
                printf(notsess);
                printf(fprompt,13);
                return 1;
        }
        if((ftp->fp != NULLFILE) && (ftp->fp != stdout))
                fclose(ftp->fp);
        ftp->fp = NULLFILE;

        if(argc < 3){
                ftp->fp = stdout;
        } else if((ftp->fp = fopen(argv[2],"w")) == NULLFILE){
                printf(cantwrite,argv[2]);
                printf(fprompt,14);
                return 1;
        }
        ftp->state = RECEIVING_STATE;
        ftpsetup(ftp,ftpdr,NULLVFP,ftpcds);
        /* Generate the command to start the transfer */
        if(argc > 1)
                return sndftpmsg(ftp,"NLST %s\r\n",argv[1]);
        else
                return sndftpmsg(ftp,"NLST\r\n","");
}

/* Start transmit. Syntax: put <local name> [<remote name>] */
static
int
doput(int argc,char *argv[])
{
        char *remotename,*localname;
        char *mode;
        struct ftp *ftp;

        if((ftp = current->cb.ftp) == NULLFTP){
                printf(notsess);
                printf(fprompt,15);
                return 1;
        }
        localname = argv[1];

        if(argc < 3)
                remotename = localname;
        else
                remotename = argv[2];

        if((ftp->fp != NULLFILE) && (ftp->fp != stdout))
                fclose(ftp->fp);

        if(ftp->type == IMAGE_TYPE)
                mode = binmode[READ_BINARY];
        else
                mode = "r";

        if((ftp->fp = fopen(localname,mode)) == NULLFILE){
                printf(cantread,localname);
                if(mput_state==MPUT_PASSIV) printf(fprompt,16);
                return 1;
        }
        ftp->state = SENDING_STATE;
        ftpsetup(ftp,NULLVFP,ftpdt,ftpcds);

        /* Generate the command to start the transfer */
        return sndftpmsg(ftp,"STOR %s\r\n",remotename);
}

/* Abort a GET or PUT operation in progress. Note: this will leave
 * the partial file on the local or remote system */
int
doabort(int argc,char *argv[])
{
        register struct ftp *ftp;

        ftp = current->cb.ftp;

        /* Close the local file */
        if((ftp->fp != NULLFILE) && (ftp->fp != stdout))
                fclose(ftp->fp);
        ftp->fp = NULLFILE;

        switch(ftp->state){
        case SENDING_STATE:
                /* Send a premature EOF.
                 * Unfortunately we can't just reset the connection
                 * since the remote side might end up waiting forever
                 * for us to send something.
                 */
                close_tcp(ftp->data);
                p_num=0;    /* p_num auch zurcksetzen */
                mput_state = MPUT_PASSIV;
                printf("Put aborted\n");
                printf(fprompt,17);
                break;
        case RECEIVING_STATE:
                /* Just exterminate the data channel TCB; this will
                 * generate a RST on the next data packet which will
                 * abort the sender
                 */
                del_tcp(ftp->data);
                ftp->data = NULLTCB;
                printf("Get aborted\n");
                printf(fprompt,18);
                break;
        }
        ftp->state = COMMAND_STATE;
        fflush(stdout);
		return 0;
}

/* create data port, and send PORT message */
static void 
ftpsetup(struct ftp *ftp,
					 void (*recv)(struct tcb *tcb,int16 cnt),
					 void (*send)(struct tcb *tcb,int16 cnt),
					 void (*state)(struct tcb *tcb,char old,char new))
{
        struct socket lsocket;
        struct mbuf *bp;

        lsocket.address = ip_addr;
        lsocket.port = lport++;

        /* Compose and send PORT a,a,a,a,p,p message */

        if((bp = alloc_mbuf(35)) == NULLBUF){   /* 5 more than worst case */
                printf(nospace);
                printf(fprompt,19);
                return;
        }
        /* I know, this looks gross, but it works! */
        sprintf(bp->data,"PORT %u,%u,%u,%u,%u,%u\r\n",
                hibyte(hiword(lsocket.address)),
                lobyte(hiword(lsocket.address)),
                hibyte(loword(lsocket.address)),
                lobyte(loword(lsocket.address)),
                hibyte(lsocket.port),
                lobyte(lsocket.port));
        bp->cnt = strlen(bp->data);
        send_tcp(ftp->control,bp);

        /* Post a listen on the data connection */
        ftp->data = open_tcp(&lsocket,NULLSOCK,TCP_PASSIVE,0,
                recv,send,state,0,(char *)ftp);
}

/* FTP Client Control channel Receiver upcall routine */
void
ftpccr(register struct tcb *tcb,int16 cnt)
{
        struct mbuf *bp;
        struct ftp *ftp;
        char nu[4];
        int number = 0;

        if((ftp = (struct ftp *)tcb->user) == NULLFTP){
                /* Unknown connection; kill it */
                close_tcp(tcb);
                return;
        }
        /* Hold output if we're not the current session */
        if((mode != CONV_MODE) || (current == NULLSESSION) || (current->cb.ftp != ftp))
                return;

        if(recv_tcp(tcb,&bp,cnt) > 0){
                while(bp != NULLBUF){
/*try*/
                        number = 0;
                        if(bp->data[3] == '-') number = -1;
                        if(bp->data[3] == ' '){
                                memcpy(nu, bp->data, 3);
                                nu[3] = '\0';
                                number = atoi(nu);
                                switch(number){
                                case 220:
/* bitte einloggen */                   fwrite(bp->data,1,(unsigned)bp->cnt,stdout);
/* logflag globale */                   logflag = 1;
/* Variable mit    */                   break;
/* default 0       */           case 331:
                                case 530:
/* bitte Password */                    logflag = 2;
                                        break;
                                case 503:
/* login incorrect */                   logflag = 3;
                                        break;
                                case 230:
/* login scheint korrekt */             logflag = 0;
                                        break;
                                }
                        }
                        switch(logflag){
/* number =503 */       case 3:
                                printf("login incorrect\n");
/* number =220 */       case 1:
                                printf("login: ");
                                break;
/* number =331,530 */   case 2:
                                printf("Password: ");
                                break;
/* number =230 */       default:
/* oder sonstwas */             switch(number){
                                case 226:
                                        break;
                                case -1:
                                case 221:
                                        fwrite(bp->data,1,(unsigned)bp->cnt,stdout);
                                        break;
                                default:
                                        fwrite(bp->data,1,(unsigned)bp->cnt,stdout);
                                        if(current->cb.ftp->state == COMMAND_STATE)
                                                printf(fprompt, 26);
                                }
                        }
/*end try*/
                        bp = free_mbuf(bp);
                }
                fflush(stdout);                
        }
}

/* FTP Client Control channel State change upcall routine */
void
ftpccs(register struct tcb *tcb,char old,char new)
{
        struct ftp *ftp;
        char notify = 0;
        extern char *tcpstates[];
        extern char *reasons[];
        extern char *unreach[];
        extern char *exceed[];

        /* Can't add a check for unknown connection here, it would loop
         * on a close upcall! We're just careful later on.
         */
        ftp = (struct ftp *)tcb->user;

        if((current != NULLSESSION) && (current->cb.ftp == ftp))
                notify = 1;

        switch(new){
        case CLOSE_WAIT:
                if(notify)
                        printf("%s\n",tcpstates[new]);
                close_tcp(tcb);
                break;
        case CLOSED:    /* heh heh */
                if(notify){
                        printf("%s (%s",tcpstates[new],reasons[tcb->reason]);
                        if(tcb->reason == NETWORK){
                                switch(tcb->type){
                                case DEST_UNREACH:
                                        printf(": %s unreachable",unreach[tcb->code]);
                                        break;
                                case TIME_EXCEED:
                                        printf(": %s time exceeded",exceed[tcb->code]);
                                        break;
                                }
                        }
                        printf(")\n");
                        cmdmode();
                }
                del_tcp(tcb);
                if(ftp != NULLFTP)
                        ftp_delete(ftp);
                break;
        default:
                if(notify) {
                        printf("%s\n",tcpstates[new]);
                }
                break;
        }
        if(notify)
                fflush(stdout);
}

/* FTP Client Data channel State change upcall handler */
static
void
ftpcds(struct tcb *tcb,char old,char new)
{
        struct ftp *ftp;

        if((ftp = (struct ftp *)tcb->user) == NULLFTP){
                /* Unknown connection, kill it */
                close_tcp(tcb);
                return;
        }
        switch(new){
        case FINWAIT2:
        case TIME_WAIT:
                if((ftp != NULLFTP) && (ftp->state == SENDING_STATE)){
                        /* We've received an ack of our FIN, so
                         * return to command mode
                         */
                        ftp->state = COMMAND_STATE;
                        if((current != NULLSESSION) && (current->cb.ftp->state == COMMAND_STATE )){
                                printf("Put complete, %lu bytes sent\n",
                                        tcb->snd.una - tcb->iss - 2);
                                if( mput_state == MPUT_AKTIV)
                                        mput_state = MPUT_DONE;
                                else
                                {
                                        printf(fprompt,23);
                                        fflush(stdout);
                                }
                                
                        }
                }
                break;          
        case CLOSE_WAIT:
                close_tcp(tcb);
                if((ftp != NULLFTP) && (ftp->state == RECEIVING_STATE)){
                        /* End of file received on incoming file */
                        if(ftp->fp != stdout)
                                fclose(ftp->fp);
                        ftp->fp = NULLFILE;
                        ftp->state = COMMAND_STATE;
                        if((current != NULLSESSION) && (current->cb.ftp == ftp)){
                                printf("Get complete, %lu bytes received\n",
                                        tcb->rcv.nxt - tcb->irs - 2);
                                switch(mget_state){
                                        case MGET_GETDIR_AKTIV:
                                                mget_sfmp();
                                                mget_state = MGET_DONE;
                                                break;
                                        case MGET_AKTIV:
                                                mget_state = MGET_DONE;
                                                break;
                                        case MGET_PASSIV:
                                        default:
                                                printf(fprompt,24);
                                                fflush(stdout);
                                                break;
                                }
                        }
                }
                break;
        case CLOSED:
                if(ftp != NULLFTP)
                        ftp->data = NULLTCB;
                del_tcp(tcb);
                break;
        }
}

/* Send a message on the control channel */
int
sndftpmsg(struct ftp *ftp,char *fmt,char *arg)
{
        struct mbuf *bp;
        int16 len;

        len = strlen(fmt) + strlen(arg) + 10;   /* fudge factor */
        if((bp = alloc_mbuf(len)) == NULLBUF){
                printf(nospace);
                printf(fprompt,25);
                return 1;
        }
        sprintf(bp->data,fmt,arg);
        bp->cnt = strlen(bp->data);
        send_tcp(ftp->control,bp);
        return 0;
}

/*
 * mput und mget kopiert nur Dateien zwischen aktuellem lokal und
 * aktuellem remote Ordner!!
 */
int
domput(int argc,char *argv[])
{
        int i;

        mput_state = MPUT_DONE;
        if( argc >= 2){
              if(argc<17){
                   for(i=1;i<argc;i++){
                         mp_dat[i-1] = dir (argv[i], 0);
                         mp_dat[i]=NULL;
                   }
              }
              else
                   printf("\nError: Too much parameters");
              }
        else{
                mp_dat[0] = dir (".", 0);
                mp_dat[1] = NULL;
        }
        fflush(stdout);
        return 0;
}

int 
domget(int argc,char *argv[])
{
        int i;

        for( i=1; i<argc; i++){
                mget_masks[i-1] = argv[i];
        }
        anz_masks = argc-1;
        mget_state = MGET_GETDIR;
		return 0;
}

void 
mget_getdir(void)
{
        static char get_cmd[] = "ls . ";
        char line[100], *linp;
        int len;

        a_tmpfile (dir_name);

        linp = line;
        memcpy(line, get_cmd,5);
        linp += 5;
        strcpy(linp,dir_name);
        len = (int)strlen(line);

        mget_state = MGET_GETDIR_AKTIV;
        ftpparse(line,len);
}

int
mget_sfmp(void)
{
        int i;
        char datei[30];
        int found; 

        a_tmpfile (get_name);

        if( (mg_dir = fopen(dir_name, "r")) == NULLFILE){
                printf(cantread, dir_name);
                printf(fprompt,27);
                return -1;
        }
        if( (mg_get = fopen(get_name, "w"))== NULLFILE){
                printf(cantwrite, get_name);
                printf(fprompt,28);
                return -1;
        }

        for(i=0; i<anz_masks; i++){
                found = 0;
                fseek(mg_dir, 0L,0);
                while( fscanf(mg_dir,"%s\n",datei) != EOF){
                        if( match( datei, mget_masks[i])){
                                fprintf(mg_get, "%s\n", datei);
                                found = 1;
                        }
                }
                if(found != 1)
                        printf("%s not found\n", mget_masks[i]);
        }

        fclose(mg_dir);
        unlink(dir_name);
        fclose(mg_get);
        if( (mg_get = fopen(get_name, "r")) == NULLFILE){
                printf(cantread, get_name);
                printf(fprompt,29);
				return -1;
        }
		return 0;
}


void 
strtolower(char *ptr)
{
        while( *ptr != 0){
                *ptr = tolower( *ptr);
                ptr++;
        }
}

void 
mput_send(void)
{

        char send_file[25];
        char line[100]/*, *linp */;
/*        int len;
        static char putcmd[] = "put ";

        linp = line;
        memcpy(line, putcmd, 4);   */     /* put_ ohne '\0' nach line */
/*        linp += 4;             */        /* linp zeigt auf line + 4  */
        if(mp_dat[p_num]!=NULLFILE){
                if ( fscanf (mp_dat[p_num], "%s\n", send_file) != EOF )
                {
                        mput_state = MPUT_AKTIV;
                        /* strcpy(linp, send_file); */
                        sprintf(line,"put %s",send_file);
                   /*     len = strlen(line);  */
                        ftpparse(line,strlen(line) );
                }
                else
                {
                        fclose (mp_dat[p_num]);   /* File p_num ist abge- */
                        mp_dat[p_num++]=NULL;    /* arbeitet, das nchste*/
                                                /* mit p_num++          */
                }
        }
        else
        {
                p_num=0; /* alle Files abgearbeitet beim nchsten mal    */
                         /* beginnen wir wieder von vorne                */
                mput_state = MPUT_PASSIV;
                printf(fprompt,30);
        }
        fflush(stdout);
}

void 
mget_recv(void)
{
        char get_file[25];
        char line[100], *linp;
        static char getcmd[] = "get ";
        int len;

        linp = line;
        memcpy(line, getcmd, 4);
        linp += 4;
        
        if( fscanf( mg_get, "%s\n", get_file) != EOF){
                mget_state = MGET_AKTIV;
                strcpy( linp, get_file);
                len = (int)strlen(line);
                ftpparse( line, len);
        }
        else{
                fclose(mg_get);
                unlink(get_name);
                mget_state = MGET_PASSIV;
                printf(fprompt,31);
        }
        fflush(stdout);
}
