#ifndef __GLOBALH
#define __GLOBALH

#ifdef __TURBOC__
	#pragma warn -par
    #include <stdio.h>		; wg. mglicher Probleme mit (f/s)printf() ...
#endif

/* Global definitions used by every source file.
 * Some may be compiler dependent.
 */

/* Indexes into binmode in files.c; hook for compilers that have special
 * open modes for binary files
 */
#define	READ_BINARY		0
#define	WRITE_BINARY	1
extern char *binmode[];

/* These two lines assume that your compiler's longs are 32 bits and
 * shorts are 16 bits. It is already assumed that chars are 8 bits,
 * but it doesn't matter if they're signed or unsigned.
 */
typedef 		  long  int32;	/* 32-bit signed integer */
typedef unsigned short  int16;	/* 16-bit unsigned integer */

/* Since not all compilers support structure assignment, the ASSIGN()
 * macro is used. This controls how it's actually implemented.
 */
#ifdef	NOSTRUCTASSIGN	/* Version for old compilers that don't support it */
#define	ASSIGN(a,b)	memcpy((char *)&(a),(char *)&(b),sizeof(b));
#else					/* Version for compilers that do */
#define	ASSIGN(a,b)	((a) = (b))
#endif

/* Define null object pointer in case stdio.h isn't included */
#ifndef	NULL
/* General purpose NULL pointer */
#define	NULL 0L         /* (void*)0 verursacht Probleme bei cast */
#endif
#define NULLC '\0'
#define	NULLCHAR (char *)0	/* Null character pointer */
#define	NULLFP	 (int (*)(int argc, char** argv))0	/* Null pointer to function returning int */
#define	NULLVFP	 (void (*)(struct tcb *tcb,int16 cnt))0	/* Null pointer to function returning void */
#define	NULLFILE (FILE *)0	/* Null file pointer */

/* General purpose function macros */
#define	min(x,y)	((x)<(y)?(x):(y))	/* Lesser of two args */
#define	max(x,y)	((x)>(y)?(x):(y))	/* Greater of two args */

#ifdef	MPU8080	/* Assembler routines are available */
int16 hinibble(),lonibble(),hibyte(),lobyte(),hiword(),loword();

#else

/* Extract a short from a long */
#define	hiword(x)	((int16)((x) >> 16))
#define	loword(x)	((int16)(x))

/* Extract a byte from a short */
#define	hibyte(x)	(((x) >> 8) & 0xff)
#define	lobyte(x)	((x) & 0xff)

/* Extract nibbles from a byte */
#define	hinibble(x)	(((x) >> 4) & 0xf)
#define	lonibble(x)	((x) & 0xf)

#endif

#ifdef	SYS5
#include <string.h>
#define rindex	strrchr
#define index	strchr
#endif

#ifdef ATARI
#include <stdlib.h>
#else
/* Heavily used functions from the standard library */
char *index(),*rindex(),*malloc(),*calloc(),*ctime(),*tmpnam();
#endif

#endif