#ifndef __IFACEH
#define __IFACEH

/* Interface control structure */
struct interface {
	struct interface *next;	/* Linked list pointer */
	char *name;		/* Ascii string with interface name */
	int16 mtu;		/* Maximum transmission unit size */
	int (*ioctl)(void);		/* Function to handle device control */
	int (*send)(struct mbuf*,
				struct interface*,
				int32 gateway,
                char precedence,
                char delay,
                char throughput,
                char reliability);		/* Routine to send an IP datagram */
	int (*output)( struct interface*, char*, char*, int16, struct mbuf * );	
	                    /* Routine to send link packet */
	int (*raw)( struct interface *, struct mbuf*);		/* Routine to call to send raw packet */
	int (*recv)(struct interface *);		/* Routine to kick to process input */
	int (*stop)( int16 );		/* Routine to call before detaching */
	int (*init)( struct interface * );		/* Routine to init hardware */
	int16 dev;		/* Subdevice number to pass to send */
	int16 flags;		/* Configuration flags */
#define	DATAGRAM_MODE	0	/* Send datagrams in raw link frames */
#define	CONNECT_MODE	1	/* Send datagrams in connected mode */
	int16 trace;		/* Trace flags */
#define	IF_TRACE_OUT	0x0001	/* Output packets */
#define	IF_TRACE_IN	0x0010	/* Packets to me except broadcast */
#define	IF_TRACE_ASCII	0x0100	/* Dump packets in ascii */
#define	IF_TRACE_HEX	0x0200	/* Dump packets in hex/ascii */
	char *hwaddr;		/* Device hardware address, if any */
};
#define	NULLIF	(struct interface *)0
extern struct interface *ifaces;	/* Head of interface list */


#endif