#include "iface.h"
#include "ip.h"

/* Route an IP datagram. This is the "hopper" through which all IP datagrams,
 * coming or going, must pass.
 *
 * This router is a temporary hack, since it only does host-specific or
 * default routing (no hierarchical routing yet).
 *
 * "rxbroadcast" is set to indicate that the packet came in on a subnet
 * broadcast. The router will kick the packet upstairs regardless of the
 * IP destination address.
 */
void ip_route( struct mbuf *bp,char rxbroadcast );
                 /* True if packet had link broadcast address */

/* Add an entry to the IP routing table. Returns 0 on success, -1 on failure */
int rt_add(int32 target,   /* Target IP address prefix */
		   unsigned bits,  /* Size of target address prefix in bits (0-32) */
		   int32 gateway,
		   int metric,
		   struct interface *interface);

/* Remove an entry from the IP routing table. Returns 0 on success, -1
 * if entry was not in table. */
int rt_drop(int32 target,unsigned bits);

/* Given an IP address, return the MTU of the local interface used to
 * reach that destination. This is used by TCP to avoid local fragmentation
 */
int16 ip_mtu(int32 addr);

/* Convert IP header in host format to network mbuf */
struct mbuf *htonip(struct ip *ip,struct mbuf *data);

/* Extract an IP header from mbuf */
int ntohip(struct ip *ip,struct mbuf **bpp);

/* Perform end-around-carry adjustment */
int16 eac(register int32 sum);     /* Carries in high order 16 bits */

/* Checksum a mbuf chain, with optional pseudo-header */
int16 cksum(struct pseudo_header *ph,register struct mbuf *m,int16 len);


