/* Main network program - provides both client and server functions */

#define HOSTNAMELEN 32          /* changed from 16 by Bdale 860812 */

extern char startup[];  /* File to read startup commands from */

#include <stdarg.h>
#include <stdio.h>
#include <tos.h>
#include <time.h>
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "netprint.h"
#include "timer.h"
#include "icmp.h"
#include "iface.h"
#include "misc.h"
#include "eth.h"
#include "enetdump.h"
#include "ip.h"
#include "ipcmd.h"
#include "ipdump.h"
#include "icmpcmd.h"
#include "tcp.h"
#include "ftp.h"
#include "ftpcli.h"
#include "ftpserv.h"
#include "telnet.h"
#include "tnserv.h"
#include "session.h"
#include "cmdparse.h"
#include "config.h"
#include "atari.h"
#include "arpcmd.h"
#include "main.h"
#include "ping.h"
#include "tcpcmd.h"
#include "udpcmd.h"
#include "ttydriv.h"

#ifdef  TRACE
#include "trace.h"
/* Dummy structure for loopback tracing */
struct interface loopback = { NULLIF, "loopback" };
#endif

extern struct interface *ifaces;
extern char version[];
extern struct mbuf *loopq;


#define MPUT_PASSIV 0
#define MPUT_AKTIV  1
#define MPUT_DONE   2
#define MPUT_NPR    3
extern int mput_state;
extern int prn_flag;


#define MGET_PASSIV 0
#define MGET_GETDIR 1
#define MGET_GETDIR_AKTIV 2
#define MGET_AKTIV 3
#define MGET_DONE 4
#define MGET_ERROR 5

extern int mget_state;

#define FALSE 0
#define TRUE (!FALSE)
int tn_output_buffered = FALSE;	/* flag: telnet outputbuffer not empty */
int tn_output_stopped = FALSE;	/* flag: telnet output to screen halted */

int mode;  /* telnet or ftp */
long sp;   /* Stackpointer */
int eap;   /* eap fr dohostname */

FILE *logfp;
char badhost[] = "Unknown host %s\n";
char hostname[HOSTNAMELEN];     
unsigned nsessions = NSESSIONS;
int16 lport = 1001;
char prompt[] = "net> ";
char nospace[] = "No space!!\n";        /* Generic malloc fail message */

#ifndef ATARI
char escape = 0x18;     /* default escape character is <^X> */
#else
int  escape = 97*256;		/* escape character is "Undo" */
int  tn_stopout = 44*256; 	/* default telnet output stop by <alt-Y> */
int  tn_clearout = 46*256;	/* default telnet output buffer clear by <alt-C> */
#endif

/* local prototypes */
void main(int argc,char *argv[]);
static void tn_printbufsize(void);
static void tn_stop(void);
static void tn_continue(void);
static int tn_freescreenbuffer(void);
static void tn_clearbuffer(void);
static int doexit(int argc,char *argv[]);
static int dohostname(int argc,char *argv[]);
int check_eap(void);
static int dolog(int argc,char *argv[]);
static int dohelp(int argc,char *argv[]);
static int doecho(int argc,char *argv[]);
static int doeol(int argc,char *argv[]);
static int doattach(int argc,char *argv[]);
static int doparam(int argc,char *argv[]);
static int dotrace(int argc,char *argv[]);
static void showtrace(register struct interface *ifp);
static int doescape(int argc,char *argv[]);
static int doprint (int argc,char *argv[]);


/* Command lookup and branch table */

static struct cmds cmds[] = {
        /* The "go" command must be first */
        "",             go,             0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "!",            doshell,        0, NULLCHAR,    NULLCHAR,       0,
#if (defined(AX25) || defined(ETHER) || defined(APPLETALK))
        "arp",          doarp,          0, NULLCHAR,    NULLCHAR,       HIDDEN,
#endif
#ifdef  AX25
        "ax25",         doax25,         0, NULLCHAR,    NULLCHAR,       HIDDEN,
#endif  
        "attach",       doattach,       2,
                "attach <hardware> <hw specific options>", NULLCHAR,    HIDDEN,

/* This one is out of alpabetical order to allow abbreviation to "c" */
#ifdef  AX25
        "connect",      doconnect,      3,"connect interface callsign [digipeaters]",
                NULLCHAR,       HIDDEN,
#endif
        "cd",           docd,           0, NULLCHAR,    NULLCHAR,       0,
        "close",        doclose,        0, NULLCHAR,    NULLCHAR,       0,
        "disconnect",   doclose,        0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "dir",          dodir,          0, NULLCHAR,    NULLCHAR,       0,
        "echo",         doecho,         0, NULLCHAR,    "echo [refuse|accept]", HIDDEN,
        "eol",          doeol,          0, NULLCHAR,
                "eol options: unix, standard",  HIDDEN,
#ifndef MSDOS
        "escape",       doescape,       0, NULLCHAR,    NULLCHAR,       HIDDEN,
#endif      
#ifdef ETHER
        "etherstat",    doetherstat,    0, NULLCHAR,    NULLCHAR,       HIDDEN,
#endif
        "exit",         doexit,         0, NULLCHAR,    NULLCHAR,       0,
        "ftp",          doftp,          2, "ftp <address>",     NULLCHAR,       0,
        "help",         dohelp,         0, NULLCHAR,    NULLCHAR,       0,
        "hostname",     dohostname,     0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "kick",         dokick,         0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "log",          dolog,          0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "ip",           doip,           0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "memstat",      memstat,        0, NULLCHAR,    NULLCHAR,       HIDDEN,

#ifdef  AX25
        "mode",         domode,         2, "mode <interface>",  NULLCHAR,       HIDDEN,
#endif

        /* netprint als alias fr prn (fr MS-DOS-Leute) */
        "netprint",     doprn,          0, NULLCHAR,    NULLCHAR,	    HIDDEN,
#ifdef  AX25
        "param",        doparam,        2, "param <interface>", NULLCHAR,       HIDDEN,
#endif
        "ping",         doping,         0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "print",        doprint,        0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "prn",          doprn,          0, NULLCHAR,    NULLCHAR,       0,
        "pwd",          docd,           0, NULLCHAR,    NULLCHAR,       0,
        "quit",         doexit,         0, NULLCHAR,    NULLCHAR,       0,
        "record",       dorecord,       0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "reset",        doreset,        0, NULLCHAR,    NULLCHAR,       0,
        "route",        doroute,        0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "session",      dosession,      0, NULLCHAR,    NULLCHAR,       0,
        "shell",        doshell,        0, NULLCHAR,    NULLCHAR,       0,
#ifdef SMTP
        "smtp",         dosmtp,         0, NULLCHAR,    NULLCHAR,       HIDDEN,
#endif
#ifdef  SERVERS
        "start",        dostart,        2, "start <servername>",NULLCHAR,       0,
        "stop",         dostop,         2, "stop <servername>", NULLCHAR,       0,
#endif
        "tcp",          dotcp,          0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "telnet",       dotelnet,       2, "telnet <address>",  NULLCHAR,       0,
#ifdef  TRACE
        "trace",        dotrace,        0, NULLCHAR,    NULLCHAR,       HIDDEN,
#endif
        "udp",          doudp,          0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "upload",       doupload,       0, NULLCHAR,    NULLCHAR,       HIDDEN,
        "?",            dohelp,         0, NULLCHAR,    NULLCHAR,       0,
        NULLCHAR,       NULLFP,         0,
                "Unknown command; type \"?\" for list",   NULLCHAR,     0
};

#ifdef  SERVERS

static struct cmds startcmds[] = {
#ifdef TEST
        "discard",      discard_start,  0, NULLCHAR, NULLCHAR, HIDDEN,
        "echo",         echo_start,     0, NULLCHAR, NULLCHAR, HIDDEN,
#endif
        "ftp",          ftp_start,      0, NULLCHAR, NULLCHAR, 0,
#ifdef SMTP
        "smtp",         smtp_start,     0, NULLCHAR, NULLCHAR, HIDDEN,
#endif
        "telnet",       telnet_start,   0, NULLCHAR, NULLCHAR, 0,
        NULLCHAR,       NULLFP,         0,
                "start options: ftp, telnet", NULLCHAR, 0
};

static struct cmds stopcmds[] = {
#ifdef TEST
        "discard",      discard_stop,   0, NULLCHAR, NULLCHAR, HIDDEN,
        "echo",         echo_stop,      0, NULLCHAR, NULLCHAR, HIDDEN,
#endif
        "ftp",          ftp_stop,       0, NULLCHAR, NULLCHAR, 0,
#ifdef SMTP
        "smtp",         smtp_stop,      0, NULLCHAR, NULLCHAR, HIDDEN,
#endif
        "telnet",       telnet_stop,    0, NULLCHAR, NULLCHAR, 0,
        NULLCHAR,       NULLFP,         0,
                "stop options: ftp, telnet",  NULLCHAR, 0
};
#endif

void main(int argc,char *argv[])
{
        static char inbuf[BUFSIZ];      /* keep it off the stack */
        int c;
        char *ttybuf;
        int16 cnt;
        FILE *fp;
        struct interface *ifp;
        struct mbuf *bp;
        extern int p_num;

        ioinit();				 /* Karte da ?, Maus aus & linea0 */
        eap=check_eap(); /* 16-Bit EAP einlesen */
         
        printf("KA9Q Internet Protocol Package, v%s\n",version);
        printf("Copyright 1988 by Phil Karn, KA9Q\n");
        printf("Implementation for ATARI-MEGA ST \275 1990, 1991 by LPR TU Mnchen\n");
        printf("Updated 10/94 by Max Rechenberg for EIKON-Project\n");
        printf("Great Thanks to REGENT, LPR & LDV for help, hard- and software !\n"); 

        sessions = (struct session *)calloc(nsessions,sizeof(struct session));
        current = sessions;
        if(argc > 1){
                /* Read startup file named on command line */
                fp = fopen(argv[1],"r");
        } else {
                fp = fopen(startup,"r");
        }
        if(fp != NULLFILE)
        {
                while(fgets(inbuf,BUFSIZ,fp) != NULLCHAR)
                        cmdparse(cmds,inbuf);
                fclose(fp);
        }               
        else
                printf ("\ncannot find startupfile (%s)\n",startup);

        cmdmode();

        /* Main commutator loop */
        for(;;)
        {
            if(mput_state==MPUT_DONE){
                  if(prn_flag)
                      npr_send();
                  else
                      mput_send();
            }
            else{
                  switch ( mget_state ){
                  case MGET_GETDIR:
                         mget_getdir();
                         break;
                  case MGET_DONE:
                         mget_recv();
                         break;
                  default:
                                /* Process any keyboard input */
                          while((c = kbread()) != -1){
                                 if(c == escape && escape != 0)
                                 {
                                        if(mode != CMD_MODE)
                                                cmdmode();
                                         continue;
                                 }
								 if(c == tn_clearout)
								 {
								 		tn_continue();
								 		tn_clearbuffer();
								 		continue;
								 }
                                 if(tn_output_stopped)
                                 {
                                         /* start output by any key */
                                         tn_continue();
                                         continue;
                                 }
                                 if(c == tn_stopout)
                                 {
                                     if(mode == CONV_MODE &&
                                        current != NULLSESSION &&
                                        current->type == TELNET)
	                                        tn_stop();
                                     continue;
                                 }
                                if((cnt = ttydriv(c,&ttybuf)) == 0)
                                         continue;
                                 switch(mode)
                                 {
                                 case CMD_MODE:
                                         cmdparse(cmds,ttybuf);
                                         fflush(stdout);
                                         break;
                                 case CONV_MODE:
                                         if (current->parse != 0)
                                         (*current->parse)(ttybuf,cnt);
                                         break;
                                 }/* ende switch(mode) */
                                 if (mode == CMD_MODE)
                                         printf(prompt);
                                 fflush(stdout);
                          }/* ende while */
                  }/* ende switch(mget_state) */
            }/* ende else */
            /* Service the loopback queue */
            while((bp = dequeue(&loopq)) != NULLBUF)
            {
#ifdef  TRACE
                  dump(&loopback,IF_TRACE_IN,TRACE_IP,bp);                
#endif
                  ip_recv(bp,0);
             }/* ende while */
             /* Service the interfaces */
             for (ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
             {
                   if(ifp->recv != 0)
                         (*ifp->recv)(ifp);
             }

             /* Service the clock if it has ticked */
             check_time();

             /* Service telnet screen buffer output */
             if( !tn_output_stopped ) tn_freescreenbuffer();
             else tn_printbufsize();
             
             /* Wait until interrupt, then do it all over again */
             eihalt();
        }/* ende for(;;) */
}

/* Standard commands called from main */

/* Enter command mode */
int cmdmode(void)
{
        if(mode != CMD_MODE){
                mode = CMD_MODE;
                if( tn_output_buffered )
                {
                	tn_continue();
                	tn_clearbuffer();
                }
                cooked();
                printf("\n%s",prompt);
                fflush(stdout);
        }
        return 0;
}

#define TN_BUFFSIZE 128

struct tn_sbuffer {
    struct tn_sbuffer * next;
    char buffer[TN_BUFFSIZE];
    };
typedef struct tn_sbuffer * tn_sbuffp;

#define TN_NULLBUFFER ((tn_sbuffp) 0)
static tn_sbuffp tn_bufferhead = TN_NULLBUFFER;
static tn_sbuffp tn_buffin = TN_NULLBUFFER;
static int bufindex = TN_BUFFSIZE;
static long buffered_chars = 0;

static void
tn_continue(void)
{
#if FALSE
	int i;
#endif
	
    if(!tn_output_stopped) return;
  	tn_output_stopped = FALSE;
#if FALSE
    for(i=0; i<29; i++) printf("\010");
    printf("                             ");
    for(i=0; i<29; i++) printf("\010");
#endif
}

static void tn_stop(void)
{
    if(tn_output_stopped) return;
    tn_output_stopped = TRUE;
#if FALSE
    printf(" ** output halted, %6li ** ",buffered_chars);
#endif
}

void tn_printbufsize(void)
{
#if FALSE
    static long old = 0;
	int i;

    if( old == buffered_chars) return;
    old = buffered_chars;
	for( i=0; i<10; i++ ) printf("\010");
    printf("%6li ** ",buffered_chars);
#endif
}
    
void tn_bufferscreen(char c)
{
    tn_sbuffp new;
    
	if( bufindex == TN_BUFFSIZE )
	{
	    /* no current buffer - get new one */
		new = (struct tn_sbuffer * ) malloc(sizeof( struct tn_sbuffer ));
        if( new == TN_NULLBUFFER )
        {
        	/* no more memory - clear 2 buffers and try again */
        	tn_freescreenbuffer();
        	tn_freescreenbuffer();
			new = (struct tn_sbuffer * ) malloc(sizeof( struct tn_sbuffer ));
        }
		if( new == TN_NULLBUFFER )
		{
			/* no more memory - clear all buffers */
		    tn_continue();
		    while( !tn_freescreenbuffer ) ;
            Bconout(2,c);
			return;
		}

        if( tn_buffin == TN_NULLBUFFER )
        {
        	/* first buffer */
        	tn_bufferhead = new;
        	tn_output_buffered = TRUE;
        }
        else
            /* link buffer to list */
            tn_buffin->next = new;

		tn_buffin = new;
		tn_buffin->next = TN_NULLBUFFER;
		bufindex = 0;
	}
	tn_buffin->buffer[bufindex++] = c;
	buffered_chars++;
}

static int tn_freescreenbuffer(void)
/* free one screenbuffer. Return TRUE (-1), if no more buffers */
{
	int i;
	tn_sbuffp p;
	
	if(tn_bufferhead == TN_NULLBUFFER) return -1;
	
    if(tn_buffin == tn_bufferhead)
    {
    	/* the last one buffer */
    	for(i=0; i<bufindex; buffered_chars-- )
    	  Bconout(2,tn_bufferhead->buffer[i++]);
    	free(tn_bufferhead);
    	bufindex = TN_BUFFSIZE;
    	tn_bufferhead = tn_buffin = TN_NULLBUFFER;
    	tn_output_buffered = FALSE;
    	return -1;
    }
    else
    {
    	/* one full buffer */
    	for(i=0; i<TN_BUFFSIZE; buffered_chars-- )
    	  Bconout(2,tn_bufferhead->buffer[i++]);
    	p = tn_bufferhead;
    	tn_bufferhead = p->next;
    	free(p);
    }
  	return 0;
}

static void tn_clearbuffer(void)
{
	tn_sbuffp p;

    p = tn_bufferhead;
    while( p != TN_NULLBUFFER )
    {
    	tn_bufferhead = p->next;
    	free(p);
    	p = tn_bufferhead;
    }
  	bufindex = TN_BUFFSIZE;
   	tn_bufferhead = tn_buffin = TN_NULLBUFFER;
   	tn_output_buffered = FALSE;
   	buffered_chars = 0;
 }

static int doexit(int argc,char *argv[])
{
        if(logfp != NULLFILE)
                fclose(logfp);
        iostop();
        exit(0);
		return 0;
}

static int dohostname(int argc,char *argv[])
{
  int ziff;
  
  if(argc < 2)
  {
	if ( (strcmp(hostname,"eikona")==0) && (eap!=-1) ) 
    {
      ziff = eap % 0x10;	           /* auf 1 Stelle krzen */
   	  printf("%s%x\n",hostname, ziff); /* beides kombiniert ausgeben */
    }
    else 						/* entweder Buserror oder kein 'eikona' */
	{
      printf("%s\n",hostname);
    } 	
  }  
  else 
     strncpy(hostname,argv[1],HOSTNAMELEN);
  
  return 0;
}

int check_eap()
{
  sp = Super(0L);				/* ergnzt 10/94 MR */
  eap = EAP;            /* EAP=16Bits->int */
  Super((void *)sp);
  
  if (eap==-1)
  {
    printf("Sorry, EAP not found !\n");
    return -1;
  }  
  else
    return eap;
}
    
static int dolog(int argc,char *argv[])
{
        static char logname[15];

        if(argc < 2){
                if(logfp)
                        printf("Logging to %s\n",logname);
                else
                        printf("Logging off\n");
                return 0;
        }
        if(logfp){
                fclose(logfp);
                logfp = NULLFILE;
        }
        if(strcmp(argv[1],"stop") != 0){
                strncpy(logname,argv[1],15);     /* logname = argv[1] */
                logfp = fopen(logname,"a+");    /* und File ffnen   */
        }
        return 0;
}

static int dohelp(int argc,char *argv[])
{
        register struct cmds *cmdp;
        int i,j,full = 0;

        if ( argc == 2 && !strcmp (argv[1], "full") )
                full = 1;
        printf("Main commands:\n");
        for(i=0, cmdp = cmds; cmdp->name != NULL; cmdp++)
        {
                if ( cmdp->hidden != HIDDEN || full )
                {
                        printf("%s",cmdp->name);
                        if((i % 4) == 3)
                                printf("\n");
                        else
                        {
                                for(j=(int)strlen(cmdp->name);j < 16; j++)
                                        putchar(' ');
                        }
                        i++;
                }
        }
        if((i % 4) != 0)
                printf("\n");
        return 0;
}

static int doecho(int argc,char *argv[])
{
        extern int refuse_echo;

        if(argc < 2){
                if(refuse_echo)
                        printf("Refuse\n");
                else
                        printf("Accept\n");
        } else {
                if(argv[1][0] == 'r')
                        refuse_echo = 1;
                else if(argv[1][0] == 'a')
                        refuse_echo = 0;
                else
                        return -1;
        }
        return 0;
}

/* set for unix end of line for remote echo mode telnet */
static int doeol(int argc,char *argv[])
{
        extern int unix_line_mode;

        if(argc < 2){
                if(unix_line_mode)
                        printf("Unix\n");
                else
                        printf("Standard\n");
        } else {
                if(strcmp(argv[1],"unix") == 0)
                        unix_line_mode = 1;
                else if(strcmp(argv[1],"standard") == 0)
                        unix_line_mode = 0;
                else {
                        return -1;
                }
        }
        return 0;
}

/* Attach an interface
 * Syntax: attach <hw type> <I/O address> <vector> <mode> <label> <bufsize> [<speed>]
 */
static int doattach(int argc,char *argv[])
{
        extern struct cmds attab[];

        return subcmd(attab,argc,argv);
}

#ifdef AX25
/* Manipulate I/O device parameters */
static int doparam(int argc,char *argv[])
{
        register struct interface *ifp;

        for (ifp=ifaces;ifp != NULLIF;ifp = ifp->next){
                if(strcmp(argv[1],ifp->name) == 0)
                        break;
        }
        if (ifp == NULLIF){
                printf ("Interface \"%s\" unknown\n",argv[1]);
                return 1;
        }
        if (ifp->ioctl == NULLFP){
                printf("Not supported\n");
                return 1;
        }
        /* Pass rest of args to device-specific code */
        return (*ifp->ioctl)(ifp,argc-2,argv+2);
}
#endif

/* Log messages of the form
 * Tue Jan 31 00:00:00 1987 44.64.0.7:1003 open FTP
 */
/*VARARGS2*/
void log(struct tcb *tcb,char *fmt,...)
{
		va_list argpoint; /* Parameter-Pointer */
        char *cp;
        long t;

        if(logfp == NULLFILE)
                return;
                
		va_start(argpoint, fmt); 

        time(&t);
        cp = ctime(&t);
        rip(cp);
        fprintf(logfp,"%s %s - ",cp,psocket(&tcb->conn.remote));
        vfprintf(logfp,fmt,argpoint);
        fprintf(logfp,"\n");
        fflush(logfp);

        va_end(argpoint);
}

/* Configuration-dependent code */

/* List of supported hardware devices */
struct cmds attab[] = {
#ifdef LANCE
        /* LANCE Ethernet interface */
        "LANCE", eth_attach, 3,
        "attach LANCE <mtu> <adress>",
        "Could not attach LANCE", 0,
#endif
#ifdef  SLIP
        /* Ordinary asynchronous adaptor */
        "asy", asy_attach, 8, 
        "attach asy <address> <vector> slip|ax25 <label> <buffers> <mtu> <speed>",
        "Could not attach asy", 0,
#endif
        NULLCHAR, NULLFP, 0,
        "Unknown device",
        NULLCHAR, 0
};

/* Protocol tracing function pointers */

#ifdef  TRACE

int (*tracef[])() = {
#ifdef  AX25
        ax25_dump,
#else
        NULLFP,
#endif

#ifdef  ETHER
        ether_dump,
#else
        NULLFP,
#endif
        ip_dump
};

#else

int (*tracef[])() = { NULLFP }; /* No tracing at all */

void
dump (struct interface *interface,
	  int direction,
	  unsigned type,
	  struct mbuf *bp)
{
}
#endif

#ifdef  AX25
/* Set up a SLIP link to use AX.25 */
void kiss_attach(struct interface *if_asy,int (**srecv)())
{
        axarp();
        if(mycall.call[0] == '\0'){
                printf("set mycall first\n");
                free((char *)if_asy);
                return -1;
        }
        if_asy->ioctl = kiss_ioctl;
        if_asy->send = ax_send;
        if_asy->output = ax_output;
        if_asy->raw = kiss_raw;
        if(if_asy->hwaddr == NULLCHAR)
                if_asy->hwaddr = malloc(sizeof(mycall));
        memcpy(if_asy->hwaddr,(char *)&mycall,sizeof(mycall));
        *srecv = kiss_recv;
        return 0;
}

/* Display or set IP interface control flags */
void domode(int argc,char *argv[])
{
        register struct interface *ifp;

        for(ifp=ifaces;ifp != NULLIF;ifp = ifp->next){
                if(strcmp(argv[1],ifp->name) == 0)
                        break;
        }
        if(ifp == NULLIF){
                printf("Interface \"%s\" unknown\n",argv[1]);
                return 1;
        }
        if(argc < 3){
                printf("%s: %s\n",ifp->name,
                 (ifp->flags & CONNECT_MODE) ? "VC mode" : "Datagram mode");
                return 0;
        }
        switch(argv[2][0]){
        case 'v':
        case 'c':
        case 'V':
        case 'C':
                ifp->flags = CONNECT_MODE;
                break;
        case 'd':
        case 'D':
                ifp->flags = DATAGRAM_MODE;
                break;
        default:
                printf("Usage: %s [vc | datagram]\n",argv[0]);
                return 1;
        }
        return 0;
}
#else   /* KISS mode not configured */
int kiss_attach(struct interface *if_asy,int (*srecv)())
{
        printf("KISS mode not configured\n");
        return -1;
}
#endif

#ifdef SERVERS
int dostart(int argc,char *argv[])
{
        return subcmd(startcmds,argc,argv);
}

int dostop(int argc,char *argv[])
{
        return subcmd(stopcmds,argc,argv);
}

#endif SERVERS

#ifdef  TRACE
static int dotrace(int argc,char *argv[])
{
        struct interface *ifp;

        if(argc < 2){
                showtrace(&loopback);
                for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
                        showtrace(ifp);
                return 0;
        }
        if(strcmp("loopback",argv[1]) == 0)
                ifp = &loopback;
        else 
                for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
                        if(strcmp(ifp->name,argv[1]) == 0)
                                break;

        if(ifp == NULLIF){
                printf("Interface %s unknown\n",argv[1]);
                return 1;
        }
        if(argc >= 3)
                ifp->trace = htoi(argv[2]);

        showtrace(ifp);
        return 0;
}

/* Display the trace flags for a particular interface */
static void showtrace(register struct interface *ifp)
{
        if(ifp == NULLIF)
                return;
        printf("%s:",ifp->name);
        if(ifp->trace & (IF_TRACE_IN | IF_TRACE_OUT)){
                if(ifp->trace & IF_TRACE_IN)
                        printf(" input");
                if(ifp->trace & IF_TRACE_OUT)
                        printf(" output");

                if(ifp->trace & IF_TRACE_HEX)
                        printf(" (Hex/ASCII dump)");
                else if(ifp->trace & IF_TRACE_ASCII)
                        printf(" (ASCII dump)");
                else
                        printf(" (headers only)");
                printf("\n");
        } else
                printf(" tracing off\n");
        fflush(stdout);
}
#endif

#ifndef MSDOS
static int doescape(int argc,char *argv[])
{
#ifdef ATARI
        printf ("escape key is always and only \"Undo\"!\n");
        return 0;
#else
        if(argc >= 2)
                escape = *argv[1];
        if (escape < ' ' )
                printf ("Ctrl-%c\n", (char)(escape+'@'));
        else
                printf ("%c\n", escape);
        return 0;
#endif
}
#endif

static int doprint (int argc,char *argv[])
{
        int i, nlflag = 1;

        for (i=1; i<argc; i++)
                if ( strcmp (argv[i], "-n") )
                        printf ("%s ", argv[i]);
                else
                        nlflag = 0;
        if ( nlflag )
                printf ("\n");
		return 0;
}
