#ifndef __MBUF
#define __MBUF

/* Basic message buffer structure */
struct mbuf {
        struct mbuf *next;      /* Links mbufs belonging to single packets */
        struct mbuf *anext;     /* Links packets on queues */
        char *data;             /* Active working pointers */
        int16 cnt;
};
#define NULLBUF (struct mbuf *)0
#define NULLBUFP (struct mbuf **)0

/* Allocate mbuf with associated buffer of 'size' bytes */
struct mbuf *alloc_mbuf( register int16 size );

/* Unlink a packet from the head of the queue */
struct mbuf *dequeue( register struct mbuf **q );


/* Copy user data into an mbuf */
struct mbuf *qdata(char  *data,
			       int16  cnt );

/* Append packet to end of packet queue */
void enqueue( struct mbuf **q, struct mbuf *bp );

/* Free all resources associated with mbuf
 * Return pointer to next mbuf in packet chain
 */
struct mbuf *free_mbuf( register struct mbuf *bp );

/* Free packet (a chain of mbufs). Return pointer to next packet on queue,
 * if any
 */
struct mbuf *free_p( register struct mbuf *bp );

/* Free entire queue of packets (of mbufs) */
void free_q( struct mbuf **q );

/* Count up the total number of bytes in an mbuf */
int16 len_mbuf( register struct mbuf *bp );

/* Count up the number of packets in a queue */
int16 len_q( register struct mbuf *bp );

/* Pull a 32-bit integer in host order from buffer in network byte order */
int32 pull32( struct mbuf **bpp );

/* Pull a 16-bit integer in host order from buffer in network byte order */
int16 pull16( struct mbuf **bpp );

/* Pull single character from mbuf */
char pullchar( struct mbuf **bpp );

/* Copy and delete "cnt" bytes from beginning of packet. Return number of
 * bytes actually pulled off
 */
int16 pullup( struct mbuf **bph, char *buf, int16 cnt );

/* Put a short in host order into a char array in network order */
char *put16( register char *cp, int16 x );

/* Put a long in host order into a char array in network order */
char *put32( register char *cp, int32 x );

/* Trim mbuf to specified length by lopping off end */
void trim_mbuf(struct mbuf **bpp,int16 length);

int16 dup_p(struct mbuf **hp,
	        register struct mbuf  *bp,
            register int16   offset,
            register int16   cnt );

/* Copy first 'cnt' bytes of packet into a new, single mbuf */
struct mbuf *copy_p(register struct mbuf *bp,
			        register int16  cnt );

/* Append mbuf to end of mbuf chain */
void append( struct mbuf **bph,
     	     struct mbuf  *bp );

/* Copy mbuf data into user buffer */
int16 dqdata( struct mbuf *bp,
              char *buf,
      	      unsigned  cnt );

#define AUDIT(bp)       audit(bp,__FILE__,__LINE__)

#endif
