
         /* netprint eingefgt am 13.06.1990 von Michael Klingler */
        /*                   NETPRINT 1.00                       */
       /* letzte nderung: 31.07.1990  Version lauffhig        */
      /*  enthlt folgende Funktionen:                         */
     /*       int donpr(), para_check(), print_syntax(),      */
    /*            file_delete(), all_delete(), npr_send(),   */
   /*             write_info(), doprn(), ftpnpr()           */
   
/* 02.09.91 Herbert Thielen										  */
/*          Diverse nderungen, u. a. Pfade in Filenamen erlaubt, */
/*          mehr Sicherheitsabfragen.							  */

#include <stdio.h>
#include <ctype.h>
#include <tos.h>
#include "ext.h"
#include <string.h>
#include "global.h"
#include "atari.h"
#include "mbuf.h"
#include "netuser.h"
#include "icmp.h"
#include "timer.h"
#include "tcp.h"
#include "ftp.h"
#include "session.h"
#include "cmdparse.h"
#include "netprint.h"
#include "ftpcli.h"
#include "iface.h"
#include "ip.h"

extern struct session *current;
extern char nospace[];
extern char badhost[];
extern char startup[];

extern int logflag;

# define BAD_SYNTAX  2
# define REMOVE_FILE 3
# define REMOVE_ALL  4
# define PRINT_FILE  5
# define SPEC_BAD    0
# define SPEC_OK     1
# define BAD         0
# define OK          1
# define PR1         "fj1"
# define PR2         "fj2"
# define IMG         "imagen"
# define USE_FILTER  1
# define NO_FILTER   0
# define NO_OPT      0
# define OK_OPT      1

static char badpa[]    ="\nFalscher Parameter: ";
static char info_file[MAXPATH];

#ifndef LPR_GREEN
   static char dest_path[]="/export_lpr/ibm/tmp/dosprn";
   static char host[]="mars";
#else
   static char dest_path[]="/usr/tmp/dosprn";
   static char host[]="green";
#endif

#define MPUT_PASSIV 0
#define MPUT_AKTIV  1
#define MPUT_DONE   2
extern int mput_state;

int prn_flag;

static int ex_flag;
static char *file_name[16];                /* Namen der auszudruckenden Files  */
static char printer[8];                   /* Druckername nur 8 Zeichen        */
static int  prflag;                      /* pr-Filter benutzen oder nicht    */
static int  gr_opt;                     /* Grafikoptimierung fr fj-Drucker */
static int  hpgl;                      /* HPGL-Emulation fr imagen        */
static int  filec=0;                  /* Filecounter: Anzahl der Files    */
static int  c_addr;                  /* Code Adresse der Ethernetkarte   */
static int  f_c=0;                  /* file counter,wird als Zhler ben.*/
static int  info_flag=BAD;        /* Flag zeigt an ob als nchstes ein*/
                          /* Infofile gesendet wird.          */
                      
static char old_file[16][16];             /* Die Unix-Filenamen werden gespeichert */
static int  npargc;                      /* Netprint argument counter        */
static char parse_argv[16][MAXPATH];    /* Zwischenspeicherung fr die      */
static char *p_argv[16];               /* Argumente, sowie Pointer dazu    */


/*  */
/* Nach dem Einloggen wird donpr() aufgerufen, das den npr_send Vorgang   */
/* initiiert, nachdem der Parametercheck erfolgreich verlief              */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  17.07.1990                                                  */
/*  */

static int
donpr(int argc,char *argv[])
{
        register struct ftp *ftp;
        int para_state;

        ftp = current->cb.ftp;
        c_addr=(int)ip_addr&15;

        sndftpmsg(ftp,"CWD %s\r\n",dest_path);
        para_state=para_check(argc,argv);        /* Parameter prfen       */

        switch(para_state){
        case BAD_SYNTAX :                        /* Parameter unsinnig     */
                print_syntax(); break;           /* Syntax anzeigen        */
        case REMOVE_FILE:                        /* Parameter:  -c         */
                file_delete(); break;            /* File lschen           */
        case REMOVE_ALL :                        /* Parameter:  -t         */
                all_delete(); break;             /* alle ges. Files lschen*/
        case PRINT_FILE :                        /* Parameter sinnvoll     */
                npr_send(); break;               /* In das Zielverzeichnis */
                                                 /* wechseln und Files     */
                                                 /* schicken               */
        }
        return 0;
}

/*  */
/* Hier werden die bergebenen Parameter ausgewertet                      */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  17.07.1990                                                  */
/*  */

static int
para_check(int argc,char *argv[])  /* letzte nderung 29.06.1990 V 0.03  */
{
        int   i;         /* Schleifenzhler                       */
        int   f_spec=0;  /* File spezifiziert: SPEC_BAD, SPEC_OK  */
        int   check=BAD; /* Zunchst pesimistisch sein            */
        char  firstc;    /* Erstes  Zeichen eines Parameters      */
        char  secondc;   /* Zweites Zeichen eines Parameters      */
        char  *p;        /* Pointer auf evtl. Druckernamen        */

        filec    =0;           /* File counter initialisieren     */
        hpgl     =BAD;         /* Default keine HPGL-Emulation    */
        prflag   =NO_FILTER;   /* Default pr nicht benutzen       */
        gr_opt   =NO_OPT;      /* Default Grafik nicht optimieren */        
        strncpy(printer,PR2,8);/* Default Drucker fj2             */
        
        for(i=1;i<argc;i++){
           firstc =tolower(argv[i][0]);
           secondc=tolower(argv[i][1]);
           p      =&argv[i][2];  /* dritter Buchstabe des Parameters */
           if(firstc=='-'){     /* Parameter gefunden               */
             switch(secondc){
               case 'c': check=REMOVE_FILE;  break; /* File lschen        */
               case 'd': strncpy(printer,p,8);break;/* kopiert Druckername */
               case 'p': prflag=USE_FILTER;  break; /* Filter benutzen     */
               case 'm': gr_opt='0'+ *p;     break; /* Grafik optimieren   */
               case 't': check=REMOVE_ALL;   break; /* Alle Files lschen  */
               case 'h': strncpy(printer,IMG,8);    /* imagen ist Drucker  */
                         hpgl=OK; break;            /* hpgl Emulation      */
               default : printf("%s%s\n\n",badpa,argv[i]); /* Falscher Parameter  */
                         return BAD_SYNTAX;
             } /* ende switch */
           }  /* ende if     */
           else{
             if( strpbrk(argv[i],"?*") != NULL ) {	              	/* HT */
               printf("%s%s\n\n",badpa,argv[i]); /* keine Wildcards erlaubt */
               return BAD_SYNTAX;
             }
             file_name[filec++]=argv[i];      /* argv[i] ist Filename      */ 
             f_spec=SPEC_OK;                 /* wenn kein '-' voraus geht */
           }/* ende else */
        }/*ende for */

        if((!strcmp(printer,PR1)) && (!strcmp(printer,PR2))) 
                gr_opt=NO_OPT; /* Nur fj1 und fj2 knnen Grafik optimieren */ 

        switch(check){
            case BAD: 
                      if(f_spec==SPEC_OK){ /* keine Parameter nur Filename */
                          file_name[filec]=NULL; /* Liste mit NULL beenden */
                          return PRINT_FILE;
                      }
                      return BAD_SYNTAX;    /* Anweisung nicht sinnvoll    */
            case REMOVE_FILE:
                      if(f_spec==SPEC_BAD) return BAD_SYNTAX;
                      /* keine Files zum lschen spezifiziert */
                      return check;
            case REMOVE_ALL:
                      if(f_spec==SPEC_OK) return BAD_SYNTAX;
                      /* Wenn alle gelscht werden sollen, dann */
                      /* ist die Angabe eines Filenamen sinnlos */
                      return check;
            default:  return check;
        }  /* ende switch */
}

/*  */
/*                  Ausgabe der Syntax des prn-Kommandos                  */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  31.07.1990                                                  */
/*  */

static void
print_help(void)
{
    printf(  "Syntax: prn [<params>] <file> [<file>..]");
    printf("\n        netprint [<params>] <file> [<file>..]");
    printf("\n        Drucken von Files via UNIX-Rechner.");
    printf("\n        Maximal 16 Parameter bzw. Filenamen erlaubt!");
    printf("\n        <file> darf Pfade, aber keine Wildcards enthalten!\n");
    printf("\nParameter: -D<name> : Whlt Drucker 'name'. Default: 'fj2'.");
    printf("\n           -P       : Seitenformatierung und Zeilennummern ('pr').");
    printf("\n           -M<n>    : Grafikoptimierung fr fj-Drucker, <n>=0..6");
    printf("\n           -H       : HPGL-Emulation auf Imagen-Drucker.");
    printf("\n           -C       : Lscht Files aus der Warteschlange.");
    printf("\n                      Angabe des File-Namen (ohne Pfad) gengt!");
    printf("\n           -T       : Lscht alle Files des letzten Druckauftrags");
    printf("\n                      aus der Warteschlange\n");
}

static int
print_syntax(void)
{
    char quit_line[]="quit\n";
    
    print_help();
    
    prn_flag=0;
    ftpparse(quit_line,strlen(quit_line));
    mput_state=MPUT_PASSIV;
    return 0;
}        

/*  */
/* Ein file und das zugehrige infofile werden beim host gelscht         */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  17.07.1990                                                  */
/*  */

static int
file_delete(void)
{
        register struct ftp *ftp;
        char  line[32];
        char *cp;
        int i;

        ftp = current->cb.ftp;  /* Pointer auf momentane Session erfragen */
        for(i=0; i<filec; i++) {
          /* Filenamen extrahieren */
          if( ((cp=strrchr(file_name[i],'\\')) == NULL) &&
              ((cp=strrchr(file_name[i],':')) == NULL) )
            cp=file_name[i];		/* nur Filename */
          else
            cp++;					/* Zeichen hinter '\\' bzw. ':' */
  
          sprintf(line,"@a%x%s\r\n",c_addr,cp); 
          sndftpmsg(ftp,"DELE %s",line);       /* infofile lschen */
          sprintf(line,"a%x%s\r\n",c_addr,cp); 
          sndftpmsg(ftp,"DELE %s",line);       /* file lschen     */
        }
        sprintf(line,"quit\n");
        ftpparse(line,strlen(line));
        return 0;
}

/*  */
/* Alle gesendeten Files lschen (Noch nicht getestet)                    */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  17.07.1990                                                  */
/*  */

static int
all_delete(void)
{
     register struct ftp *ftp;
     char  line[32];
     int i=0;
     
     ftp = current->cb.ftp;
     if( old_file[0][0]== 0 ) printf("No files to cancel\n"); /* HT */
     while(old_file[i][0]!=0){
        printf("Cancel %s\n",old_file[i]);					/* HT */
        sprintf(line,"@a%x%s\r\n",c_addr,old_file[i]); 
        sndftpmsg(ftp,"DELE %s",line);
        sprintf(line,"a%x%s\r\n",c_addr,old_file[i]); 
        sndftpmsg(ftp,"DELE %s",line);
        i++;
     }
     old_file[0][0] = 0;		/* HT: File-Liste 'lschen' */
     sprintf(line,"quit\n");
     ftpparse(line,strlen(line));
     return 0;
}

/*  */
/* Zu jedem auszudruckenden File bentigt das Spool-Programm ein infofile */
/* dessen Namen mit '@' beginnt  (sonst kein Ausdruck)                    */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  17.07.1990                                                  */
/*  */

static int
write_info(void)
{
     FILE *fd;
     char pr[16];
     char op[8];
     char f_n[32];

     a_tmpfile(info_file);				/* get filename */
     fd = fopen (info_file, "w");
     if(fd==NULLFILE) return BAD;
     sprintf(f_n,"a%x%s ",c_addr,old_file[f_c]);
     fputs( f_n,fd );
                                          /* den Namen eintragen       */
     sprintf(pr," -d%s",printer);        /* Druckername montieren     */
     fputs( pr,fd );                    /* Druckername eintragen     */
     if (prflag==USE_FILTER)           /* Filter benutzen ?         */ 
         fputs( " -p",fd );           /* Aber natrlich mit Filter */
     if (hpgl==OK)
         fputs( " -H",fd );                      /* HPGL Emulator benutzen */
     if (gr_opt!=NO_OPT){                       /* Grafik optimieren      */ 
         sprintf(op," -m%d",gr_opt);           /* Parameter montieren    */
         fputs( op,fd );                      /* und eintragen          */
     }
     fputs( "                                                       ",fd);
     fputs( "                                                       \n",fd);
                   /* zuletzt noch cr anfgen*/
     fclose(fd);
     return OK;
}

/*  */
/* npr_send() orientiert sich sehr stark an dem mput()-Mechanismus und    */
/* ist teilweise eine direkte Kopie von mput_send(), beide Routinen werden*/
/* von der Hauptschleife in main() aufgerufen, wenn das zugehrige Flag   */
/* mput_state entsprechend gesetzt ist                                    */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  24.07.1990                                                  */
/*  */

int
npr_send(void)
{
    char *cp;
    char put_line[MAXPATH+7+16];     /* put_line ist die Eingabe fr den Parser  */ 
    struct ftp *ftp;
                           
    ftp=current->cb.ftp;
    ftp->type = IMAGE_TYPE;
    if(f_c<filec){        /* sind noch files zu verschicken ? */
       if(info_flag==BAD){
          /* Filenamen extrahieren: '\\' oder ':' von rechts suchen */
          if( ((cp=strrchr(file_name[f_c],'\\')) == NULL) &&
              ((cp=strrchr(file_name[f_c],':')) == NULL) )
            cp=file_name[f_c];		/* nur Filename */
          else
            cp++;					/* Zeichen hinter '\\' bzw. ':' */
          strncpy(old_file[f_c],cp,16);
         
          sprintf(put_line,"put %s a%x%s\n",file_name[f_c],c_addr,old_file[f_c]);
          mput_state = MPUT_AKTIV;
          ftpparse(put_line,strlen(put_line));
          if(ftp->state!=SENDING_STATE){
                mput_state=MPUT_PASSIV;
                sprintf(put_line,"quit\n");
                ftpparse(put_line,strlen(put_line));
                fflush(stdout);
                info_flag=BAD;
                prn_flag=0;
                return BAD;
          }
          printf("sending %s\n",file_name[f_c]);
          info_flag=OK;
       }
       else
       {
          if(write_info()==OK){ /* infofile auf Ramdisk schreiben */
              sprintf(put_line,"put %s @a%x%s\n",info_file,c_addr,old_file[f_c]);
              mput_state=MPUT_AKTIV; /* und rber senden */
              ftpparse(put_line,strlen(put_line));
              info_flag=BAD;
              f_c++;
          }
          else{
              printf("npr_send: can't write infofile\n");
              mput_state=MPUT_PASSIV;
                                        /* wenn ein infofile nicht     */
                                       /* geschrieben werden kann,    */
              info_flag=BAD;          /* brechen wir den Vorgang ab  */
              f_c=0;
              prn_flag=0;
              return BAD;
          }
       }
    }
    else{                             /* das letzte File wurde bertragen */
           old_file[f_c][0]=0;       /* wir beenden die session indem wir*/ 
           f_c=0;                   /* mit 'quit' ftp verlassen         */
           mput_state=MPUT_PASSIV;
           sprintf(put_line,"quit\n");
           ftpparse(put_line,strlen(put_line));
           fflush(stdout);
           info_flag=BAD;
           prn_flag=0;
    }
    return OK;
}

/*  */
/* doprn() ist in weiten Teilen eine Kopie von doftp() und sorgt dafr,   */
/* da wir uns automatisch auf dem UNIX-Rechner einloggen und eine        */
/* eigene session erhalten                                                */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  17.07.1990                                                  */
/*            02.09.91 Herbert Thielen: Hilfe bei Aufruf mit '-help'      */
/*  */

int
doprn(int argc,char *argv[])
{
        struct session *s;
        struct ftp *ftp;
        struct tcb *tcb;
        struct socket lsocket,fsocket;
        int i;
        
        if( argc==1 ){							/* HT */
           print_help();
           return 0;
        }

        prn_flag=1;
        ex_flag=1;
        for(i=0;i<argc;i++){     /* aber erst mssen wir die Parameter */
                strncpy(parse_argv[i],argv[i],MAXPATH);  /* retten */
                p_argv[i]=parse_argv[i];
        }
        npargc=argc;
        lsocket.address = ip_addr;
        lsocket.port = lport++;
        if((fsocket.address = resolve(host)) == 0){
                printf(badhost,host);
                return 1;
        }
        fsocket.port = FTP_PORT;

        /* Allocate a session control block */
        if((s = newsession()) == NULLSESSION){
                printf("Too many sessions\n");
                return 1;
        }
        current = s;
        if((s->name = malloc((unsigned)strlen(host)+1)) != NULLCHAR)
                strcpy(s->name,host);
        s->type = FTP;
        s->parse = ftpparse;

        /* Allocate an FTP control block */
        if((ftp = ftp_create(0)) == NULLFTP){ /* neue Session anlegen  */
                s->type = FREE;   /* Pech kein Platz fr neue Session */
                printf(nospace);
                return 1;
        }
        ftp->state = COMMAND_STATE;
        s->cb.ftp = ftp;        /* Downward link */
        ftp->session = s;       /* Upward link */

        /* Now open the control connection */
        tcb = open_tcp(&lsocket,&fsocket,TCP_ACTIVE,
                0,ftpnpr,NULLVFP,ftpccs,0,(char *)ftp);
                /* hier wurde ftpccr() durch unsere spezielle ftpnpr() */
                /* Routine ersetzt damit das einloggen automatisch     */
                /* abluft */
        ftp->control = tcb;
        go(argc,argv);
        return 0;
}

/*  */
/* ftpnpr() ist in weiten Teilen eine Kopie von ftpccr() */
/* Autor:     Michael Klingler                                            */
/* Version:   1.00                                                        */
/* nderung:  17.07.1990                                                  */
/*  */

static void
ftpnpr(register struct tcb *tcb, int16 cnt)
{
        struct mbuf *bp;
        struct ftp *ftp;
        char nu[4];
        int number = 0;
        char line[32];

        if((ftp = (struct ftp *)tcb->user) == NULLFTP){
                /* Unknown connection; kill it */
                close_tcp(tcb);
                return;
        }
        /* Hold output if we're not the current session */
        if((mode != CONV_MODE) || (current == NULLSESSION) || (current->cb.ftp != ftp))
                return;

        if(recv_tcp(tcb,&bp,cnt) > 0){
                while(bp != NULLBUF){
/*try*/
                        number = 0;
                        if(bp->data[3] == '-') number = -1;
                        if(bp->data[3] == ' '){
                                memcpy(nu, bp->data, 3);
                                nu[3] = '\0';
                                number = atoi(nu);
                                switch(number){
                                case 220:
/* bitte einloggen */                   logflag = 1;
/* logflag globale */                   sprintf(line,"dosprn\n");
                                        ftpparse(line,strlen(line));
/* Variable mit    */                   break;
/* default 0       */           case 331:
/* bitte Password */                    logflag = 2;
                                        sprintf(line,"dosprn\n");
                                        ftpparse(line,strlen(line));
                                        break;
                                case 530:
/* bitte Password */                    logflag = 2;
                                        sprintf(line,"dosprn\n");
                                        ftpparse(line,strlen(line));
                                        break;
                                case 503:
/* login incorrect */                   logflag = 3;
                                        break;
                                case 230:
/* login scheint korrekt */             logflag = 0;
                                        break;
                                }
                        }
                        switch(logflag){
/* number =503 */       case 3:
                                printf("login incorrect\n");
/* number =220 */       case 1:
                                break;
/* number =331,530 */   case 2:
                                break;
/* number =230 */       default:
/* oder sonstwas */             switch(number){
                                case 226:
                                        break;
                                case -1:
                                case 221:
                                        break;
                                default:
                                      if(current->cb.ftp->state == COMMAND_STATE && ex_flag){
                                           donpr(npargc,p_argv); 
                                           ex_flag=0;
                                      }
                                          /* mit den gemerkten Parametern */
                                         /* starten wir nun Netprint     */
                                }
                        }
/*end try*/
                        bp = free_mbuf(bp);
                }
                fflush(stdout);
        }
}



                    /*         ENDE PRINTFILE          */
                   /*         MK  13.06.1990          */      

