/* **************** PROTOTYPEN ******************** */

struct tcb *open_tcp(struct socket *lsocket, /* Local socket */
					 struct socket *fsocket, /* Remote socket */
					 int mode,               /* Active/passive/server */
					 int16 window,           /* Receive window (and send buffer) sizes */
					 void (*r_upcall)(struct tcb *tcb,int16 cnt), /* Function to call when data arrives */
					 void (*t_upcall)(struct tcb *tcb,int16 cnt), /* Function to call when ok to send more data */
					 void (*s_upcall)(struct tcb *tcb,char old,char new), /* Function to call when connection state changes */
					 char tos,
					 char *user);            /* User linkage area */

int send_tcp(register struct tcb *tcb,struct mbuf *bp);
int recv_tcp(register struct tcb *tcb,struct mbuf **bp,int16 cnt);
int close_tcp(register struct tcb *tcb);
int del_tcp(register struct tcb *tcb);
int tprintf(struct tcb *tcb,char *message,...);
int tcpval(struct tcb *tcb);
int kick_tcp(register struct tcb *tcb);
void reset_tcp(register struct tcb *tcb);
