/* ============================================================= */
/* BEISPIEL.C von Dirk Sabiwalsky 8/93 (Tabulator 5)			*/
/* ------------------------------------------------------------- */
/* Ein beispielhaftes Papillon-Modul zum Invertieren des selek-	*/
/* tierten Blocks										*/
/* ------------------------------------------------------------- */
/* Lassen Sie sich nicht durch die Lnge dieser C-Quelle		*/
/* entmutigen. Im Prinzip ist's ganz einfach! Das einzig		*/
/* problematische sind eventuell die eingeschrnkten AES-		*/
/* aufrufe (nur die Funktionen, fr die hier unten auch		*/
/* ein Makro angegeben ist, drfen verwendet werden). An-		*/
/* sonsten kann man wie gewohnt GEM-Dialoge programmieren.		*/
/* Allerdings mssen wir uns Event- und Fenster-Aufrufe hier	*/
/* verkneifen, weil das Protokoll einen gemeinsamen Modul-		*/
/* und Papillon-Redraws doch etwas ZU knifflig werden			*/
/* wrde. Aber die bereitgestellten AES-Routinen sollten schon	*/
/* fr Radiobuttons, Slider, Dialoge etc. ausreichen, oder? 	*/
/* ------------------------------------------------------------- */
/* Viel Spa beim Programmieren eigener Module wnschen Ihnen	*/
/* Stefan Becker und Dirk Sabiwalsky						*/
/* ============================================================= */

/* -------- */
/* Includes */
/* -------- */

#include <stdio.h>
#include <string.h>
#include <vdi.h>
#include <aes.h>		/* NUR fr Prototypen! AES-Calls sind NUR */
					/* ber die Funktionszeiger im Parameterblock */
					/* erlaubt! */

#include "beispiel.h"
#include "beispiel.rsh"	/* decompiliertes Resource */

#include "pap_mod.h"	/* Typen fr Papillon-Datenstrukturen */

/* ---------- */
/* Konstanten */
/* ---------- */

#define TRUE	1
#define FALSE	0

/* ------ */
/* Makros */
/* ------ */

#define ABS(x) 	(((x)>0) ? (x) : (-(x)))
#define MAX(x,y)	(((x)>(y)) ? (x) : (y))
#define MIN(x,y)	(((x)<(y)) ? (x) : (y))

/* ---------- */
/* Prototypen */
/* ---------- */

void cdecl do_module_job(void);   /* damit Konstantendeklaration unten mglich */

/* -------- */
/* Variable */
/* -------- */

int	vdi_handle,	/* Handle der VDI-Arbeitsstation */
	cb,ch;		/* Breite und Hhe eines Systemfont-Buchstabens */

/* ----------------------- */
/* Papillon-Parameterblock */
/* ----------------------- */

/* Den Papillon-Parameterblock NICHT umbenennen, weil sonst die */
/* Zugriffsmakros nicht mehr funktionieren wrden! */
/* Es darf nur einen solchen Parameterblock im Modul geben! */

EXTPAP_PARMS par = {
					MOD_MAGIC,	/* magic: Magic, welches Papillon sucht, */
								/* um den Parameterblock zu finden */

					/* die folgenden Werte trgt Papillon ein, bevor */
					/* er das Modul startet */

					0,			/* pap_vers: Papillon-Version */
					0,			/* appl_id: Applikations-ID */
					0,			/* vdi_handle: Handle einer VDI-Arbeitsstation */
					0,			/* char_width: Breite eines Systemfont-Buchstabens */
					0,			/* char_height: Hhe eines Systemfont-Buchstabens */
					0,			/* sys_planes: Anzahl der auf dem Monitor verfgbaren Farbebenen */
					NULL,		/* fsel_path: Zeiger auf aktuellen Fileselektor-Pfad */
					NULL,		/* in_pic_bm: Zeiger auf Eingabebild */
					NULL,		/* in_blk_bm: Zeiger auf Eingabeblock */
					NULL,		/* in_blk_msk: Zeiger auf die Maske zum Eingabeblock (kann NULL sein!) */
					NULL,		/* pic_name: Zeiger auf den Namen einer Bilddatei, */
								/* die das Modul laden soll (fr Module, die keine */
								/* Eingabe erhalten und neue Bilder liefern und sich */
								/* in <file_ext> fr einen Bildtyp verantwortlich erklrt */
								/* haben */

					/* allgemeine Funktionszeiger */

					NULL,		/* pap_new_pic */
					NULL,		/* pap_free_pic */
					NULL,		/* pap_malloc */
					NULL,		/* pap_calloc */
					NULL,		/* pap_free */
					NULL,		/* pap_alert */

					/* AES-Funktionszeiger */

					NULL,		/* pap_form_center */
					NULL,		/* pap_form_dial */
					NULL,		/* pap_objc_draw */
					NULL,		/* pap_form_do */
					NULL,		/* pap_rsrc_obfix */
					NULL,		/* pap_graf_mkstate */
					NULL,		/* pap_objc_offset */
					NULL,		/* pap_graf_slidebox */
					NULL,		/* pap_appl_find */
					NULL,		/* pap_appl_read */
					NULL,		/* pap_appl_write */
					NULL,		/* pap_graf_mouse */
					NULL,		/* pap_fsel_input */
					NULL,		/* pap_fsel_exinput */

					/* USERDEF-Routinen fr Checkboxen, Radiobuttons */
					/* und unterstrichenen Text */

					NULL,		/* pap_init_userdefs */
					NULL,		/* pap_forget_userdefs */

					/* reservierte Bytes */

					"",			/* res1 */

					/* die folgenden Werte sind modulspezifisch, also */
					/* bitte selbst eintragen! */

					{
					    0x00,0x00,0x03,0x00,0x00,0x00,0x05,0x80,0x00,0x00,0x0B,0x80,0x00,0x1C,0x17,0x00,
					    0x00,0x12,0x2E,0x00,0x00,0x19,0x5C,0x00,0x00,0x14,0xB8,0x06,0x00,0x22,0x70,0x0B,
					    0x00,0x41,0x20,0x17,0x00,0x80,0x90,0x2E,0x01,0x00,0x48,0x5C,0x02,0x00,0x24,0xB8,
					    0x04,0x00,0x13,0x70,0x04,0x00,0x09,0xE0,0x04,0x00,0x04,0xC0,0x04,0x00,0x02,0x40,
					    0x04,0x00,0x01,0x20,0x04,0x00,0x00,0x90,0x04,0x00,0x01,0x50,0x04,0x00,0x02,0xF0,
					    0x04,0x00,0x05,0xE0,0x04,0x00,0x0B,0x00,0x08,0x00,0x16,0x00,0x10,0x7F,0xEC,0x00,
					    0x20,0x80,0x18,0x00,0x41,0x7F,0xF0,0x00,0x82,0xFF,0xE0,0x00,0x85,0x80,0x00,0x00,
					    0x4B,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00
					},			/* mod_icon: das Icon des Moduls (schwarz/wei, 32 * 32 Pixel) */

					"Invertieren", /* mod_name: der Name des Moduls */

					"",			/* file_ext: hier trgt man den Dateityp ein, den das Modul */
								/* laden kann (z.B. "IMG" fr GEM-Image-Bilder) */
								/* <mod_gets> mu dann M_GETS_NIX und <mod_sends> mu M_SENDS_PIC */
								/* sein. */
								/* in <pic_name> liefert Papillon dann den kompletten Namen */
								/* der zu ladenden Bilddatei */

					M_GETS_BLOCK,	/* mod_gets: was erhlt das Modul vom Papillon? (hier: einen Block) */
					M_SENDS_BLOCK, /* mod_sends: was liefert das Modul zurck? (hier: einen Block) */

					/* hier werden die Ausgabedaten eingetragen */
					/* !Achtung! ALLE Ausgabebitmaps mssen vom Modul allokiert werden! */
					/* das Modul darf KEINE Eingabebitmaps freigeben oder als Ausgabebitmap verwenden! */
					
					NULL,		/* out_pic_bm: dieses Bild liefert das Modul */
					NULL,		/* out_blk_bm: diesen Block liefert das Modul */
					NULL,		/* out_blk_mask: diese Maske liefert das Modul (kann auch NULL sein!) */

					do_module_job, /* do_job: Verweis auf die Modul-Hauptroutine */
					0,			/* erg_code: Ergebniscode des Moduls */
								/* (erg_code<=0 bedeutet Fehler, erg_code>0 alles OK) */

					/* reservierte Bytes */
					""			/* res2 */
				};

/* ------------------------- */
/* Hilfsroutinen fr Dialoge */
/* ------------------------- */

int get_objflags(OBJECT *ob, int item)
{
	return(ob[item].ob_flags);
}

void set_objflag(OBJECT *ob, int item, int flag)
{
	ob[item].ob_flags|=flag;
}

void clear_objflag(OBJECT *ob, int item, int flag)
{
	ob[item].ob_flags&=~flag;
}

int get_objstate(OBJECT *ob, int item)
{
	return(ob[item].ob_state);
}

void set_objstate(OBJECT *ob, int item, int state)
{
	ob[item].ob_state|=state;
}

void clear_objstate(OBJECT *ob, int item, int state)
{
	ob[item].ob_state&=~state;
}

void set_objselection(OBJECT *ob, int item, int flag)
{
	if(flag)
	{
		set_objstate(ob,item,SELECTED);
	}
	else
	{
		clear_objstate(ob,item,SELECTED);
	}
}

int object_selected(OBJECT *ob, int item)
{
	return(get_objstate(ob,item) & SELECTED);
}

void enable_button(OBJECT *ob, int item)
{
	set_objflag(ob,item,SELECTABLE);
	clear_objstate(ob,item,DISABLED);
}

void disable_button(OBJECT *ob, int item)
{
	clear_objflag(ob,item,SELECTABLE);
	set_objstate(ob,item,DISABLED);
}

void get_objtext(OBJECT *ob, int item, char *s)
{
     switch(ob[item].ob_type & 0xff)
     {
          case G_USERDEF :    strcpy(s,(char*)ob[item].ob_spec.userblk->ub_parm);
                              break;
          case G_TEXT :
          case G_BOXTEXT :
          case G_FTEXT :
          case G_FBOXTEXT :   strcpy(s,ob[item].ob_spec.tedinfo->te_ptext);
                              break;
          case G_BUTTON:
          case G_STRING :
          case G_TITLE :      strcpy(s,ob[item].ob_spec.free_string);
                              break;
     }
}

void set_objtext(OBJECT *ob, int item, char *s)
{
     switch(ob[item].ob_type & 0xff)
     {
          case G_USERDEF :    strcpy((char*)ob[item].ob_spec.userblk->ub_parm,s);
                              break;
          case G_TEXT :
          case G_BOXTEXT :
          case G_FTEXT :
          case G_FBOXTEXT :   strcpy(ob[item].ob_spec.tedinfo->te_ptext,s);
                              break;
          case G_BUTTON:
          case G_STRING :
          case G_TITLE :      strcpy(ob[item].ob_spec.free_string,s);
                              break;
     }
}

/* ---------------------------------------------------------- */
/* decompiliertes Resource an aktuelle die Auflsung anpassen */
/* ---------------------------------------------------------- */

void init_rsc(void)
{
	int	i;

	for(i=0;i<NUM_OBS;i++)
	{
		rsrc_obfix(rs_object,i);
	}
}

void fix_pixels(int *coord,int this_size, int design_size)
{
	int	px;

	px=*coord>>8;
	if(px)
	{
		px=px*this_size/design_size;
		*coord=(*coord & 0xff) | (px<<8);
	}
}

void fix_koordinates(void)
{
	int		i;
	OBJECT	*this_ob;
	
	for(i=0;i<NUM_OBS;i++)
	{
		this_ob=&rs_object[i];
	
		if(   this_ob>=TREE[1]
		   && (this_ob->ob_type & 0xff)!=G_IMAGE
		   && (this_ob->ob_type & 0xff)!=G_ICON)
		{
			fix_pixels(&(this_ob->ob_x),cb,8);
			fix_pixels(&(this_ob->ob_y),ch,16);
			fix_pixels(&(this_ob->ob_width),cb,8);
			fix_pixels(&(this_ob->ob_height),ch,16);
		}
	}
}

/* ----------------------- */
/* eine Bitmap invertieren */
/* ----------------------- */

void invert_plane(char *plane, long size)
{
	long    *lptr;
	char    *cptr;
	
	lptr=(long*)plane;
	while(size>sizeof(long)*8)
	{
		*lptr++ ^= 0xFFFFFFFFL;
		*lptr++ ^= 0xFFFFFFFFL;
		*lptr++ ^= 0xFFFFFFFFL;
		*lptr++ ^= 0xFFFFFFFFL;
		*lptr++ ^= 0xFFFFFFFFL;
		*lptr++ ^= 0xFFFFFFFFL;
		*lptr++ ^= 0xFFFFFFFFL;
		*lptr++ ^= 0xFFFFFFFFL;

		size -= sizeof(long)*8;
	}

	cptr=(char*)lptr;
	while(size-- > 0)
	{
		*cptr++ ^= 0xFF;
	}
}

void invert_bitmap(C_BITMAP *bm)
{
	int	i;

	if(bm==NULL) return;
	
	for(i=0;i<bm->bm_planes;i++)
	{
		invert_plane(bm->bm_adr[i],(long)bm->bm_words * 2L * (long)bm->bm_height);
	}
}

/* --------------------------------------------------- */
/* Modul-Hauptroutine (wird vom Papillon angesprungen) */
/* --------------------------------------------------- */

void cdecl do_module_job(void)
{
	int		xd,yd,wd,hd,exit_obj;
	C_BITMAP	*new_block=NULL,*new_mask=NULL;

	/* wurde vom Papillon ein Block bergeben? */
	if(par.in_blk_bm==NULL)
	{
		alert("Dieses Modul bentigt einen selektierten Block als Eingabe!","Abbruch");
		par.erg_code=-1;	/* Ergebniscode: Fehler */
		return;			/* zurck zum Papillon */
	}

	/* globale Variablen vorbelegen */
	vdi_handle=par.vdi_handle;
	cb=par.char_width;
	ch=par.char_height;

	/* Resource an Auflsung anpassen */
	init_rsc();
	fix_koordinates();

	/* USERDEFS initialisieren (fr Checkboxen, Radiobuttons, unterstrichenen Text) */
	init_userdefs(rs_object,NUM_OBS);
	
	/* Maus auf Pfeil */
	graf_mouse(ARROW,0);

	/* Dialog abarbeiten */
     form_center(TREE[DMAIN],&xd,&yd,&wd,&hd);
     form_dial(FMD_START,0,0,0,0,xd,yd,wd,hd);
     objc_draw(TREE[DMAIN],0,MAX_DEPTH,xd,yd,wd,hd);
     exit_obj=form_do(TREE[DMAIN],0) & 0x7fff;
     clear_objstate(TREE[DMAIN],exit_obj,SELECTED);
     form_dial(FMD_FINISH,0,0,0,0,xd,yd,wd,hd);

	/* was hat der User ausgewhlt? */
	if(exit_obj==RSD_CANCEL)
	{
		par.erg_code=0;					/* Nix passiert! */
		forget_userdefs(rs_object,NUM_OBS);	/* Userdefs wieder freigeben */
		return;							/* zurck zum Papillon */
	}

	/* Maus auf Biene */
	graf_mouse(BUSYBEE,0);
	
	/* einen neuen Block allokieren */
	if(new_bitmap(&new_block,par.in_blk_bm->bm_width,par.in_blk_bm->bm_height,par.in_blk_bm->bm_planes,par.in_blk_bm->bm_colors,TRUE)<0)
	{
		/* Speichermangel! */
		par.erg_code=-1;	/* Ergebniscode: Fehler */
		return;			/* zurck zum Papillon */
	}
	
	/* den alten Block in den neuen kopieren */
	memcpy(new_block->bm_adr[0],
		  par.in_blk_bm->bm_adr[0],
		  (long)par.in_blk_bm->bm_words * 2L * (long)par.in_blk_bm->bm_height * (long)par.in_blk_bm->bm_planes);

	/* Wenn das Modul zum Block zustzlich eine Maske als */
	/* Eingabeparameter erhalten hat, wird auch eine Maske */
	/* zurckgeliefert, die allerdings extra allokiert werden */
	/* mu! */
	
	if(par.in_blk_msk!=NULL)	/* Maske da? */
	{
		/* neue Maske allokieren */
		if(new_bitmap(&new_mask,par.in_blk_msk->bm_width,par.in_blk_msk->bm_height,1,NULL,TRUE)<0)
		{
			/* Speichermangel! */
			par.erg_code=-1;	/* Ergebniscode: Fehler */
			return;			/* zurck zum Papillon */
		}

		/* die alte Maske in die neue kopieren */
		memcpy(new_mask->bm_adr[0],
			  par.in_blk_msk->bm_adr[0],
			  (long)par.in_blk_msk->bm_words * 2L * (long)par.in_blk_msk->bm_height);
	}
	
	/* den Block invertieren */
	invert_bitmap(new_block);

	/* Maus auf Pfeil */
	graf_mouse(ARROW,0);
	
	/* Ergebnisbitmaps des Moduls eintragen */
	par.out_blk_bm = new_block;
	par.out_blk_msk = new_mask;

	par.erg_code = 1;			/* Ergebniscode: alles klar! */

	/* RSC-Userdefs wieder freigeben */
	forget_userdefs(rs_object,NUM_OBS);
}

/* -------------------------------- */
/* Hauptprogramm (NICHT verndern!) */
/* -------------------------------- */

int main(void)
{
	int	niemals=FALSE;

	/* damit der Linker die Funktion <do_module_job> */
	/* nicht kurzerhand rauswirft: */
	
	if(niemals)			/* Immer FALSE ;-) */
	{
		do_module_job();	/* Dummy-Call, der nie aufgerufen wird */
	}
	
	/* eine Meldung ausgeben, falls das Modul irrtmlich gestartet wird */
	
	puts("\nPapillon-Module knnen nicht als eigenstndige\n"
		"Programme gestartet werden!\nBitte Taste drcken\n!");
		
	getchar();	/* Auf Tastendruck warten */
	return(-1);	/* Auf Wiedersehen */
}

/* =================== */
/* Ende von BEISPIEL.C */
/* =================== */
