/* ============================================================= */
/* PAP_MOD.H von Dirk Sabiwalsky 8/93 (Tabulator 5)			*/
/* ------------------------------------------------------------- */
/* Konstanten und Typen fr Papillon-Module					*/
/* ============================================================= */

/* ---------- */
/* Konstanten */
/* ---------- */

#define MOD_MAGIC   "PaPi-MoD"  /* Magic fr Papillon-Modulstart */

#define MAX_PLANES  8           /* Maximale Anzahl an Farbebenen pro Bild */
#define MAX_COLORS  256         /* Maximale Anzahl von Farben pro Bild */
#define RGB_COLORS  3           /* Anzahl von Eintrgen in einem RGB */

/* Modul-I/O-Definitionen */
#define M_GETS_NIX      0       /* Modul braucht KEINE Eingabedaten */
#define M_GETS_PIC      1       /* Modul braucht ein Eingabebild */
#define M_GETS_BLOCK    2       /* Modul braucht einen Eingabeblock */
#define M_GETS_FILE     3       /* Modul erhlt unbekannte Bildfiles, */
                                /* z.B. fr neue Bildlader */

#define M_SENDS_NIX     0       /* Modul liefert KEINE neuen Daten */
#define M_SENDS_PIC     1       /* Modul generiert ein ganz neues Bild */
#define M_SENDS_BLOCK   2       /* Modul generiert einen neuen Block */

/* ------------- */
/* diverse Typen */
/* ------------- */

typedef int RGB[RGB_COLORS];	/* ein einzelner Farbwert (Promilleanteile) */

typedef struct				/* eine Papillon-Bitmap im Standardformat */
{
	int	bm_width,           /* Breite in Pixeln */
		bm_height,          /* Hhe in Pixeln */
		bm_words,           /* Breite in Words: (bm_width+15)/16 */
		bm_planes;          /* Anzahl der Farbebenen: 1..MAX_PLANES */
	RGB  *bm_colors;         /* die RGB-Werte der Farben: 2^(bm_planes-1) */
	char *bm_adr[MAX_PLANES];/* Adressen der einzelnen Bildplanes */
} C_BITMAP;

/* ---------------------------------- */
/* Typen der Papillon-Funktionszeiger */
/* ---------------------------------- */

/* allgemeine Funktionszeiger */

typedef void cdecl (*JOB_PTR)(void);
typedef int cdecl (*NEWPIC_FKT)(C_BITMAP **pic, int xauf, int yauf, int planes, RGB *colors, int show_warning);
typedef void cdecl (*FREEPIC_FKT)(C_BITMAP *pic);
typedef void* cdecl (*MALL_FKT)(size_t bytes);
typedef void* cdecl (*CALL_FKT)(size_t n, size_t s);
typedef void cdecl (*FREE_FKT)(void *ptr);
typedef void cdecl (*ALRT_FKT)(char *msg, char *button);

/* AES-Funktionszeiger */

typedef int cdecl (*FORM_CENTER_FKT) (OBJECT *tree, int *x, int *y, int *w, int *h);
typedef int cdecl (*FORM_DIAL_FKT) (int a, int b, int c, int d, int e, int x, int y, int w, int h);
typedef int cdecl (*OBJC_DRAW_FKT) (OBJECT *t, int a, int b, int x, int y, int w, int h);
typedef int cdecl (*FORM_DO_FKT) (OBJECT *t, int s);
typedef int cdecl (*RSRC_OBFIX_FKT) (OBJECT *t, int o);
typedef int cdecl (*GRAF_MKSTATE_FKT) (int *a, int *b, int *c, int *d);
typedef int cdecl (*OBJC_OFFSET_FKT) (OBJECT *t, int o, int *x, int *y);
typedef int cdecl (*GRAF_SLIDEBOX_FKT) (OBJECT *t, int a, int b, int c);
typedef int cdecl (*APPL_FIND_FKT) (const char *apname);
typedef int cdecl (*APPL_READ_FKT) (int id, int length, void *buf);
typedef int cdecl (*APPL_WRITE_FKT) (int id, int length, void *buf);
typedef int cdecl (*GRAF_MOUSE_FKT) (int number, MFORM *m);
typedef int cdecl (*FSEL_INPUT_FKT) (char *p, char *s, int *b);
typedef int cdecl (*FSEL_EXINPUT_FKT) (char *p, char *s, int *b, char *m);

/* USERDEF-Routinen fr Checkboxen, Radiobuttons und unterstrichenen Text */

typedef void cdecl (*INIT_USERDEFS) (OBJECT rs_object[], int num_obs);
typedef void cdecl (*FORGET_USERDEFS) (OBJECT rs_object[], int num_obs);

/* ------------------------------------------------------------- */
/* Makros zum leichten Aufruf der von Papillon bereitgestellten	*/
/* Funktionen ohne langes Rumhantieren mit Pointern etc.		*/
/* ------------------------------------------------------------- */

/* allgemeine Funktionen */

#define new_bitmap(p,x,y,l,c,m)		(*(par.pap_newpic))(p,x,y,l,c,m)
#define free_bitmap(b)				(*(par.pap_freepic))(b)
#define malloc(b)					(*(par.pap_malloc))(b)
#define calloc(n,b) 				(*(par.pap_calloc))(n,b)
#define free(p)					(*(par.pap_free))(p)
#define alert(m,b)					(*(par.pap_alert))(m,b)

/* AES-Funktionen */

#define form_center(t,x,y,b,h)		(*(par.pap_form_center))(t,x,y,b,h)
#define form_dial(a,b,c,d,e,x,y,w,h)	(*(par.pap_form_dial))(a,b,c,d,e,x,y,w,h)
#define objc_draw(t,a,b,x,y,w,h)		(*(par.pap_objc_draw))(t,a,b,x,y,w,h)
#define form_do(t,s)				(*(par.pap_form_do))(t,s)
#define rsrc_obfix(t,o)				(*(par.pap_rsrc_obfix))(t,o)
#define graf_mkstate(a,b,c,d) 		(*(par.pap_graf_mkstate))(a,b,c,d)
#define objc_offset(t,o,x,y)			(*(par.pap_objc_offset))(t,o,x,y)
#define graf_slidebox(t,a,b,c)		(*(par.pap_graf_slidebox))(t,a,b,c)
#define appl_find(n)				(*(par.pap_appl_finf))(n)
#define appl_read(i,l,b) 			(*(par.pap_appl_read))(i,l,b)
#define appl_write(i,l,b)			(*(par.pap_appl_write))(i,l,b)
#define graf_mouse(n,p)				(*(par.pap_graf_mouse))(n,p)
#define fsel_input(p,s,b)			(*(par.pap_fsel_input))(p,s,b)
#define fsel_exinput(p,s,b,m) 		(*(par.pap_fsel_exinput))(p,s,b,m)

/* USERDEF-Routinen fr Checkboxen, Radiobuttons und unterstrichenen Text */

#define init_userdefs(r,n)			(*(par.pap_init_userdefs))(r,n)
#define forget_userdefs(r,n)			(*(par.pap_forget_userdefs))(r,n)

/* --------------------------- */
/* der Papillon-Parameterblock */
/* --------------------------- */

typedef struct
{
	char	magic[8];				/* Magic, welches Papillon sucht, um den */
							/* Parameterblock zu finden */
							/* mu "PaPi-MoD" sein (case-sensitive) */
	
	/* die folgenden Werte trgt Papillon ein, bevor er das Modul startet */
	
	int	pap_vers;       		/* Papillon-Version */
	int	appl_id;        		/* Applikations-ID von Papillon */
	int	vdi_handle;     		/* Handle einer VDI-Arbeitsstation */
	int	char_width;     		/* Breite eines Systemfont-Buchstabens */
	int	char_height;    		/* Hhe eines Systemfont-Buchstabens */
	int	sys_planes;     		/* Anzahl der auf dem Monitor verfgbaren Farbebenen */
	char	*fsel_path;			/* Zeiger auf aktuellen Fileselektor-Pfad */
	C_BITMAP	*in_pic_bm;		/* Zeiger auf Eingabebild */
	C_BITMAP	*in_blk_bm;		/* Zeiger auf Eingabeblock */
	C_BITMAP	*in_blk_msk;		/* Zeiger auf die Maske zum Eingabeblock (kann NULL sein!) */
	char	*pic_name;			/* Zeiger auf den Namen einer Bilddatei, */
							/* die das Modul laden soll (fr Module, die keine */
							/* Eingabe erhalten und neue Bilder liefern und sich */
							/* in <file_ext> fr einen Bildtyp verantwortlich erklrt */
							/* haben */
	
	/* Funktionen, die Papillon dem Modul bereitstellt */
	/* Falls derartige Funktionen vom Modul gebraucht werden, */
	/* dann AUSSCHLIESSLICH DIESE verwenden! */
	
	/* allgemeine Funktionszeiger */
	
	NEWPIC_FKT	pap_newpic;	/* Funktion, die eine neue Bitmap erzeugt */
	FREEPIC_FKT	pap_freepic;	/* Funktion, die eine Bitmap wieder freigibt */
	MALL_FKT		pap_malloc;	/* Funktion, die Speicher reserviert */
	CALL_FKT		pap_calloc;	/* Funktion, die gelschten Speicher reserviert */
	FREE_FKT		pap_free;		/* Funktion, die Speicher wieder freigibt */
	ALRT_FKT		pap_alert;	/* Funktion, die eine Papillon-Alarmmeldung ausgibt */
	
	/* AES-Funktionszeiger; KEINE anderen AES-Funktionen benutzen! */

	FORM_CENTER_FKT     pap_form_center;	/* ^form_center */
	FORM_DIAL_FKT       pap_form_dial;      /* ^form_dial */
	OBJC_DRAW_FKT       pap_objc_draw;      /* ^objc_draw */
	FORM_DO_FKT         pap_form_do;        /* ^form_do */
	RSRC_OBFIX_FKT      pap_rsrc_obfix;     /* ^rsrc_obfix */
	GRAF_MKSTATE_FKT    pap_graf_mkstate;   /* ^graf_mkstate */
	OBJC_OFFSET_FKT     pap_objc_offset;    /* ^objc_offset */
	GRAF_SLIDEBOX_FKT	pap_graf_slidebox;  /* ^graf_slidebox */
	APPL_FIND_FKT       pap_appl_find;      /* ^appl_find */
	APPL_READ_FKT       pap_appl_read;      /* ^appl_read */
	APPL_WRITE_FKT      pap_appl_write;     /* ^appl_write */
	GRAF_MOUSE_FKT      pap_graf_mouse;     /* ^graf_mouse */
	FSEL_INPUT_FKT      pap_fsel_input;     /* ^fsel_input */
	FSEL_EXINPUT_FKT    pap_fsel_exinput;   /* ^fsel_exinput */
	
	/* USERDEF-Routinen fr Checkboxen, Radiobuttons und unterstrichenen Text */
	/* Buttons und Radiobuttons werden Mac-a-like dargestellt, */
	/* Text-Objekte mit erweitertem Objekttyp 255 werden unterstrichen */
	
	INIT_USERDEFS       pap_init_userdefs;		/* ^init_userdefs */
	FORGET_USERDEFS	pap_forget_userdefs;	/* ^forget_userdefs */
	
	/* reservierte Bytes fr zuknftige Erweiterungen (voerst = 0) */
	
	char	res1[64];
	
	/* die folgenden Werte sind modulspezifisch, also bitte selbst eintragen! */
	
	char	mod_icon[128];			/* das Icon des Moduls (schwarz/wei, 32 * 32 Pixel) */
	char	mod_name[36];   		/* der Name des Moduls */
	char	file_ext[4];			/* file_ext: hier trgt man den Dateityp ein, den das Modul */
							/* laden kann (z.B. "IMG" fr GEM-Image-Bilder) */
							/* <mod_gets> mu dann M_GETS_NIX und <mod_sends> mu M_SENDS_PIC */
							/* sein. */
							/* in <pic_name> liefert Papillon dann den kompletten Namen */
							/* der zu ladenden Bilddatei */
	int	mod_gets;				/* was erhlt das Modul vom Papillon? */
	int	mod_sends;			/* was liefert das Modul zurck? */

	/* hier werden die Ausgabedaten eingetragen */
	/* !Achtung! ALLE Ausgabebitmaps mssen vom Modul allokiert werden! */
	/* das Modul darf KEINE Eingabebitmaps freigeben oder als Ausgabebitmap verwenden! */

	C_BITMAP	*out_pic_bm;		/* dieses Bild liefert das Modul, NULL falls keins */
	C_BITMAP	*out_blk_bm;		/* diesen Block liefert das Modul, NULL falls keiner */
	C_BITMAP	*out_blk_msk;		/* diese Maske liefert das Modul, NULL falls keine */
	
	JOB_PTR	do_job;			/* Verweis auf die Modul-Hauptroutine */
	int	erg_code;				/* Ergebniscode des Moduls */
							/* (erg_code<=0 bedeutet Fehler, erg_code>0 alles OK) */

	/* reservierte Bytes fr zuknftige Erweiterungen (voerst = 0) */
	
	char	res2[64];
	
} EXTPAP_PARMS;

/* ================== */
/* Ende von PAP_MOD.H */
/* ================== */
