*************************************************************************
* Example program for the use of SINGSONG.				*
*************************************************************************

super	MACRO
	clr.l	-(sp)
	move.w	#$20,-(sp)
	trap	#1
	addq.l	#6,sp
	move.l	d0,oldsp
	ENDM

unsuper	MACRO
	move.l	oldsp,-(sp)
	move.w	#$20,-(sp)
	trap	#1
	addq.l	#6,sp
	ENDM

*	*	*	*	*	*	*	*	*	*

sing	move.l	4(a7),a3		; base page
	move.l	#mystack,a7
	move.l	$c(a3),d0		; text len
	add.l	$14(a3),d0		; data len
	add.l	$1c(a3),d0		; BSS len
	add.l	#$100,d0		; basepage
	move.l	d0,-(sp)
	move.l	a3,-(sp)
	clr.w	-(sp)
	move.w	#$4a,-(sp)
	trap	#1			; release memory
	add.l	#12,sp

	move.l	#215000,-(sp)		; malloc data area
	move.w	#$48,-(sp)
	trap	#1
	addq.l	#6,sp
	move.l	d0,song_ptr
	add.l	#10000,d0
	move.l	d0,vset_ptr

	pea	env_str			; execute singsong
	pea	cmd_str
	pea	prog_nm
	move.w	#3,-(sp)
	move.w	#$4b,-(sp)
	trap	#1
	add.l	#14,sp
	add.l	#256,d0
	move.l	d0,prog_ptr

	lea	song_nm,a4		; load song
	move.l	song_ptr,a5
	move.l	#$10000,a6
	bsr	open

	lea	vset_nm,a4		; load voice set
	move.l	vset_ptr,a5
	move.l	#200000,a6
	bsr	open

	super				; supervisor mode!

	move.l	prog_ptr,a6		; play the song
	move.l	song_ptr,12(a6)
	move.l	vset_ptr,16(a6)
	jsr	4(a6)

.loop2	movem.l	d0-d7/a0-a6,-(sp+
	bsr	clrscr
	bsr	blah
	bsr	flip
	bsr	msprs
	movem.l	(sp)+,d0-d7/a0-a6
	bra	goon	
	
msprs	lea.l	cordbuf,a0
	bsr	moveit
	lea.l	cordbuf2,a0
	bsr	moveit
	lea.l	cordbuf3,a0
	bsr	moveit
	lea.l	cordbuf4,a0
	bsr	moveit
	lea.l	cordbuf5,a0
	bsr	moveit
	rts
	
	
moveit	move.w	6(a0),d0	;pull xvel
	move.w	8(a0),d1	;pull yvel
	add.w	d0,(a0)		;add it to xcord
	add.w	d1,2(a0)	;add it to ycord
	tst.w	(a0)		;xcord
	bmi	negx
	cmp.w	#300,(a0)	;at right
	beq	negx
xneged
	tst.w	2(a0)		;ycord
	bmi	negy
	cmp.w	#180,2(a0)	;at bot
	beq	negy
yneged
	rts
	
negx	neg.w	6(a0)
	bra	xneged

negy	neg.w	8(a0)
	bra	yneged
	
	rts
	
blah	lea.l	cordbuf,a0
	bsr	pspr
	lea.l	cordbuf2,a0
	bsr	pspr
	lea.l	cordbuf3,a0
	bsr	pspr
	lea.l	cordbuf4,a0
	bsr	pspr
	lea.l	cordbuf5,a0
	bsr	pspr
	rts

pspr
	move.w	(a0),d0		;x
	move.w	2(a0),d1	;y
	move.w	4(a0),d6	;height
	move.l	10(a0),a2	;graphic addr
	move.w	d0,d5		;for anding later
	muls	#160,d1
	lsr.w	#4,d0		;/16-also gfets rid of bot 4 bits
	lsl.w	#3,d0		;*8
	add.w	d0,d1		;reletive offset
	move.l	logadr,a1
	
	add.l	d1,a1
	and.w	#15,d5		;rotation amount

right_16	
		move.l	#$ffffffff,d0
		moveq.l	#0,d1		*plane1
		moveq.l	#0,d2		*plane2
		moveq.l	#0,d3		*plane3
		moveq.l	#0,d4		*plane4
		move.w	(a2)+,d0	*get line of mask data
		move.w	(a2)+,d1	*get plane 1
		move.w	(a2)+,d2
		move.w	(a2)+,d3
		move.w	(a2)+,d4	*get plane 4
		ror.l	d5,d0		*d5 has scroll amount
		ror.l	d5,d1
		ror.l	d5,d2
		ror.l	d5,d3
		ror.l	d5,d4
		and.w	d0,(a1)		*mask and or in left side
		or.w	d1,(a1)+
		and.w	d0,(a1)
		or.w	d2,(a1)+
		and.w	d0,(a1)
		or.w	d3,(a1)+
		and.w	d0,(a1)
		or.w	d4,(a1)+
		swap	d0
		swap	d1
		swap	d2
		swap	d3
		swap	d4
		and.w	d0,(a1)		*mask and or in right side
		or.w	d1,(a1)+
		and.w	d0,(a1)
		or.w	d2,(a1)+
		and.w	d0,(a1)
		or.w	d3,(a1)+
		and.w	d0,(a1)
		or.w	d4,(a1)+
		lea.l	144(a1),a1
		dbra	d6,right_16
		rts
		

clrscr	
	move.l	logadr,a0
	move.l	#pic,a1
	move.w	#999,d7
loop
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	dbra	d7,loop
	rts

flip	
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	physadr,d0
	move.l	logadr,d1
	move.l	d1,physadr
	move.l	d0,logadr
	move.w	#0,-(sp)
	move.l	physadr,-(sp)
	move.l	logadr,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#12,sp
	move.w	#37,-(sp)	;wait vbl
	trap	#14
	addq.l	#2,sp		;??
	movem.l	(sp)+,d0-d7/a0-a6
	rts
	
	
	section data
	
logadr	dc.l	$70000
physadr	dc.l	$78000
height	dc.w	0
space	ds.b	2560
ustk	dc.l	0
	ds.b	256
cordbuf	dc.w	120,0,15,0,5	;x,y,height,xvel,yvel
	dc.l	grapbuf
cordbuf2 dc.w	140,0,15,0,4
	dc.l	grapbuf
cordbuf3
	dc.w	160,0,15,0,3
	dc.l	grapbuf
cordbuf4
	dc.w	180,0,15,0,4
	dc.l	grapbuf
cordbuf5
	dc.w	200,0,15,0,5
	dc.l	grapbuf
pic	

grapbuf	incbin	b:spr16a.dat

goon	cmp.b	#$39,(a6)		; check for space key
	bne	.loop2			; carryon if not pressed

	move.l	prog_ptr,a6		; stop playing
	jsr	8(a6)

	unsuper				; user mode

	clr.w	-(sp)			; program terminate
	move.w	#$4c,-(sp)
	trap	#1

*	*	*	*	*	*	*	*	*	*

open	clr.w	-(sp)			; load a file
	move.l	a4,-(sp)		; a4 -> filename
	move.w	#$3d,-(sp)
	trap	#1
	addq.l	#8,sp
	tst.w	d0
	bmi	diskerr
	move.w	d0,-(sp)		; store file handle

read	move.l	a5,-(sp)		; read file to data area
	move.l	a6,-(sp)
	move.w	d0,-(sp)
	move.w	#$3f,-(sp)
	trap	#1
	add.w	#12,sp
	move.l	d0,d7			; store length

close	move.w	#$3e,-(sp)		; close file
	trap	#1			; handle already on stack
	addq.l	#4,sp
	move.l	d7,d0
	tst.l	d0			; d0=bytes loaded, -ve=err
diskerr	rts

*	*	*	*	*	*	*	*	*	*

prog_ptr:	dc.l	0
song_ptr:	dc.l	0
vset_ptr:	dc.l	0

prog_nm:	dc.b	'a:\singsong\singsong.prg',0	; playback routine name
song_nm:	dc.b	'a:\quartet.dem\demo1.4v',0	; song name
vset_nm:	dc.b	'a:\voice.set',0	; voiceset name
		even
env_str:	dc.b	0,0
cmd_str:	dc.b	0,0

*

oldsp	dc.l	0

	ds.l	100			stack space
mystack	ds.w	1			(stacks go backwards)

*	*	*	*	*	*	*	*	*	*
