*     Prospero Fortran GEM constants
*     6 Aug 1987

*     {GEM messages}
      INTEGER*4 MN_SELECTED, WM_REDRAW,  WM_TOPPED,  WM_CLOSED,
     -          WM_FULLED, WM_ARROWED, WM_HSLID, WM_VSLID, WM_SIZED,
     -          WM_MOVED, WM_NEWTOP, WM_UNTOPPED, AC_OPEN, AC_CLOSE

      PARAMETER (MN_SELECTED = 10)
      PARAMETER (WM_REDRAW   = 20)
      PARAMETER (WM_TOPPED   = 21)
      PARAMETER (WM_CLOSED   = 22)
      PARAMETER (WM_FULLED   = 23)
      PARAMETER (WM_ARROWED  = 24)
      PARAMETER (WM_HSLID    = 25)
      PARAMETER (WM_VSLID    = 26)
      PARAMETER (WM_SIZED    = 27)
      PARAMETER (WM_MOVED    = 28)
      PARAMETER (WM_NEWTOP   = 29)
      PARAMETER (WM_UNTOPPED = 30)     ! { Not applicable to GEM 1.1 }
      PARAMETER (AC_OPEN     = 40)
      PARAMETER (AC_CLOSE    = 41)
    
*     {Event types for evnt_multi   (bit significant values) }
      INTEGER*4 MU_KEYBD, MU_BUTTON, MU_M1, MU_M2, MU_MESAG, MU_TIMER    = 0020h)
      PARAMETER (MU_KEYBD    = $0001)
      PARAMETER (MU_BUTTON   = $0002)
      PARAMETER (MU_M1       = $0004)
      PARAMETER (MU_M2       = $0008)
      PARAMETER (MU_MESAG    = $0010)
      PARAMETER (MU_TIMER    = $0020)

*     {Bit significant values for ob_state word}
      INTEGER*4 NORMAL, SELECTED, CROSSED, CHECKED, DISABLED,
     -          OUTLINED, SHADOWED, DRAW3D, WHITEBAK
      PARAMETER (NORMAL      = $0000)   ! { Useful for all bitmaps }
      PARAMETER (SELECTED    = $0001)
      PARAMETER (CROSSED     = $0002)
      PARAMETER (CHECKED     = $0004)
      PARAMETER (DISABLED    = $0008)
      PARAMETER (OUTLINED    = $0010)
      PARAMETER (SHADOWED    = $0020)
      PARAMETER (DRAW3D      = $0040)   ! { Not applicable to GEM 1.1 }
      PARAMETER (WHITEBAK    = $0080)   ! { Not applicable to GEM 1.1 }

*     {Bit significant values for ob_flags word}
      INTEGER*4 NONE, SELECTABLE, DEFAULT, EXIT, EDITABLE, RBUTTON, 
     -          LASTOB, TOUCHEXIT, HIDETREE, INDIRECT
      PARAMETER (NONE        = $0000)
      PARAMETER (SELECTABLE  = $0001)
      PARAMETER (DEFAULT     = $0002)
      PARAMETER (EXIT        = $0004)
      PARAMETER (EDITABLE    = $0008)
      PARAMETER (RBUTTON     = $0010)
      PARAMETER (LASTOB      = $0020)
      PARAMETER (TOUCHEXIT   = $0040)
      PARAMETER (HIDETREE    = $0080)
      PARAMETER (INDIRECT    = $0100)

*     {Object types}
      INTEGER*4 G_BOX, G_TEXT, G_BOXTEXT, G_IMAGE, G_PROGDEF, G_IBOX,
     -          G_BUTTON, G_BOXCHAR, G_STRING, G_FTEXT, G_FBOXTEXT,
     -          G_ICON, G_TITLE
      PARAMETER (G_BOX       = 20)
      PARAMETER (G_TEXT      = 21)
      PARAMETER (G_BOXTEXT   = 22)
      PARAMETER (G_IMAGE     = 23)
      PARAMETER (G_PROGDEF   = 24)
      PARAMETER (G_IBOX      = 25)
      PARAMETER (G_BUTTON    = 26)
      PARAMETER (G_BOXCHAR   = 27)
      PARAMETER (G_STRING    = 28)
      PARAMETER (G_FTEXT     = 29)
      PARAMETER (G_FBOXTEXT  = 30)
      PARAMETER (G_ICON      = 31)
      PARAMETER (G_TITLE     = 32)

*     {Object header offsets}
      INTEGER*4 ob_next, ob_head, ob_tail, ob_type, ob_flags, ob_state,
     -          ob_spec, ob_x, ob_y, ob_width, ob_height
      PARAMETER (ob_next     = 0)
      PARAMETER (ob_head     = 2)
      PARAMETER (ob_tail     = 4)
      PARAMETER (ob_type     = 6)
      PARAMETER (ob_flags    = 8)
      PARAMETER (ob_state    = 10)
      PARAMETER (ob_spec     = 12)
      PARAMETER (ob_x        = 16)
      PARAMETER (ob_y        = 18)
      PARAMETER (ob_width    = 20)
      PARAMETER (ob_height   = 22)

*     {Function codes for objc_edit}
      INTEGER*4 ED_START, ED_INIT, ED_CHAR, ED_END
      PARAMETER (ED_START    = 0)
      PARAMETER (ED_INIT     = 1)
      PARAMETER (ED_CHAR     = 2)
      PARAMETER (ED_END      = 3)

*     {Function codes for form_dial}
      INTEGER*4 FMD_START, FMD_GROW, FMD_SHRINK, FMD_FINISH
      PARAMETER (FMD_START   = 0)
      PARAMETER (FMD_GROW    = 1)   ! { Not applicable to GEM 2.0 }
      PARAMETER (FMD_SHRINK  = 2)   ! { Not applicable to GEM 2.0 }
      PARAMETER (FMD_FINISH  = 3)

*     {Bit significant values for window components}
      INTEGER*4 NAME, CLOSER, FULL, MOVER, INFO, SIZE, UPARROW, 
     -          DNARROW, VSLIDE, LFARROW, RTARROW, HSLIDE
      PARAMETER (NAME        = $0001)
      PARAMETER (CLOSER      = $0002)   ! { Known as CLOSE in 'C' }
      PARAMETER (FULL        = $0004)
      PARAMETER (MOVER       = $0008)   ! { Known as MOVE in 'C' }
      PARAMETER (INFO        = $0010)
      PARAMETER (SIZE        = $0020)
      PARAMETER (UPARROW     = $0040)
      PARAMETER (DNARROW     = $0080)
      PARAMETER (VSLIDE      = $0100)
      PARAMETER (LFARROW     = $0200)
      PARAMETER (RTARROW     = $0400)
      PARAMETER (HSLIDE      = $0800)

*     {Window get/set function codes}
      INTEGER*4 WF_KIND, WF_NAME, WF_INFO, WF_WXYWH, WF_CXYWH,
     -          WF_PXYWH, WF_FXYWH, WF_HSLIDE, WF_VSLIDE, WF_TOP, 
     -          WF_FIRSTXYWH, WF_NEXTXYWH, WF_NEWDESK, WF_HSLSIZE, 
     -          WF_VSLSIZE, WF_SCREEN, WF_TATTRB, WF_SIZTOP
      PARAMETER (WF_KIND     = 1)
      PARAMETER (WF_NAME     = 2)
      PARAMETER (WF_INFO     = 3)
      PARAMETER (WF_WXYWH    = 4)  ! { Known as WF_WORKXYWH in GEM 1.1 }
      PARAMETER (WF_CXYWH    = 5)  ! { Known as WF_CURRXYWH in GEM 1.1 }
      PARAMETER (WF_PXYWH    = 6)  ! { Known as WF_PREVXYWH in GEM 1.1 }
      PARAMETER (WF_FXYWH    = 7)  ! { Known as WF_FULLXYWH in GEM 1.1 }
      PARAMETER (WF_HSLIDE   = 8)
      PARAMETER (WF_VSLIDE   = 9)
      PARAMETER (WF_TOP      = 10)
      PARAMETER (WF_FIRSTXYWH= 11)
      PARAMETER (WF_NEXTXYWH = 12)
      PARAMETER (WF_NEWDESK  = 14)
      PARAMETER (WF_HSLSIZE  = 15)
      PARAMETER (WF_VSLSIZE  = 16)
      PARAMETER (WF_SCREEN   = 17)
      PARAMETER (WF_TATTRB   = 18)  ! { Not provided in GEM 1.1 }
      PARAMETER (WF_SIZTOP   = 19)  ! { Not provided in GEM 1.1 }

*     {Function codes for wind_update}
      INTEGER*4 END_UPDATE, BEG_UPDATE, END_MCTRL, BEG_MCTRL
      PARAMETER (END_UPDATE  = 0)
      PARAMETER (BEG_UPDATE  = 1)
      PARAMETER (END_MCTRL   = 2)
      PARAMETER (BEG_MCTRL   = 3)

