{ gemsubs.pas - EXTERNAL declarations for Personal Pascal library routines. }

FUNCTION Init_Gem : integer ;
  EXTERNAL ;
PROCEDURE Exit_Gem ;
  EXTERNAL ;

FUNCTION Do_Alert( alert : Str255 ; def_btn : integer ) : integer ;
  EXTERNAL ;

FUNCTION New_Dialog( n_items, x, y, w, h : integer ) : Dialog_Ptr ;
  EXTERNAL ;
PROCEDURE Delete_Dialog( dial : Dialog_Ptr ) ;
  EXTERNAL ;
FUNCTION Add_DItem( dial : Dialog_Ptr ; i_type, flags : integer ;
         x, y, w, h : integer ; border, color : integer ) : Tree_Index ;
  EXTERNAL ;
PROCEDURE Set_DText( dial : Dialog_Ptr ; item : Tree_Index ; s : Str255 ;
                        font : integer ; just : TE_Just ) ;
  EXTERNAL ;
PROCEDURE Set_DEdit( dial : Dialog_Ptr ; item : Tree_Index ;
                        template, valid, initial : Str255 ;
                        font : integer ; just : TE_Just ) ;
  EXTERNAL ;
PROCEDURE Obj_SetState( dial : Dialog_Ptr ; index : Tree_Index ;
                        state : integer ; redraw : boolean ) ;
  EXTERNAL ;
FUNCTION Obj_State( dial : Dialog_Ptr ; index : Tree_Index ) : integer ;
  EXTERNAL ;
PROCEDURE Obj_SetFlags( dial : Dialog_Ptr ; index : Tree_Index ;
                        flags : integer ) ;
  EXTERNAL ;
FUNCTION Obj_Flags( dial : Dialog_Ptr ; index : Tree_Index ) : integer ;
  EXTERNAL ;
PROCEDURE Center_Dialog( dial : Dialog_Ptr ) ;
  EXTERNAL ;
FUNCTION Do_Dialog( dial : Dialog_Ptr ; start_obj : integer ) : integer ;
  EXTERNAL ;
PROCEDURE Get_DEdit( dial : Dialog_Ptr ; item : Tree_Index ; VAR s : Str255 ) ;
  EXTERNAL ;
FUNCTION Redo_Dialog( dial : Dialog_Ptr ; start_obj : integer ) : integer ;
  EXTERNAL ;
PROCEDURE End_Dialog( dial : Dialog_Ptr ) ;
  EXTERNAL ;

FUNCTION Get_In_File( VAR path, name : Path_Name ) : boolean ;
  EXTERNAL ;
FUNCTION Get_Out_File( prompt : Str255 ; VAR name : Path_Name ) : boolean ;
  EXTERNAL ;

FUNCTION New_Menu( n_items : integer ; about : Str255 ) : Menu_Ptr ;
  EXTERNAL ;
PROCEDURE Delete_Menu( menu : Menu_Ptr ) ;
  EXTERNAL ;
FUNCTION Add_MTitle( menu : Menu_Ptr ; item : Str255 ) : integer ;
  EXTERNAL ;
FUNCTION Add_MItem( menu : Menu_Ptr ; title : Tree_Index ; item : Str255 )
                                                : integer ;
  EXTERNAL ;
PROCEDURE Draw_Menu( menu : Menu_Ptr ) ;
  EXTERNAL ;
PROCEDURE Erase_Menu( menu : Menu_Ptr ) ;
  EXTERNAL ;
PROCEDURE Menu_Hilight( menu : Menu_Ptr ; title : Tree_Index ) ;
  EXTERNAL ;
PROCEDURE Menu_Normal( menu : Menu_Ptr ; title : Tree_Index ) ;
  EXTERNAL ;
PROCEDURE Menu_Check(menu : Menu_Ptr ; item : Tree_Index ; checked : boolean );
  EXTERNAL ;
PROCEDURE Menu_Enable( menu : Menu_Ptr ; item : Tree_Index ) ;
  EXTERNAL ;
PROCEDURE Menu_Disable( menu : Menu_Ptr ; item : Tree_Index ) ;
  EXTERNAL ;
PROCEDURE Menu_Text(menu : Menu_Ptr ; item : Tree_Index ; VAR mtext : Str255);
  EXTERNAL ;

FUNCTION New_Window( w_type : integer ; VAR title : Window_Title ;
                        x_max, y_max, w_max, h_max : integer ) : integer ;
  EXTERNAL ;
PROCEDURE Open_Window( handle : integer ; x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Close_Window( handle : integer ) ;
  EXTERNAL ;
PROCEDURE Delete_Window( handle : integer ) ;
  EXTERNAL ;
PROCEDURE Set_WSize( handle, x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Set_WName( handle : integer ; VAR title : Window_Title ) ;
  EXTERNAL ;
PROCEDURE Set_WInfo( handle : integer ; VAR info : Window_Title ) ;
  EXTERNAL ;
PROCEDURE Border_Rect( wind : integer ; VAR x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Work_Rect( wind : integer ; VAR x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE First_Rect( wind : integer ; VAR x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Next_Rect( wind : integer ; VAR x, y, w, h : integer ) ;
  EXTERNAL ;
FUNCTION Rect_Intersect( x, y, w, h : integer ; VAR x1, y1, w1, h1 : integer )
                        : boolean ;
  EXTERNAL ;
FUNCTION Front_Window : integer ;
  EXTERNAL ;
PROCEDURE Bring_To_Front( handle : integer ) ;
  EXTERNAL ;
PROCEDURE Set_Window( handle : integer ) ;
  EXTERNAL ;
FUNCTION Get_Window : integer ;
  EXTERNAL ;

PROCEDURE Set_Clip( x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Draw_Mode( mode : Draw_Modes ) ;
  EXTERNAL ;
PROCEDURE Set_Color( reg : Color_Reg ; red, green, blue : integer ) ;
  EXTERNAL ;
PROCEDURE Line_Color( color : Color_Reg ) ;
  EXTERNAL ;
PROCEDURE Line_Style( style : Line_Types ) ;
  EXTERNAL ;
PROCEDURE Paint_Color( color : Color_Reg ) ;
  EXTERNAL ;
PROCEDURE Paint_Style( style : integer ) ;
  EXTERNAL ;
PROCEDURE Paint_Outline( on : boolean ) ;
  EXTERNAL ;
PROCEDURE Text_Color( color : Color_Reg ) ;
  EXTERNAL ;
PROCEDURE Text_Style( style : integer ) ;
  EXTERNAL ;

PROCEDURE Move_To( x, y : integer ) ;
  EXTERNAL ;
PROCEDURE PLine( x1, y1, x2, y2 : integer ) ;
  EXTERNAL ;
PROCEDURE Line_To( newx, newy : integer ) ;
  EXTERNAL ;
PROCEDURE Plot( x, y : integer ) ;
  EXTERNAL ;
PROCEDURE Paint_Rect( x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Frame_Rect( x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Paint_Oval( x, y, x_rad, y_rad : integer ) ;
  EXTERNAL ;
PROCEDURE Frame_Oval( x, y, x_rad, y_rad : integer ) ;
  EXTERNAL ;
PROCEDURE Paint_Round_Rect( x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Frame_Round_Rect( x, y, w, h : integer ) ;
  EXTERNAL ;
PROCEDURE Paint_Arc( x, y, x_rad, y_rad, beg_ang, end_ang : integer ) ;
  EXTERNAL ;
PROCEDURE Frame_Arc( x, y, x_rad, y_rad, beg_ang, end_ang : integer ) ;
  EXTERNAL ;
PROCEDURE Draw_String( x, y : integer ; s : Str255 ) ;
  EXTERNAL ;

PROCEDURE Set_MForm( VAR form : Mouse_Form ) ;
  EXTERNAL ;
PROCEDURE Set_Mouse( m_type : Mouse_Type ) ;
  EXTERNAL ;
PROCEDURE Hide_Mouse ;
  EXTERNAL ;
PROCEDURE Show_Mouse ;
  EXTERNAL ;
PROCEDURE Init_Mouse ;
  EXTERNAL ;
PROCEDURE Begin_Mouse ;
  EXTERNAL ;
PROCEDURE End_Mouse ;
  EXTERNAL ;

FUNCTION Get_Event(     emask, bmask, bstate, n_clicks : integer ;
                        ticks : long_integer ;
                        m1_flag : boolean ; m1x, m1y, m1w, m1h : integer ;
                        m2_flag : boolean ; m2x, m2y, m2w, m2h : integer ;
                        VAR message : Message_Buffer ;
                        VAR key, brtn, bclick, mx, my, kstate : integer
                        ) : integer ;
  EXTERNAL ;
PROCEDURE Begin_Update ;
  EXTERNAL ;
PROCEDURE End_Update ;
  EXTERNAL ;

PROCEDURE Wind_Get( handle, request : integer ; VAR v1, v2, v3, v4 : integer );
  EXTERNAL ;
PROCEDURE Wind_Set( handle, request, v1, v2, v3, v4 : integer ) ;
  EXTERNAL ;
PROCEDURE Sys_Font_Size( VAR w_char, h_char, w_box, h_box : integer ) ;
  EXTERNAL ;
PROCEDURE Clear_Screen ;
  EXTERNAL ;
FUNCTION Load_Resource( fn : Str255 ) : boolean ;
  EXTERNAL ;
PROCEDURE Find_Menu( index : integer ; VAR menu : Menu_Ptr ) ;
  EXTERNAL ;
PROCEDURE Find_Dialog( index : integer ; VAR dial : Dialog_Ptr ) ;
  EXTERNAL ;
PROCEDURE Find_Alert( index : integer ; VAR alert : Str255 ) ;
  EXTERNAL ;
PROCEDURE Free_Resource ;
  EXTERNAL ;
FUNCTION Menu_Register( id : integer ; VAR name : Str255 ) : integer ;
  EXTERNAL ;

PROCEDURE VDI_Call( cmd, sub_cmd : integer ; nints, npts : integer ;
                    VAR ctrl : Ctrl_Parms ;
                    VAR int_in : Int_In_Parms ; VAR int_out : Int_Out_Parms ;
                    VAR pts_in : Pts_In_Parms ; VAR pts_out : Pts_Out_Parms ;
                    translate : boolean ) ;
  EXTERNAL ;

PROCEDURE AES_CALL( op:integer; var Int_in :Int_in_parms; var INT_out:
                    Int_out_Parms; var addr_in:addr_in_Parms;
                    VAR Addr_out:addr_out_parms);
  EXTERNAL;

PROCEDURE DRAGBOX (x1,y1,b1,h1,x2,y2,b2,h2:integer;
                   VAR endx,endy  :integer);  
EXTERNAL;

PROCEDURE RUBBERBOX (x,y,b1,h1:integer;VAR b2,h2 :integer);     
EXTERNAL;

PROCEDURE MOVEBOX ( x1,y1,breite,hoehe,x2,y2: integer ); 
EXTERNAL;

PROCEDURE GROWBOX ( kl_x,kl_y,kl_b,kl_h,gr_x,gr_y,gr_b,gr_h : integer);
EXTERNAL;

PROCEDURE SHRINKBOX ( kl_x,kl_y,kl_b,kl_h,gr_x,gr_y,gr_b,gr_h : integer);
EXTERNAL;

PROCEDURE Line_Width(Breite:integer);
EXTERNAL;

PROCEDURE Line_Endstyle(anfang,ende:integer);
EXTERNAL;

PROCEDURE Text_Rotation(winkel:integer);
EXTERNAL;

PROCEDURE Justified_Text(x,y,Laenge,wort,zeichen:integer; s:Str255);

EXTERNAL;

PROCEDURE Text_Alignment(hor,ver:integer);
EXTERNAL;

PROCEDURE Open_Port ( device : Gem_Device );
EXTERNAL;

PROCEDURE Close_Port ( port_handle : integer);
EXTERNAL;

FUNCTION Obj_Find ( obj :Dialog_ptr ;start, depth, x, y : integer):integer;
EXTERNAL;

PROCEDURE Obj_Offset ( t:Dialog_ptr; index:integer; VAR x,y:integer);
EXTERNAL;

FUNCTION Find_Window ( x,y :integer ) : integer;
EXTERNAL;

FUNCTION Find_Resource ( r_type, r_index : integer ) : tree_ptr;
EXTERNAL;

PROCEDURE Obj_Size ( t:Tree_Ptr; index:integer; VAR x,y,b,h:integer);
EXTERNAL;

PROCEDURE Obj_Draw( t:Tree_ptr; start,tiefe:Tree_index; 
                    x_clip,y_clip,b_clip,h_clip:integer);
EXTERNAL;

FUNCTION D_Color( Border, Text : Integer; Mode : Boolean; Pattern,  
                  Inside : Integer ) : Integer; 
EXTERNAL;

PROCEDURE Obj_Redraw(Box:Dialog_Ptr; item:Tree_index);
EXTERNAL;

PROCEDURE Text_Heigth(Hoehe:integer);
EXTERNAL;

PROCEDURE Show_Dialog ( Box:Dialog_Ptr );
EXTERNAL;

{end of gemsubs}
