{ gemtype.pas - Common GEM type definitions for Personal Pascal library.
    by Mark Rose
        December, 1985
}

        Color_Reg = 0..15;
        Draw_Modes = Replace_Mode..Rev_Trans_Mode;
        Line_Types = Solid..DashDotDot;
        Paint_Types = None..Hatch12;

        Gem_Device = Screen_Device..Printer_Device;
        Inq_Type = ( Open_Vals, Ext_Vals );
        Mouse_Type = (  M_Arrow, M_Text_Curs, M_Bee, M_Point_Hand, M_Flat_Hand,
                        M_Thin_Cross, M_Thick_Cross, M_Outln_Cross );

        Pointer         = ^char;
{!!!    Dialog_Ptr      = ^char;}
{!!!    Menu_Ptr        = ^char;}
        Text_Ptr        = ^char;
        Mouse_Form = (To_Be_Added);

        File_Name       = STRING [ Max_Fn ];
        Path_Name       = STRING [ Max_Path ];
        Window_Title = STRING [ Max_WTitle ];

        Message_Buffer  = ARRAY [ 0..15 ] OF integer;

        Ctrl_Parms              = ARRAY [ 0..11 ] OF integer;
        Int_In_Parms    = ARRAY [ 0..15 ] OF integer;
        Int_Out_Parms   = ARRAY [ 0..45 ] OF integer;
        Pts_In_Parms    = ARRAY [ 0..11 ] OF integer;
        Pts_Out_Parms   = ARRAY [ 0..11 ] OF integer;
        Addr_In_Parms   = ARRAY [ 0..1 ] OF Pointer;
        Addr_Out_Parms  = ARRAY [ 0..0 ] OF Pointer;

        Point =     RECORD
                     x, y : integer
                    END;
        Rectangle = RECORD
                     x, y,        { Upper left corner of rectangle }
                     w,           { Width of rectangle }
                     h : integer; { Height of rectangle }
                    END;

        Str255 = STRING [ 255 ];

  { Editable text justification: }
        TE_Just = ( TE_Left, TE_Right, TE_Center );

  { Possible indices into a tree: }
        Tree_Range = Root..Max_Tree;
        Tree_Index = Null_Index..Max_Tree;

  { Possible object types }
        Ob_Type = G_Box..G_Title;

  { "C" style string: }
        C_String = PACKED ARRAY [ 0..Max_C_String ] OF char;
        String_Ptr = ^C_String;

  { text_edInfo }
    Text_Ed_Info = RECORD
                     te_ptext  : String_Ptr;   { ptr to text (must be 1st) }
                     te_ptmplt : String_Ptr;   { ptr to template }
                     te_pvalid : String_Ptr;   { ptr to validation chrs. }
                     te_font   : integer;      { font }
                     te_junk1  : integer;      { junk word }
                     te_just   : integer;      { justification }
                     te_color  : integer;      { color information word }
                     te_junk2  : integer;      { junk word }
                     te_thickness : integer;   { border thickness }
                     te_txtlen : integer;      { length of text string }
                     te_tmplen : integer       { length of template string }
                   END;
        Ted_Ptr = ^Text_Ed_Info;

  { "Special" object information }
        Spec_Info = RECORD
                      CASE Ob_Type OF
                       G_Box, G_IBox, G_BoxChar :
                                            ( thick : integer;
                                              color : integer );
                       G_Text, G_BoxText, G_FText, G_FBoxText :
                                            ( info : Ted_Ptr );
                       G_Image, G_ProgDef, G_Button, G_Icon :
                                            ( ptr : long_integer );
                       G_String, G_Title :
                                            ( str : String_Ptr )
                    END;

  { OBJECT structure: }
    Object = RECORD
               ob_next : Tree_Index;   { Object's next sibling }
               ob_head : Tree_Index;   { -> head of object's children }
               ob_tail : Tree_Index;   { -> tail of object's children }
               ob_type  : integer;     { type of object- BOX, CHAR,...}
               ob_flags : integer;     { flags   }
               ob_state : integer;     { state- SELECTED, OPEN, ... }
               ob_spec  : Spec_Info;   { "out"- -> anything else }
               ob_x     : integer;     { upper left corner of object }
               ob_y     : integer;     { upper left corner of object }
               ob_w     : integer;     { width of obj }
               ob_h     : integer      { height of obj }
             END;

  { Type of a whole tree: }
        Tree = ARRAY [ Tree_Range ] OF Object;
        Tree_Ptr = ^Tree;
        Menu_Ptr = Tree_Ptr;
        Dialog_Ptr = Tree_Ptr;

  { icon_block }
    Icon_Block = RECORD
                   ib_pmask : long_integer;
                   ib_pdata : long_integer;
                   ib_ptext : long_integer;
                   ib_char  : integer;
                   ib_xchar : integer;
                   ib_ychar : integer;
                   ib_xicon : integer;
                   ib_yicon : integer;
                   ib_wicon : integer;
                   ib_hicon : integer;
                   ib_xtext : integer;
                   ib_ytext : integer;
                   ib_wtext : integer;
                   ib_htext : integer
                 END;

  { bit_block }
    Bit_Block = RECORD
                  bi_pdata : long_integer;  { ptr to bit forms data }
                  bi_wb    : integer;       { width of form in bytes }
                  bi_hl    : integer;       { height in lines }
                  bi_x     : integer;       { source x in bit form }
                  bi_y     : integer;       { source y in bit form }
                  bi_color : integer        { fg color of blt }
                END;

  { user_blk }
    User_Blk = RECORD
                 ub_code : long_integer;
                 ub_parm : long_integer
               END;

  { parm_blk }
    Parm_Blk = RECORD
                 pb_tree      : long_integer;
                 pb_obj       : integer;
                 pb_prevstate : integer;
                 pb_currstate : integer;
                 pb_x         : integer;
                 pb_y         : integer;
                 pb_w         : integer;
                 pb_h         : integer;
                 pb_xc        : integer;
                 pb_yc        : integer;
                 pb_wc        : integer;
                 pb_hc        : integer;
                 pb_parm      : long_integer
               END;

{ End of gemtype.pas }

