IMPLEMENTATION MODULE VT52;

(*-------------------------------------------------------------------------*)
(* This module uses VT-52 ESC-Codes for some helpful screen management     *)
(* commands. Procedures also existing in IBM M2DS are implemented with     *)
(* compatible names in this TDI MODULA-2 sourcecode, in fact these are     *)
(* only the procedures SetCursor() and Clear()     (c) 1/1987 BANANACO.    *)
(*-------------------------------------------------------------------------*)

FROM Terminal IMPORT Write;

PROCEDURE CurDownScroll;
  BEGIN  
  Write (CHR (10))
  END CurDownScroll;

PROCEDURE CurUp;
  BEGIN 
  Write (CHR (27)); 
  Write ('A')
  END CurUp;

PROCEDURE CurDown;
  BEGIN 
  Write (CHR (27)); 
  Write ('B')
  END CurDown;

PROCEDURE CurRight;
  BEGIN 
  Write (CHR (27)); 
  Write ('C')
  END CurRight;

PROCEDURE CurLeft;
  BEGIN 
  Write (CHR (27));
  Write ('D')
  END CurLeft;

PROCEDURE Clear();
  BEGIN 
  Write (CHR (27)); 
  Write ('E')
  END Clear;

PROCEDURE CurHome;
  BEGIN 
  Write (CHR (27)); 
  Write ('H')
  END CurHome;

PROCEDURE CurUpScroll;
  BEGIN 
  Write (CHR (27)); 
  Write ('I')
  END CurUpScroll;

PROCEDURE EndOfScreen;
  BEGIN 
  Write (CHR (27)); 
  Write ('J')
  END EndOfScreen;

PROCEDURE EndOfLine;
  BEGIN 
  Write (CHR (27)); 
  Write ('K')
  END EndOfLine;

PROCEDURE InsertLine;
  BEGIN 
  Write (CHR (27)); 
  Write ('L')
  END InsertLine;

PROCEDURE DelLine;
  BEGIN 
  Write (CHR (27)); 
  Write ('M')
  END DelLine;

PROCEDURE SetCursor(X, Y: INTEGER);
  BEGIN 
  IF X < 0 THEN 
     X := 0 
  ELSIF X > 79 THEN 
     X := 79 
     (*END*)
  END;
  IF Y < 0 THEN 
     Y := 0
  ELSIF Y > 24 THEN 
     Y := 24
     (*END*)
  END;
  Write (CHR (27)); 
  Write ('Y');
  Write (CHR(Y+32));
  Write (CHR(X+32)) 
  END SetCursor;

PROCEDURE SelectColor (Color: CARDINAL);
  BEGIN 
  Color:=Color MOD 16;
  Write (CHR (27)); 
  Write ('b');
  Write (CHR (ORD ('0') + Color))
  END SelectColor;

PROCEDURE SelectBack (Color: CARDINAL);
  BEGIN 
  Color:=Color MOD 16;
  Write (CHR (27)); 
  Write ('c');
  Write (CHR (ORD('0') + Color))
  END SelectBack;

PROCEDURE StartOfScreen;
  BEGIN 
  Write (CHR (27)); 
  Write ('d')
  END StartOfScreen;

PROCEDURE CurOn;
  BEGIN 
  Write (CHR (27)); 
  Write ('e')
  END CurOn;

PROCEDURE CurOff;
  BEGIN 
  Write (CHR (27)); 
  Write ('f')
  END CurOff;

PROCEDURE CurSave;
  BEGIN 
  Write (CHR (27)); 
  Write ('j')
  END CurSave;

PROCEDURE CurRestore;
  BEGIN 
  Write (CHR (27)); 
  Write ('k')
  END CurRestore;

PROCEDURE ClearLine;
  BEGIN 
  Write (CHR (27)); 
  Write ('l')
  END ClearLine;

PROCEDURE StartOfLine;
  BEGIN 
  Write (CHR (27)); 
  Write ('o')
  END StartOfLine;

PROCEDURE InverseOn;
  BEGIN 
  Write (CHR (27)); 
  Write ('p')
  END InverseOn;

PROCEDURE InverseOff;
  BEGIN 
  Write (CHR (27)); 
  Write ('q')
  END InverseOff;

PROCEDURE WrapOn;
  BEGIN 
  Write (CHR (27)); 
  Write ('v')
  END WrapOn;

PROCEDURE WrapOff;
  BEGIN 
  Write (CHR (27)); 
  Write ('w')
  END WrapOff;

END (* of MODULE *) VT52.

