IMPLEMENTATION MODULE Diamond ;

(* Atari 520 ST : Recursive diamond *)

(* --------------------------------------------------------------- *)
(* (c) Copyright Modula 2 Software Ltd 1986.  All rights reserved. *)
(* --------------------------------------------------------------- *)
(* (c) Copyright TDI Software Inc 1985, 1986. All rights reserved. *)
(* --------------------------------------------------------------- *)

(*$A+*)

FROM GEMVDIbase IMPORT
     (* types *) VDIWorkInType, VDIWorkOutType;

FROM VDIOutputs IMPORT
     (* procs *) PolyLine ;

FROM VDIControls IMPORT
     (* procs *) OpenVirtualWorkstation, CloseVirtualWorkstation ;

FROM VDIAttribs IMPORT
     (* procs *) SetLineColour ;

FROM AESGraphics IMPORT
     (* procs *) GrafHandle;

FROM GemDem IMPORT
     (* vars  *) WorkX, WorkY ;
 
VAR currentX, currentY : INTEGER;
    Point              : ARRAY [0..3] OF INTEGER;



PROCEDURE MoveTo (x, y : INTEGER);

BEGIN
  currentX := x;
  currentY := y;
END MoveTo;


PROCEDURE LineTo (toX, toY : INTEGER);

BEGIN
  Point [0] := currentX;
  Point [1] := currentY;
  Point [2] := toX;
  Point [3] := toY;
  MoveTo (toX, toY); (* remember to change currentX, currentY *)
  PolyLine (handle, 2, Point);
END LineTo;


PROCEDURE D ( x, y, s : INTEGER );
VAR i : INTEGER ; 
BEGIN
  IF s < m THEN RETURN END;
  s := s DIV 2;
  i := SetLineColour(handle,1) ;
  D (x+s, y, s);
  i := SetLineColour(handle,2) ;
  D (x-s, y, s);
  i := SetLineColour(handle,3) ;
  D (x, y-s, s);
  i := SetLineColour(handle,4) ;
  D (x, y+s, s);
  MoveTo (x, y+s);
  LineTo (x+s, y);
  LineTo (x, y-s);
  LineTo (x-s, y);
  LineTo (x, y+s);
END D;
   
VAR handle : INTEGER;
    j      : INTEGER;
    m      : INTEGER;
    In     : VDIWorkInType;
    Out    : VDIWorkOutType;

PROCEDURE DoDiamond ;
BEGIN
  currentX := WorkX; currentY := WorkY;
  FOR j := 0 TO 9 DO In [j] := 1 END;
  In [10] := 2;
  handle := GrafHandle (j, j, j, j);
  OpenVirtualWorkstation (In, handle, Out);
  m := 6;
  D ( Out[0] DIV 2, Out[1] DIV 2, Out[1] DIV 2 - 40 );
  CloseVirtualWorkstation (handle);
END DoDiamond ;

END Diamond.
