IMPLEMENTATION MODULE GemDem ;

(* ----------------------------------------------

    GEM demonstration module for TDI Modula-2/ST

    (c) Copyright Modula 2 Software Ltd. 1986.
    (c) Copyright TDI Software Inc. 1985, 1986.

    The source of this demonstration program is
    included to aid your understanding of the
    Modula-2/ST to GEM interface. For full details
    of the GEM interface please see the Digital
    Research Inc GEM manuals.

    The resource file 'GEMDEM.RSC' used by this 
    program was generated by a Resource Compiler
    utility. This is contained in the Modula-2/ST
    developers toolkit.

    If you develop any nice demonstration programs
    why not include them in GemDem, and return
    it to us. We will include it on our release
    disks with acknowlegments to the relevent authors.

    Happy Modula-2 coding !! 

    Modula-2 Development Group. 1986.

   ---------------------------------------------- *)

(* 
        Version    :    2.01a    06-Aug-86    Phil Camp, Modula 2 Software Ltd
                        Added new "A" compiler option.
                        2.00a    19-Mar-86    Phil Camp TDI
                        Made compatible with colour ST systems.
                        Corrected minor bugs.
                        1.00a    01-Sep-85    Phil Camp TDI
                        Original version

*)

FROM SYSTEM IMPORT ADR, ADDRESS ;

(* NB. In this module we have simply imported the GEM library modules and
       then used the form "<libname>.<item>" to access each library. This
       has been done to make it easier for you to identify the GEM library
       calls. 
*)

(* The following compiler option '(*$A+*)' is a new feature included in the
   Modula 2 compiler from version 2.01a onwards. Setting it on instructs the
   compiler to generate short subroutines calls (BSR) for ALL calls. This 
   option can save space in a program but all branches to a subroutine must
   be within 32K of the call. The linker reports an error if a branch is too
   big. Another new option '(*$Q+*)' tells the compiler to generate short 
   calls only on subroutine calls within a module. Most modules should not be
   over 32K large so use this option to reduce code size.

   Summary:

      If the complete program is not over 32K bytes then use (*$A+*) in all
      modules.

      If the complete program is too big for A+ then use (*$Q+*) in all modules
      less than 32K long.

*)

(*$A+*)  (* GemDem is not very big so do all branches short *)

IMPORT GEMVDIbase, VDIControls, VDIAttribs, VDIOutputs,
       GEMAESbase, AESGraphics, AESMenus, AESForms, AESObjects, AESEvents,
       AESResources, AESWindows, AESApplications ;
IMPORT Fractal, Diamond, Sierpinski, Lines, Cube ;


CONST (* Object definitions in GEMDEM.RSC from GEMDEM.I *)
  MENU1         =   0 ;     (* TREE *)
  ABOUTBOX      =   1 ;     (* TREE *)
  ALERT1        =   0 ;     (* STRING *)
  DESKMENU      =   3 ;     (* OBJECT IN MENU1 *)
  DEMOMENU      =   4 ;     (* OBJECT IN MENU1 *)
  ABOUTOBJ      =   7 ;     (* OBJECT IN MENU1 *)
  FRACTAL       =  16 ;     (* OBJECT IN MENU1 *)
  SIERPINS      =  17 ;     (* OBJECT IN MENU1 *)
  DIAMONDS      =  18 ;     (* OBJECT IN MENU1 *)
  LINES         =  19 ;     (* OBJECT IN MENU1 *)
  QUIT          =  21 ;     (* OBJECT IN MENU1 *)
  CUBE          =  22 ;     (* OBJECT IN MENU1 *)
  INFOOK        =  4 ;      (* OBJECT IN ABOUTBOX *)
 
VAR 
  VDIHandle : INTEGER ;
  workIn  : GEMVDIbase.VDIWorkInType ;
  workOut : GEMVDIbase.VDIWorkOutType ;
  WidthChar, HeightChar, WidthFont, HeightFont : INTEGER ;

  (* Window data *)
  Window : INTEGER ;            (* window handle *)
  WindX, WindY, WindWidth, WindHeight : INTEGER ; (* Total window *)

  Appl : INTEGER ;
  MenuTree : ADDRESS;


(* ------------------------------------------------------------------- *)

PROCEDURE InitWindow ( VAR Title : ARRAY OF CHAR ) ;
VAR 
  i : INTEGER ;
  maxX, maxY : INTEGER ;
  str : ARRAY [0..70] OF CHAR ;
BEGIN
  (* Remove mouse *)
  AESGraphics.GrafMouse(GEMAESbase.MouseOff,NIL) ;
  (* Create space for window *)
  maxX := workOut[0] ; maxY := workOut[1] ;
  Window := AESWindows.WindowCreate(GEMAESbase.Name+GEMAESbase.Closer,10,25,
                                    maxX-40,maxY-50) ;
  (* Draw the window *)
  AESGraphics.GrafGrowBox(10,25,1,1,10,25,maxX-40,maxY-50) ;
  AESWindows.WindowOpen(Window,10,25,maxX-40,maxY-50) ;
  (* Get location of window *)
  AESWindows.WindowGet(Window,GEMAESbase.WorkXYWH,
                       WorkX,WorkY,WorkWidth,WorkHeight) ;
  AESWindows.WindowGet(Window,GEMAESbase.CurrXYWH,
                       WindX,WindY,WindWidth,WindHeight) ;
  (* Set title *)
  AESWindows.WindowSet(Window,GEMAESbase.WindowName,
                       INTEGER(ADR(Title) DIV 10000H),
                       INTEGER(ADR(Title) MOD 10000H),0,0) ;
  (* put back mouse *)
  AESGraphics.GrafMouse(GEMAESbase.MouseOn,NIL) ;
  (* Set fill for blanking operations *)
  i := VDIAttribs.SetFillInteriorStyle(VDIHandle,1) ; (* Set solid fill *)
  i := VDIAttribs.SetFillColour(VDIHandle,GEMAESbase.White) ; (* Set white *)
  (* blank window *)
  ClearWindow ;
END InitWindow ;

PROCEDURE CloseWindow ;
VAR
  result : INTEGER ;
BEGIN
  AESWindows.WindowClose(Window) ;
  AESGraphics.GrafShrinkBox(0,0,0,0,WindX,WindY,WindWidth,WindHeight) ;
  AESWindows.WindowDelete(Window) ;
END CloseWindow ;
  
PROCEDURE WaitWindowClosed ;
BEGIN
  Events() ;
END WaitWindowClosed;
 
PROCEDURE ClearWindow ;
VAR rectArray : GEMVDIbase.PxyArrayType ; 
BEGIN
  AESGraphics.GrafMouse(GEMAESbase.MouseOff,NIL) ;
  rectArray[0] := WorkX ;
  rectArray[1] := WorkY ;
  rectArray[2] := WorkX + WorkWidth ;
  rectArray[3] := WorkY + WorkHeight ;
  VDIOutputs.FillRectangle(VDIHandle,rectArray) ;
  AESGraphics.GrafMouse(GEMAESbase.MouseOn,NIL) ;
END ClearWindow ;  

(* ------------------------------------------------------------------- *)

PROCEDURE DoAboutDialog ;

TYPE
  Object = RECORD
             next  : CARDINAL;
             head  : CARDINAL;
             tail  : CARDINAL;
             type  : CARDINAL;
             flags : CARDINAL;
             state : CARDINAL;
             spec  : ADDRESS;
             obx   : CARDINAL;
             oby   : CARDINAL;
             width : CARDINAL;
             depth : CARDINAL;
           END;
  Tree = POINTER TO ARRAY [0..200] OF Object;
VAR
  dTree : ADDRESS ;
  x, y, w, h : INTEGER ;
  result : INTEGER ;

  PROCEDURE ObjectAddress(tree : INTEGER; obindex : INTEGER) : ADDRESS;
  VAR res : INTEGER; treeadr : Tree; ob : POINTER TO ADDRESS;
  BEGIN
    AESResources.ResourceGetAddr(0,tree,treeadr);
    RETURN ADR(treeadr^[obindex]);
  END ObjectAddress;

  PROCEDURE GetObjectState(tree : INTEGER; obindex : INTEGER) : BITSET;
  VAR res : INTEGER; treeadr : Tree;
  BEGIN
    AESResources.ResourceGetAddr(0,tree,treeadr);
    RETURN BITSET(treeadr^[obindex].state);
  END GetObjectState;

  PROCEDURE SetObjectState(tree : INTEGER; obindex : INTEGER; state : BITSET);
  VAR res : INTEGER; treeadr : Tree;
  BEGIN
    AESResources.ResourceGetAddr(0,tree,treeadr);
    treeadr^[obindex].state := INTEGER(state);
  END SetObjectState;


  PROCEDURE DeselectObject(tree : INTEGER; obindex : INTEGER);
  CONST
    Selected = 0 ;
  VAR b : BITSET;
  BEGIN
    b := GetObjectState(tree,obindex);
    b := b - {Selected};
    SetObjectState(tree,obindex,b);
  END DeselectObject;

BEGIN
  AESResources.ResourceGetAddr(GEMAESbase.RTree,ABOUTBOX,dTree) ;
  AESForms.FormCenter(dTree,x,y,w,h) ;
  AESForms.FormDialogue(GEMAESbase.FormStart,0,0,0,0,x,y,w,h) ;
  AESForms.FormDialogue(GEMAESbase.FormGrow,0,0,0,0,x,y,w,h) ;
  AESObjects.ObjectDraw(dTree,0,10,x,y,w,h) ;
  result := AESForms.FormDo(dTree,0) ;
  DeselectObject(ABOUTBOX,INFOOK) ;
  AESForms.FormDialogue(GEMAESbase.FormShrink,0,0,0,0,x,y,w,h) ;
  AESForms.FormDialogue(GEMAESbase.FormFinish,0,0,0,0,x,y,w,h) ;
END DoAboutDialog ;

PROCEDURE DoDemo ( VAR Title : ARRAY OF CHAR ; DemoProc : PROC ) ;
BEGIN
  (* disable menu items whilst demo in action *)
  AESMenus.MenuItemEnable(MenuTree,ABOUTOBJ,0) ;
  AESMenus.MenuItemEnable(MenuTree,FRACTAL,0) ;
  AESMenus.MenuItemEnable(MenuTree,SIERPINS,0) ;
  AESMenus.MenuItemEnable(MenuTree,DIAMONDS,0) ;
  AESMenus.MenuItemEnable(MenuTree,LINES,0) ;
  AESMenus.MenuItemEnable(MenuTree,CUBE,0) ;
  AESMenus.MenuItemEnable(MenuTree,QUIT,0) ;
  InitWindow(Title) ;
  AESGraphics.GrafMouse(GEMAESbase.MouseOff,NIL) ;
  DemoProc() ;
  AESGraphics.GrafMouse(GEMAESbase.MouseOn,NIL) ;
  WaitWindowClosed ;
  CloseWindow ;
  (* enable menu items *)
  AESMenus.MenuItemEnable(MenuTree,ABOUTOBJ,1) ;
  AESMenus.MenuItemEnable(MenuTree,FRACTAL,1) ;
  AESMenus.MenuItemEnable(MenuTree,SIERPINS,1) ;
  AESMenus.MenuItemEnable(MenuTree,DIAMONDS,1) ;
  AESMenus.MenuItemEnable(MenuTree,LINES,1) ;
  AESMenus.MenuItemEnable(MenuTree,CUBE,1) ;
  AESMenus.MenuItemEnable(MenuTree,QUIT,1) ;
END DoDemo ;
  
  
(* ------------------------------------------------------------------- *)

PROCEDURE Events ;
(* Handle resource events *)
VAR
  result : INTEGER ;
  done : BOOLEAN ;
  pipeBuff : ARRAY [0..9] OF INTEGER ;

  PROCEDURE SelectMenu( Menu, Item : INTEGER ) ;
  BEGIN
    CASE Menu OF
      DESKMENU : IF Item = ABOUTOBJ THEN
                   DoAboutDialog ;
                 END                        ;       |
      DEMOMENU : CASE Item OF
                   FRACTAL  : DoDemo("Fractal Tree",Fractal.DoFractal) ; |
                   SIERPINS : DoDemo("Sierpinski Curve",
                                      Sierpinski.DoSierpinski); |
                   DIAMONDS : DoDemo("Diamond",Diamond.DoDiamond); |
                   LINES    : DoDemo("Lines",Lines.DoLines) ; |
                   CUBE     : DoDemo("Cube",Cube.DoCube) ; |
                   QUIT     : done := TRUE ; |
                 ELSE
                 END ;
    ELSE
    END ;
    (* put header back normal*)
    AESMenus.MenuTitleNormal(MenuTree,Menu,1) ;
  END SelectMenu ;

BEGIN
  AESGraphics.GrafMouse(GEMAESbase.Arrow,NIL) ; (* put pointing mouse *)
  done := FALSE ;
  REPEAT
    AESEvents.EventMessage(ADR(pipeBuff)) ;
    CASE pipeBuff[0] OF         (* message type *)
      GEMAESbase.MenuSelected   : SelectMenu(pipeBuff[3],pipeBuff[4]) ; |
      GEMAESbase.WindowClosed   : done := TRUE ; |
    ELSE
    END ;
  UNTIL done ;
END Events ;


(* ------------------------------------------------------------------- *)

PROCEDURE InitResource() : BOOLEAN ;
CONST
  ResourceFileName = "gemdem.rsc" ;
  Alert = "[3][ No resource file for Modula-2 ST/GEM Demo ][OK]" ;

VAR
  str : ARRAY [0..99] OF CHAR ;
  result : INTEGER ;
  i : CARDINAL ;
BEGIN
  Appl := AESApplications.ApplInitialise() ;
  str := ResourceFileName ;
  AESResources.ResourceLoad(str) ;
  IF ( GEMAESbase.AESCallResult = 0 ) THEN
    str := Alert ;
    result := AESForms.FormAlert(1,str) ;
    RETURN FALSE ;
  END ;
  (* enable the menu tree *)
  AESResources.ResourceGetAddr(GEMAESbase.RTree,MENU1,MenuTree) ;
  AESMenus.MenuBar(MenuTree,1) ;
  (* Get AES VDI handle *)
  VDIHandle:=AESGraphics.GrafHandle(WidthChar,HeightChar,WidthFont,HeightFont);
  (* Open VDI Virtual workstation *)
  FOR i := 0 TO 9 DO workIn[i] := 1 ; END ;
  workIn[10] := 2 ; (* Set RC *)
  VDIControls.OpenVirtualWorkstation(workIn,VDIHandle,workOut) ;
  Colour := workOut[39] (* number of colours *) > 2 ; 
  RETURN TRUE ;
END InitResource ;

(* ------------------------------------------------------------------- *)

PROCEDURE Terminate ;
BEGIN
  AESMenus.MenuBar(MenuTree,0) ;
  AESResources.ResourceFree() ;
  VDIControls.CloseVirtualWorkstation(VDIHandle) ;  
  AESApplications.ApplExit ;
END Terminate ;
(* ------------------------------------------------------------------- *)

VAR
  ch : CHAR ;

BEGIN
  IF InitResource() THEN
    Events ;
  END ;
  Terminate ;
END GemDem.
