IMPLEMENTATION MODULE Sierpinski;

(* GEM Demo : Draw Sierpinski curve *)

(* --------------------------------------------------------------- *)
(* (c) Copyright Modula 2 Software Ltd 1986.  All rights reserved. *)
(* --------------------------------------------------------------- *)
(* (c) Copyright TDI Software Inc 1985, 1986. All rights reserved. *)
(* --------------------------------------------------------------- *)

(*$S-*)(*$T-*)(*$A+*)

FROM GEMVDIbase IMPORT
     (* types *) VDIWorkInType, VDIWorkOutType ;

FROM VDIControls IMPORT
     (* procs *) OpenVirtualWorkstation, CloseVirtualWorkstation ;

FROM VDIOutputs IMPORT
     (* procs *) PolyLine ;

FROM VDIAttribs IMPORT
     (* procs *) SetLineColour ;

FROM AESGraphics IMPORT
     (* procs *) GrafHandle;

FROM GemDem IMPORT
     (* vars  *) WorkX, WorkY, WorkWidth, WorkHeight, Colour ;

VAR currentX, currentY : INTEGER;

VAR
  Px, Py,
  i, h,
  x0, y0 : CARDINAL;
  ch     : CHAR;
  SquareSize : INTEGER ;
  Points : ARRAY [0..3] OF INTEGER;
  handle : INTEGER;
  In     : VDIWorkInType;
  Out    : VDIWorkOutType;
  dummy  : INTEGER;
  colourIndex, maxColour : INTEGER ;

PROCEDURE Line ( direction, length : CARDINAL ) ;
  PROCEDURE LineR(x, y : CARDINAL ) ;
  VAR aX, aY : INTEGER;
  BEGIN
    aX := INTEGER(x);
    aY := INTEGER(y);
    Points [0] := currentX;
    Points [1] := currentY;
    currentX := currentX + aX;
    currentY := currentY + aY;
    Points [2] := currentX;
    Points [3] := currentY;
    PolyLine (handle, 2, Points);
  END LineR;

BEGIN
  CASE direction OF 
    0 : LineR(length,0 ) ;           |
    1 : LineR(length,length) ;       |
    2 : LineR(0,length) ;            |
    3 : LineR(-INTEGER(length),length) ;      |
    4 : LineR(-INTEGER(length),0) ;           |
    5 : LineR(-INTEGER(length),-INTEGER(length)) ;     |
    6 : LineR(0,-INTEGER(length)) ;           |
    7 : LineR(length,-INTEGER(length)) ;      |
  END ;
END Line ;


PROCEDURE A ( k : CARDINAL );

BEGIN
  IF k > 0 THEN
    A(k-1); Line(7,h); B(k-1); Line(0,2*h);
    D(k-1); Line(1,h); A(k-1);
  END;
END A;


PROCEDURE B ( k : CARDINAL );

BEGIN
  IF k > 0 THEN
    B(k-1); Line(5,h); C(k-1); Line(6,2*h);
    A(k-1); Line(7,h); B(k-1);
  END;
END B;


PROCEDURE C ( k : CARDINAL );

BEGIN
  IF k > 0 THEN
    C(k-1); Line(3,h); D(k-1); Line(4,2*h);
    B(k-1); Line(5,h); C(k-1);
  END;
END C;


PROCEDURE D ( k : CARDINAL );

BEGIN
  IF k > 0 THEN
    D(k-1); Line(1,h); A(k-1); Line(2,2*h);
    C(k-1); Line(3,h); D(k-1);
  END;
END D;


CONST Depth = 6;  (* because it looks nice *)

PROCEDURE DoSierpinski;

BEGIN
  FOR dummy := 0 TO 9 DO In [dummy] := 1 END;
  In [10] := 2;
  handle := GrafHandle (dummy, dummy, dummy, dummy);
  OpenVirtualWorkstation (In, handle, Out);
  maxColour := Out[39]-1 ; colourIndex := 1 ;
  i := 0;
  IF Colour THEN
    SquareSize := 128 ;
  ELSE
    SquareSize := 256 ;
  END ;
  h := SquareSize DIV 4;
  x0 := CARDINAL(WorkWidth-WorkX-1) DIV 2 + CARDINAL(WorkX);
  y0 := CARDINAL(WorkHeight-WorkY-1) DIV 2 + h + CARDINAL(WorkY)+20;
  REPEAT
    colourIndex := SetLineColour(handle,colourIndex) ;
    INC(colourIndex) ;
    IF ( colourIndex > maxColour ) THEN
      colourIndex := 1 ;
    END ;
    INC (i);
    DEC (x0,h);
    h := h DIV 2;
    INC (y0,h);
    currentX := x0;
    currentY := y0;
    A (i); Line (7,h);
    B (i); Line (5,h);
    C (i); Line (3,h);
    D (i); Line (1,h);
  UNTIL (i = Depth);
  CloseVirtualWorkstation (handle);
END DoSierpinski;

END Sierpinski.
