/*
 *    This header file contains fields related to STeno's capability
 *  to interact with an outside application.
 *
 *  Copyright  1990-1993 Strata Software, JMG software.
 *  Copyright  1994, Cysco Software
 */

/***************************************************************************

USE OF AES MESSAGES:

The STeno interfaces uses a "standard" of sending AES messages that has
been in use by JMG Software for a few years, a modification of the "Tom
Hudson Standard" suggested in Start magazine a long time ago.

The AES message packet is defined as follows:

	word 0 :	High Byte : 	Application ID byte
				Low Byte  :		Message ID ("type")
				
	word 1 :	ap_id of source process
	
	word 2 :	(additional length of message if any)
	
	word 3 :	Command number or flag, if any
	
	word 4 :	no use defined
	
	word 5 :	no use defined
	
	word 6 & 7 :	Pointer to data structure (if used)

The low byte of word 0 indicates the message ID, or "type", showing the
purpose of the message (used types are described below).  In all cases, a
reply to a specific message (a handshake, for instance) will use the same
type byte with the high bit set.  For instance, a reply to a message type
of 0x0F would be 0x8F.
**************************************************************************/

#define ED_HELLO	0xED00	/* Sent by Application to the STeno when starting. */

#define ED_REPLY	0xED80	/* Acknowledge sent by STeno to Application after 
							 * ED_HELLO.  Word 3 contains STeno's version 
							 * number (ie 0x0210), or 0 if STeno is already
							 * in use by another application.
							 */

/* The following messages are all sent by the Application to STeno: */

#define ED_OPEN		0xED01	/* Open up the STeno window */

#define ED_BYE		0xED02	/* Sent by the Application right before it exits. */

#define ED_LOADF	0xED10	/* The Application would like STeno to load a file.
							 * Word 6 & 7 contain pointer to full filename.
							 * Word 4 & 5 contain a LONG value of the line # to
							 * position to the top of the window.  If 0, then 
							 * start-of-file, if > # of lines, then end-of-file.
							 */

#define ED_NEW		0xED11	 						/* The Application would like STeno to "New", 
													 * clearing buffer and filename.
							 						 */

#define ED_SAVEF	0xED12							/* Please save buffer to filename in word 6 & 7; 
													 * if word 6 & 7 = NULL, use
													 * current name (or "UNTITLED.TXT" if no current name).
													 * word 3 TRUE = Append OK, FALSE = Replace only.
													 */

#define ED_CUT		0xED14							/* Application triggering the "CUT BLOCK" command. */

#define ED_COPY		0xED15							/* Application triggering the "COPY BLOCK" command. */

#define ED_PASTE	0xED16							/* Application triggering the "PASTE BLOCK" command. */

#define ED_DELETE	0xED17							/* Application triggering the "DELETE BLOCK" command. */

#define ED_FIND		0xED18							/* Trigger the FIND command;
													 * search string pointed by word 6 & 7.
													 * word 3 contain CASE SENSITIVE flag
													 * If NULL, trigger the FINDNEXT command
													 */

#define ED_CHANGE	0xED19							/* Trigger CHANGE command; 
													 * word 4 & 5 point to the search 
													 * word 6 & 7 point to the replace
													 * word 3 contain CASE SENSITIVE flag
													 */

#define ED_PRINT	0xED1A							/* Trigger PRINT command. */

#define ED_LINE		0xED1D							/* Words 4/5 contains the line # to position to. */

#define ED_READ		0xED1E							/* Word 3 contains the READ ONLY flag, TRUE or FALSE. */

#define ED_INQINF	0xED1F							/* Will return information about the current file. */
													/* Returns message ED_INQINF | 0x8000
													 * Word 3 contains Modified Flag
													 * Word 6 & 7 point to full filename
													 */

/* The following messages would be sent by STeno to the Application: */

#define ED_DCLICK	0xED30							/* A double-click to select a word was done. Word 6 & 7 point to the start of * 
													 * the block. */

#define	ED_SELECT	0xED31							/* A block was selected with the mouse or keyboard. Word 6 & 7 point to the *
													 * start of the block. */

#define ED_MLOAD	0xED40							/* OPEN was selected from Menu.  Word 6 & 7 contain the filename. */

#define ED_MNEW		0xED41							/* New was selected from the Menu. */

#define ED_MSAVE	0xED42							/* SAVE or SAVE AS was selected from Menu. Word 6 & 7 point to filename. */

#define ED_CLOSE	0xED50							/* Window close selected */

#define ED_UNDOK	0xED51							/* UNDO key pressed */

