/*
 *    stenomsg.h
 *
 *  Header file defining messages understood by STeno.
 *
 *  Copyright  1989-1993, Eric Rosenquist
 *  Copyright  1994, Jeffrey A. Krzsztow, Cysco Software
 *
 */

typedef union {
	int msg[8];
	struct {
		short msgcode;
		short sender_id;
		short extra_bytes;
		char *line;
		short line_length;
	} append_line_request;
	struct {
		short msgcode;
		short sender_id;
		short extra_bytes;
		short command_flags;
		long line_number;
		char *pointer;
	} hyperedit_request;
} STENO_MSG;

/**********************************/
/*  Requests understood by STeno  */
/**********************************/
#define STENO_APPEND_LINE	1000

/**********************************/
/*    Errors returned by STeno    */
/**********************************/
#define STENO_ERROR			9998					/* General purpose error */
#define STENO_BUFFER_FULL	9999					/* File buffer is full.  */
