/*******************************************************************
 * Modul	   : PR_ZIFF.H
 * Projekt	: PRFZIFFERN
 * Aufgabe	: Prfziffernrechnung nach Art der Banken
 *            
 *------------------------------------------------------------------
 * (C)1993 by LANTEC ComPro
 * Autor	: Ralph Lanfermann
 * Datum	: 11.06.1993
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/

/* 
	Berechnet aus einer laufenden Nummer und dem Vorsatz eine
  	Kundennummer mit Prfziffer.
  	
	Parameter :
	-> : 
	base  4 Stellige Nummer des Kunden.  (z.B. : 540 )
	pre   2 Stelliger Vorsatz. ( z.B. :  Filiale 23 )
	<- :
	eine  7 Stellige Kundennummer ( im Beispiel : 2305406 )
*/	
GLOBAL LONG _clc_pnum( CONST LONG lfd_nr ,CONST LONG vorsatz );

/* 
	Berechnet aus der 7 Stelligen Nummer die Laufende
	Nummer.
	-> kdnr : 7 Stellige Nummer ( z.B. 2305406 )
	<- lfd  : Die Laufende Nummer ( also 540 )
*/	

GLOBAL LONG _getlfd( CONST LONG numm );

/*
	Berechnet von 'start' an 'anzahl' neue Nummern.
	
	-> start : 1.Nummer  
		anzahl: Wieviele Nummern sollen es werden.
		pres  : Vorsatz
		func  : Zeiger auf eine Funktion, die wie folgt deklariert
		        ist.
		        VOID func ( LONG a , LONG b )
		        Wobei a die Werte 1,2,...,anzahl hat und
		        in b die jeweiligen Kundennummern enthalten
		        sind.
		        Die Funktion kann die Nummern ausgeben oder sichern
		        oder vergessen oder....
	<- nix
*/		
GLOBAL VOID _clc_some( LONG start , LONG anzahl , LONG pres, VOID(*func)(LONG,LONG) );

/* 
	Die Funktion berechnet die nchste Laufende Nummer.
	
	-> : 
	numm : Startnummer, z.B. 2305398
	pre  : Vorsatz  23
	mode : Richtung, entweder -1 oder +1 
			 bei +1 kme dann 2305406 heraus.
			 Es sind auch grere Distanzen mglich. (+5 -9 ... );		

	<- :
	Entweder die folgende Nummer oder eine 0L, wenn die 
	laufende Nummer negativ oder zu 5-Stellig wird.
	
*/	
GLOBAL LONG _clc_next(CONST LONG numm ,CONST LONG pre ,  WORD mode );

/*
	Die Funktion prft die Nummer und gibt ein FALSE (0) fr
	'falsche Prfziffer' oder ein TRUE (1) fr ok zurck.
	
	-> :
		numm : Die zu prfende Nummer.
		pre  : Der Vorsatz.
	<- :
		TRUE : Nummer korrekt
		FALSE: Nummer falsch, zu kurz, zu lang....
*/
			
GLOBAL BOOLEAN _tst_numm( CONST LONG numm, CONST LONG pre );


