/*******************************************************************
 * Modul	   : RPMT_DEF.H
 * Projekt	: RPMT
 * Aufgabe	: Definition der Task-Struktur
 *            Definition der Drives und Devices
 *------------------------------------------------------------------
 * Autor	: Ralph Lanfermann
 * Datum	: 28.04.1993
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/


typedef struct
	{
	int t_id;	    		/* Task- Identifikation */
	int t_min1;     		/* Start-x              */
	int t_max1;    	   /* End-x                */
	int t_akt1;          /* x-Aktuell            */
	int t_min2;          /* Start-Y              */
	int t_max2;          /* End-Y                */
	int t_akt2;          /* Y-Aktuell            */
	int t_drive;		   /* Drive-Vektor         */
	int t_device;		   /* Device-Vektor        */
	int t_status;		   /* Status               */
	/* Zeiger auf Fenster der Task */
	/* FENSTER *fen; */
	void (*t_funktion)(int ind);   /* Funktion   */
	char t_name[31];	   /* Task- Name           */
	}TASK;

/* 
	Task-Manager Definitionen
	Laufwerke.
*/	

#define T_DA  0x1
#define T_DB  0x2
#define T_DC  0x4
#define T_DD  0x8
#define T_DE  0x10
#define T_DF  0x20
#define T_DG  0x40
#define T_DH  0x80
#define T_DI  0x100
#define T_DJ  0x200
#define T_DK  0x400
#define T_DL  0x800
#define T_DM  0x1000
#define T_DN  0x2000
#define T_DO  0x4000
#define T_DP  0x8000

/* 
   Taskmanager devices
   type peripherie
*/   

#define T_SCREEN 0x1   
#define T_PRINT  0x2
#define T_MODEM  0x4

/* 0x8 - 0x800 eigene Typen */

#define T_DTAUS  0x8
#define T_ZBUFF  0x10

/* 
	Task-Manager
	Status-Definitionen
*/

#define T_HOLD   1
#define T_RUN    2
#define T_WAIT   3
	
/* Struktur fr Events */

typedef struct
{
  int    mox;                            /* Maus-X-Position */
  int    moy;                            /* Maus-Y-Position */
  int    mobutton;                       /* Mausknopf */
  int    kstate;                         /* Shift-Tastatur-Status */
  int    kreturn;                        /* Keycode von Event-Keyboard */
  int    breturn;                        /* Anzahl der Klicks */
  int    ascii_code;                     /* ASCII-Code der Taste */
  int    scan_code;                      /* Scan-Code der Taste */
  int    shift;                          /* Shift-Taste bettigt ? */
  int    ctrl;                           /* Control-Taste bettigt ? */
  int    alt;                            /* Alternate-Taste bettigt ? */
} RLKINFO;      

/* Eventfunktion */
int multievent( int *msg , RLKINFO *mk , long time );
	
	