/*******************************************************************
 * Modul	   : RPMT_GEM.H
 * Projekt	: -----
 * Aufgabe	: GEM-Schnittstelle. Workstation anmelden
 *            Applikation anmelden GDOS-Test
 *------------------------------------------------------------------
 * Autor	: Ralph Lanfermann
 * Datum	: 28.08.1992
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/


#include <vdi.h>
#include <aes.h>

#if !defined TRUE
#define TRUE 0
#endif

#if !defined FALSE
#define FALSE 1
#endif


int work_in[128];       	/*  zum Oeffnen von VDI  */
int work_out[128];

int contrl[12];       	/*  fuer VDI-Aufrufe     */
int intin[128];
int ptsin[128];
int intout[128];
int ptsout[128];
int addrin [128];
int addrout[128];
int global[15];

int gl_apid;           	/*  Handle von AES       */
int handle,            	/*  Handle von VDI       */
    phys_handle;			/*  Handle von AES-VDI   */
    
int aesfonts,		/* Verfgbare Fonts fr AES      */
    vdifonts;       /* Verfgbare Fonts akt. Treiber */
	 
int gdosok;			/* TRUE fr GDOS da FALSE fr kein GDOS */	 


/* Zeichenzellenmae */
	 
int gl_hchar, 
	 gl_wchar, 
	 gl_hbox, 
	 gl_wbox;
	
GRECT gl_desk;

int init_gem(int flag);
void exit_gem(void);

int init_gem(int flag)
	{
	int i;


	/* Applikation anmelden */
	if( (gl_apid = appl_init()) != -1)
		{
		/* Eingabearray initialisieren */
		for ( i=0; i<10; i++)
			work_in[i]=1;
		work_in[10]=2; 

		/* AES - Handle erfragen */
		phys_handle = graf_handle( 
		&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox );

		work_in[0] = handle = phys_handle;

		/* virtuelle Workstation ffnen */
		v_opnvwk( work_in, &handle, work_out);
		
		/* Desktopmae bestimmen */
		wind_get( 0, 4, &gl_desk.g_x, &gl_desk.g_y,
		&gl_desk.g_w, &gl_desk.g_h);
		
		/* Maus ausschalten */
		graf_mouse(0,0L);

		gdosok = FALSE;

		/* GDOS-INFO ? */
		if ( flag == TRUE )
			{
			/* Ist GDOS geladen ? */
			if ( vq_gdos() == 0 )
				gdosok = FALSE;
			else
				{
				/* Ja, Fonts laden */
				gdosok = TRUE;
				vdifonts = vst_load_fonts( handle , 0 );
				aesfonts = vst_load_fonts( phys_handle, 0 );
				}	
			}
		return(1);
		}
	else
		return (0);
	}

void exit_gem()
 	{
 	if ( gdosok == TRUE )
 		{
 		/* geladene Fonts freigeben */
 		vst_unload_fonts( handle , 0 );
 		vst_unload_fonts( phys_handle , 0 );
 		}
  	v_clsvwk( handle );
  	appl_exit();
 	}
