/*
 * tos2gem.h vom 21.06.1995
 *
 * Autor:
 * Thomas Binder
 *
 * Zweck:
 * Enthlt die Stuktur des TOS2GEM-Cookies.
 *
 * History:
 * 30.08.1994: Erstellung
 * 02.09.1994: Textpuffer- und Bildschirm-Offset
 *             sind jetzt Bestandteil der Cookie-
 *             Struktur behandelt.
 * 03.09.1994: Neues Element "x_vis"
 *             Neues Element "switch_cursor"
 * 04.09.1994: Neues Element "reserve"
 *             "switch_cursor" heit jetzt
 *             "switch_output"
 * 05.09.1994: "switch_output" bekommt jetzt
 *             keinen Parameter mehr, sondern
 *             "switcht" richtig
 * 11.10.1994: Das erste reservierte Feld wird
 *             jetzt benutzt und heit
 *             "cursor_handle". Ist dieses grer
 *             Null (dadurch ist auch
 *             Kompatibilitt zu Programmen
 *             gewhrleistet, die davon nichts
 *             wissen), wird dieses VDI-Handle
 *             zum Zeichnen des Cursor benutzt,
 *             was die Ausgabe deutlich
 *             beschleunigt.
 *             Cookie-Struktur ist jetzt optisch
 *             bersichtlicher.
 * 05.11.1994: Offset-Werte hinzugefgt
 * 02.01.1995: Konstante RESERVED_SIZE hinzugefgt
 *             und Cookie-Struktur entsprechend
 *             angepat.
 * 29.01.1995: Neues Element buffer_output
 * 31.01.1995: Kommentierung des neuen Elements
 * 05.04.1995: Neues Element color, auerdem
 *             Struktur so gendert, da es keine
 *             Probleme mit C-Compilern geben
 *             drfte, die durch Komma getrennte
 *             Elemente in umgekehrter Reihenfolge
 *             anordnen. Zustzlich kann die
 *             Headerdatei jetzt auch gefahrlos
 *             mehrfach eingebunden werden.
 * 21.06.1995: Neues Element stats.
 */

#ifndef _TOS2GEM_H
#define _TOS2GEM_H

/* Anzahl der Felder im reserved-Feld */
#define RESERVED_SIZE	2

/* Die Cookie-Struktur */
typedef struct
{
/* Versionsdatum (GEMDOS-Format) */
	WORD	date;					/* 0x00 */

/* Reservierungsfunktion */
	WORD	(*reserve)(void);		/* 0x02 */

/* Initialisierungsfunktion */
	WORD	(*init)(void);			/* 0x06 */

/* Umschaltefunktion */
	WORD	(*deinit)(void);		/* 0x0a */

/* Ausgabeumlenkungs-Umschaltfunktion */
	WORD	(*switch_output)(void);	/* 0x0e */

/* Zeiger auf Textpuffer */
	char	*text_buffer;			/* 0x12 */

/* Maximale Anzahl Pufferzeilen */
	WORD	max_lines;				/* 0x16 */

/* Gre des "Text"bildschirms */
	WORD	x_size;					/* 0x18 */
	WORD	y_size;					/* 0x1a */

/* Wieviele Spalten sind sichtbar? */
	WORD	x_vis;					/* 0x1c */

/* Wieviele Zeilen sind zu sehen? */
	WORD	y_vis;					/* 0x1e */

/* Linke obere Ecke des Bildschirms (in Pixel!) */
	WORD	x_off;					/* 0x20 */
	WORD	y_off;					/* 0x22 */

/* Maximale Ausmae eines Zeichens (in Pixel!) */
	WORD	char_w;					/* 0x24 */
	WORD	char_h;					/* 0x26 */

/* Zu benutzende VDI-Workstation */
	WORD	vdi_handle;				/* 0x28 */

/* Offset des sichtbaren Ausschnitts */
	WORD	y_offset;				/* 0x2a */

/* Offset innerhalb des Textpuffers */
	WORD	text_offset;			/* 0x2c */

/*
 * Wenn > 0: VDI-Handle zum Zeichnen des Cursors
 * (mu != vdi_handle sein!)
 */
	WORD	cursor_handle;			/* 0x2e */

/*
 * Wenn > 0: Soviele Zeichen sollen erstmal nur
 * gepuffert und erst bei Bedarf ausgegeben werden
 */
	WORD	buffer_output;			/* 0x30 */

/*
 * Wenn 1: TOS2GEM arbeitet mit "kompatibler"
 * VT52-Farbuntersttzung. Wenn > 1: TOS2GEM
 * benutzt VDI-Farbindex-kompatible Farben.
 */
	WORD	color;					/* 0x32 */

/*
 * Interne Statusvariablen, deren Bedeutung nicht
 * genauer erlutert wird. Sie werden beim
 * Abschalten der Umlenkung belegt und bei
 * Reaktivierung via switch_output ausgelesen.
 * Zweck des Ganzen: Dadurch wird es Applikationen
 * ermglicht, TOS2GEM zwischenzeitig freizugeben
 * und spter im exakt gleichen Zustand
 * weiterzubenutzen (siehe Doku).
 */
	WORD	stats[5];				/* 0x34 */

/* Bislang reserviert, auf 0 setzen */
	WORD	reserved[RESERVED_SIZE];/* 0x3e */
} TOS2GEM_COOKIE;

#endif

/* EOF */
