/*
*		FILE:		EXT_FAX.C
*
*		Demo fr Faxausgabe mit TeleOffice
*
*		Automatisches Ext.Fax Start und Stop.
*
*	Aufruf:
*		FAX_TEXT.TTP <FILE> <ADR_KRZEL> <FAXNUMMER>
*	
*/

#define RESOLUTION	1		/* gefaxt wird in "FINE" */
#define DEL_AFTER	1		/* Und die Datei wird anschl. gelscht */
#define LFT_MARG	5		

#define IMG_PG1		"PAGE1.IMG"
#define IMG_PGN		"PAGEn.IMG"

#include <tos.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "fax_out.h"

#define MAX_BUF	1024



typedef struct {
					int version;
					int	headlen;
					int nplanes;
					int patlen;
					int	pixw,pixh;
					int width,height;
				} IMGHEADER;
				
				
typedef struct {
					int 	selected;
					char 	name[31];
					char	zusatz[31];
					char	telefon[31],fax[31];
					char	strasse[31];
					char	plz[10],ort[26];
					char	usr0[12];
					char	usr1[12];
				} ADRESSE;
				
				
FAX_OUTPUT *fxout;

char *strtail( char *str,int len )
{
	int n;
	static char sbuf[64];
	n = (int)strlen(str);
	if( n<len ) strcpy( sbuf,str );
	else		strcpy( sbuf,&str[n-len] );
	return sbuf;
}

	
int init_fxout( void  )
{
	long oldsp=0L;
	struct cookie *cptr;

	if( Super((void *)1L)==0 ) oldsp = Super( NULL );
	cptr = *(struct cookie **)0x5a0;
	if( oldsp ) Super( (void *)oldsp );
	fxout=NULL;
	if( cptr == NULL ) return -1;	/* altes TOS ohne Cookie Jar! */
	while( cptr->c ){
		if( cptr->c == FAX_COOKIE ) {		/* gefunden */
			fxout = (FAX_OUTPUT *)cptr->v;
			return 0;
		}
		cptr++;
	}
	return -1;
}



void get_imgline( FILE *fp,char *imbuf,int *vrc,int bytes,int pat_len )
{
	char data,*dp,pattern[4];
	int  i;
	if( *vrc ){
		(*vrc)--;
		return;		/* Line Replication */
	}
	dp = imbuf;
	while( bytes>0 ) {
		data = fgetc( fp );
		switch( data ) {
			case 0:
					data = fgetc( fp );
					if( data ) {		/* Pattern-Run */
						bytes -= pat_len*(int)data;
						for(i=0;i<pat_len;i++) pattern[i] = fgetc( fp );
						while( data-- )
							for(i=0;i<pat_len;i++ ) *dp++ = pattern[i];
					} else {
						data = fgetc( fp );
						if( data==0xff ) *vrc = (int)fgetc(fp);
						(*vrc)--;
					}
					break;
			case 0x80:			/* Bit-String */
					data = fgetc( fp );
					bytes -= (int)data;
					while( data-- ) *dp++ = fgetc( fp );
					break;
			default:			/* Solid Run */
					i = data & 0x7f;
					bytes -= i;
					data = (data & 0x80) ? 0xff:0x00;
					while( i-- ) *dp++ = data;
					break;
		}
	}
}	


void img_fax( char *filename )
{
	FILE *fp;
	int  plen,b_width,im_h,vrc;
	char buf[MAX_BUF];
	IMGHEADER img_hd;
	
	if((fp = fopen( filename,"rb" ))==NULL) return;
	fread( &img_hd,sizeof(IMGHEADER),1L,fp );
	b_width= (img_hd.width+7)>>3;
	plen   = img_hd.patlen;
	im_h   = img_hd.height;
	fseek(fp,img_hd.headlen*2L,SEEK_SET);
	vrc = 0;
	while( im_h-- ) {
		get_imgline( fp,buf,&vrc,b_width,plen );
		(*fxout->bit_out)(buf,b_width<<3,1,b_width>>1);
	}
	(*fxout->lf)();
	fclose( fp );
}


void txt_fax( char *filename )
{
	FILE *fp;
	char buf[MAX_BUF];
	int  pg_empty=1,page=1;
	
	if((fp = fopen( filename,"r" ))==NULL) return;
	while( !feof(fp) ) {
		fgets(buf,MAX_BUF,fp);
		if( pg_empty ) {
			img_fax( page==1 ? IMG_PG1:IMG_PGN );
		}
		pg_empty=0;
		(*fxout->txt_out)( buf ); /* Zeile ausgeben */
		(*fxout->lf)( );		  /* und den Zeilenvorschub nicht vergessen */
		if( fxout->txt_line == fxout->tot_txtlines ) { /* Seitenende erreicht */
			page++;
			pg_empty = 1;
			(*fxout->page_break)();
		}
	}
	fclose( fp );
}


void fax_it( char *argv[] )
{
	ADRESSE adr;
	void    *ap[2];

	memset(&adr,0,sizeof(ADRESSE));
	strcpy( adr.name,argv[2] );		/* Adresskrzel in adr.name */
	strcpy( adr.fax,argv[3] );		/* Faxnummer eintragen */
	adr.selected |= 0x0008;
	ap[0] = &adr;
	ap[1] = NULL;

	(*fxout->init_extfax)(ap,1,RESOLUTION,strtail(argv[1],32));

	(*fxout->init_app)(1,0,0,0);
	fxout->lft_margin = LFT_MARG;
	txt_fax( argv[1] );	/* Fax erzeugen */
	(*fxout->ff)();
	(*fxout->exit_app)();

	(*fxout->term_extfax)(0,0L,DEL_AFTER);
}

int main( int argc, char *argv[] )
{
	if( init_fxout( ) ) return 1;
	if( fxout->init_extfax==NULL ) {
		puts( "\nFehler: Kein OFFICE.ACC geladen! ");
		return 1;
	}

	if( argc!=4 ) {
		puts("\nFehler: Parameteranzahl");
		return 1;
	}

	fax_it( argv );
	
	return 0;
}
