; Robot arm demo #1
; by Tom Hudson
;
; Put ROBOTARM.3D2 on drive A

load3d "a:\tomhudsn\robotarm.3d2"

; Reset internal tree structure

treeclr

; Add arm parts to tree

treeadd BASE,LOWARM,UPARM,CLAW

; Build tree!

relate LOWARM,BASE,shoulder
relate UPARM,LOWARM,elbow
relate CLAW,UPARM,wrist

; Set joint restrictions

limit LOWARM,-45,45,0,0,-180,180
limit UPARM,-90,90,0,0,0,0
limit CLAW,0,0,0,0,-180,180

; Now let's watch the action!

mono:draft:perspec 999:zoom 100:cam1 40,30,0:view wire
watch on

for clawz=0 to 90 step 10
load3d "a:\tomhudsn\robotarm.3d2"
position CLAW,0,0,clawz
treeset BASE
superview
next clawz

watch off:end
