; BACKFLIP by Darrel Anderson Version 1.4 
; Required files SMALGAL.3D2,RIGHTARM.3D2,LEFTARM.3D2,
; F_SMAL_B.3D2,F_SMAL_C.3D2. Use MAKESMAL.CTL to create these files.
; 80 Object CAD-3D 2.02 REQUIRED.

alert "Place required files in Drive"
load3d "B:\SMALLGAL.3D2"

bx=-4
group a:clrgrp:select Ltoes:grpcent fx,fy,fz:floor=fz

gosub DEFSPLINES
gosub TREESETUP

zoom 70:perspec 710:backgnd yes,no
cam2 -5000,+400,-800,0,0,0,0
rstart "A:\BACKFLIP",m:view s:draft:goto RUNIT

;____________________________MAIN_LOOP___________________________
@RUNIT
;  START AN 80 COUNT LOOP ...

for frame=0 to 80 

if frame<60 then framev=frame
pos=10*frame:neg=10*frame

if frame<50 then gosub LEFT:gosub LEGS:gosub TORSO:gosub RIGHT:goto REC

if frame<74 then gosub LEFT:gosub TORSO:gosub LEGS:gosub RIGHT:goto REC

gosub LEGS:gosub TORSO:gosub LEFT:gosub RIGHT:goto REC

;_________________PARTIAL-SKEL_SUB-ROUTINES______________________
@LEFT
load3d "B:\SMALLGAL.3D2"
kill Lhumerus,Lradius,Lulna,Lhand
merge3d "B:\LEFTARM.3D2"
position thorax,(s2x(frame)) * -.5,0,0
position Lhumerus,s1x(frame),(s1y(frame))*-1,0
position Lulna,pos0,0,0
position Lradius,0,0,0

treeset saclumbr
gosub POSTTREE

if frame<50 then gosub CAMTRAC
cam2 -5000+(frame*60),+400-(framev*100),-800+(framev*100),flx,fly,flz,0

group d:clrgrp
select Lhumerus,Lradius,Lulna,Lhand:if frame<72 then select box

superview:vtobgnd

return
;_____________________________________________________________________
@TORSO
load3d "B:\SMALLGAL.3D2"
kill thorax,cervneck,skull,mandible,Rclavicl,Lclavicl,Rscapula,Lscapula
merge3d "B:\F_SMAL_B.3D2"

position thorax,(s2x(frame)) * -.5,0,0
position cervneck,(s2x(frame)) * -.2,0,0
position skull,(s2x(frame)) * -.2,0,0

treeset saclumbr
gosub POSTTREE

if frame<50 then gosub CAMTRAC
cam2 -5000+(frame*60),400-(framev*100),-800+(framev*100),flx,fly,flz,0

group d:clrgrp
select thorax,cervneck,skull,mandible,Rclavicl,Lclavicl,Rscapula,Lscapula

superview:vtobgnd

return
;_____________________________________________________________________
@RIGHT
load3d "B:\SMALLGAL.3D2"
kill Rhumerus,Rulna,Rradius,Rhand
merge3d "B:\RIGHTARM.3D2"

position thorax,(s2x(frame)) * -.5,0,0
position Rhumerus,s1x(frame),s1y(frame),0
position Rulna,0,0,0
position Rradius,0,0,0

treeset saclumbr
gosub POSTTREE

if frame<50 then gosub CAMTRAC
cam2 -5000+(frame*60),400-(framev*100),-800+(framev*100),flx,fly,flz,0

group d:clrgrp
select Rhumerus,Rulna,Rradius,Rhand
superview:vtobgnd

return
;__________________________________________________________________
@LEGS

load3d "B:\SMALLGAL.3D2"
kill pelvis,Lfemur,Rfemur,Lknee,Rknee,Ltibia,Rtibia,Lfibula,Rfibula
kill Lankle,Rankle,Ltoes,Rtoes,saclumbr
merge3d "B:\F_SMAL_C.3D2"

position thorax,(s2x(frame)) * -.5,0,0
position pelvis,(s2x(frame)) * -.5,0,0
position Lfemur,s2x(frame),0,0
position Rfemur,s2x(frame),0,0
position Ltibia,s3x(frame),0,0
position Lfibula,s3x(frame),0,0
position Rtibia,s3x(frame),0,0
position Rfibula,s3x(frame),0,0
position Lankle,0,0,0
position Ltoes,(s2x(frame)) * .2,0,0
position Rankle,0,0,0
position Rtoes,(s2x(frame)) * .2,0,0

treeset saclumbr
gosub POSTTREE

if frame<50 then gosub CAMTRAC
cam2 -5000+(frame*60),400-(framev*100),-800+(framev*100),flx,fly,flz,0

group d:clrgrp
select pelvis,Lfemur,Rfemur,Lknee,Rknee,Ltibia,Rtibia,Lfibula,Rfibula
select Lankle,Rankle,Ltoes,Rtoes,saclumbr

superview:vtobgnd

return
;______________ POST-TREESET_OBJECT_MANIPULATION________________
@POSTTREE
; AFTER THE TREESET FUNCTION HAS BEEN EXECUTED, THE OBJECT GROUP
; CAN BE MANIPULATED AS A WHOLE.
; THE FIRST OPERATION KEEPS THE FEET ON ONE LEVEL (THE "FLOOR").

group a:clrgrp:select Ltoes:grpcent cx,cy,cz:tofloor=floor-cz
group d
if frame<35 then xlate 0,0,tofloor

; THIS NEXT SECTION HANDLES THE FLIP OF THE FIGURE...
; ROTATION > 180 DEGREES ARE CONVERTED TO NEGATIVE EQUIVALENT.
flip=s4x(frame)
if s4x(frame)>180 then flip=s4x(frame)-360
setarb fx,fy,fz:if frame>34 then setarb 0,200,0
rotate flip,0,0
if frame > 34 then xlate 0,(pos-280)*4,s5z(frame-34)

return
;_____________________________________________________________
@REC

bell
clrgrp:superview
if frame>= 72 then group a:clrgrp:select box:superview
record
clrbgnd
next frame
; THE PREVIOUS LINE SENDS US BACK TO THE TOP OF THE MAIN LOOP.

rstop:end
;_____________________CAMERA-TRACKING__SUB-ROUTINE___________________
@CAMTRAC
group a:clrgrp:select Rscapula:grpcent lx,ly,lz:group d
flx=lx:fly=ly:flz=lz:return
; _______________SUB-ROUTINE TO CREATE TREE STRUCTURE________________
@TREESETUP

; ADD ALL OBJECTS TO TREE (ORDER IS NOT SIGNIFICANT)
treeclr
treeadd thorax,Rhumerus,Lhumerus,Rulna,Lulna,Rradius,Lradius,Rhand,Lhand
treeadd skull,mandible,cervneck,Lscapula,Rscapula,Rclavicl,Lclavicl
treeadd pelvis,Lfemur,Lknee,Lfibula,Ltibia,Lankle,Ltoes
treeadd saclumbr,Rfemur,Rknee,Rfibula,Rtibia,Rankle,Rtoes

; BUILD TREE USING SACLUMBR (LOWER SPINE) AS ROOT.
; START BY WORKING OUT TOWARDS LEFT TOES...
relate pelvis,saclumbr,*lowback
relate Lfemur,pelvis,*lhip
relate Ltibia,Lfemur,*lknee
relate Lfibula,Lfemur,*lknee
relate Lknee,Lfibula,*lknee
relate Lankle,Lfibula,*lankle
relate Ltoes,Lankle,*ltoes

; ...AND NOW TOWARDS RIGHT TOES...
relate Rfemur,pelvis,*rhip
relate Rtibia,Rfemur,*rknee
relate Rfibula,Rfemur,*rknee
relate Rknee,Rfibula,*rknee
relate Rankle,Rfibula,*rankle
relate Rtoes,Rankle,*rtoes

; ...UP TO SKULL AND OUT TO HANDS.
relate thorax,saclumbr,*midback
relate Lclavicl,thorax,*lscapul
relate Rclavicl,thorax,*rscapul
relate Rscapula,thorax,*rscapul
relate Lscapula,thorax,*lscapul
relate Rhumerus,thorax,*rsholdr
relate Lhumerus,thorax,*lsholdr
relate Rulna,Rhumerus,*relbow
relate Lulna,Lhumerus,*lelbow
relate Rradius,Rhumerus,*relbow
relate Lradius,Lhumerus,*lelbow
relate Rhand,Rulna,*rwrist
relate Lhand,Lulna,*lwrist
relate cervneck,thorax,*lowneck
relate skull,cervneck,*upneck
relate mandible,skull,*jaw

return
;________________SPLINE_DEFINITION_SUB-ROUTINES__________________
@DEFSPLINES

; SHOULDER
defpt 1,0,0,0
defpt 1,-160,0,0
defpt 1,240,0,0
defpt 1,-10,40,0
defpt 1,0,90,0
defspline 1,81,B

; FEMUR
defpt 2,0,0,0
defpt 2,180,0,0
defpt 2,120,0,0
defpt 2,-40,0,0
defpt 2,90,0,0
defpt 2,150,0,0
defpt 2,0,0,0
defspline 2,81,B

; TIBIA/FIBULA
defpt 3,0,0,0
defpt 3,-160,0,0
defpt 3,-140,0,0
defpt 3,0,0,0
defpt 3,0,0,0
defpt 3,-20,0,0
defpt 3,0,0,0
defspline 3,81,B

; WHOLE FIGURE
defpt 4,0,0,0
defpt 4,-10,0,0
defpt 4,20,0,400
defpt 4,50,0,1000
defpt 4,360,0,0
defspline 4,81,B

; JUMP
defpt 5,0,0,0
defpt 5,0,0,1000
defpt 5,0,0,0
defspline 5,47,B

return

