; *************************************
; * >EXTENDED VT52-TERMINAL EMULATOR< *
; *===================================*
; * Entwickelt mit PROFIMAT-Assembler *
; *      M.Schumacher, (p) 12/87      *
; *      (AUTO-ORDNER-VERSION!!)      *
; *   >>> LAST UPDATE: 25.06.88 <<<   *
; *************************************

LOGBASE  equ $44E         ; Zeiger auf logischen Bildschirm
VID_R0   equ $FFFF8240    ; Video-Farbregister 0
REGISTER equ d3-d7/a0/a3-a6;bentigte Register fr Verschieberoutinen
RESETCO  equ INIT_CONOUT  ; Terminal-Initialisierungsroutine
NVBLS    equ $454         ; Anzahl VBL-Routinen
VBLQUEUE equ $456         ; Zeiger auf Zeiger auf VBL-Routinen

 text

INSTALL:
 move.l   4(a7),a4        ; ^Basepage
 move.l   12(a4),d7       ; Lnge TXT
 add.l    20(a4),d7       ;      +DTA
 add.l    #256,d7         ;      +256

\frage:
 pea      MLD             ; Intro-Text
 move.w   #9,-(a7)        ; ausgeben
 trap     #1
 move.w   #1,-(a7)        ; Cconin
 trap     #1
 addq.w   #8,a7           ; Stack aufrumen
 swap     d0              ; MSW <-> LSW
 andi.w   #$ff,d0         ; Scan-Code fr Taste isolieren
 cmpi.w   #36,d0          ; "j"?
 beq.s    GO_ON           ; ja, xVT52 installieren
 cmpi.w   #49,d0          ; "n"?
 bne.s    \frage          ; nein, nochmal das Ganze
 clr.w    -(a7)           ; sonst unverrichteter Dinge
 trap     #1              ; das Programm abbrechen

GO_ON:
 move.l   d7,-(a7)        ; Anzahl zu reservierender Bytes
 clr.l    -(a7)           ; SUPER ON
 move.w   #$20,-(a7)
 trap     #1
 move.l   d0,2(a7)        ; alten SSP merken

 bsr      INIT_CONOUT     ; Emulator initialisieren
 move.l   VBLQUEUE,a0     ; ^VBL-Zeiger
 addq.l   #4,a0           ; 1. Slot berspringen (GEM!)
 move.w   NVBLS,d0        ; Anzahl der Routinen (-1)
 subq.w   #2,d0           ; in dbra-Zhler wandeln
\test_slot:
 tst.l    (a0)            ; Slot frei?
 beq.s    \freeslot       ; ja
 addq.l   #4,a0           ; sonst halt
 dbra     d0,\test_slot   ; den nchsten Slot testen
 bra.s    \noslot         ; kein freier Slot mehr?! (normal unmglich)
\freeslot:
 lea      CRS_IRR,a1      ; Cursor-Interrupt-Routine
 move.l   a1,(a0)         ; einbinden
\noslot:
 lea      TRAPS,a4        ; ^Speicher fr Original-Trap-Handler
 move.l   $84,(a4)+       ; alten GEMDOS-Vektor merken
 lea      GEMDOS,a2       ; und neuen
 move.l   a2,$84          ; installieren
 move.l   $88,(a4)+       ; aktuellen GEM-Vektor merken (-> RTE!!!!!)
 move.l   $B4,(a4)+       ; BIOS-Vektor
 lea      BIOS,a2
 move.l   a2,$B4
 move.l   $B8,(a4)        ; XBIOS-Vektor
 lea      XBIOS,a2
 move.l   a2,$B8

 trap     #1              ; SUPER OFF
 addq.l   #6,a7           ; Stack aufrumen

 bsr      SHOW_PIC        ; Bild anzeigen
 move.w   #$31,-(a7)      ; KEEP PROCESS (hi zombie!)
 trap     #1              ; auf Wiedersehen im GEMDOS


;***************************************************************************
;* G E M D O S / A E S+V D I / B I O S / X B I O S - T R A P H A N D L E R *
;***************************************************************************

SAVE_REGS:                ; Register retten
 move.l   (a7)+,d0        ; Rcksprungadresse retten
 lea      SAVE_TOP,a1     ; A1=Registerspeicher, Obergrenze
 move.w   (a7)+,-(a1)     ; save(SR)
 move.l   (a7)+,-(a1)     ; save(PC)
 movem.l  d1-d7/a1-a7,-(a1);save(Register)
 lea      2(a0),a7        ; SSP auf 1. Parameter setzen
 move.l   d0,-(a7)        ; Rcksprungadresse zurck
 rts

REST_REGS:                ; Register zurckholen
 lea      SAVE_BOT,a1     ; A1=Registerspeicher, Untergrenze
 movem.l  (a1)+,d1-d7/a1-a7;Register zurck
 move.l   (a1)+,-(a7)     ; PC zurck
 move.w   (a1)+,-(a7)     ; SR zurck
 rte                      ; zurck ins aufrufende Programm

SAVE_BOT:                 ; Untergrenze Zwischenspeicher
 ds.w     31,0            ; Platz fr Register, PC und SR
SAVE_TOP:                 ; Obergrenze Zwischenspeicher


GEMDOS:
 movea.l  a7,a0           ; A0=SSP;
 btst     #5,(a0)         ; if (Aufruf aus S-Mode)
 beq.s    \from_user
 addq.l   #6,a0           ;    then Offset addieren (PC.L+SR.W)
 bra.s    \test_pline
\from_user:
 move.l   USP,a0          ;    else User Stack benutzen;
\test_pline:
 movem.l  a0,-(a7)        ; A0 retten
 lea      REDIR,a0        ; Zeiger auf Flag fr Ausgabe-Umlenkung
 tst.w    (a0)            ; gesetzt?
 movem.l  (a7)+,a0        ; A0 zurck, keine CCR-Beeinflussung
 beq.s    \test_gdos      ; keine Umlenkung => auf Ausgabefunktionen prfen
 cmpi.w   #$46,(a0)       ;   FORCE-Aufruf?
 bne      \orig           ;   nein
 cmpi.w   #1,2(a0)        ;   Umlenkung auf Stdout?
 bne      \orig           ;   nein
 lea      REDIR,a0        ;   sonst Flag wieder
 clr.w    (a0)            ;   auf 0 setzen
 bra      \orig           ;   ab ins GEMDOS
\test_gdos:
 cmpi.w   #9,(a0)         ; if (Funktion == PRINT LINE)
 beq.s    \pline          ; then eigene Funktion benutzen
 cmpi.w   #64,(a0)        ; else if (Funktion == WRITE)
 beq.s    \write          ;      then auf Ausgabe-Kanal prfen
 cmpi.w   #2,(a0)         ;      else if (Funktion == CCONOUT)
 beq.s    \cconout        ;           then eigene Funktion benutzen
 cmpi.w   #6,(a0)         ;           else if (Funktion != CRAWIO)
 bne.s    \test_force     ;                then auf force() testen
 cmpi.b   #-1,3(a0)       ;                else if (Zeichen == 255)
 beq.s    \orig           ;                     then Original aufrufen
 bra.s    \cconout        ;                     else Zeichen ausgeben
\test_force:
 cmpi.w   #$46,(a0)       ; FORCE-Aufruf?
 bne.s    \orig           ; nein
 cmpi.w   #1,2(a0)        ; wird auf Stdout umgelenkt?
 bne.s    \orig           ; nein
 lea      REDIR,a0        ; sonst Umlenkungs-Flag
 st       (a0)            ; setzen
 bra.s    \orig           ; und GEMDOS aufrufen
\cconout:                 
 bsr      SAVE_REGS       ; Register retten
 bsr      CON_OUT         ; Zeichen ausgeben
 bra      REST_REGS       ; Register zurck, fertig
\pline:
 bsr      SAVE_REGS       ; Register retten
 bsr      WRITE           ; String ausgeben
 bra      REST_REGS       ; Register zurck, fertig
\orig:
 move.l   TRAPS,a0        ; else Originalroutine
 jmp      (a0)            ; benutzen
\write:
 cmpi.w   #1,2(a0)        ; Ausgabe auf CON:?
 bne.s    \orig           ; nein, ham wa nix mit zu tun
 clr.l    d0              ; Default: 0 Zeichen ausgeben
 addq.w   #2,a0           ; Anzahl auszugebender
 move.l   2(a0),d1        ; Zeichen holen
 beq.s    \retour         ; kein Zeichen ist definitiv zu wenig!
 bsr      SAVE_REGS       ; ansonsten Register retten
 addq.w   #4,a7           ; (a7) = String-Pointer
 move.l   d1,-(a7)        ; Anzahl Zeichen als Rckgabewert auf Stack retten
 move.l   d1,-(a7)        ; und nochmal als Zhler
 move.l   8(a7),-(a7)     ; String-Pointer auf Stack legen
\lp:
 move.l   (a7),a0         ; String-Pointer holen
 addq.l   #1,(a7)         ; auf nchstes Zeichen zeigen lassen
 move.b   (a0),d1         ; Zeichen holen
 and.w    #$FF,d1         ; nur LSB beachten
 move.w   d1,-(a7)        ; Zeichen auf Stack legen
 bsr      CON_OUT         ; und ausgeben
 addq.w   #2,a7           ; Stack korrigieren
 subq.l   #1,4(a7)        ; Anzahl Zeichen dekrementieren
 bne.s    \lp             ; und nchstes Zeichen ausgeben
 addq.l   #8,a7           ; Zhler und Pointer lschen
 move.l   (a7)+,d0        ; Anzahl ausgegebener Zeichen in d0 zurckgeben
 bra      REST_REGS       ; Register restaurieren und zurckspringen
\retour:
 rte                      ; tsch


AES_VDI:
 cmpi.w   #$73,d0         ; VDI-Aufruf?
 bne.s    \orig           ; nein, AES
 move.l   a0,-(a7)        ; a0 retten
 move.l   d1,a0           ; ^ParameterBlock
 move.l   (a0),a0         ; ^ContrlBlock
 cmpi.w   #5,(a0)         ; VDI-ESC-Sequenz? (CONTRL[0])
 bne.s    \clear          ; nein
 lea      10(a0),a0       ; ^Unterfunktionsnummer (CONTRL[5])
 cmpi.w   #16,(a0)        ; <16?
 bmi.s    \ok             ; ja, eigene Routine ausfhren
 cmpi.w   #101,(a0)       ; VDI ESC 101?
 beq.s    \ok             ; ja
 cmpi.w   #102,(a0)       ; Font installieren?
 bne.s    \fail           ; nein, dann Originalroutine benutzen
\ok:                      ; *** eigene Routinen ausfhren ***
 lea      VDI_TOP,a0      ; ^Zwischenspeicher
 move.l   (a7)+,-(a0)     ; alten Inhalt von a0 retten
 move.w   (a7)+,-(a0)     ; SR
 move.l   (a7)+,-(a0)     ; PC
 movem.l  d0-d7/a1-a7,-(a0);alle Register retten
 bsr      VDI_ENTRY       ; Routine ausfhren
 lea      VDI_BOT,a0      ; ^Zwischenspeicher
 movem.l  (a0)+,d0-d7/a1-a7;Register wieder zurck
 move.l   (a0)+,-(a7)     ; PC,
 move.w   (a0)+,-(a7)     ; SR und
 move.l   (a0)+,a0        ; a0 restaurieren,
 rte                      ; Exception beenden
\fail:
 move.l   (a7)+,a0        ; a0 restaurieren
\orig:
 move.l   TRAPS+4,-(a7)   ; Originaladresse AES/VDI
 rts                      ; benutzen
\clear:
 cmpi.w   #3,(a0)         ; ClearWorkstation?
 bne.s    \fail           ; nein
 movem.l  a1-a2,-(a7)     ; Register retten
 lea      TCB,a0          ; ^TerminalControlBlock
 lea      CCB+6,a1        ; ^CursorControlBlock (abs. Cursorposition)
 move.l   LINE_A,a2       ; ^Line-A-Block
 lea      -46(a2),a2      ; ^VDI-Block
 move.w   36(a0),(a2)+    ; Zeichenhhe in Pixels
 move.l   4(a0),(a2)+     ; max. Spalte/Zeile
 move.w   38(a0),(a2)+    ; Bytes pro Textzeile
 addq.w   #4,a2           ; Vorder-/Hintergrundfarbe berspringen
 move.l   (a1),(a2)+      ; abs. Cursorposition
 addq.w   #2,a2           ; vert. Offset berspringen
 move.l   (a0),(a2)+      ; akt. Spalte/Zeile
 movem.l  (a7)+,a1-a2     ; Register zurck
 move.l   (a7)+,a0        ; a0 zurck
 pea      \clear_ret      ; da soll's wieder hin
 move.w   SR,-(a7)        ; SR auf Stack
 bra.s    \orig           ; Original-Routine des VDI ausfhren
\clear_ret:
 movem.l  a0-a2,-(a7)     ; Register retten
 lea      TCB,a0          ; ^TerminalControlBlock
 lea      CCB+6,a1        ; ^CursorControlBlock (abs. Cursorposition)
 move.l   LINE_A,a2       ; ^Line-A-Block
 move.l   -28(a2),(a0)    ; akt. Spalte/Zeile
 move.l   -34(a2),(a1)    ; abs. Cursorposition
 movem.l  (a7)+,a0-a2     ; Register zurck
 rte                      ; fertig

VDI_BOT:
 ds.w     35,0            ; Platz fr d0-a7, SR & PC
VDI_TOP:


BIOS:
 movea.l  a7,a0           ; A0=SSP;
 btst     #5,(a0)         ; if (Aufruf aus S-Mode)
 beq.s    \from_user
 addq.l   #6,a0           ;    then Offset addieren (PC.L+SR.W)
 bra.s    \test_wr_asc
\from_user:
 move.l   USP,a0          ;    else User Stack benutzen;
\test_wr_asc:
 cmpi.w   #12,(a0)        ; if (Funktion != WRITE_ASC)
 bne.s    \test_bconout   ;    then auf BCONOUT testen
 bsr      SAVE_REGS       ;    else { Register retten;
 bsr      WRITE_ASC       ;           String ausgeben;
 bra      REST_REGS       ;           Register zurck; beenden }
\test_bconout:
 cmpi.w   #3,(a0)         ; if (Funktion == BCONOUT)
 beq.s    \test_dev       ;    then auf Ausgabegert testen
\orig_bios:
 move.l   TRAPS+8,-(a7)   ;    else Originalroutine benutzen
 rts
\test_dev:
 addq.w   #2,a0           ; Zeiger auf Gertenummer setzen
 cmpi.w   #2,(a0)         ; if (Ausgabegert != Console)
 bne.s    \test_dev_vid   ;    then auf ASCII-Ausgabe testen
 bsr      SAVE_REGS       ;    else { Register retten;
 bsr      CON_OUT         ;           Zeichen ausgeben;
 bra      REST_REGS       ;           Register zurck; beenden }
\test_dev_vid:
 cmpi.w   #5,(a0)         ; if (!ASCII_Ausgabe)
 bne.s    \orig_bios      ;    then Originalroutine benutzen
 bsr      SAVE_REGS       ;    else { Register retten;
 bsr      ASC_OUT         ;           Zeichen ausgeben;
 bra      REST_REGS       ;           Register zurck; beenden }


XBIOS:
 movea.l  a7,a0           ; A0=SSP;
 btst     #5,(a0)         ; if (Aufruf aus S-Mode)
 beq.s    \from_user
 addq.l   #6,a0           ; then Offset addieren (PC.L+SR.W)
 bra.s    \test_cursconf
\from_user:
 move.l   USP,a0          ; else User Stack benutzen;
\test_cursconf:
 cmpi.w   #21,(a0)        ; if (Funktion == CURSCONF)
 beq.s    \cursconf       ; then eigene Funktion benutzen
 cmpi.w   #100,(a0)       ; else if (Funktion == INIT_SCREEN)
 beq.s    \init           ;      then Bildschirmausgabe initialisieren
 move.l   TRAPS+12,-(a7)  ;      else Originalroutine benutzen
 rts
\cursconf:
 bsr      SAVE_REGS       ; Register retten
 bsr      CURSCONF        ; eigene Routine anstoen
 bra      REST_REGS       ; Register zurck, beenden
\init:
 bsr      SAVE_REGS       ; Register retten
 bsr.s    INIT_CONOUT     ; Ausgabe initialisieren
 bra      REST_REGS       ; Register zurck, beenden


;***************************************************************************
;* N E U E   R O U T I N E N   F  R   V T 5 2   U N D   VDI-E S C A P E S *
;***************************************************************************

INIT_CONOUT:              ; ESC 'i', Terminal initialisieren
 dc.w     $A000           ; Line A-Pointer holen
 lea      TCB,a2          ; TerminalControlBlock initialisieren
 move.l   4(a1),a4        ; ^8*8-Font
 move.l   $4C(a4),28(a2)  ; ^Fontdaten speichern
 move.l   8(a1),a4        ; ^8*16-Font
 move.l   $4C(a4),a4      ; ^Fontdaten
 move.l   a4,24(a2)       ; speichern
 move.l   a4,32(a2)       ; und 8x16 zum aktuellen Font machen
 move.l   #$4f0018,4(a2)  ; max. Spalte=79; max. Zeile=24
 move.b   #2,8(a2)        ; Wrapping ein-, Inverse Darstellung ausschalten
 clr.w    10(a2)          ; keine Cursor-Position gespeichert (ESC 'j')
 move.l   #$100500,36(a2) ; Zeichenhhe 16 Pixels, 16*80 Bytes/Textzeile

 lea      LINE_A,a2       ; Line-A Adresse
 move.l   a0,(a2)         ; merken
 clr.l    -28(a0)         ; Zeile/Spalte in VDI-Block auf 0 setzen

 lea      VEC_BASE,a2     ; Ausgabevektor initialisieren
 lea      STD_VEC,a3      ; ^Standardausgabe
 move.l   a3,(a2)         ; als Default bernehmen

 lea      CCB,a4          ; CursorControlBlock initialisieren
 move.w   #$200,(a4)      ; Cursor ausschalten, Blinkmodus whlen
 move.l   #$140014,2(a4)  ; Blinkrate und -zhler auf 20 stellen
 move.l   LOGBASE,6(a4)   ; abs. Cursorposition auf Bildschirm-Anfang

 lea      BEL_ADR,a0      ; ^Speicher fr Adresse Gong-Routine (Control G)
 move.l   #$FC201C,d0     ; TOS-Adresse (Version vom 06.02.1986)
 cmpi.w   #$1986,$FC001A  ; "altes" TOS?
 beq.s    \old_tos        ; ja
 move.l   #$FC2270,d0     ; sonst Blitter-TOS-Adresse nehmen
\old_tos:
 move.l   d0,(a0)         ; Vektor installieren

 lea      TCB,a0          ; ^TerminalControlBlock
 bsr      CLS             ; Bildschirm lschen+Home
 bsr      DEF_TABS        ; Tabulatoren auf default setzen
 bra      UPDATE_END      ; Cursor freigeben und zurck


CRS_IRR:                  ; Cursor-Interruptroutine
 lea      AES_OK,a1       ; ^Flag laden
 tst.w    (a1)            ; AES aktiv?
 bne.s    \aes_ok         ; ja, normal weitermachen
 lea      TRAPS+4,a2      ; ^alter AES/VDI-Vektor
 move.l   $88,a0          ; aktueller AES/VDI-Vektor
 cmpa.l   (a2),a0         ; noch derselbe?
 beq.s    \irr_end        ; ja, GEM noch nicht initialisiert
 move.l   a0,(a2)         ; sonst Originaladresse AES/VDI merken
 st       (a1)            ; Flag setzen (fr: AES aktiv)
 lea      AES_VDI,a0      ; und eigene Routine
 move.l   a0,$88          ; installieren
 bra.s    \irr_end        ; fertig, ab jetzt geht's normal weiter
\aes_ok:
 move.l   $88,d1          ; derzeit aktive AES/VDI-Adresse
 lea      AES_VDI,a0      ; eigenen Trap-Handler neu installieren
 cmp.l    a0,d1           ; hat sich Adresse gendert?
 beq.s    \weiter         ; nein, weiter
 move.l   a0,$88          ; sonst AES/VDI als Vektor installieren (grins)
 lea      TRAPS+4,a2      ; ^alter AES/VDI-Vektor
 move.l   d1,(a2)         ; neuen Vektor merken
 bsr      UPDATE_CRS      ; und Cursor
 bra      CRS_OFF         ; abschalten
\weiter:
 lea      CCB,a4          ; ^CursorControlBlock
 btst     #3,(a4)         ; Cursor eingeschaltet?
 beq.s    \irr_end        ; nein, fertig
 btst     #0,(a4)         ; wird gerade Text ausgegeben?
 beq.s    \irr_end        ; ja, dann nicht stren
 btst     #1,(a4)         ; Blinken eingeschaltet?
 bne.s    \blink          ; ja
 btst     #2,(a4)         ; Cursorposition schon invertiert?
 bne.s    \irr_end        ; ja, nicht mehr invertieren
\inv:
 bsr      CUR_INV         ; Cursorposition invertieren
\irr_end:
 rts                      ; zurck zum IR-Slot-Handler
\blink:
 subq.w   #1,4(a4)        ; Blinkzhler --
 bne.s    \irr_end        ; noch nicht 0, fertig
 move.w   2(a4),4(a4)     ; sonst Zhler neu laden
 bra.s    \inv            ; invertieren und zurck


CURSCONF:                 ; XBIOS(21)
 bsr      UPDATE_CRS      ; Cursor abschalten
 move.w   4(a7),d1        ; Funktionsnummer holen
 bne.s    \f1             ; nicht 0
 bclr     #3,(a4)         ; Cursor ausschalten
 bra.s    \zurck         ; fertig
\f1:
 cmpi.w   #1,d1           ; Fkt.-Nr. 1?
 bne.s    \f2             ; nein
 bset     #3,(a4)         ; Cursor einschalten
 bra.s    \zurck
\f2:
 cmpi.w   #2,d1           ; Fkt.-Nr. 2?
 bne.s    \f3             ; nein
 bset     #1,(a4)         ; Cursor in Blinkmodus versetzen
 bra.s    \zurck
\f3:
 cmpi.w   #3,d1           ; Fkt.-Nr. 3?
 bne.s    \f4             ; nein
 bclr     #1,(a4)         ; Blinkmodus ausschalten
 bra.s    \zurck
\f4:
 cmpi.w   #4,d1           ; Fkt.-Nr. 4?
 bne.s    \f5             ; nein
 move.w   6(a7),2(a4)     ; Blinkrate setzen
 move.w   6(a7),4(a4)     ; Zhler initialisieren
 bra.s    \zurck
\f5:
 cmpi.w   #5,d1           ; Fkt.-Nr. 5?
 bne.s    \zurck         ; nein, ignorieren
 clr.l    d0              ; d0.L wegen Wortoperation lschen
 move.w   2(a4),d0        ; Blinkrate holen
\zurck:
 move.l   d0,-(a7)        ; Rckgaberegister retten
 bsr      UPDATE_END      ; Cursor wieder freigeben
 move.l   (a7)+,d0        ; Register zurck
 rts


WRITE_ASC:                ; String ausgeben (ohne Steuerzeichen)
 move.l   4(a7),a6        ; ^Ausgabestring
 clr.l    -(a7)           ; Anzahl ausgegebener Zeichen: 0
\lp:
 move.b   (a6)+,d0        ; auszugebendes Byte holen
 beq.s    \ende           ; falls 0: fertig
 addq.l   #1,(a7)         ; sonst Zhler++
 bsr.s    ASC_ENTRY       ; und Zeichen ausgeben
 bra.s    \lp             ; bis String-Ende
\ende:
 move.l   (a7)+,d0        ; Anzahl Zeichen zurckgeben
 rts

ASC_OUT:                  ; DIREKTE ZEICHENAUSGABE (0x00-0xFF)
 move.w   4(a7),d0        ; Zeichen holen
ASC_ENTRY:
 andi.w   #$FF,d0         ; nur Byte beachten
 bra      PUT             ; und ausgeben


WRITE:                    ; String ausgeben (mit Steuerzeichen)
; bra.s    WRITE_ASC       ; !!! fr reine ASCII-Ausgabe ohne ESCapes !!!
 move.l   4(a7),a6        ; ^Ausgabestring
 clr.l    -(a7)           ; Anzahl ausgegebener Zeichen: 0
\lp:
 move.b   (a6)+,d1        ; auszugebendes Byte holen
 bne.s    \aus            ; ausgeben, falls<>0
 lea      TCB+9,a0        ; ^Grafik-Flag
 tst.b    (a0)            ; Grafik eingeschaltet?
 beq.s    \ende           ; nein, fertig
\aus:
 addq.l   #1,(a7)         ; sonst Zhler++ und
 move.b   d1,d0           ; Zeichen
 bsr.s    CON_ENTRY       ; ausgeben
 bra.s    \lp             ; bis String-Ende
\ende:
 move.l   (a7)+,d0        ; Anzahl Zeichen zurckgeben
 rts

CON_OUT:                  ; AUSGABE MIT STEUERZEICHEN
 move.w   4(a7),d0        ; Zeichen holen
CON_ENTRY:
; bra.s    ASC_ENTRY       ; !!! fr reine ASCII-Ausgabe ohne ESCapes !!!
 andi.w   #$FF,d0         ; LSB isolieren
 lea      VEC_BASE,a1     ; ^Vektor
 move.l   (a1),a0         ; Vektor holen
 jmp      (a0)            ; und anspringen


STD_VEC:
 cmpi.w   #" ",d0         ; Zeichen < Blank?
 bpl      PUT             ; nein, ausgeben
 cmpi.w   #$1B,d0         ; ESC?
 bne.s    \control        ; nein
 lea      ESC_SEQ,a0      ; ^ESC-Handler
 move.l   a0,(a1)         ; als Vektor fr nchstes Zeichen merken
\return:
 clr.l    d0              ; "kein Fehler aufgetreten"
 rts                      ; fertig
\control:
 subq.w   #7,d0           ; <7?
 bmi.s    \return         ; wenn ja, dann nicht beachten
 cmpi.w   #7,d0           ; >13?
 bpl.s    \return         ; ja: Ausgabe unterdrcken
 lea      BEL,a1          ; ^dingelingeling
 add.w    d0,d0           ; Zeichenoffset in Word-Pointer umwandeln
 move.w   CTRL(PC,d0.w),a2; entsprechenden Vektor
 add.l    a1,a2           ; +Offset 1. Routine
 lea      TCB,a0          ; ^TerminalControlBlock
 bsr.s    UPDATE_CRS      ; Cursor abschalten
 jsr      (a2)            ; ausfhren
 bra.s    UPDATE_END      ; Cursor wieder einschalten


CTRL:     dc.w  0         ; Glocke
          dc.w  BS-BEL    ; Backspace
          dc.w  TAB-BEL   ; Tabulator
          dc.w  LF-BEL    ; Zeilenvorschub
          dc.w  LF-BEL    ; Vertikaltabulator (wie Zeilenvorschub)
          dc.w  LF-BEL    ; Formularvorschub  (        -"-       )
          dc.w  CR-BEL    ; Wagenrcklauf


UPDATE_CRS:
 lea      CCB,a4          ; ^CursorControlBlock
 bclr     #0,(a4)         ; disable Cursor
 btst     #2,(a4)         ; Cursor sichtbar?
 beq.s    \return         ; nein
 bra      CUR_INV         ; sonst Cursorposition invertieren
\return:
 rts

UPDATE_END:
 lea      TCB,a0          ; ^TerminalControlBlock
 move.l   LOGBASE,a1      ; ^Video-RAM
 move.w   38(a0),d0       ; Bytes/Textzeile
 mulu     2(a0),d0        ; * akt. Zeile
 adda.l   d0,a1           ; + Bildschirm-Anfang
 adda.w   (a0),a1         ; + akt. Spalte
 move.l   a1,6(a4)        ; = abs. Cursorposition
 bset     #0,(a4)         ; enable Cursor 
 move.l   LINE_A,a2       ; ^LINE_A-Block
 move.l   (a0),-28(a2)    ; Zeile und Spalte in VDI-Block bertragen
 clr.l    d0              ; "kein Fehler aufgetreten"
 rts


ESC_SEQ:                  ; Esc-Sequenz verarbeiten; Einsprung mit:
                          ; d0.w = Steuerzeichen; a1 = ^VEC_BASE
 lea      VEC_BASE,a1     ; Ausgabe-Vektor
 lea      STD_VEC,a0      ; wieder auf die normale Ausgabe biegen
 move.l   a0,(a1)         ; umschalten
 subi.w   #"A",d0         ; Offset abziehen
 bmi.s    \esc_fail       ; zu klein, ungltig
 cmpi.w   #"Z"-"A",d0     ; <="Z"?
 ble.s    \esc_big        ; ja, entsprechende Routine ausfhren
 bra.s    \esc_sml        ; sonst auf Kleinbuchstaben testen
\esc_fail:
 clr.l    d0              ; "kein Fehler aufgetreten"
 rts
\esc_big:
 bsr.s    UPDATE_CRS      ; Cursor ausschalten
 lea      CRS_UP,a1       ; Adresse der 1. Routine
 add.w    d0,d0           ; Zeichen als Wort-Offset
 lea      E_BIG,a2        ; Adress-Tabelle
 move.w   0(a2,d0.w),a2   ; Adress-Offset holen
 adda.l   a1,a2           ; + 1. Routine
 lea      TCB,a0          ; ^TerminalControlBlock
 jsr      (a2)            ; Routine ausfhren
 bsr.s    UPDATE_END      ; Cursor wieder ein
 rts                      ; fertig
\esc_sml:
 subi.w   #"a"-"A",d0     ; Offset fr Kleinbuchstaben abziehen
 bmi.s    \esc_fail       ; <"a", ignorieren
 cmpi.w   #"z"-"a",d0     ; >"z"?
 bgt.s    \esc_fail       ; ja, ignorieren
 bsr      UPDATE_CRS      ; Cursor ausschalten
 lea      SET_COLOR,a1    ; Adresse der 1. Routine
 add.w    d0,d0           ; Zeichen als Wort-Offset
 lea      E_SML,a2        ; ^Adress-Tabelle
 move.w   0(a2,d0.w),a2   ; Adress-Offset holen
 adda.l   a1,a2           ; + 1. Routine
 lea      TCB,a0          ; ^TerminalControlBlock
 jsr      (a2)            ; Routine ausfhren
 bsr      UPDATE_END      ; Cursor einschalten
 rts                      ; fertig


PUT:                      ; Zeichen in d0.w ausgeben
                          ; (verndert: a0-a4/d0-d3)
 lea      CCB,a4          ; ^Cursor-Controlblock
 bclr     #0,(a4)         ; disable Cursor
 bclr     #2,(a4)         ; Cursorposition nicht invertiert
 lea      TCB,a0          ; ^TerminalControlBlock
 move.l   32(a0),a1       ; ^aktuelle Fontdaten
 lea      \wr_16,a3       ; (16 Scan-Zeilen ausgeben)
 cmp.l    24(a0),a1       ; aktueller Font=8x16?
 beq.s    \write          ; ja
 lea      \wr_end,a3      ; sonst nur 8 Scan-Zeilen ausgeben
\write:
 adda.w   d0,a1           ; Offset addieren
 move.l   6(a4),a2        ; abs. Cursorposition
 move.b   (a1),(a2)+      ; Scan-Zeilen bertragen; Spalte ++
 move.b   01*256(a1),01*80-1(a2)
 move.b   02*256(a1),02*80-1(a2)
 move.b   03*256(a1),03*80-1(a2)
 move.b   04*256(a1),04*80-1(a2)
 move.b   05*256(a1),05*80-1(a2)
 move.b   06*256(a1),06*80-1(a2)
 move.b   07*256(a1),07*80-1(a2) ; letzte Scan-Zeile 8x8
 jmp      (a3)                   ; Je nachdem, ob 8x8 oder 8x16-Font gewhlt
\wr_16:                          ; ist, \wr_end oder \wr_16 anspringen
 move.b   08*256(a1),08*80-1(a2)
 move.b   09*256(a1),09*80-1(a2)
 move.b   10*256(a1),10*80-1(a2)
 move.b   11*256(a1),11*80-1(a2)
 move.b   12*256(a1),12*80-1(a2)
 move.b   13*256(a1),13*80-1(a2)
 move.b   14*256(a1),14*80-1(a2)
 move.b   15*256(a1),15*80-1(a2) ; letzte Scan-Zeile 8x16
\wr_end:
 btst     #2,8(a0)        ; Unterstrich ein?
 beq.s    \half           ; nein
 moveq    #80,d1          ; Bytes/Pixelzeile
 mulu     36(a0),d1       ; *Zeichenhhe in Pixel
 st       -81(a2,d1.w)    ; letzte Scan-Zeile unterstreichen
\half:
 btst     #3,8(a0)        ; halbe Helligkeit ein?
 beq.s    \inv            ; nein
 bsr      LIGHTMASK       ; sonst maskieren
\inv:
 btst     #0,8(a0)        ; inverse Darstellung?
 beq.s    \inc_col        ; nein
 bsr      CUR_INV         ; sonst invertieren
 bchg     #2,(a4)         ; alten Cursor-Status restaurieren
\inc_col:
 moveq    #80,d1          ; Bytes/Pixelzeile
 move.l   a2,6(a4)        ; abs. Cursorposition++
 addq.w   #1,(a0)         ; Spalte inkrementieren
 cmp.w    (a0),d1         ; letzte Spalte erreicht?
 bgt.s    \return         ; nein, fertig
 btst     #1,8(a0)        ; wrap eingeschaltet?
 bne.s    \wrap           ; ja
 subq.w   #1,(a0)         ; sonst letzte Spalte
 subq.l   #1,6(a4)        ; und abs. Cursorposition beibehalten
 bra.s    \return         ; Ende
\wrap:
 clr.w    (a0)            ; Spalte 0
 move.w   38(a0),d3       ; Bytes/Textzeile
 ext.l    d3              ; auf Langwort bringen
 add.l    d3,6(a4)        ; + abs. Cursorposition
 sub.l    d1,6(a4)        ; - 1 Pixelzeile = neue Position
 addq.w   #1,2(a0)        ; Zeile ++
 move.w   6(a0),d2        ; letzte Zeile
 cmp.w    2(a0),d2        ; berschritten?
 bpl.s    \return         ; nein, fertig
 subq.w   #1,2(a0)        ; sonst letzte Zeile beibehalten
 sub.l    d3,6(a4)        ; ebenso abs. Position
 bsr      SCROLL_UP       ; alles 1 Zeile hochschieben
 bsr      DEL_LINE        ; und letzte Zeile lschen
\return:
 bset     #0,(a4)         ; enable Cursor 
 move.l   LINE_A,a2       ; ^LINE_A-Block
 move.l   (a0),-28(a2)    ; Zeile und Spalte in VDI-Block bertragen
 clr.l    d0              ; "kein Fehler"
 rts                      ; tschau

CUR_INV:                  ; Cursorposition invertieren
                          ; (verndert: d1/a1-a2/a4)
 move.l   a2,-(a7)        ; Register retten
 lea      TCB,a0          ; ^TerminalControlBlock
 lea      CCB,a4          ; ^CursorControlBlock
 move.l   6(a4),a1        ; abs. Cursor-Adresse
 lea      \inv_end,a2     ; 8*8 annehmen
 move.w   36(a0),d1       ; Zeichenhhe
 subq.w   #8,d1           ; -Offset fr 8*8
 beq.s    \inv            ; ok, 8*8-Font
 lea      \inv_16,a2      ; sonst 16 Bytes NOTten
\inv:
 not.b    (a1)
 not.b    0080(a1)
 not.b    0160(a1)
 not.b    0240(a1)
 not.b    0320(a1)
 not.b    0400(a1)
 not.b    0480(a1)
 not.b    0560(a1)
 jmp      (a2)
\inv_16:
 not.b    0640(a1)
 not.b    0720(a1)
 not.b    0800(a1)
 not.b    0880(a1)
 not.b    0960(a1)
 not.b    1040(a1)
 not.b    1120(a1)
 not.b    1200(a1)
\inv_end:
 bchg     #2,(a4)         ; Cursorposition invertiert
 move.l   (a7)+,a2        ; Register zurck
 rts

LIGHTMASK:                ; Zeichen unter Cursor halbhell darstellen
 movem.l  d3/d4/a2,-(a7)  ; Register retten
 lea      TCB,a0          ; ^TerminalControlBlock
 lea      CCB,a4          ; ^CursorControlBlock
 move.w   #$AA,d3         ; Bitmaske fr gerade Pixelzeilen
 moveq    #$55,d4         ; Bitmaske fr ungerade Pixelzeilen
 move.l   6(a4),a1        ; abs. Cursor-Adresse
 lea      \light_end,a2   ; 8*8 annehmen
 move.w   36(a0),d1       ; Zeichenhhe
 subq.w   #8,d1           ; -Offset fr 8*8
 beq.s    \light          ; ok, 8*8-Font
 lea      \light_16,a2    ; sonst 16 Bytes maskieren
\light:
 and.b    d3,(a1)
 and.b    d4,0080(a1)
 and.b    d3,0160(a1)
 and.b    d4,0240(a1)
 and.b    d3,0320(a1)
 and.b    d4,0400(a1)
 and.b    d3,0480(a1)
 and.b    d4,0560(a1)
 jmp      (a2)
\light_16:
 and.b    d3,0640(a1)
 and.b    d4,0720(a1)
 and.b    d3,0800(a1)
 and.b    d4,0880(a1)
 and.b    d3,0960(a1)
 and.b    d4,1040(a1)
 and.b    d3,1120(a1)
 and.b    d4,1200(a1)
\light_end:
 movem.l  (a7)+,d3/d4/a2  ; Register zurck
 rts

DEL_SCRUP:                ; ESC 'M'
 move.w   6(a0),d1        ; max. Zeile
 sub.w    2(a0),d1        ; -akt. Zeile=Anzahl zu scrollender Zeilen
 beq.s    \del            ; schon in letzter Zeile, nur noch lschen
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; -akt. Spalte=^Zeilenanfang
 bsr.s    SCR_UP_ENTRY    ; hochscrollen
\del:
 move.w   6(a0),d3        ; letzte Zeile
 bra      DEL_ENTRY       ; lschen und zurckkehren

SCROLL_UP:                ; Bildschirminhalt incl. der akt. Zeile
                          ; um eine Zeile nach oben schieben
 move.l   LOGBASE,a1      ; ^Video-RAM
 move.w   2(a0),d1        ; aktuelle Zeile
 beq      SCR_UP_END      ; nicht scrollen, falls schon oben
SCR_UP_ENTRY:             ; Einsprung fr ESC 'M'
 subq.w   #1,d1           ; d1 in dbra-Zhler wandeln
 move.w   38(a0),d0       ; Bytes/Textzeile
 move.w   36(a0),d2       ; Zeichenhhe
 lsr.w    #2,d2           ; div 4 (es werden immer 4 Pixelzeilen verschoben)
 subq.w   #1,d2           ; in dbra-Zhler wandeln
 move.l   a1,a2           ; Zieladresse (a1)
 adda.w   d0,a2           ; + Bytes/Textzeile = Quelladresse (a2)
 movem.l  a0/a4/a6,-(a7)  ; Register retten
\scr_lns:                 ; d1+1 Zeilen nach oben scrollen
 move.w   d2,d0           ; Zeichenhhe/4-1
\scr_ln:                  ; 1 Textzeile nach oben scrollen
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,40(a1) ; 4 komplette Pixelzeilen verschieben
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,80(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,120(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,160(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,200(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,240(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,280(a1)
 adda.w   #320,a1
 dbra     d0,\scr_ln      ; die nchsten 4 Pixelzeilen verschieben
 dbra     d1,\scr_lns     ; nchste Textzeile
 movem.l  (a7)+,a0/a4/a6  ; Register zurck
SCR_UP_END:
 rts

INS_SCRDN:                ; ESC 'L'
 bsr.s    SCROLL_DOWN     ; Zeile einfgen
 bra      DEL_LINE        ; und lschen

DEL_SCRDN:                ; ESC 't'
 move.w   2(a0),d1        ; akt. Zeile
 beq.s    \del            ; schon oben, nur noch lschen
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; -akt. Spalte=^Zeilenanfang
 adda.w   38(a0),a1       ; +Bytes/Textzeile (1 Textzeile tiefer)
 suba.w   #80,a1          ; -80 Bytes (1 Pixelzeile hher)
 bsr.s    SCR_DN_ENTRY    ; runterscrollen
\del:
 clr.w    d3              ; oberste Zeile (0)
 bra      DEL_ENTRY       ; lschen und zurckkehren

SCROLL_DOWN:              ; Bildschirminhalt incl. der akt. Zeile
                          ; um eine Zeile nach unten schieben
 move.l   LOGBASE,a1      ; ^Video-RAM
 adda.l   #32000-80,a1    ; ^letzte Pixel-Zeile
 move.w   6(a0),d1        ; max. Zeile
 sub.w    2(a0),d1        ; -aktuelle=Anzahl zu scrollender Zeilen
 beq      SCR_DN_END      ; nicht scrollen, falls schon unten
SCR_DN_ENTRY:             ; Einsprung fr ESC 't'
 subq.w   #1,d1           ; sonst in dbra-Zhler wandeln
 move.w   38(a0),d0       ; Anzahl Bytes/Textzeile = Offset
 move.w   36(a0),d2       ; Zeichenhhe
 lsr.w    #2,d2           ; div 4 (es werden immer 4 Pixelzeilen verschoben)
 subq.w   #1,d2           ; in dbra-Zhler wandeln
 move.l   a1,a2           ; Zieladresse (a1)
 suba.w   d0,a2           ; - Offset = Quelladresse (a2)
 movem.l  a0/a4/a6,-(a7)  ; Register retten
\scr_lns:                 ; d1+1 Zeilen nach unten scrollen
 move.w   d2,d0           ; Zeichenhhe/4-1
\scr_ln:                  ; 1 Textzeile nach unten scrollen
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,(a1)
 movem.l  (a2),REGISTER
 movem.l  REGISTER,40(a1) ; 4 komplette Pixelzeilen verschieben
 suba.w   #120,a2
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,-80(a1)
 movem.l  (a2),REGISTER
 movem.l  REGISTER,-40(a1)
 suba.w   #120,a2
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,-160(a1)
 movem.l  (a2),REGISTER
 movem.l  REGISTER,-120(a1)
 suba.w   #120,a2
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,-240(a1)
 movem.l  (a2),REGISTER
 movem.l  REGISTER,-200(a1)
 suba.w   #120,a2
 suba.w   #320,a1
 dbra     d0,\scr_ln      ; die nchsten 4 Pixelzeilen verschieben
 dbra     d1,\scr_lns     ; nchste Textzeile
 movem.l  (a7)+,a0/a4/a6  ; Register zurck
SCR_DN_END:
 rts

DEL_LINE:                 ; akt. Zeile lschen, Cursor auf Spalte 0
 move.w   2(a0),d3        ; akt. Zeile
DEL_ENTRY:                ; Einsprung fr Lschen beliebiger Zeilen
 move.l   LOGBASE,a1      ; ^Video-RAM
 addq.w   #1,d3           ; ++
 move.w   38(a0),d1       ; Bytes/Textzeile
 mulu     d3,d1           ; (akt. Zeile+1)*(Bytes/Textzeile)
 adda.l   d1,a1           ; = Bildschirm-Offset
 move.w   36(a0),d2       ; Zeichenhhe
 lsr.w    #2,d2           ; div 4 (es werden immer 4 Pixelzeilen gelscht)
 subq.w   #1,d2           ; in dbra-Zhler wandeln
 movem.l  a0/a4/a6,-(a7)  ; Register retten
 movem.w  ZEROES,REGISTER ; Register lschen
\lp:
 movem.l  REGISTER,-(a1)  ; 4 komplette Pixelzeilen lschen
 movem.l  REGISTER,-(a1)
 movem.l  REGISTER,-(a1)
 movem.l  REGISTER,-(a1)
 movem.l  REGISTER,-(a1)
 movem.l  REGISTER,-(a1)
 movem.l  REGISTER,-(a1)
 movem.l  REGISTER,-(a1)
 dbra     d2,\lp          ; nchste Pixelzeile
 movem.l  (a7)+,a0/a4/a6  ; Register zurck
 clr.w    (a0)            ; Cursor in Spalte 0
 rts                      ; fertig


BEL:                      ; Control G (bingggg!)
 suba.l   a5,a5           ; A5 lschen
 move.l   BEL_ADR,-(a7)   ; Original TOS-Routine
 rts                      ; anspringen

CRS_LEFT:                 ; ESC 'C' (=Backspace BS)
BS:
 tst.w    (a0)            ; Spalte 0?
 beq.s    \zurck         ; ja, BS nicht mglich
 subq.w   #1,(a0)         ; sonst Spalte--
\zurck:
 rts                      ; das war's

CALC_POS:                 ; nchste Tab-Position berechnen
 clr.l    d7              ; Default-Rckgabewert: Kein Fehler
 move.w   d0,d1           ; Spalte retten fr Byte-Offset
 move.w   d0,d2           ; nochmal retten fr Bit-Offset
 moveq    #7,d3           ; Bit-Zhler initialisieren
 lsr.w    #3,d1           ; Byteoffset berechnen (Spalte div 8)
 and.w    d3,d2           ; Divisionsrest (Spalte mod 8)
 sub.w    d2,d3           ; von 7 subtrahiert = Bit-Offset
\bit_lp:
 btst     d3,0(a1,d1.w)   ; Tab gesetzt?
 beq.s    \weiter         ; nein
 rts                      ; sonst zurck
\weiter:
 addq.w   #1,d0           ; Spalte ++
 dbra     d3,\bit_lp      ; und weitersuchen
\byte_lp:
 addq.w   #1,d1           ; nchstes Byte des Tabulatoren-Bit-Vektors
 cmpi.w   #10,d1          ; schon letztes Byte berschritten?
 bge.s    \fail           ; ja, mit Fehler zurck
 tst.b    0(a1,d1.w)      ; gibt's hier'n Tab?
 bne.s    \s_next         ; yeah!
 addq.w   #8,d0           ; sonst Spalte += 8 (!@$%"?C-Syntax!)
 bra.s    \byte_lp        ; und nchstes Byte untersuchen
\s_next:
 moveq    #7,d3           ; wieder beim MSB mit der
 bra.s    \bit_lp         ; Suche beginnen
\fail:
 moveq    #-1,d7          ; nicht fndig geworden...
 rts                      ; und tsch

TAB:
 lea      TABS,a1         ; ^TabulatorenBitVektor
 move.w   (a0),d0         ; akt. Spalte
 addq.w   #1,d0           ; ++
 cmpi.w   #80,d0          ; >=letzte?
 bge.s    \wrap           ; ja, auf Wrap testen
 bsr.s    CALC_POS        ; sonst nchsten Tab suchen
 tst.l    d7              ; gefunden?
 bmi.s    \wrap           ; n
 move.w   d0,(a0)         ; sonst Spalte setzen
\ende:
 rts                      ; und zurck
\wrap:
 btst     #1,8(a0)        ; Wrapping erlaubt?
 beq.s    \ende           ; nein, nichts ndern
 clr.w    d0              ; sonst ersten
 bsr.s    CALC_POS        ; Tabulator finden
 tst.l    d7              ; keiner da?
 bmi.s    \ende           ; letztendlich nicht, fertig
 move.w   d0,(a0)         ; sonst Spalte setzen und LF ausfhren

LF:
 move.w   2(a0),d0        ; akt. Zeile
 cmp.w    6(a0),d0        ; =letzte?
 bmi.s    \ok             ; nein
 bsr      SCROLL_UP       ; sonst scrollen
 move.w   (a0),-(a7)      ; akt. Spalte merken
 bsr      DEL_LINE        ; und letzte Zeile lschen
 move.w   (a7)+,(a0)      ; akt. Spalte zurck
 rts
\ok:
 addq.w   #1,2(a0)        ; Zeile++
 rts

CR:
 clr.w    (a0)            ; Cursor in Spalte 0 setzen
 rts                      ; fertig


CLS:                      ; Bildschirm lschen+Home
 movem.l  a0/a6,-(a7)     ; Register retten
 moveq    #49,d0          ; 50 mal 8 Pixelzeilen lschen
 move.l   LOGBASE,a6      ; ^Video-RAM
 adda.w   #32000,a6       ; +32000=Bildschirmende
CLS_ENTRY:                ; Entry point fr teilweises Lschen
 movem.w  ZEROES,d1-a2    ; 10 Register lschen
\lp:
 movem.l  d1-a2,-(a6)     ; 8 komplette Pixelzeilen lschen
 movem.l  d1-a2,-(a6)     ; (jeder movem-Befehl lscht 40 Bytes)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 movem.l  d1-a2,-(a6)
 dbra     d0,\lp          ; die nchste 10 Zeilen
 movem.l  (a7)+,a0/a6     ; Register zurck

HOME:                     ; Cursor nach 0,0
 clr.l    (a0)            ; Spalte/Zeile auf 0
 move.l   LINE_A,a2       ; ^LINE_A-Block
 clr.l    -28(a2)         ; Zeile und Spalte in VDI-Block bertragen
 rts           


E_BIG:                    ; Offset-Tabelle fr ESC "Grobuchstabe"
 dc.w 0                   ; A Cursor rauf
 dc.w CRS_DOWN-CRS_UP     ; B Cursor runter
 dc.w CRS_RIGHT-CRS_UP    ; C Cursor rechts
 dc.w CRS_LEFT-CRS_UP     ; D Cursor links
 dc.w CLS-CRS_UP          ; E Bildschirm lschen
 dc.w BIG_FONT-CRS_UP     ; F 8x16-Font aktivieren
 dc.w SML_FONT-CRS_UP     ; G 8x8-Font aktivieren
 dc.w HOME-CRS_UP         ; H Home
 dc.w CRS_UP_SCR-CRS_UP   ; I Cursor rauf (Scrollen, falls in Zeile 0)
 dc.w DEL_FROM_CRS-CRS_UP ; J Lschen ab Cursor bis Bildschirm-Ende
 dc.w L_TO_END-CRS_UP     ; K Lschen ab Cursor bis Zeilenende
 dc.w INS_SCRDN-CRS_UP    ; L Zeile einfgen, Rest runterschieben
 dc.w DEL_SCRUP-CRS_UP    ; M Zeile lschen, Rest hochscrollen
 dc.w DEF_TABS-CRS_UP     ; N Tabulatoren an jede 8. Spalte setzen
 dc.w CLR_TABS-CRS_UP     ; O alle Tabulatoren lschen (Tabula rasa)
 dc.w SET_TAB-CRS_UP      ; P Tabulator setzen
 dc.w CLR_TAB-CRS_UP      ; Q Tabulator lschen
 dc.w LIGHT_ON-CRS_UP     ; R halbe Helligkeit einschalten
 dc.w LIGHT_OFF-CRS_UP    ; S volle Helligkeit einschalten
 dc.w FSCR_LEFT-CRS_UP    ; T akt. Zeile um 1 Pixel nach links scrollen
 dc.w FSCR_RIGHT-CRS_UP   ; U akt. Zeile um 1 Pixel nach rechts scrollen
 dc.w FSCRDN-CRS_UP       ; V incl. akt. Zeile pixelweise nach unten scrollen
 dc.w FDSCRUP-CRS_UP      ; W akt. Zeile lschen, Rest pixelweise hochscrollen
 dc.w FSCRUP-CRS_UP       ; X incl. akt. Zeile pixelweise nach oben scrollen
 dc.w DIR_CRS-CRS_UP      ; Y Cursor positionieren (Zeile, Spalte)
 dc.w FDSCRDN-CRS_UP      ; Z akt. Zeile lschen, Rest pixelweise runter


E_SML:                    ; Offset-Tabelle fr ESC "Kleinbuchstabe"
 dc.w CRS_ON_T-SET_COLOR  ; a Cursor einschalten, falls ESC 'f'-Zhler=0
 dc.w 0                   ; b Vordergrundfarbe setzen
 dc.w 0                   ; c Hintergrundfarbe setzen
 dc.w DEL_TO_CRS-SET_COLOR; d von Bildschirmanfang bis incl. Cursor lschen
 dc.w CRS_ON-SET_COLOR    ; e Cursor einschalten, ESC 'f'-Zhler lschen
 dc.w CRS_OFF-SET_COLOR   ; f Cursor ausschalten
 dc.w GET_TCB-SET_COLOR   ; g Pointer auf TerminalControlBlock holen
 dc.w GET_CCB-SET_COLOR   ; h Pointer auf CursorControlBlock holen
 dc.w RESETCO-SET_COLOR   ; i Terminal initialisieren
 dc.w SAVE_CRS-SET_COLOR  ; j Cursorposition speichern
 dc.w REST_CRS-SET_COLOR  ; k Cursor an zuletzt gemerkte Stelle
 dc.w DEL_LINE-SET_COLOR  ; l Zeile lschen
 dc.w WHITE_BLK-SET_COLOR ; m weie Schrift auf schwarzem Grund
 dc.w BLK_WHITE-SET_COLOR ; n schwarze Schrift auf weiem Grund
 dc.w L_TO_CRS-SET_COLOR  ; o von Zeilenanfang bis incl. Cursor lschen
 dc.w INV_ON-SET_COLOR    ; p inverse Darstellung ein
 dc.w INV_OFF-SET_COLOR   ; q inverse Darstellung aus
 dc.w GRAPHMODE-SET_COLOR ; r Grafikmodus
 dc.w INS_SCRUP-SET_COLOR ; s Zeile einfgen, Rest hochschieben
 dc.w DEL_SCRDN-SET_COLOR ; t Zeile lschen, Rest runterschieben
 dc.w SCR_LEFT-SET_COLOR  ; u akt. Zeile um 1 Spalte nach links scrollen
 dc.w WRAP_ON-SET_COLOR   ; v automatischen Zeilenberlauf einschalten
 dc.w WRAP_OFF-SET_COLOR  ; w automatischen Zeilenberlauf ausschalten
 dc.w SCR_RIGHT-SET_COLOR ; x akt. Zeile um 1 Spalte nach rechts scrollen
 dc.w UNDER_ON-SET_COLOR  ; y Unterstrich ein
 dc.w UNDER_OFF-SET_COLOR ; z Unterstrich aus



CRS_ON_T:                 ; ESC 'a'
 tst.b    1(a4)           ; liegt kein ESC 'f'-Aufruf vor?
 beq.s    \ein            ; nein, einschalten
 subq.b   #1,1(a4)        ; sonst Anzahl der Aufrufe dekrementieren
 bne.s    \zurck         ; nur bei 0 einschalten
\ein:
 bset     #3,(a4)         ; Cursor einschalten
\zurck:
 rts

SET_COLOR:                ; ESC 'b'/'c' (nicht untersttzt)
 lea      VEC_BASE,a1     ; Vektor
 lea      SET_COLOR2,a2   ; auf Holen des Farbwertes
 move.l   a2,(a1)         ; umschalten
 rts
SET_COLOR2:
 lea      VEC_BASE,a1     ; Vektor wieder
 lea      STD_VEC,a2      ; auf normale Ausgabe
 move.l   a2,(a1)         ; umschalten
 rts

CRS_ON:                   ; ESC 'e'
 bset     #3,(a4)         ; Cursor einschalten
 clr.b    1(a4)           ; Anzahl CRS_OFF lschen
 rts

CRS_OFF:                  ; ESC 'f'
 bclr     #3,(a4)         ; Cursor ausschalten
 addq.b   #1,1(a4)        ; Anzahl der Aufrufe inkrementieren
 rts

INV_ON:                   ; ESC 'p'
 bset     #0,8(a0)        ; inverse Darstellung ein
 rts

INV_OFF:                  ; ESC 'q'
 bclr     #0,8(a0)        ; inverse Darstellung aus
 rts

WRAP_ON:                  ; ESC 'v'
 bset     #1,8(a0)        ; Wrapping einschalten
 rts

WRAP_OFF:                 ; ESC 'w'
 bclr     #1,8(a0)        ; Wrapping ausschalten
 rts

UNDER_ON:                 ; ESC 'y'
 bset     #2,8(a0)        ; Unterstrich einschalten
 rts

UNDER_OFF:                ; ESC 'z'
 bclr     #2,8(a0)        ; Unterstrich ausschalten
 rts

INS_SCRUP:                ; ESC 's'
 bsr      SCROLL_UP       ; Zeile einfgen, Rest hochschieben
 bsr      DEL_LINE        ; und neue Zeile lschen
 rts

SCR_LEFT:                 ; ESC 'u'
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; -akt. Spalte=^Zeilenanfang
 move.w   36(a0),d2       ; Zeichenhhe (Pixels)
 subq.w   #1,d2           ; in dbra-Zhler wandeln
\lp1:
 movea.l  a1,a2           ; a1=Ziel, a2=Quelle
 addq.w   #1,a2           ; Quelle=Ziel+1
 moveq    #12,d1          ; 13*6=78 Bytes verschieben
 move.b   (a1),d3         ; vorderstes Bytes merken
\lp2:
 move.b   (a2)+,(a1)+     ; 6 Bytes nach links verschieben
 move.b   (a2)+,(a1)+
 move.b   (a2)+,(a1)+
 move.b   (a2)+,(a1)+
 move.b   (a2)+,(a1)+
 move.b   (a2)+,(a1)+
 dbra     d1,\lp2
 move.b   (a2),(a1)+      ; Byte 78 verschieben
 move.b   d3,(a1)+        ; Anfangsbyte ans Ende (79) setzen
 dbra     d2,\lp1         ; nchste Pixelzeile verschieben
 rts

SCR_RIGHT:                ; ESC 'x'
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; -akt. Spalte=^Zeilenanfang
 adda.w   38(a0),a1       ; +Bytes/Textzeile=^Anfang nchster Textzeile
 move.w   36(a0),d2       ; Zeichenhhe (Pixels)
 subq.w   #1,d2           ; in dbra-Zhler wandeln
\lp1:
 movea.l  a1,a2           ; a1=Ziel, a2=Quelle
 subq.w   #1,a2           ; Quelle=Ziel-1
 moveq    #12,d1          ; 13*6=78 Bytes verschieben
 move.b   (a2),d3         ; letztes Bytes merken
\lp2:
 move.b   -(a2),-(a1)     ; 6 Bytes nach rechts verschieben
 move.b   -(a2),-(a1)
 move.b   -(a2),-(a1)
 move.b   -(a2),-(a1)
 move.b   -(a2),-(a1)
 move.b   -(a2),-(a1)
 dbra     d1,\lp2
 move.b   -(a2),-(a1)     ; Byte 78 verschieben
 move.b   d3,-(a1)        ; letztes Byte an den Anfang setzen
 dbra     d2,\lp1         ; nchste Pixelzeile verschieben
 rts

SAVE_CRS:                 ; ESC 'j'
 move.w   10(a0),d0       ; Anzahl gespeicherter Positionen
 cmpi.w   #3,d0           ; schon alle 3 besetzt?
 bne.s    \set            ; nein
 subq.w   #1,d0           ; sonst 1 abziehen
 subq.w   #1,10(a0)
 move.l   16(a0),12(a0)   ; neue Position 1=alte P. 2 (alte 1 geht verloren)
 move.l   20(a0),16(a0)   ; neue Position 2=alte P. 3
\set:
 lsl.w    #2,d0           ; Anzahl in Longpointer wandeln
 move.l   (a0),12(a0,d0.w); Spalte und Zeile merken
 addq.w   #1,10(a0)       ; Anzahl inkrementieren
 rts                      ; fertig

REST_CRS:                 ; ESC 'k'
 move.w   10(a0),d0       ; Anzahl gespeicherter Positionen
 beq.s    \zurck         ; fertig, falls 0
 subq.w   #1,d0           ; sonst Anzahl dekrementieren
 subq.w   #1,10(a0)
 lsl.w    #2,d0           ; und in Longpointer wandeln
 move.l   12(a0,d0.w),(a0); alte Position zurckholen
 move.w   6(a0),d0        ; grte Zeilennummer
 cmp.w    2(a0),d0        ; < aktueller? (wegen EVTL. Fontwechsel)
 bpl.s    \zurck         ; nein, alles ok
 move.w   d0,2(a0)        ; sonst in letzte Zeile positionieren
\zurck:
 rts

GET_TCB:                  ; ESC 'g'
 bsr      UPDATE_END      ; Cursor wieder freigeben
 move.l   a0,d0           ; d0:=^TerminalControlBlock
 addq.l   #4,a7           ; und direkt zum Trap-Handler zurckspringen
 rts                      ; (also nicht ber ESC_SEQ)

GET_CCB:                  ; ESC 'h'
 bsr      UPDATE_END      ; Cursor wieder freigeben
 move.l   a4,d0           ; d0:=^CursorControlBlock
 addq.l   #4,a7           ; und direkt zum Trap-Handler zurckspringen
 rts                      ; (also nicht ber ESC_SEQ)

WHITE_BLK:                ; ESC 'm'
 clr.w    VID_R0          ; inverse Darstellung (wei auf schwarz)
 rts

BLK_WHITE:                ; ESC 'n'
 move.w   #1,VID_R0       ; normale Darstellung (schwarz auf wei)
 rts

DEL_TO_CRS:               ; ESC 'd'
 move.w   2(a0),d0        ; akt. Zeile
 beq.s    L_TO_CRS        ; falls in Zeile 0, nur noch bis Cursor lschen
 move.w   36(a0),d1       ; Zeichenhhe in Pixeln
 subq.w   #8,d1           ; - 8
 beq.s    \del            ; 8x8-Font aktiv?
 add.w    d0,d0           ; sonst doppelt so viele Zeilen lschen
\del:
 subq.w   #1,d0           ; Anzahl Zeilen in dbra-Zhler wandeln
 move.l   (a0),-(a7)      ; akt. Spalte und Zeile retten
 pea      \weiter         ; Rcksprungadresse merken
 movem.l  a0/a6,-(a7)     ; Register retten
 movea.l  6(a4),a6        ; abs. Cursorposition
 suba.w   (a0),a6         ; - akt. Spalte=^Zeilenanfang
 bra      CLS_ENTRY       ; Zeilen lschen
\weiter:
 move.l   (a7)+,(a0)      ; Spalte und Zeile zurck

L_TO_CRS:                 ; ESC 'o'
 move.w   (a0),d1         ; akt. Spalte
 move.w   d1,d2           ; merken
 moveq    #80,d3          ; Bytes/Pixelzeile
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   d1,a1           ; -akt. Spalte=Zeilenanfang
 movea.l  a1,a2           ; merken
 adda.l   d3,a2           ; und Offset fr nchste Pixelzeile addieren
 move.w   36(a0),d0       ; Zeichenhhe
 subq.w   #1,d0           ; in dbra-Zhler wandeln
\lp_pixz:
 clr.b    (a1)+           ; Byte lschen
 dbra     d1,\lp_pixz     ; nchstes Byte
 movea.l  a2,a1           ; Anfang der nchsten Pixelzeile
 adda.l   d3,a2           ; wieder Offset addieren
 move.w   d2,d1           ; Zhler wieder laden
 dbra     d0,\lp_pixz     ; und nchste Pixelzeile lschen
\zurck:
 rts

GRAPHMODE:                ; ESC 'r'
 lea      VEC_BASE,a1     ; Ausgabevektor
 lea      GET_WIDTH,a2    ; auf Holen der Grafikbreite
 move.l   a2,(a1)         ; umbiegen
 st       9(a0)           ; Grafikmodus einschalten
 rts
GET_WIDTH:                ; Grafikbreite fr ESC 'r' bestimmen
 lea      GET_HEIGHT_H,a2 ; Ausgabevektor auf Holen der Grafikhhe
 move.l   a2,(a1)         ; umbiegen
 lea      TCB,a0          ; ^TerminalControlBlock
 subi.w   #32,d0          ; Offset von Wert fr Breite abziehen
 move.w   d0,44(a0)       ; und merken
 moveq    #80,d1          ; max. Spalte
 sub.w    (a0),d1         ; -akt. Spalte
 move.w   d1,40(a0)       ; als erlaubte Breite bernehmen
 rts
GET_HEIGHT_H:             ; Grafikhhe, Hunderter
 lea      GET_HEIGHT_L,a2 ; Ausgabevektor auf Holen der Grafikhhe
 move.l   a2,(a1)         ; umbiegen
 lea      TCB+46,a0       ; Speicher fr Grafikhhe in Pixels
 subi.w   #32,d0          ; Offset vom Hhenwert abziehen
 mulu     #100,d0         ; mal 100
 move.w   d0,(a0)         ; merken
 rts
GET_HEIGHT_L:             ; Grafikhhe, Zehner+Einer
 lea      TCB,a0          ; ^TerminalControlBlock
 subi.w   #32,d0          ; Offset vom Hhenwert abziehen
 move.w   d0,d1           ; und zwischenspeichern
 andi.w   #$F,d1          ; Einer isolieren
 lsr.w    #4,d0           ; Zehner 
 andi.w   #$F,d0          ; isolieren
 mulu     #10,d0          ; mal 10
 add.w    d1,d0           ; + Einer
 add.w    d0,46(a0)       ; + Hunderter
 tst.w    44(a0)          ; Breite=0?
 bne.s    \weiter         ; nein
\fail:
 lea      STD_VEC,a2      ; sonst Ausgabe wieder auf Standard
 move.l   a2,(a1)         ; umbiegen
 rts
\weiter:
 tst.w    46(a0)          ; Hhe=0?
 beq.s    \fail           ; ja, abbrechen
 lea      GRAPHICS,a2     ; sonst Ausgabe auf Grafik
 move.l   a2,(a1)         ; stellen
 clr.l    48(a0)          ; Zhler initialisieren
 lea      CCB,a4          ; ^CursorControlBlock
 move.l   6(a4),52(a0)    ; abs. Cursorpos. als linken Offset merken
 move.w   #400,d1         ; max. Anzahl Pixelzeilen
 move.w   2(a0),d2        ; akt. Zeile
 mulu     36(a0),d2       ; * Zeichenhhe in Pixels
 sub.w    d2,d1           ; von max. Anzahl subtrahieren
 move.w   d1,42(a0)       ; = Anzahl erlaubter Pixelzeilen
 rts
GRAPHICS:                 ; Grafikausgabe
 lea      TCB,a0          ; ^TerminalControlBlock
 move.w   48(a0),d1       ; akt. hor. Position
 move.w   50(a0),d2       ; akt. Pixelzeile
 cmp.w    42(a0),d2       ; mit erlaubter Anzahl vergleichen
 bpl.s    \next           ; zu gro, nicht ausgeben
 cmp.w    40(a0),d1       ; hor. Pos. mit max. Position vergleichen
 bpl.s    \next           ; zu gro, nicht ausgeben
 move.l   52(a0),a2       ; linker Zeilenoffset
 move.b   d0,0(a2,d1.w)   ; Grafikbyte ausgeben
 btst     #0,8(a0)        ; Invertierung eingeschaltet?
 beq.s    \next           ; nein
 not.b    0(a2,d1.w)      ; sonst halt invertieren
\next:
 addq.w   #1,d1           ; hor. Position ++
 cmp.w    44(a0),d1       ; mit Breite vergleichen
 beq.s    \more           ; letzte Position schon erreicht
 move.w   d1,48(a0)       ; sonst merken
 rts                      ; fertig
\more:
 clr.w    48(a0)          ; wieder bei Position 0 anfangen
 addi.l   #80,52(a0)      ; Offset fr nchste Pixelzeile addieren
 move.w   50(a0),d1       ; akt. Pixelzeile
 addq.w   #1,d1           ; ++
 cmp.w    46(a0),d1       ; =Hhe der Grafik?
 beq.s    \fertig         ; ja, Grafikmodus beenden
 move.w   d1,50(a0)       ; sonst neue Position merken
 rts
\fertig:
 lea      STD_VEC,a2      ; Ausgabe wieder auf Standard
 move.l   a2,(a1)         ; umbiegen
 sf       9(a0)           ; und Grafik ausschalten
 rts



CRS_UP:                   ; ESC 'A'
 tst.w    2(a0)           ; Zeile 0?
 beq.s    \zurck         ; ja, ignorieren
 subq.w   #1,2(a0)        ; sonst --
\zurck:
 rts

CRS_DOWN:                 ; ESC 'B'
 move.w   2(a0),d0        ; akt. Zeile
 cmp.w    6(a0),d0        ; =letzte?
 bpl.s    \zurck         ; ja, ignorieren
 addq.w   #1,2(a0)        ; sonst ++
\zurck:
 rts

CRS_RIGHT:                ; ESC 'C'
 cmpi.w   #79,(a0)        ; letzte Spalte?
 bpl.s    \zurck         ; ja, ignorieren
 addq.w   #1,(a0)         ; sonst ++
\zurck:
 rts

CRS_UP_SCR:               ; ESC 'I'
 tst.w    2(a0)           ; Zeile 0?
 bne.s    \runter         ; nein
 move.w   (a0),-(a7)      ; akt. Spalte merken
 bsr      SCROLL_DOWN     ; sonst runterscrollen
 bsr      DEL_LINE        ; und Zeile lschen
 move.w   (a7)+,(a0)      ; akt. Spalte zurck
 bra.s    \zurck
\runter:
 subq.w   #1,2(a0)        ; Zeile --
\zurck:
 rts

BIG_FONT:                 ; ESC 'F'
 move.l   24(a0),d0       ; ^8x16-Fontdaten
 cmp.l    32(a0),d0       ; Font schon aktiv?
 beq.s    \zurck         ; ja, fertig
 move.l   d0,32(a0)       ; sonst als aktuellen Font bernehmen
 move.w   #24,6(a0)       ; max. Zeile=24
 move.l   #$100500,36(a0) ; Hhe=16 Pixel; Bytes/Textzeile=1280
 lsr      2(a0)           ; akt. Zeile halbieren
 clr.w    10(a0)          ; gemerkte Cursorpositionen lschen
\zurck:
 rts

SML_FONT:                 ; ESC 'G'
 move.l   28(a0),d0       ; ^8x8-Fontdaten
 cmp.l    32(a0),d0       ; Font schon aktiv?
 beq.s    \zurck         ; ja, fertig
 move.l   d0,32(a0)       ; sonst als aktuellen Font bernehmen
 move.w   #49,6(a0)       ; max. Zeile=49
 move.l   #$80280,36(a0)  ; Hhe=16 Pixel; Bytes/Textzeile=640
 lsl      2(a0)           ; akt. Zeile verdoppeln
 clr.w    10(a0)          ; gemerkte Cursorpositionen lschen
\zurck:
 rts

DEL_FROM_CRS:             ; ESC 'J'
 move.w   6(a0),d0        ; letzte Zeile
 sub.w    2(a0),d0        ; Cursor schon unten?
 beq.s    L_TO_END        ; ja, nur noch ab Cursor lschen
 move.w   36(a0),d1       ; Zeichenhhe in Pixeln
 subq.w   #8,d1           ; - 8
 beq.s    \del            ; 8x8-Font aktiv
 add.w    d0,d0           ; sonst doppelt so viele Zeilen lschen
\del:
 subq.w   #1,d0           ; in dbra-Zhler wandeln
 move.l   (a0),-(a7)      ; Spalte und Zeile retten
 pea      \weiter         ; Rcksprungadresse auf Stack
 movem.l  a0/a6,-(a7)     ; Register retten
 move.l   LOGBASE,a6      ; ^Video-RAM
 adda.w   #32000,a6       ; ^Bildschirm-Ende
 bra      CLS_ENTRY       ; Zeilen lschen
\weiter:
 move.l   (a7)+,(a0)      ; Spalte und Zeile zurck

L_TO_END:                 ; ESC 'K'
 moveq    #79,d1          ; max. Spalte
 sub.w    (a0),d1         ; -akt. Spalte=Anzahl zu lschender Zeichen
 move.w   d1,d2           ; merken
 moveq    #80,d3          ; Bytes/Pixelzeile
 move.l   6(a4),a1        ; abs. Cursorposition
 movea.l  a1,a2           ; merken
 adda.l   d3,a2           ; und Offset fr nchste Pixelzeile addieren
 move.w   36(a0),d0       ; Zeichenhhe
 subq.w   #1,d0           ; in dbra-Zhler wandeln
\lp_pixz:
 clr.b    (a1)+           ; Byte lschen
 dbra     d1,\lp_pixz     ; nchstes Byte
 movea.l  a2,a1           ; Anfang der nchsten Pixelzeile
 adda.l   d3,a2           ; wieder Offset addieren
 move.w   d2,d1           ; Zhler wieder laden
 dbra     d0,\lp_pixz     ; und nchste Pixelzeile lschen
\zurck:
 rts

DEF_TABS:                 ; ESC 'N'
 lea      TABS,a0         ; ^Bitvektor fr Tabulatoren
 move.l   #$80808080,d0   ; Bitmaske: Jede 8. Position
 move.l   d0,(a0)+        ; Tabulatoren setzen
 move.l   d0,(a0)+
 move.w   d0,(a0)
 rts

CLR_TABS:                 ; ESC 'O'
 lea      TABS,a0         ; Miami wei
 clr.l    (a0)+           ; Tabulatoren lschen
 clr.l    (a0)+
 clr.w    (a0)
 rts

SET_TAB:                  ; ESC 'P'
 lea      VEC_BASE,a1     ; Vektor
 lea      SGET_TAB,a2     ; zum Holen der Position
 move.l   a2,(a1)         ; umbiegen
 rts                      ; fertig
SGET_TAB:
 lea      VEC_BASE,a1     ; Vektor wieder
 lea      STD_VEC,a2      ; auf normale Ausgabe
 move.l   a2,(a1)         ; umschalten
 bsr.s    CALC_TAB        ; Tab-Position bestimmen
 bset     d2,0(a0,d0.w)   ; und Tab setzen
\zurck:
 rts

CLR_TAB:                  ; ESC 'Q'
 lea      VEC_BASE,a1     ; Vektor
 lea      CGET_TAB,a2     ; zum Holen der Position
 move.l   a2,(a1)         ; umbiegen
 rts                      ; fertig
CGET_TAB:
 lea      VEC_BASE,a1     ; Vektor wieder
 lea      STD_VEC,a2      ; auf normale Ausgabe
 move.l   a2,(a1)         ; umschalten
 bsr.s    CALC_TAB        ; Bitvektorposition berechnen
 bclr     d2,0(a0,d0.w)   ; und Tab lschen
\zurck:
 rts

CALC_TAB:                 ; Tabulatorposition berechnen
 subi.w   #32,d0          ; Offset von Tabulatorposition abziehen
 bmi.s    \fail           ; zu klein, ignorieren
 cmpi.w   #80,d0          ; grer als grte Spalte?
 bpl.s    \fail           ; ja, ignorieren
 lea      TABS,a0         ; ^Tab-Vektor
 ext.w    d0              ; Position auf Wortlnge bringen
 move.w   d0,d1           ; und retten
 asr.w    #3,d0           ; durch 8 dividieren
 moveq    #7,d2
 and.w    d2,d1           ; Rest isolieren
 sub.w    d1,d2           ; und Offset berechnen
 rts
\fail:
 addq.l   #4,a7           ; direkt zum Trap-Handler
 rts                      ; zurckspringen

LIGHT_ON:                 ; ESC 'R'
 bset     #3,8(a0)        ; halbe Helligkeit einschalten
 rts

LIGHT_OFF:                ; ESC 'S'
 bclr     #3,8(a0)        ; intensive Darstellung einschalten
 rts

FSCR_LEFT:                ; ESC 'T'
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; -akt. Spalte=^Zeilenanfang
 adda.w   38(a0),a1       ; +Bytes/Textzeile=^Anfang nchster Textzeile
 move.w   36(a0),d2       ; Zeichenhhe (Pixels)
 subq.w   #1,d2           ; in dbra-Zhler wandeln
\lp1:
 moveq    #3,d1           ; 4*10 Worte verschieben 
 move.w   #0,CCR          ; SR-Flags auf Null
 btst     #7,-80(a1)      ; Pixel ganz links gesetzt?
 beq.s    \lp2            ; nein
 move.w   #16,CCR         ; sonst X-Bit setzen
\lp2:
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 roxl     -(a1)
 dbra     d1,\lp2
 dbra     d2,\lp1         ; nchste Pixelzeile verschieben
 rts

FSCR_RIGHT:               ; ESC 'U'
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; -akt. Spalte=^Zeilenanfang
 move.w   36(a0),d2       ; Zeichenhhe (Pixels)
 subq.w   #1,d2           ; in dbra-Zhler wandeln
\lp1:
 moveq    #3,d1           ; 4*10 Worte verschieben 
 move.w   #0,CCR          ; SR-Flags auf Null
 btst     #0,79(a1)       ; Pixel ganz rechts gesetzt?
 beq.s    \lp2            ; nein
 move.w   #16,CCR         ; sonst X-Bit setzen
\lp2:
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 roxr     (a1)+
 dbra     d1,\lp2
 dbra     d2,\lp1         ; nchste Pixelzeile verschieben
 rts

FDSCRUP:                  ; ESC 'W'
 move.w   6(a0),d1        ; max. Zeile
 sub.w    2(a0),d1        ; - aktuelle
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; - akt. Spalte = ^Zeilenanfang
 bra.s    FSCRUP_ENTRY    ; schieben+lschen

FSCRUP:                   ; ESC 'X'; Bildschirminhalt incl. der akt. Zeile
                          ; um eine Zeile pixelweise nach oben schieben
 move.l   LOGBASE,a1      ; ^Video-RAM
 move.w   2(a0),d1        ; aktuelle Zeile
FSCRUP_ENTRY:             ; Einsprung fr ESC 'W'
 move.w   d1,d0           ; Zeile retten
 addq.w   #1,d0           ; plus 1 = Anzahl Textzeilen
 move.w   36(a0),d1       ; Zeichenhhe in Pixels
 mulu     d1,d0           ; Anzahl Textzeilen mal Zeichenhhe
 subq.w   #1,d0           ; 1 Zeile abziehen
 lsr.w    #1,d0           ; div 2 (es werden immer 2 Pixelzeilen verschoben)
 subq.w   #1,d0           ; in dbra-Zhler wandeln
 move.w   d0,d2           ; und merken
 subq.w   #1,d1           ; Zeichenhhe in dbra-Zhler wandeln 
 movem.l  a0/a4/a6,-(a7)  ; Register retten
 move.l   a1,-(a7)        ; Startadresse merken
\lp_scr:
 movea.l  (a7),a1         ; Ziel
 movea.l  a1,a2
 adda.w   #80,a2          ; Quelle liegt 1 Pixelzeile tiefer
 move.w   d2,d0           ; Anzahl zu scrollender Pixelzeilen-1
\scr_ln:                  ; Bildschirminhalt um 1 Pixel nach oben scrollen
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,40(a1) ; 2 Pixelzeilen verschieben
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,80(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,120(a1)
 adda.w   #160,a1
 dbra     d0,\scr_ln      ; die nchsten beiden Pixelzeilen verschieben
 movem.l  (a2)+,REGISTER  ; die letzte Pixelzeile verschieben
 movem.l  REGISTER,(a1)
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,40(a1)
 movem.w  ZEROES,REGISTER ; Register lschen
 movem.l  REGISTER,80(a1) ; und letzte Pixelzeile damit lschen
 movem.l  REGISTER,120(a1)
 dbra     d1,\lp_scr      ; Bildschirm erneut um 1 Pixel nach oben scrollen
 addq.l   #4,a7           ; Startadresse wegwerfen
 movem.l  (a7)+,a0/a4/a6  ; Register zurck
 rts

ZEROES:
 ds.l     5,0             ; 5 Null-Langworte zum Lschen der Register

FDSCRDN:                  ; ESC 'Z'
 move.w   2(a0),d1        ; akt. Zeile
 move.l   6(a4),a1        ; abs. Cursorposition
 suba.w   (a0),a1         ; ^Anfang der Textzeile
 adda.w   38(a0),a1       ; ^Anfang der nchsten Textzeile
 suba.w   #80,a1          ; ^Anfang der letzen Pixelzeile der Textzeile (Puh!)
 bra.s    FSCRDN_ENTRY    ; schieben+lschen

FSCRDN:                   ; ESC 'V'; Bildschirminhalt incl. der akt. Zeile
                          ; um eine Zeile pixelweise nach unten schieben
 move.l   LOGBASE,a1      ; ^Video-RAM
 adda.l   #32000-80,a1    ; ^letzte Pixel-Zeile
 move.w   6(a0),d1        ; max. Zeile
 sub.w    2(a0),d1        ; -aktuelle Zeile = Anzahl zu scrollender Zeilen-1
FSCRDN_ENTRY:             ; Einsprung fr ESC 'Z'
 addq.w   #1,d1           ; +1=Anzahl zu scrollender Textzeilen
 move.w   d1,d0           ; Anzahl Zeilen retten
 move.w   36(a0),d1       ; Zeichenhhe in Pixels
 mulu     d1,d0           ; mal Anzahl Textzeilen
 subq.w   #1,d0           ; minus 1 Pixelzeile
 lsr.w    #1,d0           ; div 2 (es werden immer 2 Pixelzeilen verschoben)
 subq.w   #1,d0           ; in dbra-Zhler wandeln
 move.w   d0,d2           ; und merken
 subq.w   #1,d1           ; Zeichenhhe in dbra-Zhler wandeln
 movem.l  a0/a4/a6,-(a7)  ; Register retten
 move.l   a1,-(a7)        ; Startadresse merken
\lp_scr:
 movea.l  (a7),a1         ; Ziel
 movea.l  a1,a2
 suba.w   #80,a2          ; Quelle liegt 1 Pixelzeile hher
 move.w   d2,d0           ; Anzahl zu scrollender Pixelzeilen-1
\scr_ln:                  ; Bildschirminhalt um 1 Pixel nach unten scrollen
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,(a1)
 movem.l  (a2),REGISTER
 movem.l  REGISTER,40(a1) ; 2 Pixelzeilen verschieben
 suba.w   #120,a2
 movem.l  (a2)+,REGISTER
 movem.l  REGISTER,-80(a1)
 movem.l  (a2),REGISTER
 movem.l  REGISTER,-40(a1)
 suba.w   #120,a2
 suba.w   #160,a1
 dbra     d0,\scr_ln      ; die nchsten beiden Pixelzeilen verschieben
 movem.l  (a2)+,REGISTER  ; die letzte Pixelzeile verschieben
 movem.l  REGISTER,(a1)
 movem.l  (a2),REGISTER
 movem.l  REGISTER,40(a1)
 movem.w  ZEROES,REGISTER ; Register lschen
 movem.l  REGISTER,-80(a1); und letzte Pixelzeile damit lschen
 movem.l  REGISTER,-40(a1)
 dbra     d1,\lp_scr      ; nchste Textzeile
 addq.l   #4,a7           ; Startadresse wegwerfen
 movem.l  (a7)+,a0/a4/a6  ; Register zurck
 rts

DIR_CRS:                  ; ESC 'Y'
 lea      VEC_BASE,a1     ; Vektor auf Holen
 lea      ESC_Y_X,a0      ; der Zeile
 move.l   a0,(a1)         ; umbiegen
 clr.l    d0              ; "kein Fehler aufgetreten"
 rts                      ; fertig
ESC_Y_X:
 lea      TCB,a0          ; ^TerminalControlBlock
 lea      VEC_BASE,a1     ; Vektor
 lea      ESC_Y_Y,a2      ; auf Y-Angabe
 move.l   a2,(a1)         ; umschalten
 subi.w   #32,d0          ; Offset abziehen
 bmi.s    \zurck         ; zu klein, ignorieren
 cmp.w    6(a0),d0        ; grer als grte Zeile?
 bgt.s    \zurck         ; ja, ignorieren
 move.w   d0,2(a0)        ; sonst Zeile setzen
\zurck:
 clr.l    d0              ; "kein Fehler aufgetreten"
 rts                      ; fertig
ESC_Y_Y:
 lea      TCB,a0          ; ^TerminalControlBlock
 lea      VEC_BASE,a1     ; Vektor wieder
 lea      STD_VEC,a2      ; auf normale Ausgabe
 move.l   a2,(a1)         ; umschalten
 bsr      UPDATE_CRS      ; Cursor ausschalten
 subi.w   #32,d0          ; Offset von Spaltenwert abziehen
 bmi.s    \zurck         ; zu klein, ignorieren
 cmpi.w   #80,d0          ; grer als grte Spalte?
 bpl.s    \zurck         ; ja, ignorieren
 move.w   d0,(a0)         ; sonst Spalte setzen
\zurck:
 bsr      UPDATE_END      ; und Cursor wieder einschalten
 move.l   LINE_A,a2       ; ^LINE_A-Block
 move.l   (a0),-28(a2)    ; Zeile und Spalte in VDI-Block bertragen
 rts                      ; fertig



; ************************************
; * VDI-INTERFACE FR xVT52-EMULATOR *
; ************************************

VDI_ENTRY:
 move.l   d1,-(a7)        ; ^ParameterBlock retten
 bsr      UPDATE_CRS      ; Cursor ausschalten
 move.l   (a7)+,a3        ; ^ParameterBlock
 lea      TCB,a0          ; ^TerminalControlBlock
 move.l   (a3),a2         ; ^Contrl-Array
 move.w   10(a2),d0       ; Funktionsnummer holen
 cmpi.w   #101,d0         ; VDI ESC 101?
 bne.s    \v102           ; nein
 bsr      TOP_OFFSET      ; sonst Offset zum Bildschirm-Anfang setzen
 bra      UPDATE_END      ; Cursor freigeben und zurck
\v102:
 cmpi.w   #102,d0         ; VDI ESC 102?
 bne.s    \vdi_norm       ; nein
 bsr      INIT_FONT       ; sonst Font initialisieren
 bra      UPDATE_END      ; Cursor freigeben und zurck
\vdi_norm:
 add.w    d0,d0           ; Funktionsnummer*2 (Word-Pointer)
 lea      DUMMY,a1        ; Adresse der 1. Routine
 lea      VDI_ROUTS,a2    ; Adresse der Adress-Tabelle
 move.w   0(a2,d0.w),a2   ; rel. Adresse der Routine
 adda.l   a1,a2           ; +Offset=abs. Adresse der Routine
 jsr      (a2)            ; selbige zur Ausfhrung bringen
 bra      UPDATE_END      ; Cursor freigeben und zurck


VDI_ROUTS:                ; NR. FUNKTION                    VT52-SEQUENZ
 dc.w 0                   ;  0, unbelegt
 dc.w GET_SIZE-DUMMY      ;  1, inquire screen size
 dc.w EXIT_A-DUMMY        ;  2, exit alpha mode             (ESC 'f'+ESC 'E')
 dc.w ENTER_A-DUMMY       ;  3, enter alpha mode            (ESC 'E'+ESC 'e')
 dc.w CRS_UP-DUMMY        ;  4, cursor up                   (ESC 'A')
 dc.w CRS_DOWN-DUMMY      ;  5, cursor down                 (ESC 'B')
 dc.w CRS_RIGHT-DUMMY     ;  6, cursor right                (ESC 'C')
 dc.w CRS_LEFT-DUMMY      ;  7, cursor left                 (ESC 'D')
 dc.w HOME-DUMMY          ;  8, home                        (ESC 'H')
 dc.w DEL_FROM_CRS-DUMMY  ;  9, erase to end of screen      (ESC 'J')
 dc.w L_TO_END-DUMMY      ; 10, erase to end of line        (ESC 'K')
 dc.w GOTOXY-DUMMY        ; 11, set cursor position
 dc.w WR_TXT-DUMMY        ; 12, write text
 dc.w INV_ON-DUMMY        ; 13, inverse mode on             (ESC 'p')
 dc.w INV_OFF-DUMMY       ; 14, inverse mode off            (ESC 'q')
 dc.w GET_CRSPOS-DUMMY    ; 15, inquire cursor position



DUMMY:                    ; Leer-Routine fr nicht benutzte Sequenzen
 rts

GET_SIZE:                 ; VDI ESC 1
 move.l   (a3),a5         ; ^CONTRL-Block
 move.w   #2,8(a5)        ; 2 Rckgabewerte in INTOUT
 move.l   12(a3),a5       ; ^INTOUT-Block
 move.w   #80,2(a5)       ; max. Spalte
 move.w   6(a0),(a5)      ; max. Zeile
 addq.w   #1,(a5)         ; +1
 rts

EXIT_A:                   ; VDI ESC 2
 bclr     #3,(a4)         ; Cursor ausschalten
 bra      CLS             ; Bildschirm lschen und zurck

ENTER_A:                  ; VDI ESC 3
 bsr      CLS             ; Bildschirm lschen
 bset     #3,(a4)         ; Cursor einschalten
 rts

GOTOXY:                   ; VDI ESC 11
 move.l   4(a3),a5        ; ^INTIN-Array
 move.w   2(a5),d1        ; Spalte
 subq.w   #1,d1           ; -Offset
 bmi.s    \row            ; <0, ignorieren
 cmpi.w   #79,d1          ; >79?
 bgt.s    \row            ; ja, ignorieren
 move.w   d1,(a0)         ; Spalte bernehmen
\row:
 move.w   (a5),d1         ; Zeile
 subq.w   #1,d1           ; -Offset
 bmi.s    \zurck         ; <0, ignorieren
 cmp.w    6(a0),d1        ; zu gro?
 bgt.s    \zurck         ; ja, ignorieren
 move.w   d1,2(a0)        ; sonst bernehmen
\zurck:
 move.l   LINE_A,a2       ; ^LINE_A-Block
 move.l   (a0),-28(a2)    ; Zeile und Spalte in VDI-Block bertragen
 rts

WR_TXT:                   ; VDI ESC 12
 move.l   (a3),a5         ; ^CONTRL-Block
 move.w   6(a5),d1        ; Anzahl auszugebender Zeichen
 subq.w   #1,d1           ; in dbra-Zhler wandeln
 bmi.s    \zurck         ; <0, aufhren
 move.l   4(a3),a5        ; ^INTIN-Block
\lp:
 move.w   (a5)+,d0        ; Zeichen holen
 movem.l  d1/a5,-(a7)     ; Register retten
 bsr      CON_ENTRY       ; Zeichen ausgeben
 movem.l  (a7)+,d1/a5     ; Register zurck
 dbra     d1,\lp          ; nchstes Zeichen ausgeben
\zurck:
 rts

GET_CRSPOS:               ; VDI ESC 15
 move.l   (a3),a5         ; ^CONTRL-Block
 move.w   #2,8(a5)        ; 2 Rckgabewerte in INTOUT
 move.l   12(a3),a5       ; ^INTOUT-Block
 move.w   2(a0),(a5)      ; akt. Zeile
 addq.w   #1,(a5)+        ; +Offset
 move.w   (a0),(a5)       ; akt. Spalte
 addq.w   #1,(a5)         ; +Offset
 rts

TOP_OFFSET:               ; VDI ESC 101
 move.l   4(a3),a5        ; ^INTIN-Block
 move.w   (a5),d0         ; Offset in Pixelzeilen holen
 mulu     38(a0),d0       ; *Bytes/Textzeile
 move.l   LINE_A,a2       ; ^Line A-Block
 move.w   d0,-$1E(a2)     ; Byte-Offset in VDI-Block eintragen
 rts

INIT_FONT:                ; VDI ESC 102
 move.l   4(a3),a5        ; ^INTIN-Block
 move.l   LINE_A,a6       ; ^LINE A-Block
 move.l   (a5),a5         ; ^Font-Header (INTIN[0,1])
 move.w   82(a5),d0       ; Zeichenhhe in Pixel
 move.w   d0,36(a0)       ; im eigenen und
 move.w   d0,-$2E(a6)     ; im VDI-Block merken
 moveq    #80,d1          ; Bytes pro Pixelzeile
 mulu     d0,d1           ; 80 * Zeichenhhe
 move.w   d1,38(a0)       ; = Bytes pro Textzeile
 move.w   d1,-$28(a6)     ; im VDI-Block merken
 move.l   #400,d1         ; 400 Pixelzeilen/Bildschirm
 divu     d0,d1           ; div Zeichenhhe
 subq.w   #1,d1           ; - 1
 move.w   d1,6(a0)        ; = grte Zeilennummer
 move.w   d1,-$2A(a6)     ; im VDI-Block merken
 move.l   #640,d1         ; 640 Pixels pro Pixelzeile
 divu     52(a5),d1       ; div Zeichenbreite in Pixels
 subq.w   #1,d1           ; - 1
 move.w   d1,-$2C(a6)     ; = grte Spaltennummer
 move.l   72(a5),-$A(a6)  ; Zeiger auf Offset-Tabelle
 move.w   80(a5),-$E(a6)  ; Breite eines Zeichens ( M U S S 8bit betragen!!!)
 move.w   36(a5),-$10(a6) ; ASCII-Code des ersten darstellbaren Zeichens
 move.w   38(a5),-$12(a6) ; ASCII-Code des letzten dar. Zeichens im Font
 move.l   76(a5),a5       ; ^Fontdaten
 move.l   a5,-$16(a6)     ; im VDI-Block merken
 move.l   a5,32(a0)       ; und zum aktuellen VT52-Font machen
 subq.w   #8,d0           ; 8x8-Font?
 bne.s    \8x16           ; nein
 move.l   a5,28(a0)       ; ^8x8-Fontdaten
 bra.s    \init_crs       ; Cursor initialisieren
 rts
\8x16:
 subq.w   #8,d0           ; 8x16-Font?
 bne.s    \zurck         ; nein, Chaos-Format (nicht darstellbar...)
 move.l   a5,24(a0)       ; ^8x16-Fontdaten
\init_crs:
 clr.l    (a0)            ; Cursor in Home-Position bringen
 clr.w    10(a0)          ; gemerkte Cursorpositionen lschen
\zurck:
 rts

SHOW_PIC:                 ; Begrungsbild anzeigen
 clr      -(a7)           ; "nur lesen"-Attribut
 pea      NAME            ; ^Dateiname
 move.w   #$3d,-(a7)      ; Fopen
 trap     #1              ; GEMDOS
 addq.w   #8,a7           ; Stack aufrumen
 tst.l    d0              ; Fehler?
 bmi.s    \ende           ; dann beenden
 lea      HDL,a0          ; sonst
 move.w   d0,(a0)         ; Handle retten
 pea      BUFFER          ; ^Puffer
 move.l   #40000,-(a7)    ; max. 40000 Bytes lesen
 move.w   HDL,-(a7)       ; Handle
 move.w   #$3f,-(a7)      ; Fread
 trap     #1              ; GEMDOS
 lea      12(a7),a7       ; Stack aufrumen
 tst.l    d0              ; Fehler?
 bmi.s    \close          ; dann abbrechen
 pea      BUFFER          ; ^Puffer
 move.l   d0,-(a7)        ; Anzahl gelesener Bytes
 move.w   #1,-(a7)        ; auf CON:
 move.w   #$40,-(a7)      ; per Fwrite
 trap     #1              ; des GEMDOS ausgeben
 lea      12(a7),a7       ; Stack aufrumen
\close:
 move.w   HDL,-(a7)       ; Handle per
 move.w   #$3e,-(a7)      ; Fclose
 trap     #1              ; des GEMDOS zurckgeben
 addq.l   #4,a7           ; Stack aufrumen
\ende:
 rts                      ; und fertig

 data

REDIR:    dc.w 0          ; Flag fr Umlenkung (0=nein)
AES_OK:   dc.w 0          ; Flag, ob AES installiert (0=nein)

TRAPS:                    ; Adressen der Original-GEMDOS-Trap-Handler
          dc.l 0          ;  0(TRAPS) GEMDOS
          dc.l 0          ;  4(TRAPS) AES/VDI
          dc.l 0          ;  8(TRAPS) BIOS
          dc.l 0          ; 12(TRAPS) XBIOS

LINE_A:   dc.l 0          ; ^LINE A-Block
PBLOCK:   dc.l 0          ; Speicher fr VDI-Parameterblock

VEC_BASE: dc.l 0          ; ^Verarbeitungsroutine fr Zeichen
BEL_ADR:  dc.l 0          ; Speicher fr Adresse der Bimmel-Routine

TCB:                      ; Terminal Control Block
          dc.w 0          ;  0(TCB) akt. Spalte
          dc.w 0          ;  2(TCB) akt. Zeile
          dc.w 79         ;  4(TCB) grte Spalte
          dc.w 24         ;  6(TCB) grte Zeile
          dc.b %0000      ;  8(TCB) Bit 0=1: Invertieren eingeschaltet
                          ;         Bit 1=1: Wrapping eingeschaltet
                          ;         Bit 2=1: Unterstrich eingeschaltet
                          ;         Bit 3=1: Halbe Helligkeit eingeschaltet
          dc.b 0          ;  9(TCB) Flag fr Grafik (0=aus, -1=ein)
          dc.w 0          ; 10(TCB) Anzahl gespeicherter Cursorpositionen
          dc.w 0,0        ;         1. gespeicherte Position (x,y)
          dc.w 0,0        ;         2. gespeicherte Position (x,y)
          dc.w 0,0        ;         3. gespeicherte Position (x,y)
          dc.l 0          ; 24(TCB) ^8x16 Font (GEM)
          dc.l 0          ; 28(TCB) ^8x8 Font (GEM)
          dc.l 0          ; 32(TCB) ^aktueller Font
          dc.w 16         ; 36(TCB) Hhe eines Zeichens in Pixels
          dc.w 16*80      ; 38(TCB) Bytes pro Textzeile

                          ; *** GRAFIK-VARIABLEN: ***

          dc.w 0          ; 40(TCB) Anzahl mglicher horizontaler Bytes
          dc.w 0          ; 42(TCB) Anzahl mglicher Pixelzeilen
          dc.w 0          ; 44(TCB) Grafikbreite (in Bytes)
          dc.w 0          ; 46(TCB) Grafikhhe (in Pixels)
          dc.w 0          ; 48(TCB) Zhler (horizontal)
          dc.w 0          ; 50(TCB) Zhler (Pixelzeilen)
          dc.l 0          ; 52(TCB) linker Offset (abs.) fr Pixelzeile

TABS:     ds.w 5,$8080    ; Bitvektor fr Tabulatoren

CCB:      dc.b %0010      ; Cursor Control/Status Block
                          ;    Bit 0=1: Cursor enable (fr IRR)
                          ;    Bit 1=1: Cursor darf blinken
                          ;    Bit 2=1: Cursorposition invertiert
                          ;    Bit 3=1: Cursor eingeschaltet
          dc.b 0          ;  1(CCB) Anzahl gespeicherter CUR_OFFs (ESC 'f')
          dc.w 20         ;  2(CCB) Blinkrate
          dc.w 20         ;  4(CCB) Zhler fr Blinkrate
          dc.l 0          ;  6(CCB) Cursorposition (absolut)

NAME:     dc.b "\auto\x_vt52.dat",0
MLD:      dc.b 27,'E',27,'f',27,'Y',32+11,32+28,27,'p'
          dc.b "*************************",27,'Y',32+12,32+28
          dc.b "* xVT52 aktivieren? > < *",27,'Y',32+13,32+28
          dc.b "*************************",27,'Y',32+12,32+49
          dc.b 27,"q ",27,'D',7,0

 align

HDL:      dc.w 0          ; Platz fr Filehandle

 bss

BUFFER:   ds.b 40000      ; Platz fr Datei-Inhalt

 end
