/************************************************************************/
/*                                                                      */
/*       WCOUNTB.C                                                      */
/*                                                                      */
/*       Ein Beispielprogramm fr die Verwendung des Turbo Debuggers.   */
/*                                                                      */
/*       ACHTUNG:       DIESES PROGRAMM ENTHLT EINIGE FEHLER!!!        */
/*                                                                      */
/*       Copyright (c) 1989 Borland International.                      */
/*       All rights reserved.                                           */
/*                                                                      */
/************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAXWORDLEN 16               /* maximale Lnge eines Wortes      */
#define NUL   ((char)0)             /* Endemarke (Nullzeichen)          */
#define SPACE ((char)0x20)          /* Trennzeichen zwischen Wrtern    */

char *nextword( char *lineptr );
int  wordlen( char *wordstart );

/* -------------------------------------------------------------------- */
/*       Hauptprogramm                                                  */
/* -------------------------------------------------------------------- */

void main( void )
{
   FILE       *infile;                  /* Eingabedatei                 */
   char       linebuf[1024];            /* "momentane Zeile"            */
   char       *lineptr;                 /* Zeiger auf das erste/nchste */
                                        /* Wort in linebuf              */
   int        i;                        /* fr Schleifen usw.           */
   static int wordlens[MAXWORDLEN + 1], /* speichert die Wortlngen     */
              longwords;                /* Fr Wrter > MAXWORDLEN      */


   printf( "VORSICHT!\n\n");
   printf( "WCOUNTB.C ist ein bungsprogramm fr Turbo Debugger.\n");
   printf( "Wenn Sie dieses Programm nicht vom Debugger aus gestartet\n" );
   printf( "haben, dann drcken Sie bitte nur <Return>!\n\n" );
   printf( "Ansonsten hngt sich das System auf.\n\n" );
   printf( "Weitere Informationen finden Sie im Benutzerhandbuch.\n\n" );

   printf( "Geben Sie den Namen der Textdatei ein (z.B. TEXT.DAT): " );

   gets( linebuf );                 /* linebuf wird hier "mibraucht"   */

   if ( !strlen( linebuf ))         /* nur RETURN gedrckt?             */
      exit( 1 );                    /* Dann Programm vorzeitig beenden. */

   infile = fopen( linebuf, "r" );  /* ffnen der Datei                 */
   if ( !infile )
   {
      printf( "Fehler beim ffnen von %s\n", linebuf );
      exit( 1 );
   }

                                    /* Lesen einer Zeile                */
   while ( fgets(linebuf, sizeof( linebuf ), infile ))
   {
      printf( "%s", linebuf );      /* Ausgabe                          */

                                    /* Prfung des Pufferendes und      */
                                    /* Entfernen des abschlieenden \n  */
      i = strlen( linebuf );        /* Lnge der Zeile                  */
      if ( linebuf[i - 1] != '\n' ) /* Zeilenvorschub letztes Zeichen?  */
         printf( "Beginn einer berlangen Zeile:\n\t%70s\n", linebuf );
      else
         linebuf[i - 1] = NUL;      /* Zeilenvorschub ersetzen          */

      lineptr = nextword( linebuf );/* Ermitteln des ersten Wortanfangs */

      while ( *lineptr )
      {
         i = wordlen( lineptr );    /* Bestimmung der Wortlnge         */
         if ( i > MAXWORDLEN )      /* grer als MAXWORDLEN?           */
            longwords++;            /* ja - wird als "langes Wort"      */
         else                       /* gespeichert                      */
            wordlens[i]++;          /* sonst den entsprechenden Zhler  */
                                    /* erhhen                          */

         lineptr += i;              /* Zeiger um die Wortlnge erhhen  */

         lineptr = nextword( lineptr ); /* gibt es ein weiteres Wort?   */
      }
   }

   printf( "  Lnge  Anzahl\n" );   /* Ausgabe der Wortlngen           */
   for ( i = 1; i <= MAXWORDLEN; i++ )
      printf( "  %5d %5d\n", i, wordlens[i] );
   printf( "berlange Wrter: %5d\n", longwords );

   fclose(infile);                  /* Schlieen der Datei und          */
   exit( 0 );                       /* Programmende                     */
}

/* -------------------------------------------------------------------- */
/*       char *nextword( char *lineptr );                               */
/*                                                                      */
/*       Funktion liefert einen Zeiger auf den Start des nchsten       */
/*       'Wortes' in einer Zeile.                                       */
/* -------------------------------------------------------------------- */

char *nextword( char *lineptr )
{
   while ( *lineptr == SPACE )      /* Solange der Zeiger auf ein Leer- */
      lineptr++;                    /* zeichen zeigt, wird er erhht    */

   return( lineptr );               /* Ergebnis: Zeiger auf das         */
}                                   /* nchste "Nicht-Leerzeichen"      */

/* -------------------------------------------------------------------- */
/*       int wordlen( char *wordstart );                                */
/*                                                                      */
/*       Funktion berechnet die Lnge eines 'Wortes'.                   */
/* -------------------------------------------------------------------- */

int wordlen( char *wordstart )
{
   char *charptr;                   /* Arbeitszeiger                    */

   charptr = wordstart;             /* Arbeitszeiger auf den ber-      */
                                    /* gebenen Startwert                */

                                    /* Solange das "momentane" Zeichen  */
                                    /* != NUL und != SPACE ist:         */
   while ( *charptr & *charptr != SPACE )
      charptr++;                    /* Arbeitszeiger auf das nchste    */
                                    /* Zeichen                          */

   return( charptr - wordstart );   /* Ergebnis:                        */
}                                   /* Wortende - Start = Lnge         */

/* -------------------------------------------------------------------- */
/*       Ende WCOUNTB.C                                                 */
/* -------------------------------------------------------------------- */
