(*----- Category : Module Identification -------------------------------*)

(* Module Type          : *) MODULE
(* .      Name          : *) WPPack;
(* .      Function      : WPProg - Demo                                 *)
(* .      Version/Date  : 0.03   30.12.1989                             *)
(* Product Name         : WPProg                                        *)
(* Copyright            : (c) 1989, K. Bamberger, D7500 Karlsruhe 41    *)


(*----- Category : Module Abstract -------------------------------------**

Dialog - Demo der Wordplus-Schnittstelle WPProg. *)


(*----- Category : Types and Data --------------------------------------*)

IMPORT InOut;  (* DUMMY-IMPORT ALS KRCKE FR DEN LINKER... *)
IMPORT Watch;
IMPORT Environment, HFS, SSWiS, TextWindows, GemDos,
       Strings, NumberConversions, Clock, AESForms;

IMPORT WPCode, WPPrint, WPConv, WPIndex, WPSig, WPTeX, WPKey, WPPub, WPPrtB;

TYPE
  Str2 = ARRAY [0..1] OF CHAR;

VAR 
  WPFolder, WPName,
  Source, Dest  : GemDos.Paths;
  WPDrive       : GemDos.Drives;
  Drive         : Str2;
  Client        : SSWiS.ModuleHandles;
  Tos14, Help, done,
  AutoStart     : BOOLEAN;
  Button        : INTEGER;


(*----- Category : Allg. Procs -----------------------------------------*)

PROCEDURE Message (Ok : BOOLEAN);

BEGIN
  IF Ok
     THEN  SSWiS.SetWindowMessage (Client, 0, 'Done')
     ELSE  SSWiS.SetWindowMessage (Client, 0, 'Not done')
  END
END Message;


PROCEDURE AskName (    Path, File : GemDos.Paths;
                   VAR Selection  : ARRAY OF CHAR;
                       Message    : ARRAY OF CHAR;
                       Alert      : BOOLEAN) : BOOLEAN;
VAR
  vol  : Str2;
  fol  : GemDos.Paths;
  doc  : ARRAY [0..7]  OF CHAR;
  typ  : ARRAY [0..3]  OF CHAR;
  Done : BOOLEAN;

BEGIN
  Strings.Concat (Drive, Path, fol);
  IF Tos14
     THEN  AESForms.ExtFileSelectorInput (fol, File, Done, Message)
     ELSE  IF Alert THEN
              Button := 0;  SSWiS.NotifyForm (Message, 'Ok', Button)
           END;
           AESForms.FileSelectorInput (fol, File, Done)
  END;
  IF  Done THEN
      HFS.Decode (fol, vol, fol, doc, typ);
      HFS.Encode (vol, fol, File, 0C, Selection);
      Drive := vol;
      RETURN TRUE
  ELSE
      RETURN FALSE
  END
END AskName;


PROCEDURE StartWP (Document : ARRAY OF CHAR);
VAR
  ret        : LONGINT;
  Drv        : GemDos.SetOfDrives;
  CurrDrv    : GemDos.Drives;
  CurrFolder : GemDos.Paths;
  cmdline    : ARRAY [1..128] OF CHAR;

BEGIN
  SSWiS.Close;

  CurrDrv := GemDos.GetDrive();
  GemDos.GetPath (CurrFolder, CurrDrv);
  Drv := GemDos.SetDrv (WPDrive);
  GemDos.SetPath (WPFolder);
  cmdline[1] := CHR(Strings.Length(Document));  cmdline[2] := 0C;
  Strings.Concat (cmdline, Document, cmdline);
  ret := GemDos.Exec (GemDos.LoadStart, WPName, cmdline, '');
  Drv := GemDos.SetDrv (CurrDrv);
  GemDos.SetPath (CurrFolder);
  Message (ret = 0D);

  SSWiS.Reinit
END StartWP;


(*----- Category : Menpunkt 'Demo': -----------------------------------*)

PROCEDURE ShowDoc;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Startet WORDPLUS.PRG', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;
  IF AskName ('\*.DOC', '', Source, 'Whle Dokument:', FALSE) THEN
     StartWP (Source)
  END
END ShowDoc;


PROCEDURE PrintDoc;
VAR
  Param  : WPPrtB.ParamBlk;
  Result : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Druckt ein WORDPLUS-Dokument', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;
  IF AskName ('\*.DOC', '', Source, 'Whle Dokument:', FALSE) THEN
     WPPrtB.InitParam (Param);
     WPPrtB.PrintDoc  (Source, 0C, Param, Result);
     Message (Result = WPPrint.Done)
  END
END PrintDoc;


(*----- Category : Menpunkt 'WPConv': ---------------------------------*)

PROCEDURE ASCIItoWP;
VAR
  Layout, Header, Footer,
  FnFormat, FnRuler,
  Ruler    : WPCode.WPFormat;
  Justify  : WPConv.Justification;
  Result   : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Konvertiert ASCII nach WP', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;

  Button := 3;
  SSWiS.NotifyForm ('Gewnschte Formatierung:',
                    'None|Right|Centre|Block', Button);
  CASE Button OF
      0 : Justify := WPConv.None
    | 1 : Justify := WPConv.Right
    | 2 : Justify := WPConv.Centre
    | 3 : Justify := WPConv.Block
  END;
  IF AskName ('\*.TXT', '', Source, 'Whle ASCII-Text:', FALSE) &
     AskName ('\*.DOC', '', Dest, 'Whle WORDPLUS-Dokument:', FALSE) THEN
     WPCode.CreateFormats (Layout, Header, Footer, FnFormat, FnRuler, Ruler);
     WPConv.ASCIItoWP (Source, Dest, 0C, Layout, Header, Footer, Ruler,
                       Justify, TRUE, Result);

     IF Result = WPPrint.Done
        THEN  IF AutoStart THEN  StartWP (Dest)  END
        ELSE  Message (FALSE)
     END
  END
END ASCIItoWP;


PROCEDURE WPtoASCII;
VAR
  Result : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Konvertiert WP nach ASCII', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;

  Button := 0;
  SSWiS.NotifyForm ('Sollen Einrckungen entfernt werden ?', 'Ja|Nein', Button);
  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Dokument:', FALSE) &
     AskName ('\*.TXT', '', Dest, 'Whle ASCII-Text:', FALSE) THEN
     WPConv.WPtoASCII (Source, Dest, Button=0, Result);

    IF Result = WPPrint.Done
       THEN  IF AutoStart THEN  StartWP (Dest)  END
       ELSE  Message (FALSE)
    END
  END
END WPtoASCII;


PROCEDURE WPtoWP;
VAR
  Ruler   : WPCode.WPFormat;
  Justify : WPConv.Justification;
  Result  : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Konvertiert ein WORDPLUS-Dokument', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;

  Button := 3;
  SSWiS.NotifyForm ('Gewnschte Formatierung:',
                    'None|Right|Centre|Block', Button);
  CASE Button OF
      0 : Justify := WPConv.None
    | 1 : Justify := WPConv.Right
    | 2 : Justify := WPConv.Centre
    | 3 : Justify := WPConv.Block
  END;
  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Quelle:', FALSE) &
     AskName ('\*.DOC', '', Dest, 'Whle WORDPLUS-Ziel:', FALSE) THEN
     WPConv.WPtoWP (Source, Dest, FALSE, Ruler, Justify, FALSE,
                    WPCode.AttributeSet{}, TRUE, Result);

     IF Result = WPPrint.Done
        THEN  IF AutoStart THEN  StartWP (Dest)  END
        ELSE  Message (FALSE)
     END
  END
END WPtoWP;


PROCEDURE WP3toWP2;
VAR
  Result : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Konvertiert WP3 nach WP2', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;

  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS 3.x - Dokument:', FALSE) &
     AskName ('\*.DOC', '', Dest, 'Whle WORDPLUS 2.x - Dokument:', FALSE) THEN
     WPConv.WP3toWP2 (Source, Dest, Result);

    IF Result = WPPrint.Done
       THEN  IF AutoStart THEN  StartWP (Dest)  END
       ELSE  Message (FALSE)
    END
  END
END WP3toWP2;


(*----- Category : Menpunkt 'WPIndex': --------------------------------*)

PROCEDURE CreateTOC;
VAR
  Result : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Erstellt ein Inhaltsverzeichnis', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;
  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Dokument:', FALSE) &
     AskName ('\*.DOC', '', Dest, 'Whle `TOC`-Dokument:', FALSE) THEN
     WPIndex.CreateTOC (Source, Dest, TRUE, 0, '.', TRUE,
                        WPCode.AttributeSet{}, Result);

     IF Result = WPPrint.Done
        THEN  IF AutoStart THEN  StartWP (Dest)  END
        ELSE  Message (FALSE)
     END
  END
END CreateTOC;


TYPE Types = (none, incl, excl);

PROCEDURE CreateIndex (Type : Types);
VAR
  Incl, Excl : GemDos.Paths;
  Result     : WPPrint.Results;
  str        : ARRAY [0..2] OF CHAR;
  card       : CARDINAL;
  MinLen     : WPIndex.WordLength;
  dummy      : BITSET;
  Ok         : BOOLEAN;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Erstellt ein Register', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;
  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Dokument:', TRUE) &
     AskName ('\*.DOC', '', Dest, 'Whle Index-Dokument:', TRUE) THEN
     Incl := '';  Excl := '';  MinLen := 1;
     IF  (Type = none) OR
        ((Type = incl) & AskName ('\*.DOC', '', Incl, 'Whle Inclusions:', TRUE)) OR
        ((Type = excl) & AskName ('\*.DOC', '', Excl, 'Whle Exclusions:', TRUE)) THEN
        IF Type # incl THEN
           REPEAT
             Button := 0;  str := '';
             SSWiS.AskForm ('Minimale Wortlnge (1..30) =',
                            'Ok|Exit', 0C, str, dummy, Button);
             IF Button = 1 THEN  RETURN  END;
             NumberConversions.StringToCard (str, card, Ok)
           UNTIL (card >= 1) & (card <= WPIndex.MaxWordLength);
           MinLen := card
        END;
      
        WPIndex.CreateIndex (Source, Dest, TRUE, TRUE, 0, Incl, Excl,
                             FALSE, MinLen, Result);
      
        IF Result = WPPrint.Done
           THEN  IF AutoStart THEN  StartWP (Dest)  END
           ELSE  Message (FALSE)
        END
     END
  END
END CreateIndex;


(*----- Category : Menpunkt 'WPKey': ----------------------------------*)

PROCEDURE CodeDocument;
VAR
  Key    : WPCode.WPLines;
  Result : WPPrint.Results;
  dummy  : BITSET;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Verschlsselt ein WORDPLUS-Dokument', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;

  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Quelle:', FALSE) &
     AskName ('\*.DOC', '', Dest, 'Whle WORDPLUS-Ziel:', FALSE) THEN
     Button := 0;  Key := '';
     SSWiS.AskForm ('Schlssel (Key) =', 'Ok|Exit', 0C, Key, dummy, Button);
     IF Button = 1 THEN  RETURN  END;
     WPKey.CodeDocument (Source, Dest, Key, FALSE, Result);

     IF Result = WPPrint.Done
        THEN  IF AutoStart THEN  StartWP (Dest)  END
        ELSE  Message (FALSE)
     END
  END
END CodeDocument;


PROCEDURE DecodeDocument;
VAR
  Key    : WPCode.WPLines;
  Result : WPPrint.Results;
  dummy  : BITSET;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Entschlsselt ein WORDPLUS-Dokument', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;

  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Quelle:', FALSE) &
     AskName ('\*.DOC', '', Dest, 'Whle WORDPLUS-Ziel:', FALSE) THEN
     Button := 0;  Key := '';
     SSWiS.AskForm ('Schlssel (Key) =', 'Ok|Exit', 0C, Key, dummy, Button);
     IF Button = 1 THEN  RETURN  END;
     WPKey.DecodeDocument (Source, Dest, Key, FALSE, Result);

     IF Result = WPPrint.Done
        THEN  IF AutoStart THEN  StartWP (Dest)  END
        ELSE  Message (FALSE)
     END
  END
END DecodeDocument;


(*----- Category : Menpunkt 'Other': ----------------------------------*)

PROCEDURE WPtoSIGNUM;
VAR
  ConvTable : GemDos.Paths;
  Result    : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Erstellt SIGNUM2-Dokument aus WP-Dokument', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;
  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Dokument:', FALSE) &
     AskName ('\*.SDO', '', Dest, 'Whle SIGNUM2-Dokument:', FALSE) &
     AskName ('\CONVERT.PAR', 'CONVERT.PAR', ConvTable,
              'Whle Convert-Tabelle:', FALSE) THEN
     WPSig.WPtoSIGNUM2 (Source, Dest, ConvTable, Result);
     Message (Result = WPPrint.Done)
  END
END WPtoSIGNUM;


PROCEDURE WPtoTeX;
VAR
  Result : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Erstellt TeX-Dokument aus WP-Dokument', 'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;
  IF AskName ('\*.DOC', '', Source, 'Whle WORDPLUS-Dokument:', FALSE) &
     AskName ('\*.TEX', '', Dest, 'Whle TeX-Dokument:', FALSE) THEN
     WPTeX.WPtoTeX (Source, Dest, Result);
     Message (Result = WPPrint.Done)
  END
END WPtoTeX;


PROCEDURE ExtractDTP;
VAR
  Extract : WPPub.ExtractType;
  Result  : WPPrint.Results;

BEGIN
  IF Help THEN
     Button := 0;
     SSWiS.NotifyForm ('Extrahiert Artikel aus TIMEWORKS-Dokument',
                       'Ok|Exit', Button);
     IF Button = 1 THEN  RETURN  END
  END;

  Button := 0;
  SSWiS.NotifyForm ('Was soll extrahiert werden ?',
                    'Artikel|Alles', Button);
  IF Button = 0
     THEN  Extract := WPPub.Articles
     ELSE  Extract := WPPub.AllText
  END;
 
  IF AskName ('\*.DTP', '', Source, 'Whle TIMEWORKS-Dokument:', TRUE) THEN
     WPPub.ExtractDTP (Source, 0C, Extract, Result);
     Message (Result = WPPrint.Done)
  END
END ExtractDTP;


(*----- Category : SSWiS - Steuerung: ----------------------------------*)

PROCEDURE Accept (    Owner  : SSWiS.ModuleHandles;
                      Window : SSWiS.WindowHandles;
                  VAR Report : SSWiS.EventReports);
VAR
  copyright : ARRAY [1..32] OF CHAR;

  PROCEDURE Update;
  VAR
    XY, WH : TextWindows.Points;

  BEGIN
    XY.X := 0;  XY.Y := 0;  WH.X := 400;  WH.Y := 400;
    TextWindows.ExplicitRestore (Client, 0, XY, WH)
  END Update;


BEGIN
  CASE Report.Type OF
      SSWiS.Menu  :
        CASE Report.Selection.Title OF
            0 : CASE Report.Selection.Item OF
                    0 : ShowDoc
                  | 1 : PrintDoc
                  | 3 : IF Help
                           THEN  SSWiS.SetMenuItem (Client, 0, 3, '  Help')
                           ELSE  SSWiS.SetMenuItem (Client, 0, 3, 'C Help')
                        END;
                        Help := ~Help
                  | 4 : IF AutoStart
                           THEN  SSWiS.SetMenuItem (Client, 0, 4, '  WP Auto-Start ')
                           ELSE  SSWiS.SetMenuItem (Client, 0, 4, 'C WP Auto-Start ')
                        END;
                        AutoStart := ~AutoStart;
                  | 6 : Button := 1;
                        SSWiS.NotifyForm ('Wirklich Beenden ?',
                                          'Ja|Nein', Button);
                        done := Button = 0
                    ELSE
                END

          | 1 : CASE Report.Selection.Item OF
                    0 : ASCIItoWP
                  | 1 : WPtoASCII
                  | 2 : WPtoWP
                  | 3 : WP3toWP2
                    ELSE
                END;
                Update

          | 2 : CASE Report.Selection.Item OF
                    0 : CreateTOC
                  | 1 : CreateIndex (none)
                  | 2 : CreateIndex (incl)
                  | 3 : CreateIndex (excl)
                    ELSE
                END;
                Update

          | 3 : CASE Report.Selection.Item OF
                    0 : CodeDocument
                  | 1 : DecodeDocument
                    ELSE
                END;
                Update

          | 4 : CASE Report.Selection.Item OF
                    0 : WPtoSIGNUM
                  | 1 : WPtoTeX
                  | 2 : ExtractDTP
                    ELSE
                END;
                Update
        END

    | SSWiS.Keyboard :
        CASE Report.Strokes.Keys[0] OF
             SSWiS.F1   : ASCIItoWP
           | SSWiS.F2   : WPtoASCII
           | SSWiS.F3   : WPtoWP
           | SSWiS.F4   : WP3toWP2
           | SSWiS.F5   : CreateTOC
           | SSWiS.F6   : CreateIndex (none)
           | SSWiS.F7   : CreateIndex (incl)
           | SSWiS.F8   : CreateIndex (excl)
           | SSWiS.F9   : CodeDocument
           | SSWiS.F10  : DecodeDocument
           | SSWiS.Undo : IF SSWiS.Control IN Report.Strokes.MetaKey THEN
                             done := TRUE
                          ELSE
                             Button := 1;
                             SSWiS.NotifyForm ('Wirklich Beenden ?',
                                               'Ja|Nein', Button);
                             done := Button = 0
                          END
             ELSE
         END;
         Update

    | SSWiS.Identification : copyright:='?1989 by K.Bamberger, 75 Khe 41';
                             copyright[1] := CHR(189);
                             SSWiS.Identify ('WPProg - Demo',
                                             '0.03  (30.12.1989)',
                                             'K. Bamberger', copyright)
      ELSE
  END
END Accept;


PROCEDURE Restore (Owner  : SSWiS.ModuleHandles;
                   Window : SSWiS.WindowHandles;
                   XY, WH : TextWindows.Points);
BEGIN
  XY.X := 0;  XY.Y := 0;
  TextWindows.Position (XY);
  TextWindows.Clear;
  TextWindows.WriteLn;
  TextWindows.WriteString ('   Demo der Wordplus-Schnittstelle');
  TextWindows.WriteLn;
  TextWindows.WriteLn;
  TextWindows.WriteString ('              ');
  TextWindows.Invert (TRUE);
  TextWindows.WriteString (' WPProg ');
  TextWindows.WriteLn;
  TextWindows.WriteLn;
  TextWindows.Invert (FALSE);
  TextWindows.WriteString (' Sie knnen hiermit ein vorhandenes');
  TextWindows.WriteLn;
  TextWindows.WriteString (' Wordplus-  bzw.   ASCII - Dokument');
  TextWindows.WriteLn;
  TextWindows.WriteString (' bearbeiten  und  in  Wordplus  das');
  TextWindows.WriteLn;
  TextWindows.WriteString (' Resultat begutachten.');
  TextWindows.WriteLn;
  TextWindows.WriteLn;
  TextWindows.WriteString ('  Bitte whlen Sie den gewnschten');
  TextWindows.WriteLn;
  TextWindows.WriteString ('          Menpunkt aus !');
  TextWindows.WriteLn
END Restore;


PROCEDURE InitEnvironment() : BOOLEAN;
VAR
  WPPath   : GemDos.Paths;
  Vol, Typ : ARRAY [0..7] OF CHAR;
  Done     : BOOLEAN;

BEGIN
  Drive := '?:';  Drive[0] := CHR (ORD(GemDos.GetDrive()) + ORD('A'));
  IF Environment.Get ('WPPath', WPPath) THEN
     Done := TRUE
  ELSE
     Done := AskName ('\WORDPLUS.PRG', 'WORDPLUS.PRG', WPPath,
                      'Whle WORDPLUS.PRG:', TRUE)
  END;
  IF Done THEN
     Environment.Set ('WPPath', WPPath);
     HFS.Decode (WPPath, Vol, WPFolder, WPName, Typ);
     Strings.Concat (WPName, Typ, WPName);
     WPDrive := ORD (CAP(Vol[0])) - ORD ('A');
     RETURN  TRUE
  ELSE
     RETURN  FALSE
  END
END InitEnvironment;


PROCEDURE InitSSWiS;
VAR
  XY, Min : SSWiS.ScreenPoints;
  WH      : TextWindows.Points;

BEGIN
  Help := TRUE;  AutoStart := TRUE;  done := FALSE;
  SSWiS.Register     (Client, 'WPPack', Accept);

  SSWiS.SetMenuTitle (Client, 0,    '  Demo');
  SSWiS.SetMenuItem  (Client, 0, 0, '  Show Document');
  SSWiS.SetMenuItem  (Client, 0, 1, '  Print Document');
  SSWiS.SetMenuItem  (Client, 0, 2, 'M --- Options: -----');
  SSWiS.SetMenuItem  (Client, 0, 3, 'C Help');
  SSWiS.SetMenuItem  (Client, 0, 4, 'C WP Auto-Start ');
  SSWiS.SetMenuItem  (Client, 0, 5, 'M ------------------');
  SSWiS.SetMenuItem  (Client, 0, 6, '  QUIT         Undo ');

  SSWiS.SetMenuTitle (Client, 1,    '  WPConv');
  SSWiS.SetMenuItem  (Client, 1, 0, '  ASCII to WP   F1 ');
  SSWiS.SetMenuItem  (Client, 1, 1, '  WP to ASCII   F2');
  SSWiS.SetMenuItem  (Client, 1, 2, '  WP to WP      F3');
  SSWiS.SetMenuItem  (Client, 1, 3, '  WP3 to WP2    F4');

  SSWiS.SetMenuTitle (Client, 2,    '  WPIndex');
  SSWiS.SetMenuItem  (Client, 2, 0, '  Create TOC     F5 ');
  SSWiS.SetMenuItem  (Client, 2, 1, '  Create Index   F6');
  SSWiS.SetMenuItem  (Client, 2, 2, '    " with Encl  F7');
  SSWiS.SetMenuItem  (Client, 2, 3, '    " with Excl  F8');

  SSWiS.SetMenuTitle (Client, 3,    '  WPKey');
  SSWiS.SetMenuItem  (Client, 3, 0, '  Code Doc    F9');
  SSWiS.SetMenuItem  (Client, 3, 1, '  Decode Doc  F10 ');

  SSWiS.SetMenuTitle (Client, 4,    '  Other');
  SSWiS.SetMenuItem  (Client, 4, 0, '  WP to SIGNUM ');
  SSWiS.SetMenuItem  (Client, 4, 1, '  WP to TeX');
  SSWiS.SetMenuItem  (Client, 4, 2, '  Extract DTP');

  TextWindows.Create        (Client, 0, Restore);
  SSWiS.SetWindowElements   (Client, 0, SSWiS.SetOfWindowElements
                              {SSWiS.MessageLine..SSWiS.YScroller});
  SSWiS.SetWindowTitle      (Client, 0, 'WPProg - Demo');
  SSWiS.SetWindowMessage    (Client, 0, '');
  XY.X  := 25;   XY.Y  := 40;
  SSWiS.PositionWindow      (Client, 0, XY);
  Min.X := 150;  Min.Y := 50;
  XY.X  := 290;  XY.Y  := 210;
  SSWiS.SizeWindowContent   (Client, 0, Min, XY, XY);
  WH.X := SSWiS.NullPoint.X;  WH.Y := SSWiS.NullPoint.Y;
  TextWindows.PositionWorld (Client, 0, WH);
  TextWindows.InteriorOf    (Client, 0, WH);
  TextWindows.SizeWorld     (Client, 0, WH);
  SSWiS.PlaceWindowOnTop    (Client, 0)
END InitSSWiS;


PROCEDURE ExitSSWiS;

BEGIN
  TextWindows.Delete (Client, 0);
  SSWiS.Deregister   (Client)
END ExitSSWiS;


BEGIN
  Tos14 := GemDos.Version() >= 1500H;
  IF ~InitEnvironment() THEN  RETURN  END;
  InitSSWiS();
  REPEAT
    SSWiS.PollEvents
  UNTIL done;
  ExitSSWiS
END WPPack.
