/* Progrmmlein zum Setzen der Bit's in Programmheadern */



#include <tos.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <portab.h>


#define HELP_TEXT "\33E\r\n PRG_FLAG setzt die Programmflags eines angegebenen Programms\r\n\
	Geschrieben am 27.11.1992 von Hartwig zur Nieden.\r\n\r\n\
	Format:		prg_flag <[+/-][FLAGpgsr]/[0xHexzahl]> <Programmname>\r\n\r\n\
 Dabei bedeuten:	Bit0: 'F' ... Fastloadbit\r\n\
			Bit1: 'L' ... Load to TT-Ram\r\n\
			Bit2: 'A' ... Malloc to TT-Ram\r\n\
			Bit3: 'G' ... G-Bit (keine Ahnung...)\r\n\
			Bit4:\\ MultiTOS-Protection-Bits:\r\n\
			Bit5:/	'p'= 0= Private\r\n\
				'g'= 1= Global\r\n\
				's'= 2= Super\r\n\
				'r'= 3= Readable\r\n\r\n\
 Die Angaben drfen NICHT durch 'Space' getrennt sein, nur der Pfad.\r\n\
 Alternativ knnen die Bits auch als 2-stellige Hex-Zahl angegeben werden.\r\n\
 + und - geben an, ob das Bit gesetzt oder gelscht werden soll.\r\n\
 Bei Hex-Angabe und p,g,s,r werden +/- ignoriert und die Bits von der Zahl\r\n\
 berschrieben !\r\n\
 ACHTUNG: JEDE angegebene Datei wird verndert ! Auch Texte o.. !\r\n\r\n\
	<<<Taste>>>"




UBYTE hex2char( char *ch )
{
	int i;
	UBYTE r;

	for( r=i=0;i<2;i++ ) r |= (ch[i]>'9'?toupper(ch[i])-'A'+10:ch[i]-'0')<<((1-i)<<2);
	return( r );
}


int main( int argc,char **argv )
{
	int fl;
	UBYTE flags;
	int i,fileh;

	if( argc==1 )
	{	Cconws( HELP_TEXT );
		while( !Bconstat( 2 ) );
		Bconin( 2 );
		return( 0 );
	}

	flags=0;
	fileh= Fopen( argv[2],FO_RW );
	if( fileh<0 ) return( -1 );
	Fseek( 25,fileh,0 );
	Fread( fileh,1,&flags );
	Fseek( 25,fileh,0 );
	for( i=0;i<strlen( argv[1] );i+=2 )
	{	switch( argv[1][i+1] )
		{	case 'F': fl= 0x1; break;
			case 'L': fl= 0x2; break;
			case 'A': fl= 0x4; break;
			case 'G': fl= 0x8; break;
			case 'p': fl= -1; break;
			case 'g': fl= -2; break;
			case 's': fl= -3; break;
			case 'r': fl= -4; break;
			case 'x':
				if( argv[1][i]=='0' ) fl= hex2char( &argv[1][i+2] );
				flags=0;
				i+= 2;
				break;
			default: fl=0;
		}
		if( fl )
		{	if( fl>0 )
				if( argv[1][i]=='-' ) flags &= ~fl;
				else flags |= fl;
			else
				flags = (flags&~0x30)|((~fl)<<4);
		}
	}
	Fwrite( fileh,1,&flags );
	Fclose( fileh );

	return( 0 );
}


