/*********************************************************
 *                                                       *
 *  Testprogramm fr das 16-Bit-Interface zu ST-Digital  *
 *  Erstellt mit Lattice-C                               *
 *                                                       *
 *  Erich Eder, 1989                                     *
 *                                                       *
 *********************************************************/

#include <gemlib.h>
#include <portab.h>
#include "if_acces.h"
#include "if_test.h"

#define SCREEN 0,0,640,400


int   state = 0,        /* Ein-/Ausgabe-Zustnde */
      ddir  = 0;        /* Datenrichtung */

OBJECT *panel;

/*************************************************************/

/***********************************
 * ndere Datenrichtung eines Bits *
 ***********************************/

void chg_ddir (bit)
   int bit;                     /* Bitnummer */
{
   int d;

   if_init (ddir ^= 1<<bit);
   if_write (state);
   d = ddir & 1<<bit;
   *(char*)&panel[DDIR00+bit].ob_spec = d ? 'A' : 'E';
   panel[STATE00+bit].ob_spec = d ? 0xFF1000L : 0xFF1011L;
   panel[STATE00+bit].ob_flags ^= SELECTABLE;
   objc_draw (panel, DDIR00+bit,1, SCREEN);
   objc_draw (panel, STATE00+bit,1, SCREEN);
}


/**************************
 * ndere Eingabezustnde *
 **************************/

void chg_in (field)
   int field;                   /* Bitfeld fr zu ndernde Bits */
{
   int i;

   state ^= field;
   for (i=0; i<16; i++)
      if (field & 1<<i)
      {  panel[STATE00+i].ob_state ^= SELECTED;
         objc_draw (panel, STATE00+i,1, SCREEN);
      }
}


/*************************
 * ndere Ausgabezustand *
 *************************/

void chg_out (bit)
   int bit;                     /* Bitnummer */
{
   if (ddir & 1<<bit)
   {  if_write (state ^= 1<<bit);
      panel[STATE00+bit].ob_state ^= 1;
      objc_draw (panel, STATE00+bit,1, SCREEN); 
   }
}


/************
 * Tue es ! *
 ************/

void do_it()
{
   WORD evnt,mx,my,dmy,obj;

   do
   {  evnt = evnt_multi (MU_BUTTON+MU_TIMER,
         1,1,1, 0,0,0,0,0, 0,0,0,0,0, 0L, 0,0, &mx,&my,&dmy,&dmy,&dmy,&dmy);
      if (evnt & MU_BUTTON)
      {  obj = objc_find (panel,0,8,mx,my);
         if (obj >= DDIR00 && obj <= DDIR15) chg_ddir (obj-DDIR00);
         if (obj >= STATE00 && obj <= STATE15) chg_out (obj-STATE00);
      }
      chg_in ((state ^ if_read()) & ~ ddir);
   } while (!(evnt & MU_BUTTON && obj == QUIT));
}


/************************************************************/

void main()
{
   WORD dummy;

   appl_init();
   if (! rsrc_load ("if_test.rsc"))
   {  form_alert (1,"[2][Was ist mit der Resource-Datei!?!][Abbruch]");
      exit ();
   }
   rsrc_gaddr (R_TREE, PANEL, &panel);
   form_center (panel, &dummy,&dummy,&dummy,&dummy);
   objc_draw (panel, 0,8, SCREEN);
   if_init (0);
   graf_mouse (POINT_HAND);
   do_it();
   if_stop();
   appl_exit();
}

