.TH Dlock 2 "MiNT Programmer's Manual" "Version 0.93" "Mar. 8, 1992"
.SH NAME
Dlock \- lock or unlock a BIOS disk device
.SH SYNOPSIS
.nf
LONG Dlock( WORD mode, WORD drv );
.fi
.SH DESCRIPTION
.I Dlock
is used to lock or unlock the BIOS device indicated by
.IR drv .
No GEMDOS file operations are permitted on a locked drive. Thus,
the
.I Dlock
call provides a mechanism for disk formatters or re-organizers to
lock out other processes while low-level BIOS or XBIOS operations
are in progress on the device.
.PP
If
.I mode
is 1, the drive is locked; if it is
.I 0
then the drive is unlocked and may be used again by other programs.
If a process terminates while holding a lock on a drive, that drive
is automatically unlocked.
.PP
A lock operation followed immediately by an unlock is very similar
to a media change, except that the lock operation will fail if
there are open files that refer to the indicated drive.
.SH RETURNS
0 if the lock/unlock operation was successful
.PP
EACCDN if
.I mode
is 1 and either open files exist on the drive or another process
has already locked the drive,or if
.I mode
is 0 and the drive was locked by a different process
.PP
EDRIVE if
.I drv
is not a valid BIOS device number
.SH SEE ALSO
.IR Fxattr (2)
.SH NOTES
Note that
.I Dlock
operates on BIOS devices, which may not always be in 1-1 correspondence
with GEMDOS drive letters. For this reason, to lock GEMDOS drive A:
(for example), the programmer should call
.I Fxattr
on the root directory of A: ("A:\e") and then use the
.I dev
field of the structure returned in order to determine the BIOS
device corresponding to the GEMDOS drive.
