.TH Flink 2 "MiNT Programmer's Manual" "Version 0.9" "Oct. 7, 1991"
.SH NAME
Flink \- create a new link to a file
.SH SYNOPSIS
.nf
LONG Flink( char *oldname, char *newname );
.fi
.SH DESCRIPTION
.I Flink
creates a new name (a "hard link") for the file currently named
.IR oldname .
If the
.I Flink
call is successful, then after the call the file may be referred to by
either name, and a call to
.I Fdelete
on either name will not affect access to the file through the other
name.
.I oldname
and
.I newname
must both refer to files on the same physical device. Note also that not
all file systems allow links.
.SH RETURNS
0 on success
.PP
EXDEV if
.I oldname
and
.I newname
refer to files on different physical devices
.PP
EINVFN if the file system does not allow hard links
.PP
EFILNF if the file named
.I oldname
does not currently exist
.SH "SEE ALSO"
.IR Frename (2),
.IR Fsymlink (2)
