.TH Freadlink 2 "MiNT Programmer's Manual" "Version 0.9" "Oct. 7, 1991"
.SH NAME
Freadlink \- determine contents of a symbolic link
.SH SYNOPSIS
.nf
LONG Freadlink( WORD bufsiz, char *buf, char *name );
.fi
.SH DESCRIPTION
.I Freadlink
determines what file the symbolic link
.I name
points to, i.e. what the first argument to the
.I Fsymlink
call that created
.I name
was. This 0-terminated string is placed in the memory region pointed
to by
.IR buf .
The total size of this region is given by
.IR bufsiz ;
this must be enough to hold the terminating 0.
.SH RETURNS
0 on success
.PP
ERANGE if the symbolic link contents could not fit in
.IR buf .
.PP
EFILNF if
.I name
is not found.
.PP
EACCDN if
.I name
is not the name of a symbolic link.
.PP
EINVFN if the file system containing
.I name
does not support symbolic links.
.SH "SEE ALSO"
.IR Fsymlink (2)
.SH BUGS
The Unix
.I readlink
call returns the number of bytes read on success, rather than 0.
