/*----------------------------------------------------------------------*/
/*                                                                      */
/* NDC-Demo in Turbo C                                                  */
/*                                                                      */
/* Luft nur mit GDOS bzw. NVDI korrekt !!                              */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/* - ffnen einer virtuellen WK im NDC-Modus                            */
/* - Ausgabe einiger grafischer Grundfunktionen                         */
/*                                                                      */
/*----------------------------------------------------------------------*/
/* letzte nderung: 8.4.91                                              */
/*----------------------------------------------------------------------*/ 
/* Typendefinitionen                                                    */
/*----------------------------------------------------------------------*/ 
#define  OK 0
#define  BLACK 1                       /* Farbe schwarz                 */
#define  TRANS 2                       /* Grafikmodus transparent       */
#define  CLIP_ON 1                     /* Clipping ein                  */
#define  MOUSE_DEV 1                   /* Maus als Eingabegert         */
#define  REQUEST 1                     /* Eingabemodus                  */
/*----------------------------------------------------------------------*/ 
/* Includes                                                             */
/*----------------------------------------------------------------------*/ 
#include <AES.H>
#include <VDI.H>
#include <TOS.H>                       /* fr andere Compiler osbind.h  */
/*----------------------------------------------------------------------*/    
/* Globale Variablen                                                    */
/*----------------------------------------------------------------------*/
int   contrl[12],
      intin[128],
      intout[128],
      ptsin[128],
      ptsout[128],
      work_in[11],
      work_out[57],
      handle;
/*----------------------------------------------------------------------*/    
/* Funktionsdeklarationen                                               */
/*----------------------------------------------------------------------*/
int   opnvwk(void);
void  demo(void);
/*----------------------------------------------------------------------*/    
/* ffnen einer virtuellen Workstation mit v_opnvwk                     */
/*----------------------------------------------------------------------*/
int opnvwk(void)
{
   register int index;
   int du;

   if( appl_init() != -1)
   {   
      for(index = 0; index < 10; work_in[index++] = 1);
      /*
      *  work_in[0]  = 1 ;Bildschirmtreiber in aktueller Auflsung
      *  work_in[1]  = 1 ;Linienstil       : durchgehend
      *  work_in[2]  = 1 ;Linienfarbe      : schwarz
      *  work_in[3]  = 1 ;Markertyp        : Punkt
      *  work_in[4]  = 1 ;Markerfarbe      : schwarz
      *  work_in[5]  = 1 ;Zeichensatznummer: Systemzeichensatz
      *  work_in[6]  = 1 ;Textfarbe        : schwarz
      *  work_in[9]  = 1 ;Fllmusterfarbe  : schwarz
      */
      work_in[7]  = 2;                 /* Flltyp: Muster               */
      work_in[8]  = 4;                 /* Musterindex                   */
      work_in[10] = 0;                 /* Koordinatenflag (NDC-System)  */
      
      handle = graf_handle(&du,&du,&du,&du);
      v_opnvwk(work_in,&handle,work_out); /* virtuelle Workstation ffnen */
   
      return(handle);                     /* 0: v_opnvwk fehlgeschlagen */ 
   }
   else return(0);                        /* appl_init fehlgeschlagen   */
}
/*----------------------------------------------------------------------*/ 
/* Demo                                                                 */
/*----------------------------------------------------------------------*/
void  demo(void)
{
   int   ch_wd,ch_ht,ce_wd,ce_ht,
         hor,ver,du;

   v_hide_c(handle);                   /* Maus aus                      */
   
   ptsin[0] = 0;                       /* xmin                          */
   ptsin[1] = 0;                       /* ymin                          */
   ptsin[2] = 32767;                   /* xmax                          */
   ptsin[3] = 32767;                   /* ymax                          */
   vs_clip(handle,CLIP_ON,ptsin);      /* Clipping ein                  */
   
   v_clrwk(handle);                    /* Bildschirm lschen            */

   vsf_perimeter(handle,1);            /* Umrandung an                  */
   vswr_mode(handle,TRANS);            /* Transparent-Modus             */
   
   ptsin[0] = 0;                       /* x1                            */
   ptsin[1] = 32767;                   /* y1                            */
   ptsin[2] = 5069;                    /* x2                            */
   ptsin[3] = 24657;                   /* y2                            */ 
   v_bar(handle,ptsin);                /* geflltes Rechteck            */
   
   ptsin[0] = 32767;                   /* x1                            */
   ptsin[1] = 0;                       /* y1                            */
   ptsin[2] = 27689;                   /* x2                            */
   ptsin[3] = 8110;                    /* y2                            */ 
   vr_recfl(handle,ptsin);       /* geflltes Rechteck ohne Umrandung   */

   ptsin[0] = 2000;                    /* x1                            */
   ptsin[1] = 500;                     /* y1                            */
   ptsin[2] = 7000;                    /* x2                            */
   ptsin[3] = 3500;                    /* y2                            */ 
   v_rbox(handle,ptsin);               /* Rechteck mit gerundeten Ecken */
   
   ptsin[0] = 100;                     /* x1                            */
   ptsin[1] = 100;                     /* y1                            */
   ptsin[2] = 5000;                    /* x2                            */
   ptsin[3] = 3000;                    /* y2                            */ 
   v_rfbox(handle,ptsin);  /* geflltes Rechteck mit gerundeten Ecken   */

   v_arc(handle,16383,16383,9000,10,3500);/* Kreisbogen                 */

   v_ellpie(handle,25000,25000,2000,   /* Ellipsenflchenausschnitt     */
                   3000,2600,3500); 

   ptsin[0] = 0;                       /* x1                            */
   ptsin[1] = 16383;                   /* y1                            */
   ptsin[2] = 32767;                   /* x2                            */
   ptsin[3] = 16383;                   /* y2                            */    
   v_pline(handle,2,ptsin);            /* Linie                         */

   ptsin[0] = 16383;                   /* x1                            */
   ptsin[1] = 0;                       /* y1                            */
   ptsin[2] = 16383;                   /* x2                            */
   ptsin[3] = 32767;                   /* y2                            */    
   v_pline(handle,2,ptsin);            /* Linie                         */

   vst_font(handle,1);                 /* Systemzeichensatz einstellen  */
   vst_color(handle,BLACK);            /* Textfarbe 1 (schwarz)         */
   vst_effects(handle,0);              /* keine Texteffekte             */
   vst_rotation(handle,900);           /* 90 Grad-Drehung               */
   vst_height(handle,1065,&ch_wd,&ch_ht,  /* Texthhe 1065              */
                           &ce_wd,&ce_ht);   
   vst_alignment(handle,0,0,&hor,&ver);   /* Text linksjustiert         */

   v_gtext(handle,16383,16383,"0123456789");
   
   vst_rotation(handle,0);             /* keine Textdrehung             */
   vst_height(handle,2130,&ch_wd,&ch_ht,  /* Texthhe 2130              */
                           &ce_wd,&ce_ht);   

   v_justified(handle,6000,10000,"NDC-Demo",20000,0,1);
   
   v_show_c(handle,0);                 /* Maus an                       */
   vsin_mode(handle,MOUSE_DEV,REQUEST);/* Mauseingaben abwarten         */
   vrq_locator(handle,0,0,&du,&du,&du);/* Maus positionieren und warten */
}
/*----------------------------------------------------------------------*/ 
/* Hauptprogramm                                                        */
/*----------------------------------------------------------------------*/ 
main(void)
{
   if( opnvwk() )    /* ffnen der virtuelle Workstation hat geklappt   */
   {
      demo();
      v_clsvwk(handle);             /* virtuelle Workstation schlieen  */
      appl_exit();
      return(OK);
   }
   else return(-1);
}
/*----------------------------------------------------------------------*/ 
/* That's it !!                                                         */
/*----------------------------------------------------------------------*/ 
