/*
**
**	Beispiel fr das Einbinden von Benutzerfunktionen in PCB-layout
**
**	Verwendung ist nur in Verbindung mit PCB-layout erlaubt!
**
**	Dipl.-Ing. Thomas Praefcke                             04.02.90
**
**	ACHTUNG: Die Funktionen funktionieren zur Zeit noch nicht auf
**            dem TT. Hierfr wird es Ende September 1991 die ntigen
**            nderungen geben.
*/


/*	KURZBESCHREIBUNG

	Die Details knnen dem Beispielprogramm entnommen werden.

	Hier wird nur der wesentliche Zusammenhang beschrieben!
	
	Es wurde hufig der Wunsch nach speziellen Funktionen geuert.
	Da diese Funktionen aber nur von manchen Anwendern von Zeit zu Zeit
	bentigt werden, verfgt PCB-layout jetzt ber eine Schnittstelle,
	durch die eine Ergnzung der vorhandenen Funktionen mglich ist.
	Dafr mu ein Programm gestartet werden, welches resident im Speicher
	steht (z.B. im Auto-Ordner) und in welchem sich die gewnschten
	Funktionen befinden. PCB-layout prft beim Programmstart, ob ein ent-
	sprechendes Programm vorhanden ist und richtet ggf. ein zustzliches
	Men ein.

	Der Test auf ein vorhandenes Programm erfolgt durch den Aufruf von
	Xbios(3762, 0). Ohne Zusatzprogramm gibt das Programm den Wert 3762 zu-
	rck, da diese Funktion nicht vorhanden ist. Ein eventuell vorhandenes
	Programm fngt diesen Aufruf ab und gibt die Kennung 91165 zurck.
	Durch den Aufruf Xbios(3762, 1) wird ein Zeiger auf die Parameter
	der vorhanden Funktionen abgefragt. Diese knnen dann von PCB-layout
	aufgerufen werden. Dabei wird im Register A0 ein Zeiger auf den Para-
	meterblock PCBADR bergeben. Bitte beachten Sie, da diese bergebenen
	Parameter nicht verndert werden drfen!
*/


#include <aes.h>				/* AES-Definitionen */
#include <vdi.h>				/* VDI-Definitionen */
#include <tos.h>				/* TOS-Aufrufe */

#define NULL        ( ( void * ) 0L )

/*
**	Die folgenden Definitionen sollten verwendet werden, da es in Zukunft
**	nderungen geben kann! Verwenden Sie deshalb auch mglichst meine
**	Grunfunktionen.
*/

#define P_LEER		0			/* Platinenelemente */
#define P_LOET		4
#define P_BLOCK	8
#define P_HBAHN	12
#define P_VBAHN	16
#define P_LOECK	20
#define P_ROECK	24
#define P_LUECK	28
#define P_RUECK	32
#define P_DOECK	36
#define P_DUECK	40
#define P_KREUZ	44
#define P_RKREUZ	48
#define P_LKREUZ	52
#define P_OKREUZ	56
#define P_UKREUZ	60
#define P_SPERR	64
#define P_DURCH	68
#define P_GLOCH	72
#define P_EINS		76	/* wird demnchst nicht mehr untersttzt */
#define P_9LOECK	84
#define P_9ROECK	88
#define P_9LUECK	92
#define P_9RUECK	96
#define P_DHBAHN	100
#define P_DVBAHN	104
#define P_LOKEIL	108
#define P_ROKEIL	112
#define P_LUKEIL	116
#define P_RUKEIL	120

#define PS_LEER	128			/* selektierte Platinenelemente */
#define PS_LOET	-124
#define PS_BLOCK	-120
#define PS_HBAHN	-116
#define PS_VBAHN	-112
#define PS_LOECK	-108
#define PS_ROECK	-104
#define PS_LUECK	-100
#define PS_RUECK	-96
#define PS_DOECK	-92
#define PS_DUECK	-88
#define PS_KREUZ	-84
#define PS_LKREUZ	-80
#define PS_RKREUZ	-76
#define PS_OKREUZ	-72
#define PS_UKREUZ	-68
#define PS_SPERR	-64
#define PS_DURCH	-60
#define PS_GLOCH	-56
#define PS_EINS	-52	/* wird demnchst nicht mehr untersttzt */
#define PS_9LOECK	-44
#define PS_9ROECK	-40
#define PS_9LUECK	-36
#define PS_9RUECK	-32
#define PS_DHBAHN	-28
#define PS_DVBAHN	-24
#define PS_LOKEIL	-20
#define PS_ROKEIL	-16
#define PS_LUKEIL	-12
#define PS_RUKEIL	-8

#define PL_SIZE	0xAA00L		/* Gre einer Platinenseite */
#define ZEILE		256			/* Abstand von zwei Zeilen */
#define PL_MASK	124			/* Maske fuer Platinenelement 0x7C */
#define SELEKT		128			/* selektiertes Element */


typedef struct
{	long	top;
	long	left;
	long	bottom;
	long	right;
} LRECT;

/* Definition fr einen Vektor - String */

typedef struct
{	int		flag;		/* Flags: Bit 0->belegt ->selektiert */
	LRECT	rahmen;		/* Rahmen in dem sich der Text befindet */
	long		xst;			/* x-Koordinate vom ersten Zeichenmittelpunkt*/
	long		yst;			/* y-Koordinate vom ersten Zeichenmittelpunkt*/
	int		layer;		/* Ebenen-Nummer (0 oder 1) */
	int		font;		/* Fontnummer */
	int		hoch;		/* Hhe in 1/10 mm */
	int		breit;		/* Breite in 1/10 mm */
	int		dick;		/* Stifdicke in 1/100 mm */
	int		richt;		/* Richtung des Textes */
	char		txt[31];		/* Text */
}	VECT_TXT;

/*
**	Ein Zeiger auf die folgenden Paramater wir den Funktionen bergeben
*/

typedef struct
{	long		magic1;			/* 1. Kennummer */
	long		magic2;			/* 2. Kennummer */

	char		**platine;		/* Start des Platinenfeldes */
	long		*side;			/* Offset der aktiven Seite vom Feldbeginn*/
	int		*plt_breit;		/* Breite der Platine */
	int		*plt_hoch;		/* Hhe der Platine */
	int		*plt_xoffs;		/* X-Offset des gezeigten Platinenbereiches */
	int		*plt_yoffs;		/* Y-Offset des gezeigten Platinenbereiches */
	GRECT	*fl_work;			/* Platinenflche */

	char		*puffer;			/* Start  des Zwischenpuffers */
	int		*puf_breit;		/* Breite des Zwischenpuffers */
	int		*puf_hoch;		/* Hhe des Zwischenpuffers */

	VECT_TXT	***pptxtobj;		/* Pointertabelle fr die Textobjekte */
	VECT_TXT	**ptxtobj;		/* Pointer auf Start der Textobjekte */
	int		*txt_max;			/* maximale Anzahl der Textobjekte */

	void 	(*fscreen)(void);	/* gesamten Bildschirm neu aufbauen */
	void		(*draw_ob)(OBJECT *tree, int start);	/* Dialog zeichnen */
	int 		(*form_do)(OBJECT *tree, int start);	/* Dialog fhren */
} PCBADR;

typedef struct
{	char	name[20];			/* Name fr den Meneintrag (max 18 Zeichen) */
	int 	(*funkt)();		/* Adresse der Funktion */
	int	undo;			/* Wenn TRUE vor Aufruf Zustand fr UNDO merken */ 
} FKT;

typedef struct
{	int		anzahl;		/* Anzahl der Funktionen */
	int		version;		/* Version des Treibers */
	char		info[8][40];	/* Text fr die Info-Box */
	FKT		fkt[6];		/* Funktionsdefinitionen */
} FKT_PARA;

/*	Zusatzfunktionen */

int	sperren(PCBADR *pcb_para);
int	l_maske(PCBADR *pcb_para);


/*
**	Durch diese Struktur wird PCB-layout ber die Zusatzprogramme
**	informiert.
*/

FKT_PARA	funkt =	{	2, 0,
					"Dipl.-Ing. Thomas Praefcke",
					"Computer Hard- und Software",
					"Holzvogtkamp 55",
					"D-2302 Flintbek",
					"Tel. (04347)531",
					"Dies ist ein Beispielprogramm",
					"",
					"",
					{	"  Sperren weg",	sperren,	1 ,
						"  Ltstopmaske",	l_maske,	1 ,
						"",				NULL,	0 ,
						"",				NULL,	0 ,
						"",				NULL,	0 ,
						"",				NULL,	0 
					}
				};



PCBADR	*pcbadr;		/* wird von Unterfunktionen bentigt */



/*
**	ermittelt das Feldelement
*/

int	board_ret(int x_pos, int y_pos, long side)

{	return(*(*(pcbadr->platine)+ side + (long)ZEILE * y_pos + x_pos));
}


/*
**	schreibt das Feldelement ohne den neuen Inhalt anzuzeigen
*/

void	board_set(int x_pos, int y_pos, long side, char status)

{	*(*(pcbadr->platine)+ side + (long)ZEILE * y_pos + x_pos) = status;
}


/*	hier beginnen die beiden Zusatzfunktionen */

/*
**	alle Sperren lschen
*/

int	sperren(PCBADR *para)

{	char	el;
	int	x, y;

	pcbadr = para;		/* Zeiger wird in anderen Funktionen verwendet */
	for (y = 1; y < *(para->plt_hoch); y++)				/* alle Zeilen */
		for (x = 1; x < *(para->plt_breit); x++)		/* alle Spalten  */
		{	el = board_ret(x, y, 0L) & PL_MASK;		/* Ltseite */
			if (el == P_SPERR)
				board_set(x, y, 0L, P_LEER);
			el = board_ret(x, y, PL_SIZE) & PL_MASK;	/* Bauteilseite */
			if (el == P_SPERR)
				board_set(x, y, PL_SIZE, P_LEER);
		}
	(*(*para->fscreen))();
	return (0);
}

/*
**	Eine Ltstopmaske erstellen
*/

int	l_maske(PCBADR *para)

{	char	el;
	int	x, y;

	pcbadr = para;		/* Zeiger wird in anderen Funktionen verwendet */
	for (y = 1; y < *(para->plt_hoch); y++)				/* alle Zeilen */
		for (x = 1; x < *(para->plt_breit); x++)		/* alle Spalten  */
		{	el = board_ret(x, y, 0L) & PL_MASK;		/* Ltseite */
			if (el)
				if (	el != P_LOET   && el != P_GLOCH   &&
					el != P_DHBAHN && el != P_DVBAHN)
					board_set(x, y, 0L, P_SPERR);
			el = board_ret(x, y, PL_SIZE) & PL_MASK;	/* Bauteilseite */
			if (el)
				if (	el != P_LOET   && el != P_GLOCH   &&
					el != P_DHBAHN && el != P_DVBAHN)
					board_set(x, y, PL_SIZE, P_SPERR);
		}
	(*(*para->fscreen))();
	return (0);
}



