; *********************************
; *                               *
; *            LFRAM              *
; *                               *
; * Testet, ob die CPU erweiterte *
; * Exception-Frames schreibt und *
; * setzt _longframe entsprechend *
; *                               *
; * L. Prner 2.1.1992           *
; *                               *
; *  Sprache: 680x0-Assembler     *
; * Compiler: TurboAss 1.76       *
; *                               *
; *********************************

; Vektoren

ILL             EQU $10

; Systemvariablen

_longframe      EQU $059E

                TEXT

                pea     tst_lfram(pc)
                move.w  #$26,-(sp)
                trap    #$0E            ;Supexec()
                addq.l  #$06,sp

                tst.w   d0
                beq.s   noset

                pea     gesetzt(pc)

ausgabe:
                move.w  #$09,-(sp)
                trap    #$01
                addq.l  #$06,sp

                clr.w   -(sp)
                trap    #$01            ;Pterm0()

noset:
                pea     geloescht(pc)
                bra.s   ausgabe

tst_lfram:
                move    sr,d1           ;D1 = SR
                ori     #$0700,sr       ;IPL 7
                movea.l ILL.w,a0        ;Rette Illegal-Vektor
                move.l  #new_illegal,ILL.w
                move.l  sp,d0           ;Rette Stack nach D0

                illegal

; Andere Assembler mssen stattdessen
;
;               DC.W $4AFC
;
; einfgen.

new_illegal:
                move.l  a0,ILL.w        ;Vektor wiederherstellen
                exg     sp,d0           ;Stack wiederherstellen
                addq.l  #$06,d0         ;68000er-Frame
                sub.l   sp,d0
                move.w  d0,_longframe.w
                move    d1,sr           ;IPL senken
                rts

                DATA
gesetzt:        DC.B '_longframe set.',$0A,$0D,$00
                EVEN

geloescht:      DC.B '_longframe cleared.',$0A,$0D,$00

                END
