/*														*/
/*	Binding fr zustzliche VDI-Funktionen */
/*														*/

#include <vdi.h>
#include <portab.h>

/* Funktionsprototypen */
void  v_opnbm( WORD *work_in, MFDB *bitmap, WORD *handle, WORD *work_out );
void  v_clsbm( WORD handle );
void  vq_scrninfo( WORD handle, WORD *work_out );
void	_v_bez( WORD handle, WORD count, WORD *xyarr,
				 BYTE *bezarr, WORD *extent, WORD *totpts,
				 WORD *totmoves );
void	_v_bez_fill( WORD handle, WORD count, WORD *xyarr,
				 BYTE *bezarr, WORD *extent, WORD *totpts,
				 WORD *totmoves );

WORD	contrl[12],
		intin[128],
		intout[128],
		ptsin[128],
		ptsout[128];

WORD	*pb[5] = { contrl, intin, ptsin, intout, ptsout };

/* OPEN BITMAP (VDI 100, 1) */
void  v_opnbm( WORD *work_in, MFDB *bitmap, WORD *handle, WORD *work_out )
{
   pb[1] = work_in;
   pb[3] = work_out;
   pb[4] = work_out + 45;

   contrl[0] = 100;
   contrl[1] = 0;
   contrl[3] = 20;
   contrl[5] = 1;
   *((ULONG *)(&contrl[7])) = (ULONG) bitmap;

   vdi( (VDIPB *) pb );

   *handle = contrl[6];
   pb[1] = intin;
   pb[3] = intout;
   pb[4] = ptsout;
}

/* CLOSE BITMAP (VDI 101, 1)  */
void  v_clsbm( WORD handle )
{
   contrl[0] = 101;
   contrl[1] = 0;
   contrl[3] = 0;
   contrl[5] = 1;
   contrl[6] = handle;
   vdi( (VDIPB *) pb );
}

/* VQ_SCRNINFO( 102, 1 )   */
void  vq_scrninfo( WORD handle, WORD *work_out )
{
   pb[3] = work_out;

   intin[0] = 2;
   contrl[0] = 102;
   contrl[1] = 0;
   contrl[3]  = 1;
   contrl[5] = 1;
   contrl[6] = handle;
   
   vdi( (VDIPB *) pb );

   pb[3] = intout;
}

/* V_BEZ( 6, 13 )   */
void	_v_bez( WORD handle, WORD count, WORD *xyarr,
				 BYTE *bezarr, WORD *extent, WORD *totpts,
				 WORD *totmoves )
{
	BYTE	*tmp;
	WORD	i;
	
	pb[2] = xyarr;
	pb[4] = extent;
	
	contrl[0] = 6;
	contrl[1] = count;
	contrl[3] = (count+1)>>1;
	contrl[5] = 13;
	contrl[6] = handle;
	
	tmp = (BYTE *) intin;
	
	for( i = 0; i < count; i += 2, bezarr += 2 )
	{
		*tmp++ = bezarr[1];
		*tmp++ = bezarr[0];
	}
	
	vdi( (VDIPB *) pb );
	
	*totpts = intout[0];
	*totmoves = intout[1];
	
	pb[2] = ptsin;
	pb[4] = ptsout;
}

/* V_BEZ_FILL( 9, 13 )   */
void	_v_bez_fill( WORD handle, WORD count, WORD *xyarr,
				 BYTE *bezarr, WORD *extent, WORD *totpts,
				 WORD *totmoves )
{
	BYTE	*tmp;
	WORD	i;
	
	pb[2] = xyarr;
	pb[4] = extent;
	
	contrl[0] = 9;
	contrl[1] = count;
	contrl[3] = (count+1)>>1;
	contrl[5] = 13;
	contrl[6] = handle;
	
	tmp = (BYTE *) intin;
	
	for( i = 0; i < count; i += 2, bezarr += 2 )
	{
		*tmp++ = bezarr[1];
		*tmp++ = bezarr[0];
	}
	
	vdi( (VDIPB *) pb );
	
	*totpts = intout[0];
	*totmoves = intout[1];
	
	pb[2] = ptsin;
	pb[4] = ptsout;
}