###########################################################################
#	Routine zur Erzeugung und Verarbeitung von Variable Length	  #
#	          Numbers, (C)1993 Stephan M. Sprenger			  #
#		geschrieben mit BORLAND PURE C Assembler		  #
###########################################################################


.TEXT


		bra.s		start		 ; zum Programmstart
		dc.l		0		 ; Opcode-Feld
		dc.l		0		 ; Feld fr die Zahl

start:		lea.l		-10(pc),a0	 ; Startadresse in a0
		move.l		4(a0),d1	 ; Wert in d1
		tst.b		(a0)		 ; Opcode feststellen
		beq.s		vln_to_dez	 ; Opcode=0, dann VLN->DEZ

#################### Konvertierung Dezimalzahl --> VLN #####################

dez_to_vln:	cmp.l		#$fffffff,d1	 ; Test auf Maximalwert
		bhi.s		error1		 ; grer?, dann Fehler

		moveq.l		#3,d0		 ; Zhler fr Bytes
		
loop1:		lsl.l		#1,d1		 ; Langwort shiften
		lsr.b		#1,d1		 ; Lo-Byte zurck
		bclr		#7,d1		 ; Bit 7 lschen
		cmp		#3,d0		 ; erstes Byte?
		beq.s		weiter		 ; dann weiter
		tst.b		d1		 ; Byte ist Null?
		beq.s		weiter		 ; dann nix setzen..
		bset		#7,d1		 ; ..sonst Bit 7 setzen
weiter:		move.b		d1,d2 		 ; errechnetes Byte in d2
		ror.l		#8,d2		 ; d2 nach rechts rotieren
		lsr.l		#8,d1		 ; d1 um 1 Byte weiter
		dbra		d0,loop1	 ; zum Schleifenanfang

		btst		#23,d2		 ; Bit 23 gesetzt?
		beq.s		higher		 ; nicht gesetzt, dann weiter
		bset		#15,d2		 ; sonst Bit 15 setzen

higher:		btst		#31,d2		 ; Bit 31 gesetzt?
		beq.s		ende		 ; nein, dann fertig
		ori.l		#$808000,d2	 ; doch, dann Bits 23 und 15 setzen

ende:		move.l		d2,4(a0)	 ; errechneten Wert in Feld
		moveq.l		#0,d0		 ; kein Fehler (d0=0)
		rts				 ; Programmende

error1:		move.l		#$fffffff7,4(a0) ; Maximalwert zurckliefern
		moveq.l		#-1,d0	 	 ; -1 fr Fehler
		rts				 ; Programmende

#################### Konvertierung VLN --> Dezimalzahl #####################

vln_to_dez:	cmp.l		#$fffffff7,d1	 ; Test auf Maximalwert
		bhi.s		error2		 ; grer? dann Fehler

		moveq.l		#3,d0		 ; Zhler fr Bytes
		
loop2:		move.b		d1,d2		 ; Lo-Byte nach d2 kopieren
		ror.l		#7,d2		 ; um 7 Bits rotieren
		lsr.l		#8,d1		 ; d1 um 8 Bits shiften
		dbra		d0,loop2	 ; und nochmal...
		ror.l		#4,d2		 ; 4 Bits brig..
		andi.l		#$0fffffff,d2	 ; ..und auf 0 setzen
		bra.s		ende		 ; zum Programmende

error2:		move.l		#$fffffff,4(a0)	 ; Maximalwert zurckliefern
		moveq.l		#-1,d0		 ; -1 fr Fehler
		rts				 ; Programm beenden


.END