;midixfer (ST version)
;by Stephen K Mulrine
;receive a Spectrum program (plus header) through MIDI IN
;and save in current directory
MCTRL	equ	$fffffc04
MDATA	equ	$fffffc06
PAL	equ	$ffff8240
	lea	HIDE(pc),a1
	bsr	disp		;clear screen and hide annoying cursor
	move.l	#0,-(a7)
	move.w	#$20,-(a7)
	trap	#1		;supervisor mode
	addq.w	#6,a7
	move.w	PAL.w,d1
	move.w	d1,COLOUR	;store old screen colour
	move.w	#$77,PAL.w	;turn screen cyan
	move.b	#21,MCTRL.w	;keep ST's hands off ACIA
	clr.l	d1
	clr.l	d2
	bsr.s	midird		;get LSB of file length
	move.b	d1,d2
	bsr.s	midird		;get MSB of file length
	asl.w	#8,d1
	add.w	d1,d2		;put them together
	move.l	d2,LEN
	subi.w	#1,d2		;subtract one for DBRA
	lea	BUF(pc),a1
loop	bsr.s	midird		;see a byte
	move.b	d1,(a1)+	;and pick it up
	dbra	d2,loop		;all day long you'll have good luck
	move.b	#131,MCTRL.w	;give ACIA back to ST
	move.w	COLOUR,d1
	move.w	d1,PAL.w	;restore screen colour
	move.l	d0,-(a7)
	move.w	#$20,-(a7)
	trap	#1		;back to user mode
	addq.w	#6,a7
	bsr.s	save
	lea	UNHIDE(pc),a1
	bsr.s	disp		;restore cursor
	move.w	#0,-(a7)
	trap	#1		;and exit

midird	eori.w	#$0777,PAL.w	;invert screen colour for laffs
	move.b	MCTRL.w,d1
	btst.l	#0,d1		;is there a byte to be read?
	beq.s	midird
	move.b	MDATA.w,d1	;read it
	move.w	d1,PAL.w	;change screen colour for more laffs
	rts

save	lea	BUF(pc),a1
	addq.l	#1,a1		;first byte of data is file type
	lea	FNAME(pc),a2
	move.w	#9,d1
loop2	move.b	(a1)+,(a2)+	;copy next 10 bytes for filename
	dbra	d1,loop2
	move.b	#0,(a2)
	move.w	#0,-(a7)
	pea	FNAME(pc)
	move.w	#$3c,-(a7)
	trap	#1		;open the file for writing
	addq.l	#8,a7
	tst.w	d0		;did something go horribly wrong?
	bmi.s	err		;kaboom
	move.w	d0,d6
	pea	BUF(pc)
	move.l	LEN,d2
	move.l	d2,-(a7)
	move.w	d6,-(a7)
	move.w	#$40,-(a7)
	trap	#1		;save the whole block of data
	add.l	#12,a7
	move.w	d6,-(a7)
	move.w	#$3e,-(a7)
	trap	#1		;close the file
	addq.l	#4,a7
	rts

err	lea	ERMS(pc),a1
disp	move.l	a1,-(a7)
	move.w	#9,-(a7)
	trap	#1		;print something
	addq.l	#6,a7
	rts

	section	data
HIDE	dc.b	27,"E",27,"f",0
UNHIDE	dc.b	27,"e",0
ERMS	dc.b	27,"EFile write error",13,0
	even

	section	bss
FNAME	ds.b	12
LEN	ds.l	1
COLOUR	ds.w	1
BUF	ds.b	65536
