fmt@
  ----------------------------------------------------------------------------
                   1  :  I  N  T  R  O  D  U  C  T  I  O  N 
  ----------------------------------------------------------------------------

  The motivation behind Family Roots came from my Father who,  in his  pursuit 
  to  complete  the  Skellern  dynasty,   had  amassed  pages  and  pages   of 
  information.  Sorting  and organising this information was proving to  be  a 
  very  difficult and time consuming task.  Much of the information had   been 
  duplicated, therefore a means of correcting this and resolving several other 
  problems was required.  Also,  a new 'find' could result in major changes to 
  the  tree  structure  which would in turn demand a  total  redraw,  again  a 
  lengthy job. 

  With  these  basic  problems in mind I started to  plan  Family  Roots.  The  
  program had to be graphically based as opposed to being a mere database.  It 
  required  a powerful search and match function,  a quick and easy method  of 
  making changes to the graphic structure and,  most importantly, it had to be 
  relatively hassle free and easy to use. 

  The  basic concept behind Family Roots is the work screen.  Imagine  if  you 
  can,  a huge sheet of graph paper 20448 units wide by 6400 units deep,  with 
  your family tree on it.  Your television or monitor acts as a window to this 
  huge  grid.  You  can view it in its entirety,  zoom in and out and  pan  or 
  scroll  as  necessary.  The graphics can be manipulated and  reorganised  as 
  changes occur. Part or all can be sent to the printer, giving a hard copy in 
  seconds and of course,  everything can be saved to disk to be reloaded at  a 
  later date and displayed exactly as you left it. 

  I  don't  believe  it is sensible to rely 100% on  computers  for  our  data  
  storage.  Data can become corrupted,  lost or damaged.  Formats,  needs  and 
  computers change,  thus causing compatibility problems. Also, in the case of 
  genealogy,  it  is  impractical  for  the computer to  take  charge  of  all 
  information  storage.  Some  documents like birth  and  death  certificates, 
  letters,  deeds,  church records etc;  are best kept in their original forms 
  rather  than being digitised onto magnetic media.  So,  with this  in  mind, 
  Family Roots is designed to work in parallel with a document filing  system. 
  An  option  exists  within the program to output the whole  family  tree  in 
  document form,  complete with coded and listed relationships,  which in turn 
  gives a hard copy for security purposes. 

  As it stands, the capacity of Family Roots is limited only by the workscreen 
  size  and  the  available  memory  in  your  computer.  The  workscreen  can 
  practically  accomodate 270,000 individuals.  To achieve this figure  within 
  your family tree would probably require hundreds of years of work.  You will 
  find that 1000 individuals with fairly packed database cards requires  about 
  100k of memory. Memory upgrades are inexpensive and easily installed, so any 
  worries in this area are unnecessary. 

  Family  Roots works in high and medium resolutions.  I personally  recommend 
  that  serious users obtain a high resolution monitor.  The  resulting  crisp 
  graphics give greater accuracy, less eye strain and better printer output.

  Family  Roots comes on a single sided floppy disk.  In addition to the  main 
  program,   four   other  files  are  supplied.   These  are   ROOT_HIGH.RSC, 
  ROOT_LOW.RSC, DEMO.FMT and FMT_INFO.RSC.

  DEMO.FMT holds the demonstration family tree which can be loaded and viewed. 
  This is merely a demonstration file, its contents do not claim to be correct 
  or accurate and any similarity to any persons, living or deceased, is purely 
  coincidental and totally unintended. 

  FMT_INFO.RSC contains this manual and the other two files hold the high  and 
  low  resolution loading screens.  All  three resource files can be left  off 
  your working disks if required.  The  program works happily without them and 
  leaves you with an extra 60k of free memory.

  Family  Roots  is  the  result  of 30 months  of  hard  work.  It  has  been 
  extensively tested and debugged, therefore should work without any problems.

  Thanks  must  go  to the following for their help and  assistance  with  the 
  creation of Family Roots.
                                 MUM and DAD
                                 STEVE DELANEY
                                 IRENE LAMB
                                 BOB CHEWTER
                                 MARC YOUNG

  Finally,  I  would like to wish you luck and hope that this  program  proves 
  itself  to  be a helpful and useful assistant with your research  into  your 
  family roots. 

                                                               Chris Skellern.
















  WARRANTY:  Floppyshop guarantees this disk to be free of defects in material 
  and  workmanship  under  normal use for a period of three  months  from  the 
  purchase date.  This warranty expressly excludes damage by computer viruses, 
  something which cannot happen if you keep the master disk write protected at 
  all  times.  We  recommend  that you make a backup copy  of  the  disk  upon 
  purchase  and  keep the master disk in a safe place.  As an  extra  security 
  measure,  we  suggest  that you purchase a good  virus  killer  program.  We 
  recommend  The Professional Virus Killer which is available from  Floppyshop 
  for 6.95.

  DISCLAIMER:  Although  Family  Roots has been  extensively  tested,  neither 
  Floppyshop nor Chris Skellern may be held liable for any damage caused as  a 
  direct  or indirect result of using or misusing this program.  No  warranty, 
  implied or otherwise, is given with respect to the program being fit for any 
  particular purpose.
@
  ----------------------------------------------------------------------------
                    2  :  F  I  R  S  T     S  T  E  P  S 
  ----------------------------------------------------------------------------

  This chapter deals with the first steps in using the Family Roots   program. 
  Obviously you have loaded the program and found the preference screen, hence 
  this information section. Now go back to the preference screen and click the 
  mouse on the SCREEN icon.

  The program will now be displaying the Family Roots workscreen.  This is the 
  area  where you build and modify your growing family tree.  We have set  the 
  demo  file  to auto load so you are now viewing a  fictitious  family  tree, 
  created  to  give you an idea how the program works.  Play around  with  the 
  display  screen  as much as you wish,  to familiarise yourself  with  Family 
  Roots.  Now  select  the 'P' icon to return you to the  preferences  screen, 
  followed by the 'CLEAR' icon, to remove the demo file from memory. Now click 
  the SCREEN icon again and you will return to the workscreen. As you can see, 
  it is empty so let's create an individual.

  Select 'N' from the screen menu and a rectangular box will appear,  this box 
  represents one individual. To position it on the workscreen, simply move the 
  mouse and click the left button when ready.  You can change its  position at 
  any  time  by moving the mouse cursor over the rectangle and with  the  left 
  button held down, reposition as required. 

  Now let's give our individual a personality,  first a name.  Move the  mouse 
  cursor  over  the  rectangle and click the  right  mouse  button  once.  The 
  database file for this individual is now viewable.  The cursor is positioned 
  at the top of the screen opposite 'Forename'.  Type in any name,  then press 
  RETURN. 

  As  you can see our rectangle now has a name.  Return again to the  database 
  display and move the edit cursor down to the 'Birth' column.  Now type in  a 
  date  using the slash character '/' to seperate the numbers  eg:  2/12/1932. 
  Press RETURN and the individual rectangle now displays the birth date. 

  Now,  let's  give  our individual a marriage partner.  As  before,  go  into 
  his/her  database  and this time select the MARRIAGE icon  with  the  mouse. 
  Because no current marriages exist as yet,  the program invites us to create 
  one.  Select yes and a partner database appears. Position the cursor next to 
  the  'Forename' field and as before,  insert some text.  Press RETURN to  go 
  back  to  the  individual.  You will notice from  his/her  database  that  a 
  marriage partner has been created.  Selecting RETURN again will display  the 
  workscreen and hopefully the marriage partner's forename is viewable. 

  Our individual can be linked with others to form relationships.  The program 
  will display all the necessary interconnecting tree structure automatically. 

  The whole work screen can be treated as a kind of workbench.  Small sections 
  of the tree can be worked on at a time,  then linked into the main structure 
  when completed. 

  Well  that's  the  basic theory behind Family  Roots,  the  graphic  display  
  integrated with the database. You must now read the other chapters regarding 
  relationships etc. 

  Before embarking on any serious work, I would recommend that you re-load the 
  demonstration  file from the disk and experiment with the graphic  and  text  
  manipulation functions.  To load this file,  first return to the preferences 
  screen by selecting 'P' from the menu.  With the text cursor positioned next 
  to Filename,  enter the text 'DEMO' and then select LOAD with the mouse. The 
  program  will  warn  you  about  losing  your  work  so  far,  since  it  is 
  unimportant, just select LOAD again. 
@
  ----------------------------------------------------------------------------
                       3  :  P  A  P  E  R  W  O  R  K 
  ----------------------------------------------------------------------------

  It is essential to establish a document filing system to work in conjunction 
  with the computer program.  The easiest and cheapest method of starting this 
  is the A4 ring bound file. 

  Each individual entry on the family tree has its own personal identification 
  code.  These codes start at AA00,  increasing to AA99 and then continue with 
  AB00 etc.  Once an identification code has been allocated,  it can never  be 
  used again, even if an individual is deleted from the tree. 

  So,  should you collect some letters,  photographs, birth/death certificates 
  etc,  it's  a simple matter of punching 2 holes and storing them within  the 
  binder.  You  must of course divide the collected information with blank  A4 
  sheets  or  the  special  card dividers.  The  identification  code  of  the 
  individual  can  be  written onto this divider,  which  is  then  placed  in 
  sequential order.  There is no need to have a divider for every entry within 
  the family tree,  since many would remain forever empty,  but as long as the 
  dividers are kept in order, any gaps between the ID codes means no paperwork 
  is available. 

  The  identification  code can be found at the top right hand  corner  of  an 
  individual's entry in the database.
@
  ----------------------------------------------------------------------------
              4  :  D  I  S  K  S     A  N  D     F  I  L  E  S 
  ----------------------------------------------------------------------------

  The  first thing to do is to make a backup copy of the Family  Roots  master 
  disk.

  Next,  you need 4 blank formatted disks for each family tree created.  Label 
  each of these with the family name and then on 2 of the disks write  'MASTER 
  1' and 'MASTER 2'. On the other 2, write 'WORKING 1'  and 'WORKING 2'. The 2 
  master  disks should be stored seperately from the working  disks.  Under  a 
  wardrobe  or  at the back of a sock drawer are good places  to  keep  these. 
  Remember, should a thief break into your home and steal your computer, it is 
  highly likely that he/she will take all your software as well. Computers and 
  hardware  are  replaceable  but years of hard detective  work  tracing  your 
  ancestors are not! 

  The  2  working  disks  are  the ones  you  use  alternately  to  save  your 
  progressing  work.  You must copy the Family Roots program to each in  turn, 
  along with any Desktop file required. 

  Depending on how long you spend at the program will decide on how frequently 
  you  need to save the file data.  Roughly speaking,  once every hour  should 
  suffice.  When you have saved your work, switch the 2 disks  over so that on 
  the next 'save',  the other disk has the most up to date file.  This way you 
  are  always  guaranteed to hold onto your data.  At the end of the  day  (or 
  session),  save your work to one of the master disks, replace it at the back 
  of the sock drawer and switch back to your work disks, ready for next time. 

  An autoload function has been incorporated into the program so that the user 
  can fully exploit the Desktop's Auto folder.  With the Family Roots  program 
  installed within an Auto folder (as it is on the distribution disk) and  the 
  autoload  icon set to ON,  upon boot up,  the computer will load the  Family 
  Roots  program which will then proceed to load your work file  and  finally, 
  set  the  screen display at exactly the zoom and position in  which  it  was 
  left. 
@
  --------------------------------------------------------------------------------
                    5  :  P  R  E  F  E  R  E  N  C  E  S 
  --------------------------------------------------------------------------------

  This is the program's interface with the outside world.  Files can be loaded 
  and saved, graphics can be printed, display preferences selected and certain 
  fields defined. 

  All  preference settings are saved and loaded automatically as part  of  the 
  tree  file. 

  MEMORY. 

  The memory variables displayed at the top of the screen show the size of the 
  current family tree file and the total free bytes available within memory. 

  FIELD DISPLAY. 

  Field Display allows you to change the field text from black to light grey. 

  TEXT CASE. 

  This  control allows either upper or lower case to be selected.  Due to  the 
  nature of the Family Roots text storage system, case mixing is not possible. 

  TEXT DISPLAY. 

  With this function you can switch between inversed or normal text strings.

  ID FLAGS. 

  The ID flags are included within each individual's database as a  convenient 
  means of assigning the said individual to a yes or no rule or statement. The 
  6 ID flags labelled 'A'-'F' have no effect within the program as  such,  but 
  represent in simple terms a row of on/off switches.  What each switch  means 
  is decided by yourself.  For example,  I may wish to assign flag 'A' to  the 
  statement 'not tree linked'.  Should I then find any individual with his/her 
  ID  'A' flag inversed,  I instantly know that this person does not  have  an 
  established  place  within  the tree.  This may  not  sound  very  important 
  initially,  but  remember  the ID flags can all be used  within  the  search 
  function. Going back to my example, it would now become an easy task to find 
  a list of unestablished individuals. 

  The  6  field strings on the preference screen are there simply for  you  to 
  note and remember which flag does what. They have no other function. 

  DEFINABLE FIELDS. 

  Three  fields  have been left free for the user himself to  define.  One  of 
  these  must be used as a date.  You can define their names from  within  the 
  preference  screen.  Simply  type  in  your  desired  names  and  they  will 
  automatically appear on the individual's database screen. 

  FILENAME. 

  Enter here the name under which you wish to save your data file. 

  AUTOLOAD. 

  This  allows the automatic load and go function to operate,  set to  ON  for  
  instant loading immediately after program execution. 

  DRIVE. 

  Set  the drive from which you wish to run Family Roots.  Single drive  users 
  should leave it set to A. 

  ROOTS. 

  This function displays the loading screen.

  TIDY. 

  In  an  effort  to save memory and to exploit the fact that  many  names  of  
  people,  towns etc; will be duplicated between individuals, a special system 
  of  text  storage is used.  'LONDON' or 'JOHN' may be used  several  hundred 
  times  within a large family tree but the actual text is only  stored  once. 
  However,   during  a  work  session  many  names  will  become  deleted  and 
  unrequired.  Tidy  is a little routine which scans through the text  storage 
  dump looking for any unused words and deletes them if found.  To see if  any 
  have been found,  keep an eye on your file size variable before and after  a 
  tidy.  To  be honest,  its only really  necessary to use this function  with 
  large  files  around the 100k mark.  Tidy displays the  current  word  being 
  checked on files with more than 100 words. If you decide that the process is 
  taking  too  long and holding you up (this will happen if you have  a  large 
  number of individuals on your tree), you can abort it by pressing any key.  

  INFORMATION. 

  On startup the Family Roots program scans the disk for its information  text 
  file.  Information is only available if this file is found.  As your  family 
  tree  expands you may need more memory.  Leaving the text file off the  disk 
  frees approximately 30k. 

  CLEAR. 

  Resets the program to startup. All information is lost. 

  LOAD. 

  Load the specified file into memory from the current drive. 

  SAVE. 

  Saves  the file resident in memory to the current  drive.  Ocassionally  the 
  program  has  been known to go into an endless loop when  saving.  In  other 
  words,  it saves your file again and again. The way to avoid this is to move 
  the  mouse away from the 'Save' icon just as the saving process  is  ending. 
  This is an odd problem experienced by only a few users and we believe it may 
  be connected to certain third party replacement mice being a little too fast 
  in  their actions.  We think that we have solved the problem but  using  the 
  above method will get round it if necessary.

  QUIT. 

  Leaves the program and returns to Desktop. 

  SCREEN. 

  Exits  the  preference/option  screen  and  takes  you  back  to  the   main 
  workscreen. 

  PRINTER.

  Selecting  'PRINTER' allows the user to gain access to both the graphic  and 
  text printing functions.  Only the area covered by the block can be printed, 
  so if a block is undefined,  or if a defined block is empty of  individuals, 
  access to this section is denied.

  The  user can choose between printing graphics (the tree structure) or  text 
  (the database contents).  Two types of graphic output are available,  screen 
  dump and ASCII conversion.  Screen dumps must be used in conjunction with  a 
  dot  matrix  printer (or similar) whilst the ASCII mode is  compatible  with 
  both dot matrix and daisy wheel printers.

  So even if you own a daisy wheel printer you can still print out your family 
  tree structure.

  The graphic output options allow you to print in 10 different zoom levels.

  The graphic output uses the standard ROM ALT+HELP screen dump routine  which 
  is compatible with the majority of available printers. If however, you own a 
  non  compatible  printer,  help is at hand.  You must obtain and  install  a 
  Public Domain screen dump routine.  Contact Steve Delaney at Floppyshop  for 
  more information.

  A  disk  save option exists in parallel with the printing  options  allowing 
  both  text  and graphics to be saved to disk.  Text is saved as  a  standard 
  ASCII text file,  whilst the graphics are saved in Degas file format.  These 
  images can then be easily converted into Neochrome or other formats.

  Let's examine the printer screen display.  At the top of the screen you  can 
  view  the 2 block variables which give information regarding block size  and 
  contents.  Under these,  the 13 printing options are listed. Options 'A'-'J' 
  are the 10 graphic options.  Option 'K' is the database text  dump.  Options 
  'L' and 'M' cover the graphic to ASCII conversion modes.

  Each option is displayed along with its calculated area to give  information 
  regarding the number of screen images required to print the block.  A single 
  A4 sheet of paper can hold 2 screen images.

  Options  'L' and 'M' are both special in that they take the standard  screen 
  image  of the other graphic options and convert them into an  ASCII  format. 
  Using these two functions enables a much faster and cheaper (ink wise!)  way 
  of  getting a hard copy of your family tree.  Option 'M' is a   zoomed  (x2) 
  version of 'L'.

  Below  the  option table you can see the characters per  line  and  contents 
  selector.  The  contents selector enables you to choose between 5  types  of 
  text output. As previously described, options 'L' and 'M' convert into ASCII 
  but  you  can  choose  here  whether you want each line  to  be  80  or  160 
  characters long. The choice is mostly dependent upon your printer's ability. 
  If  your  printer  can manage 160 characters per line  then  all  is   well, 
  otherwise you must stick to a setting of 80.  Please note though,  that  you 
  must  manually set your printer to 160 character condensed mode.  It is  not 
  set  through  software.  However,  you  can use the  'Send  Printer  String' 
  function (see below) to set the necessary condensed mode. You need an output 
  of 20 dpi,  to fit 160 characters onto an 8 inch sheet width.  Try   sending 
  '1B 4D 0B.' This suits most formats and sets Elite with Condensed.  When you 
  have  chosen the option to use,  choose the appropriate selector box at  the 
  bottom  of  the screen.  Each option gives you a choice of saving  to  disk, 
  printing or just test viewing on screen.

  SETUP.

  Select this to gain access to the hardware printer preferences.  It is  here 
  that  you  can  tell the computer which kind  of  printer  you  have,  which 
  interface  you are using,  whether you need 1280 or 960 dots per  line  etc. 
  Also  included here is a means of talking directly to your printer  via  the 
  printer string function.

  Draft/Final only applies to dot matrix printers and in the majority of cases 
  will only work with those which use the 1280 dots per line mode.  It  really 
  depends on your make of printer. It's a case of try it out and see.

  Printer String Function.

  Located  by  'Printer  string' are 8 pairs  of  selector  boxes.  Each  pair 
  represents  a  single  byte.  You must set the 2  digits  to  represent  the 
  required  hexadecimal  command code that your printer understands  and  then 
  select 'Send String'.  The 8 bytes are each checked for a value greater than 
  0.  If found, the string is sent to the printer. The bytes are automatically 
  saved and loaded with your Family Roots data file.  Select 'Clear String' to 
  reset the 8 bytes back to zero. For more information regarding command codes 
  you must consult your printer manual.

  Character Mode Option.

  The  2 character mode bytes offers the user a little more  flexibility  with 
  the 'L'/'M' printing options.  Basically these 2 bytes hold the  hexadecimal 
  ASCII  values of the horizontal and vertical characters used by the  'L'/'M' 
  conversion  routine.  When  the program converts a  vertical  or  horizontal 
  screen  line into an ASCII character,  it takes the ASCII  equivalents  from 
  these  2 bytes.  They are initially set to $5f ('_') and $7c  ('|').  For  a 
  clearer understanding of what they do, set one of the bytes to say $2a ('*') 
  and then print out with 'L' or 'M' modes and all will be revealed.

  If your printer allows the downloading of your own ASCII character  designs, 
  you  could design better interpretations of the '|' and '_' and set the  new 
  relevant ASCII codes.

  PREFS.

  Select  'Prefs'  to  gain  access  to  the  various  display  commands.  The  
  selectors allow you to choose fonts, text case, field size etc.

  The  'Display  and Wait' command tells the program to wait for  a  user  key 
  press after each screen has been printed. This gives the user an opportunity 
  to change or re-align the paper in the printer if required.

  'Normal/Sideways' commands the program to either display the graphic options 
  upright  or  sideways.  Sideways though,  will only work in  the  4  highest 
  graphic  modes and due to the restrictions of the medium resolution  screen, 
  can  only work in high resolution.  With the sideways  option  enabled,  the 
  family  tree  is  printed in horizontal strips.  If  printing  normally  the 
  screens are printed in vertical strips.

  ADDITIONAL INFORMATION.

  For  best results,  I would advise you to keep your family tree  individuals 
  about  10-12 units apart horizontally and 6-8 units apart vertically on  the 
  grid. See the demo file for a rough guide.

  The  user must achieve a balance between text information and graphic  zoom. 
  Displaying  contents  (5)  with zoom option (G) will  usually  result  in  a 
  horrible mess.  The lower zooms must be used with the lower content  ranges, 
  although  the  higher  zooms  can  accommodate  all  content  possibilities. 
  Sometimes, if things get tight, removing the boxes can help a great deal.

  Remember  to  keep your block size as small as possible so that you  can  be 
  sure  of  the  least  amount of paper  being  used.  The  block  though,  is 
  automatically centralized onto the sheet(s).

  FONT LOADING.

  If required,  the Family Roots printing routines can use alternative  fonts. 
  To  use this function the font must be of FONTKIT format and must be of  the 
  8x8 character size. Place the font file you wish to use on your Family Roots 
  program disk and name it 'FONT.FMT'.  Then on program startup the file  will 
  be  loaded  and  available  for use  under  the  'STANDARD'  font  selector. 
  Floppyshop can supply a number of these fonts from its Public Domain Library 
  or  perhaps  you would like to design your own.  Contact  Steve  Delaney  at 
  Floppyshop for more information.
@
  ----------------------------------------------------------------------------
                      6  :  W  O  R  K  S  C  R  E  E  N 
  ----------------------------------------------------------------------------

  This  section  deals with the graphic display and  manipulation   functions. 
  Most  mouse selectable options are also available with a single  key  press. 
  The HELP key will display all the key press options available. 

  STATUS BAR.

  Located at the top of the screen, the status bar gives information regarding 
  mouse  position,  current  zoom level,  block position and  width.  All  X/Y 
  positions are grid positions and NOT screen pixel positions.

  The status bar can be hidden by pressing 'J' on the keyboard.

  SCROLLING. 

  Scrolling  can be initiated via the menu arrow icons and can be either  full 
  or part screen.  To achieve full screen scroll you must use the right  mouse 
  button instead of the left and if using the cursor keys,  pressing the shift 
  button at the same time has the same effect. 

  ZOOMING. 

  12 zoom levels are available with the lowest zoom displaying the  workscreen 
  in  its  entirety.  The '><' and '<>' icons  enable  mouse  zooming,  whilst 
  pressing the 'INSERT' and 'HOME' keys allow access from the keyboard. 

  MARK. 

  A  screen  position can be remembered by pressing 'M' on  the  keyboard.  To 
  recall this saved position, simply press 'D'. 

  GRID. 

  Selectable from the 'G' icon or 'G' on the keyboard, the Grid lines can be a 
  great help when aligning rows of individuals.  The grid only operates on the 
  top 3 zoom levels. 

  EDIT. 

  As described in the 'Getting started' section,  an individual's database can 
  be opened and viewed by clicking the right mouse button over its  rectangle. 
  Pressing  UNDO performs the same operation with the exception that the  most 
  centralised rectangle viewable is the one opened. 

  NEW. 

  New entries are created via the 'N' icon or by pressing 'N' on the keyboard. 
  A moveable rectangle will appear in place of the mouse cursor, this must now 
  be positioned where required and made permanent by clicking the left button. 

  MOVE ENTRY. 

  Moving  an individual is a staightforward procedure of clicking and  holding 
  down the left mouse button over the required rectangle.  When satisfied with 
  its new position, release the mouse button. 

  HIDE MENU. 

  Pressing 'H' on the keyboard will toggle the screen menu. 

  INFORMATION. 

  To access the online help (i.e. this manual), press 'I' on the keyboard. 

  ABORT DISPLAY MODE.

  If you have more than 1500 entries in your family tree,  the program  enters 
  into 'Abort Display Mode'.  In this mode,  the user can can exit the display 
  process with a right mouse click at any time. This feature has been included 
  to  help avoid the inevitable delay in screen redraws for those of  you  who 
  have very large family trees.  No appreciable slow down in screen redraws is 
  noticeable on files with less than 1500 entries.  Entering this mode enables 
  you  to  scroll  around quickly without having to wait  for  the  screen  to 
  update. Also, the screen displays in full view, i.e. you can see the drawing 
  process in action. 
@

  ----------------------------------------------------------------------------
        7  :  I  N  D  I  V  I  D  U  A  L     D  A  T  A  B  A  S  E 
  ----------------------------------------------------------------------------

  The  individual's  database details can be viewed by first  positioning  the 
  mouse  cursor  over  his/her rectangle and then  clicking  the  right  mouse 
  button.  All  personal details regarding the particular individual  are  now 
  accessible.  The  screen  will  initially  be  displaying  the  individual's 
  details,  although  marriage  partners,  children and parents  are  all  now 
  accessible by selecting the relevant icons with the mouse. 

  There are three ways of leaving a screen display. The most obvious  being to 
  click the RETURN icon on the screen,  although using RETURN on the  keyboard 
  is  sometimes more convenient.  Whenever you see an icon surrounded  with  a 
  bolder border,  it signifies that this function can be activated by pressing 
  RETURN on the keyboard. Lastly, pressing the right mouse button has the same 
  effect, automatically selecting the highlighted option. 

  You  will notice a four character code located at the top right hand  corner 
  of  the  database screen.  This represents the  individual's  identification 
  code.  It is unique to that person and cannot be changed, swapped or reused, 
  even if the person is deleted from the database. 

  The screen edit cursor can be positioned using either the cursor keys or the 
  mouse.  Pressing  Shift along with the cursor keys will speed up  left/right 
  movement. 

  When  leaving  any text screen,  the program checks that all text  and  date 
  strings  are  legal.  You may sometimes be asked to remove an  illegal  date 
  format or unacceptable text character. 

  DATABASE FUNCTIONS. 

  Text strings. 

  The database accepts multiple single line input strings,  where each  string 
  must be separated with a '/' character. For example, if I was unsure whether 
  a  person's surname was spelt 'SKELLERN' or 'SKELLHORNE',  I can  type  both 
  into  the  Surname  field  and  separate  them  with  a  '/'  character  eg; 
  'SKELLERN/SKELLHORNE'.  The program will support a maximum of 16 strings all 
  of which are scannable by the search function. 

  Date strings. 

  Date  string  format must be of the  universal  Day/Month/Year  format,  eg; 
  '17/3/1899'. The slash characters must be included. Sometimes a date is only 
  partially  known and in these cases a question mark can be used to fill  the 
  missing places eg;  '6/?/1723' or '?/?/185?'.  The program's search function 
  will still check these dates as normal and return any possible matches. 
 
  Sex. 

  Select the appropriate gender character. 

  Flags. 

  See preference section. 

  Burial date. 

  Sometimes  only a date of burial rather than date of death can be  obtained, 
  so  to record this fact,  a 'B' flag is located next to the 'Date of  Death' 
  field. Click the mouse cursor over it to toggle its state. 

  Parents. 

  The parents' names and birth dates are viewable through this function. 

  Unlink. 

  This function enables relationships (previously created) to the  individual, 
  to be broken. 

  Delete. 

  The  individual  will be deleted and removed from the file  in  memory.  All  
  information  connected with the individual is lost  and  irrecoverable.  The  
  identification code is not used again within this particular family tree. 

  Search. 

  Select this to go straight into the search screen display. 

  Zoom. 

  This  option will first take you back into graphic mode and then  zoom  into 
  the individual, positioning his/her rectangle at the centre of the screen

  Bros/Sisters. 

  Select this icon to obtain a list of all brothers and sister relationships. 

  Print. 

  This  will  make  a fast text copy of all  information  connected  with  the  
  individual.  Marriage  information,  brothers,  sisters and parents are  all 
  listed along with their identification codes.  The print information can  be 
  saved to disk or sent to the printer.

  Screen. 

  This takes you back to the current graphic display position. 

  Marriages. 

  Use this to access any information regarding the individual's partner(s). 

  MARRIAGE DATABASE. 

  The marriage screen layout is very similar to the individual's with  perhaps 
  the main exception being, the actual marriage information fields. 

  The text strings,  date strings, flags etc; all follow the same procedure as  
  previously described. 

  Each individual is limited to a maximum of 10 marriages. 

  MARRIAGE DATABASE FUNCTIONS. 

  Marriage Type. 

  The  type of marriage can be defined with the flags located at the top  left 
  of the screen. Church, Civil or other are available here. 

  Subject. 

  Select this function to return to the individual's database screen. 

  Create. 

  Enables new marriage partners to be added to the individual's database.  The 
  confirmation screen allows positioning within the marriage partner's file. 

  Next. 

  Assuming  that more than one marriage partner exists,  selecting  next  will  
  display the following partner in the file. 

  Delete. 

  The currently displayed marriage partner is removed and lost. 

  Children. 

  This  function  displays a list of any children connected to  the  currently 
  displayed  marriage  partner.  Note though,  that other children may  be  in 
  relationship to the individual via a different marriage partner. 

  Search. 

  This takes you straight into the search screen. 

  ID link. 

  In some circumstances,  husbands and wives may both feature within the  same 
  family tree. It is pointless to duplicate both individuals' personal details 
  onto each other's partner database screens,  so ID link allows you to insert 
  the   partner's   individual  identification  code  instead  of   any   text 
  information.  It  is then a simple matter of locating the partner  with  the 
  search ID code function. 
@
  ----------------------------------------------------------------------------
                          8  :  L  I  N  K  I  N  G 
  ----------------------------------------------------------------------------

  This mode can be selected via the 'L' icon on the screen menu or by pressing 
  'L' on the keyboard. Linking enables relationships to be created between the 
  individuals. 

  So,  assuming  the  Link mode has been selected,  the first thing  you  will 
  notice is the mouse arrow changing to a crosshair.  This new cursor must now 
  be  positioned  over the rectangle of one of the individuals to  be  linked. 
  Press and hold down the left mouse button,  now position the cursor over the 
  other rectangle involved.  Release the button and assuming contact has  been 
  established,  the  relationship  definition  screen  will  appear.  The  two 
  individuals  are displayed above each other on the left of the  screen.  Set 
  the  control  buttons  to the right of  the  individual,  to  establish  the 
  required relationship.  When completed,  the program will return you to  the 
  graphic  display but with the addition of a hard connection between the  two 
  individuals. 

  Obviously the program takes into account other persons already connected  to 
  the two individuals and links them all up automatically. 

  To break a link, see database section. 

  You may find as time goes by that many individuals cannot be linked into the 
  growing  tree structure.  These can be kept together down the sides  of  the 
  workscreen, perhaps in male/female groups or whatever appeals to you. 
@
  --------------------------------------------------------------------------------
                             9  :  B  L  O  C  K 
  --------------------------------------------------------------------------------

  The  block function is selected from the 'B' icon or by pressing 'B' on  the 
  keyboard.  The Block is invaluable when it comes to reorganising the  family 
  tree.  It  has other uses though,  one of which is a fast method of  zooming 
  into a particular section of the family tree.  Printing the tree graphics is 
  totally dependent upon the Block function.  Finally, the search function can 
  be instructed to scan only through the entries enclosed by the block. 

  BLOCK DEFINE. 

  As  with the Link function,  after selecting 'B',  the mouse cursor  changes 
  into  a  crosshair.  Now position the cursor at one of  the  proposed  block 
  corners,  press the left mouse button and with it held down, move the cursor 
  to create your block.  When satisfied,  release the mouse button to fix  the 
  block in position.

  BLOCK ZOOM. 

  Move  the  cursor arrow over the 'B' icon and instead of pressing  the  left 
  button,  press the right. The complete block will now zoom into view via the 
  highest possible accommodating zoom level. 

  BLOCK CLEAR. 

  Pressing 'C' on the keyboard will cancel any currently defined block. 

  BLOCK MOVE. 

  With the mouse arrow moved over the block, press the left button and with it 
  held down move the mouse to reposition as required. 

  BLOCK TRIM.

  The Block area and position can be accurately trimmed via the function keys. 
  F1 and F2 will move the left most edge of the block either left or right  by 
  1  grid unit.  F3 and F4 control the right side,  F7 and F8 control the  top 
  side whilst F9 and F10 control the bottom side.
@
  --------------------------------------------------------------------------------
                           10  :  S  E  A  R  C  H 
  --------------------------------------------------------------------------------

  The  search function gives the user the ability to search through the  whole 
  file  in  memory  and look for single  and  multiple  field  matches.  After 
  selecting  the  'S' icon,  or by simply pressing 'S' on  the  keyboard,  you 
  should be faced with the main search control screen. 

  Before I describe the individual functions,  I think it's best if you  carry 
  out a simple search on the demo file.  This will in turn make  understanding 
  the basic concept here easier. 

  With  the  demo file loaded (see getting started) and the search  screen  in 
  front of you, let's do a search. 

  Say I needed to create a list of any individuals born in   Cambridge.  Using 
  the mouse,  first select SUBJECT from the row of select boxes at the  bottom 
  of the screen.  The SUBJECT search edit screen is now  displayed.  Click the 
  mouse  arrow over the edit string labelled 'TOWN' within the birth  section. 
  Type  the name Cambridge and click the right mouse button to return  to  the 
  main search screen.  We must now instruct the program to carry out a  search 
  using  information from within the Subject edit screen,  so click the  mouse 
  over the text 'SUBJECT' which is located above the mouse select boxes at the 
  bottom of the screen. The text string should inverse itself, showing that it 
  is  'live'.  Next,  check that the 'SEARCH AREA' is set to  'ALL'.  Set  the 
  search  speed to 'SLOW' and we are ready for action.  Select SEARCH and  you 
  should  witness  the  return of any matches found.  When  the  operation  is 
  complete,  select VIEW from next to one of the 'finds' and you will be taken 
  directly to its database display.  The birth town will be Cambridge,  select 
  SEARCH  from  the icon and the program returns you straight  to  the  Search 
  screen. 

  The  search  fields  can be used alongside each  other  to  enable  multiple  
  testing.  For example,  I may need to look for a JON who is married and  was 
  born sometime in 1856! 

  The search date strings will support unknown values,  so by typing  ?/?/185? 
  as a birth date,  this will force the search routine to look for anyone born 
  between  1850 and 1859.  The text strings go one step further and allow  the 
  universal  '*'  wildcard  to be used.  Should I type in  'c*'  as  a  search 
  forename,  the  program will go on to return anyone who's name  begins  with 
  'C'. For example, you may need to obtain a list of individuals with the name 
  JOHN.  Typing  in  'JO*' as a search string will  cover  'JON',  'JOHN'  and 
  'JONATHAN', although you may get the odd 'Joanne' as well. 

  CATEGORY. 

  This setting determines which edit screen you want the program to use as its 
  search source information. 

  SEARCH AREA. 

  This setting decides on where you want the search to be performed. It can be 
  set to Block or All.  Selecting All is straightforward.  All entries  within 
  the workscreen are searched,  whilst selecting Block  instructs the  program 
  to search only those enclosed by the current Block.

  SPEED. 

  Fast  forces the program to search the entries before displaying any  finds, 
  while slow displays as it finds. 

  SCROLLING. 

  These allow the user to view the whole list of finds,  should it exceed  the 
  displayable 10. 

  SEARCH. 

  Select  this to initiate the search operation.  To abort,  click  the  right 
  mouse  button.  Clicking  the left mouse button will act  as  a  pause.  The  
  search buffer is limited to a maximum of 250 'finds'. 

  SCREEN. 

  This returns you to the graphic display. 

  SUBJECT. 

  This  takes  you into the search subject  screen.  Text,  dates  and  button 
  controls  all  operate as with the database screens.  A useful tip  is  that 
  prior  to  any new search operation,  select the clear icon to  guarantee  a 
  clean screen.  It only requires one forgotten code set or a burial flag set, 
  to mess up any search operation. 

  The  program allows a specific number of children,  marriages  or  brothers/ 
  sisters  to be scanned for.  Selecting a '?' will force the program to  look 
  for any number except zero. 

  An  important point regarding children count search is that when  using  the 
  subject  screen as the source count,  any finds will equal the total sum  of 
  children  for all his wives.  When using the marriage search screen  as  the 
  source you can look for a children count match to one partner only.

  It is important to remember,  that should an inversable search flag be  left 
  blank  (non-inversed),  it does not necessarily mean that the  program  will 
  search  only for a blank match.  For example,  if the search burial flag  is 
  left un-inversed, the search routine will then return any finds that include 
  both inversed and non inversed matches.   However, if the search burial flag 
  is inversed, then only  inversed matches are returned. This point applies to 
  all inversable search flags.
 
  MARRIAGE. 

  The marriage screen follows the same rules as the Subject screen. 

  MISC. 

  Selecting  this option takes you into the miscellaneous search screen  which 
  deals  with the general search functions.  There are four options  available 
  here.  These are text string search,  date scan search,  identification code 
  search  and marriage ID code link search.  The select buttons positioned  at 
  the bottom of the screen control which function is to be used. 

  TEXT STRING SEARCH. 

  This option offers a fast means of scanning all text categories rather  than 
  just a single field. You must select either 'Subject' or 'Marriage' from the 
  adjacent select button to decide on where it will scan within the database. 

  DATE SCAN. 

  This  mode  allows  you to define an upper and lower date  limit  which  the 
  program then uses in its date scan. Any dates found within the defined range 
  are returned.  As with the text string search,  the search category must  be 
  defined. 

  IDENTIFICATION CODE. 

  This search option requires the 4 character code as its source,  it  returns 
  the matching individual. 

  ID CODE LINK. 

  This  last search option deals with the marriage ID code link  function.  It 
  returns any individuals who have an ID linked partner.
