*Flash EPROM in circuit programmer for Atari ST
*Dev started on 27 March 2008.

* By P. Putnik


* for AMD 29F040B
*




; resource set indices for FLASHSTA
;
MAIN     equ 0 ; form/dialog
TITLEBX  equ 1 ; BOXTEXT in MAIN
STR1     equ 2 ; STRING in MAIN
EDBO1    equ 3 ; FBOXTEXT in MAIN
STR2     equ 4 ; STRING in MAIN
EDBO2    equ 5 ; FBOXTEXT in MAIN
EXITBU   equ 6 ; BUTTON in MAIN
DETFLBU  equ 7 ; BUTTON in MAIN
TXTDETFL equ 8 ; BOXTEXT in MAIN
LOADBU   equ 9 ; BUTTON in MAIN
STR4     equ 10 ; STRING in MAIN
TXTLDED  equ 11 ; BOXTEXT in MAIN
PROGRBU  equ 12 ; BUTTON in MAIN
AUTHOTXT equ 13 ; TEXT in MAIN
COLDBU   equ 14 ; BUTTON in MAIN
TOSITXT  equ 15 ; TEXT in MAIN
LOADSIZT equ 16 ; TEXT in MAIN

ALATPRG  equ 0 ; Alert string





  include gemdmacr.s 
  include aes2macr.s




progbeg

 
  move.l 4(sp),a4

  pea fin-progbeg+256 *len of program and bss
  move.l (a4),-(sp)  *TPA begin
  move.w #0,-(sp)
  move.w #74,-(sp)
  trap #1
*  lea 12(sp),sp

  lea stack+354,sp



aplinit
  appl_init

*Coordinate conversion-needed by integrated RSC
coordc
  moveq #0,d0

obfloop 
  move.w d0,obfia
  move.w d0,-(sp)

  rsrc_obfix
obfia  dc.w 0
  dc.l form1  *begin adress of objects

  move.w (sp)+,d0
  addq.b #1,d0
  cmp.b #rsc_obnum,d0 *
  bne.s obfloop


 *Determine is TOS in ROM or RAM:
  pea tphy(pc)
  move.w #38,-(sp)
  trap #14
  addq.l #6,sp 

   tst.b ramtos
   beq.s tinrom
   move.b #"A",text19+12  
tinrom

  *Get aktuell drive 
  move.w #25,-(sp)
  trap #1
  addq.l #2,sp

  lea path(pc),a2  
  add.b #"A",d0
  move.b d0,(a2) 



mcontrl  bsr mctrl *program takes maus controll
  lea form1(pc),a0
  bsr opdial
  bsr resscp *screen part reserve
  bsr drdial

*Main loop of dialog    
mcont
  bsr mafing *needed if is PRG (PRG startet with bee)
  bsr fodial

  move.w excod(pc),d0

   cmp.w #LOADBU,d0
   beq loadfil

   cmp.w #PROGRBU,d0
   beq programm

  cmp.w #COLDBU,d0
  beq hardreset


  cmp.w #EXITBU,d0
  beq cl2


menu
*  bsr mafing
  bsr exobdes  
  bra mcont

cl2  
  bsr mctab *vrati kontrolu

  bsr noredr *deselect exit button

*  bsr backsp

  

applex 
  appl_exit
  pterm0  *exit PRG


redrdial   bsr drdial
     bra menu  *back to dialog



hardreset  
  pea hardr2(pc)
  move.w #38,-(sp)
  trap #14

hardr2  clr.l $420.w *destroy memvalid
  move.l 4.w,a0
  jmp (a0) *jump in ROM start


loadfil 

  bsr mabee
  lea initst(pc),a1
  bsr putext  *put initial extension
*Call fileselector:
pfilesel
  lea fsloadm(pc),a1
  bsr filesel
  tst.b buffr+100
  beq redrdial  *dialog if nothing selected
  bsr mabee
  bsr drdial

*Open selected file
  move.w #0,-(sp)
  pea buffr+100(pc)
  move.w #61,-(sp) *open file
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi filerr
*  bmi redrdial  *no error message so!
  move.w d0,handl

  * Get filelen with fseek

  move.w #2,-(sp)  *from end mode
  move.w d0,-(sp) *handle
  clr.l -(sp)  *end
  move.w #66,-(sp)
  trap #1
  lea 10(sp),sp

  move.l d0,realfill   *real filelen for display
  cmp.l #$40000,d0  *is over 256KB ?
  ble.s max256
  move.l #$40000,d0 

max256
  move.l d0,filelen   *filelen to load


*Back to filebegin
  clr.w -(sp)  *from start mode
  move.w handl(pc),-(sp) *handle
  clr.l -(sp)  *start
  move.w #66,-(sp)
  trap #1
  lea 10(sp),sp


   
  pea conbuf(pc)
  move.l filelen(pc),-(sp)
  move.w handl(pc),-(sp)
  move.w #63,-(sp)
  trap #1
  lea 12(sp),sp
  tst.l d0
  bmi filerr    
  cmp.l filelen(pc),d0  *check for full filelength load
  bne filerr
  bsr closfile


*After it need to put filename to infobox...
* Filename is at buffr...
  lea text17(pc),a2
  lea buffr(pc),a1
  moveq #12,d2
teinc1 move.b (a1)+,(a2)+
  dbf d2,teinc1


*Print out filelength in hex:

  lea text20+7(pc),a1
  move.l realfill(pc),d1
  bsr prhex5




   bra redrdial
*   bra menu


filerr
  lea alertde(pc),a0
  bsr doalert
*  bra menu 

*Clear 'Loaded is' text:
  lea text17(pc),a2
  move.b #"-",(a2)+
  clr.b (a2)

  lea text20+7(pc),a2
  move.b #"-",(a2)+
  clr.b (a2)


  bra redrdial



programm 
*Different way depending on where is TOS ...

* Way 1:  TOS in RAM:
  tst.b ramtos
  beq progtosrom

  lea alerttrap(pc),a0
  bsr doalert
  bne menu   *if cancelled

  pea pro1su(pc)
  move.w #38,-(sp)
  trap #14
  addq.l #6,sp 

  tst.b errflag
  beq menu

  lea alertpe(pc),a0
  bsr doalert
  
  bra menu


pro1su 
  clr.b errflag
  move.w #$2222,$FFFF8240  *border and color #0 - grey
*  move.w #$2700,sr   *disable all interrupts

*Delay some half sec...

  move.l #160000,d2
lopau nop
  subq.l #1,d2
  bne.s lopau

   move.w #$0770,$FFFF8240  *border and color #0 - yellow


*For AMD29F040  must first erase 2 sectors (blocks) of 64KB

 *Must using doubled addresses !
*because of address shift 
*Writing to both Flash at once...

  move.w #$AAAA,$E00AAA
  move.w #$5555,$E00554
  move.w #$8080,$E00AAA
  move.w #$AAAA,$E00AAA
  move.w #$5555,$E00554
  move.w #$3030,$E00000

*Wait until erased fully:
  move.l #900000,d2  *for some timeout  10 sec aprox
ert1 sub.l #1,d2
  beq errorp
  move.w $E00000,d0
  and.w #$8080,d0  *test bits 7 for both chip
  cmp.w #$8080,d0
  bne.s ert1

  move.w #$0007,$FFFF8240  *border and color #0 - blue 

  move.w #$AAAA,$E00AAA
  move.w #$5555,$E00554
  move.w #$8080,$E00AAA
  move.w #$AAAA,$E00AAA
  move.w #$5555,$E00554
  move.w #$3030,$E20000  *second half of 64KB by chip

  *Wait until erased fully:
  move.l #900000,d2  *for some timeout  10 sec aprox
ert2 sub.l #1,d2
  beq errorp
  move.w $E20000,d0
  and.w #$8080,d0  *test bits 7 for both chip
  cmp.w #$8080,d0
  bne.s ert2

  

  move.w #$0700,$FFFF8240  *border and color #0 - red

 *Programming itself:

  lea $E00000,a2  *destination
  lea conbuf(pc),a1   *the content
  lea $E40000,a5  *for end test


*Pause some 1 sec

  move.l #250000,d1
pau1 nop
  subq.l #1,d1
  bne.s pau1


*Now starts programming:
mainloop
  move.w #$0770,$FFFF8240  *border and color #0 - yellow
*3 byte seq before each byte:

  move.w #$AAAA,$E0AAAA
  move.w #$5555,$E05554
  move.w #$A0A0,$E0AAAA
*  nop

  move.w (a1),(a2)  *data for programming

*Data polling:

  move.w (a1)+,d1  *data to check
  and.w #$8080,d1  *only bits 7

  move.l #500,d5  *for some timeout if error

polloop  move.w (a2),d2
  and.w #$8080,d2  *only bits 7
  cmp.w d1,d2
  beq.w succ1
  subq.l #1,d5
  bne.s polloop

*error

errorp  move.w col0(pc),$FFFF8240

  st errflag
  rts


succ1 *continue until E3FFFF
  move.w #$0007,$FFFF8240  *border and color #0 - blue 
  addq.l #2,a2
  cmp.l a2,a5
  bgt mainloop


*SW protection activate:

*  move.w #$AAAA,$E0AAAA
*  move.w #$5555,$E05554
*  move.w #$A0A0,$E0AAAA


   move.w #$0070,$FFFF8240  *border and color #0 - green, end

*pause 1 sec, then normal color

  move.l #340000,d2
lopau2 nop
  subq.l #1,d2
  bne.s lopau2

  move.w col0(pc),$FFFF8240

  rts




progtosrom   *todo



  bra menu




tphy   *move.l $42e.w,orgphyst

  move.l $FFFF8240,col0  *store col0

   move.l $42e.w,d4  *Phystop
   move.l $426.w,d1  *resvector
   cmp.l #$31415926,d1
   bne.s notramt
*Check is pointer right after phystop:
  move.l $42A.w,d2
  and.w #$FF00,d2
  cmp.l d2,d4
  bne.s notramt
  st ramtos
  bra.s ramtex
notramt clr.b ramtos
ramtex 

 *get TOS version too here

  move.l 4.w,d1
  clr.b d1  *on round address always
  move.l d1,a1
  move.b 2(a1),d0  *TOS ver major
  move.b 3(a1),d1  *TOS ver minor

  cmp.b #2,d0
  blt.s itstos1
  rts  *ret immed if TOS 2 or more

itstos1 cmp.b #4,d1
  blt.s under14
  rts

under14 st oldtos

  rts



prhex5 move.l d1,d5 
  swap d5
  and.w #$000f,d5
  bsr.s conv1

prhex4 move.w d1,d5 
  and.w #$f000,d5
  moveq #12,d4
  bsr.s conv
prhex3  move.w d1,d5
  and.w #$0f00,d5
  moveq #8,d4
  bsr.s conv
prhex2 move.w d1,d5
  and.w #$00f0,d5
  moveq #4,d4
  bsr.s conv
  move.w d1,d5
 and.w #$000f,d5 
  bra.s conv1
conv  lsr.w d4,d5
conv1  add.b #"0",d5
  cmp.b #"9",d5
  ble.s notlet
  addq.b #7,d5  *slovo A-F
notlet  move.b d5,(a1)+
  rts




  


closfile  move.w handl(pc),-(sp)
  move.w #62,-(sp)
  trap #1
  addq.l #4,sp
  rts

	

*AES dialog subrutines


*DRAW DIALOG SUBRUTINE
*In parameter:a0-tree adress

opdial *put tree adress on all places where needed 
  lea fca(pc),a1 
  move.l a0,(a1)
*  move.l a0,oda-fca(a1)
  move.l a0,fda-fca(a1)
  move.l a0,oca-fca(a1)
  move.l a0,oda2-fca(a1)
  move.l a0,oda2f-fca(a1)
  move.l a0,oda3-fca(a1)
*  move.l a0,oboff+2-fca(a1)
*centre objekt
  
  form_center
fca ds.l 1
*Enter coords
  lea cost(pc),a1 
  lea intout+2(pc),a0
  bsr.s copint2
  bsr.s copints
*  lea odp(pc),a1 
*  bsr.s copints
  lea odp2+4(pc),a1
  bsr.s copints
  lea fdf+2(pc),a1
  bsr.s copints
  bsr.s copints
  lea obnu+4(pc),a1
  
copints lea cost(pc),a0
copint2 moveq #3,d0
copil move.w (a0)+,(a1)+
  dbf d0,copil
  rts



*Reserve screen part
resscp
  form_dial
  dc.w 0
cost ds.w 8 
  rts



drdial 
  moveq #0,d0
  bra obdr  *ret via


*Object exit rutine "Form do"
  
fodial
  form_do
  dc.w 0
fda ds.l 1
  move.w intout(pc),excod  *Save exit button
  rts

cldial  bsr.s noredr

*Back screenpart
backsp
  form_dial
fdf dc.w 3
  ds.w 8

  rts

obsel move.w d0,obnu
  move.w #1,status
  bra.s ochl
obdes move.w d1,obnu
  bra.s clrstat

noredr  clr.w status+2  *No redraw by leave dialog
exobdes
  move.w excod(pc),obnu
clrstat  clr.w status  *normal status
ochl 
  objc_change
obnu dc.w 0,0,0,0,0,0
status  dc.w 0,1
oca ds.l 1
  move.w #1,status+2 * redraw needed after again
  rts



doalert
  move.l a0,ala
  form_alert
  dc.w 1  *Default
ala  dc.l 0 
  move.w intout(pc),d0
  cmp.w #1,d0 *test pressed key
  rts



obdr move.w d0,odp2
  objc_draw
odp2 dc.w 0,3 *depth=3 used
  ds.w 4
oda2 ds.l 1
  rts


clobdr  *startobject is mainbox 
  objc_draw
odp3 dc.w 0,2 *depth=2 used
clip3  ds.w 4
oda3 ds.l 1
  rts

obdrf move.w d0,odp2f
  bsr AEScall
  dc.w 42
odp2f dc.w 0,0
  ds.w 4
oda2f ds.l 1
  rts


mctrl
  wind_update
  dc.w 3
  rts

mctab
  wind_update
  dc.w 2
  rts

mafing moveq #3,d1
  bra.s grafmo
maarr moveq #0,d1
  bra.s grafmo
mabee moveq #2,d1
grafmo move.w d1,mousf
  graf_mouse
mousf dc.w 3
  dc.l 20000 *not used
  rts    






*Central rutine for param. adress serve etc.
AEScall  move.l (sp),a1  *reta
  move.w (a1)+,d0 *function number, a1 now hold intinadr (or reta)
  lea AESct-5(pc),a3
funsrl addq.l #5,a3
  cmp.b (a3),d0
  bne.s funsrl
  moveq #4,d1
  clr.l d0
  lea contrl(pc),a2
  move.l a2,a0
fuccl move.b (a3)+,d0
  move.w d0,(a2)+
  dbf d1,fuccl  
  
  lea AESPB(pc),a2
  move.l a1,8(a2) *pintin
  move.w 2(a0),d0  *# of intin
  lsl.w #1,d0  
  add.l d0,a1  *adress of addrin
  move.w 6(a0),d0
  beq.s noadrin
  move.l a1,16(a2) *paddrin
  lsl.w #2,d0  *mult by 4
  add.l d0,a1 
noadrin  move.l a1,(sp)  *Skip datas! -prepare retadress
  move.l a2,d1
  move.w #200,d0
  trap #2  *Call AES function
  rts


AESPB dc.l contrl  * pcontrol
pglobal dc.l global
pintin ds.l 1
pintout dc.l intout
paddrin ds.l 1
paddrout dc.l addrout

*Tables with AES control blocks of (only) used functions
AESct *must contents all in prg. used functions
  dc.b 10,0,1,0,0  *APPL init
  dc.b 19,0,1,0,0  *APPL exit
  dc.b 21,3,5,0,0  *EVNT button
  dc.b 23,0,1,1,0  *Evnt message
  dc.b 42,6,1,1,0  *Objc draw
  dc.b 43,4,1,1,0  *Objc find
  dc.b 44,1,3,1,0  *Objc offset
  dc.b 47,8,1,1,0  *Objc change
  dc.b 50,1,1,1,0  *Form do (dialog)
  dc.b 51,9,1,0,0  *Form dial
  dc.b 52,1,1,1,0  *Form alert
  dc.b 54,0,5,1,0  *Form center
  dc.b 78,1,1,1,0  *Graf mouse
  dc.b 79,0,5,0,0  *Graf mkstate
  dc.b 90,0,2,2,0  *Old Fsel for TOS 1.02 and 1.00
  dc.b 91,0,2,3,0  *Fsel input
  dc.b 107,1,1,0,0 *Wind update
  dc.b 114,1,1,1,0 *RSRC obfix
  dc.b 0
  even


filesel  clr.l buffr 
   
   tst.b oldtos
  bne.s fiselold

  move.l a1,fsmadr
  fsel_i  
*  bsr AEScall
*  dc.w 91,0,2,3,0 *Only for new TOS!!!
  dc.l path
  dc.l buffr
fsmadr ds.l 1  
  tst.w intout
  beq.s fisend
  tst.w intout+2
  beq.s fisend
  
fsok  lea buffr+100(pc),a1
  lea path(pc),a0
  bsr.s pdcopy
*Now drop attributes of select
droat 
  subq.l #1,a0
  cmp.b #"\",-(a1)  *is subdir end marker
  bne.s droat
  addq.l #1,a1  *move forward
  lea 2(a0),a2  *store ext (with . ) begin from path

  lea buffr(pc),a0
  tst.b (a0) *check for nothing selected or written
  beq.s fis2
  bra.s pdcopy
  
fisend 
fis2  clr.l buffr+100
  rts


fiselold  *AES 90 for older TOS

  fsel_input
  dc.l path
  dc.l buffr

  tst.w intout
  beq.s fisend
  tst.w intout+2
  beq.s fisend
  bra.s fsok



pdcopy 
  tst.b (a0)
  beq.s pdret 
  move.b (a0)+,(a1)+
  bra.s pdcopy

pdret move.b (a0),(a1)  *For case that longer was there prior
  rts


*Insert extension on path end
*a1 - pointer
putext lea path(pc),a0
searz  tst.b (a0)+
  bne.s searz
*Now search back for \
searbs cmp.b #"\",-(a0)
  bne.s searbs
  addq.l #1,a0

  moveq #5,d1  *copy 4-5 chars and zero term.
initc move.b (a1)+,(a0)+
  dbf d1,initc
  clr.b (a0)
  rts  










rsc_obnum equ 17



*rsc_obs	dc.w	16	* 17 objects in RSC *

form1	dc.w	-1,1,16
	dc.w	20,0,16		*0*
	dc.l	$21111
	dc.w	2,7,72,14

	dc.w	2,-1,-1
	dc.w	22,0,0		*1*
	dc.l	ted1
	dc.w	6,$500,52,$601

	dc.w	3,-1,-1
	dc.w	28,0,0		*2*
	dc.l	text1
	dc.w	1,$305,18,1

	dc.w	4,-1,-1
	dc.w	30,8,0		*3*
	dc.l	ted2
	dc.w	6,$706,7,1

	dc.w	5,-1,-1
	dc.w	28,0,0		*4*
	dc.l	text2
	dc.w	24,$405,12,1

	dc.w	6,-1,-1
	dc.w	30,8,0		*5*
	dc.l	ted3
	dc.w	26,$706,7,1

	dc.w	7,-1,-1
	dc.w	26,5
	dc.b	0
flag1	dc.b	0		*6*
	dc.l	text3
	dc.w	62,12,8,1

	dc.w	8,-1,-1
	dc.w	26,5
	dc.b	0
flag2	dc.b	0		*7*
	dc.l	text4
	dc.w	3,$70A,18,1

	dc.w	9,-1,-1
	dc.w	22,0,0		*8*
	dc.l	ted4
	dc.w	23,$70A,17,1

	dc.w	10,-1,-1
	dc.w	26,5
	dc.b	0
flag3	dc.b	0		*9*
	dc.l	text5
	dc.w	48,4,13,$201

	dc.w	11,-1,-1
	dc.w	28,0,0		*10*
	dc.l	text6
	dc.w	50,$505,10,1

	dc.w	12,-1,-1
	dc.w	22,0,0		*11*
	dc.l	ted5
	dc.w	47,$606,15,1

	dc.w	13,-1,-1
	dc.w	26,5
	dc.b	0
flag4	dc.b	0		*12*
	dc.l	text7
	dc.w	48,$509,13,$401

	dc.w	14,-1,-1
	dc.w	21,0,0		*13*
	dc.l	ted6
	dc.w	41,$30C,$612,1

	dc.w	15,-1,-1
	dc.w	26,5
	dc.b	0
flag5	dc.b	0		*14*
	dc.l	text8
	dc.w	60,$101,10,1

	dc.w	16,-1,-1
	dc.w	21,0,0		*15*
	dc.l	ted7
	dc.w	3,$303,14,1

	dc.w	0,-1,-1
	dc.w	21,32,0		*16*
	dc.l	ted8
	dc.w	48,8,13,1

		* Tedinfo blocks *

ted1	dc.l	text9,null,null
	dc.w	3,6,2,$1113
	dc.w	0,-1,52,1

ted2	dc.l	text10,text11,text12
	dc.w	3,6,2,$1180
	dc.w	0,-1,6,7

ted3	dc.l	text13,text14,text15
	dc.w	3,6,2,$1180
	dc.w	0,-1,6,7

ted4	dc.l	text16,null,null
	dc.w	3,6,2,$1180
	dc.w	0,-1,2,1

ted5	dc.l	text17,null,null
	dc.w	3,6,2,$1180
	dc.w	0,-1,2,1

ted6	dc.l	text18,null,null
	dc.w	5,6,0,$1180
	dc.w	0,-1,26,1

ted7	dc.l	text19,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,15,1

ted8	dc.l	text20,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,14,1

		* Free string / Alert data *

alert1	dc.b	'[1][After clicking OK, you have 10|seconds to set switches in cor-|rect positions.|End of programming is shown by |green border.][OK|Cancel]',0

alertde	dc.b	'[3][Load error!][Damn!]',0

alerttrap  dc.b	'[1][Set switches in correct pos. !| |    Enable writing !][Proceed|Cancel]',0

alertpe	dc.b	'[3][Programming error !][ $@# !! ]',0




		* Text data *

text1	dc.b	'Start offset, hex:',0
text2	dc.b	'Length, hex:',0
text3	dc.b	'E X I T',0
text4	dc.b	'Detect Flash type:',0
text5	dc.b	'LOAD CONTENT',0
text6	dc.b	'Loaded is:',0
text7	dc.b	'PROGRAMM !',0
text8	dc.b	'Cold boot',0
text9	dc.b	'Atari ST in-circuit Flash programmer for AMD 29F040',0
text10	dc.b	'-----',0
text11	dc.b	'$_____',0
text12	dc.b	'X',0
text13	dc.b	'-----',0
text14	dc.b	'$_____',0
text15	dc.b	'X',0
text16	dc.b	'      -      ',0
text17	dc.b	'      -      ',0
text18	dc.b	'V 0.1  By P. Putnik, 2008',0
text19	dc.b	'TOS is in: ROM',0
text20	dc.b	'Len: $       ',0
null	dc.b	0,0 








		

initst dc.b "*.*",0,0

  
fsloadm dc.b "LOAD CONTENT..",0



   even

oldtos dc.w 0
errflag ds.w 0

*Put here current drive.... :
path dc.b  "D:\*.*",0,0,0

  even

  SECTION BSS

  ds.b 512  *place for path

excod ds.w 1


contrl ds.w 5
global ds.l 16  
intout ds.w 7  *max 7
addrout ds.l 2  *max 2
emb ds.w 8  

ramtos ds.w 1
col0 ds.w 1

filelen ds.l 1
realfill ds.l 1
handl ds.w 1
orgphyst ds.l 1
buffr ds.b 512

conbuf ds.b $40000  *for 256KB

stack ds.b 368

fin



