* GUI Atari ST program JOYMOUT
* Purpose:  testing of attached mouse on port 0
*  and joystick(s) on port 1 and port 0

* By P. Putnik  2009


*First RSC object indices
; resource set indices for JOYMOUT
;
MAIND    equ 0 ; form/dialog
MOUBL    equ 1 ; ICON in MAIND
MOUBR    equ 2 ; ICON in MAIND
MOUBODY  equ 3 ; ICON in MAIND
EXITBU   equ 4 ; BUTTON in MAIND
JOYMID   equ 5 ; ICON in MAIND
JOYBUL   equ 6 ; ICON in MAIND
JOYBUR   equ 7 ; ICON in MAIND
JOYUP    equ 8 ; ICON in MAIND
JOYDWN   equ 9 ; ICON in MAIND
JOYRIG   equ 10 ; ICON in MAIND
JOYLEFT  equ 11 ; ICON in MAIND
STR1     equ 12 ; STRING in MAIND
STR2     equ 13 ; STRING in MAIND
JOYP0    equ 14 ; BUTTON in MAIND
JOYP1    equ 15 ; BUTTON in MAIND
VPOSSTR  equ 16 ; STRING in MAIND
VPOS     equ 17 ; TEXT in MAIND
HPOSSTR  equ 18 ; STRING in MAIND
HPOS     equ 19 ; TEXT in MAIND
TIT1     equ 20 ; BOXTEXT in MAIND
TIT2     equ 21 ; BOXTEXT in MAIND
INSTR1   equ 22 ; TEXT in MAIND
INSTR2   equ 23 ; TEXT in MAIND



* Assembled with  Devpac 3 !
  include gemdmacr.s 
  include aes2macr.s

* Everything is done with system calls
* No need to go in supervisor mode 


progbeg
 
  move.l 4(sp),a4
  pea fin-progbeg+256 *len of program and bss
  move.l (a4),-(sp)  *TPA begin
  move.w #0,-(sp)
  move.w #74,-(sp)   *Mshrink
  trap #1
  lea 12(sp),sp



aplinit
  appl_init

*Coordinate conversion-needed by integrated RSC
coordc
  moveq #0,d0

obfloop 
  move.w d0,obfia
  move.w d0,-(sp)

  rsrc_obfix
obfia  dc.w 0
  dc.l form1  *begin adress of objects

  move.w (sp)+,d0
  addq.b #1,d0
  cmp.b #rsc_obnum,d0   *
  bne.s obfloop


  
* Setting joystick monitoring rutine :

   move.w  #34,-(sp)   *Kbdvbase
   trap	#14
   addq.l    #2,sp    
  
   move.l  d0,a1
   lea 24(a1),a1   * Joystick vector
   move.l  (a1),joymorg  *Save original one (which is just an rts)
   move.l  #moni,(a1)



mcontrl  bsr mctrl *program takes maus controll
  lea form1(pc),a0
  bsr opdial
  bsr resscp *screen part reserve
  bsr drdial

  bsr mafing   *needed if is PRG (PRG startet with bee)


*Main loop of dialog    
 
mcont
   pea $600ff   * Testing keypress without waiting
   trap #1
   addq.l #4,sp

  tst.b   d0
  beq.s  tomou   *** T

  cmp.b  #13,d0   *Enter for exit
  beq cl2

  cmp.b  #"1",d0   * 1 for mouse mode
  beq   jp1s

  cmp.b  #"0",d0   * 0 for joy on mouse port
  beq   jp0s



tomou
    tst.b  flag2  
    bne   joyprc   *skip if no mouse

  * Doing mouse pos displaying:

   graf_mkstate   *Get mouse cursor pos and button states

   move.w  intout+2(pc),d1   *X pos
   cmp.w  lastx(pc),d1    * Skip if  not moved. otherwise cursor flashes
   beq.s  seeyp
   move.w  d1,lastx
   lea   text9(pc),a1
   bsr  decpri

* Redraw it:
   moveq  #HPOS,d0
   bsr   obdr
  
seeyp  move.w  intout+4(pc),d1   *Y pos
   cmp.w  lasty(pc),d1
   beq.s  drawmbs
   move.w  d1,lasty
   lea   text8(pc),a1
   bsr  decpri

* Redraw it:
   moveq  #VPOS,d0
   bsr   obdr

* Draw mouse button states only when changes:
drawmbs
  move.w  intout+6(pc),d1
  move.w  mouprev(pc),d2
  cmp.b  d1,d2
  beq.s  samemoub

* Left button:
  
  and.b #1,d1
  and.b #1,d2
  cmp.b d1,d2
  beq.s  rightbu

  lea  i_blk1+4(pc),a1
  tst.b  d1  *is pressed
  bne.s  lebupr
  
  move.l  #icon1,(a1)
  bra.s  draleb

lebupr    move.l  #icon2,(a1)

draleb  moveq  #MOUBL,d0
   bsr  obdr


rightbu   move.w  intout+6(pc),d1
  move.w  mouprev(pc),d2

* Right mouse button and left joy. but. on same line :
  
  and.b #2,d1
  and.b #2,d2
  cmp.b d1,d2
  beq.s  savemkst

  lea  i_blk2+4(pc),a1
  lea  i_blk5+4(pc),a2
  tst.b  d1  *is pressed
  bne.s  ribupr

  move.l  #icon1,(a1)
  move.l  #icon5,(a2)
  bra.s  drarib

ribupr    move.l  #icon2,(a1)
      move.l  #icon6,(a2)

drarib  moveq  #MOUBR,d0
   bsr  obdr

   moveq  #JOYBUL,d0
   bsr  obdr


savemkst    move.w  intout+6(pc),mouprev   *save last state

samemoub

   bsr  obfind   * Is some action button clicked ?
   tst.b  d0
   beq.s   joyprc


   cmp.w #EXITBU,d0
   beq cl2

   cmp.w  #JOYP0,d0
   beq   jp0sm
   
   cmp.w  #JOYP1,d0
   beq   jp1s


joyprc
   
  bsr    joyt

  bra mcont   *loop back



cl2    *Exit program

   bsr mctab *back control

   pea  ikbdres(pc)    *Back regular IKBD mode
   move.w  #1,-(sp)
   move.w  #25,-(sp)
   trap  #14
   addq.l  #8,sp


   move.w  #34,-(sp)   *Kbdvbase
   trap	#14
   addq.l    #2,sp    
  
   move.l  d0,a1
   lea 24(a1),a1   * Joystick vector
   move.l  joymorg(pc),(a1)   *Back original 
       
  
applex 
  appl_exit
  pterm0  *exit PRG



jp0sm   * when 0 is selected with mouse click

  * allow only when left button is released !

releast
     graf_mkstate 
     btst  #0,intout+7
     bne.s   releast

* 'Turn off' :
   lea  i_blk1+4(pc),a1
   move.l  #icon1,(a1)  
   moveq  #MOUBL,d0
   bsr  obdr

    bsr   delay


jp0s   *joystick port 0 selected

* Mouse off: 
    bsr   delay
  
   graf_mouse
   dc.w   256   *M_off
   dc.l   mmgpbuf   *dummy
*    dc.w   $A00A

    bsr  delay

    
*    pea  ikbdh12(pc)   * Disable mouse
*    move.w  #0,-(sp)
*    move.w  #25,-(sp)
*    trap  #14
*    addq.l  #8,sp

   pea  ikbdh14(pc)   * Set joystick event reporting mode
   * for case when  joystick is in mouse port - port 0
   move.w  #0,-(sp)
   move.w  #25,-(sp)
   trap  #14
   addq.l  #8,sp

   move.b  #1,flag2
   clr.b   flag3
   bra.s   dispjoys

jp1s   *joystick port 1 selected
    bsr   delay
    bsr   delay
    pea  ikbdres(pc)   *Reset IKBD for regular mode
    move.w  #1,-(sp)
    move.w  #25,-(sp)
    trap  #14
    addq.l  #8,sp
  
   
*    pea  ikbdh08(pc)   * Set relative mode
*    move.w  #0,-(sp)
*    move.w  #25,-(sp)
*    trap  #14
*    addq.l  #8,sp

   bsr   delay
      
   graf_mouse
   dc.w   257   *M_on  - Display mouse cursor
   dc.l   mmgpbuf   *dummy
*     dc.w   $A009

    move.b  #1,flag3
    clr.b   flag2

dispjoys
   moveq  #JOYP0,d0
   bsr  obdr

   moveq  #JOYP1,d0
   bsr  obdr

*   bra   mcont

   bra  joyprc


delay   *some delay:
  moveq  #7,d7
dell  move.w  #37,-(sp)
  trap  #14
  addq.l  #2,sp
  dbf   d7,dell

   rts


  * IKBD commands: 
ikbdh14   dc.b  $14,0   * Joystick event reporting
ikbdh12   dc.b  $12,0   *disable mouse
ikbdh08   dc.b   $08,0   *Set relative mode
ikbdh1A   dc.b  $1A,0   *disable joysticks
ikbdres    dc.b  $80,1,0,0



* Joystick action displaying:

joyt    move.w  joyc(pc),d1
   
   cmp.w  joyst(pc),d1
   bne.s   joysst   * If change, display

* Otherwise only in every 16th pass
   lea  pascnt2(pc),a2
   move.w  (a2),d2
   addq.w  #1,d2
   move.w  d2,(a2)
   and.w  #$F,d2
   bne  joytex

     
joysst 
   tst.b   flag2  * if 1 joy on port 0
   beq.s  joyon1

   move.b joyc(pc),joyc+2
   bra.s   joyt1

joyon1 move.b joyc+1(pc),joyc+2

joyt1
   move.b  joyc+2(pc),d1
   lea   i_blk10+4(pc),a1
   btst  #2,d1   *left

   bne.s  joylp

   move.l  #icon11,(a1)
   bra.s  showi10
joylp   move.l  #icon10,(a1)  

showi10  moveq  #JOYLEFT,d0
   bsr   obdr


   move.b  joyc+2(pc),d1
   lea   i_blk9+4(pc),a1
   btst  #3,d1   *right

   bne.s  joyrp

   move.l  #icon11,(a1)
   bra.s  showi9
joyrp   move.l  #icon9,(a1)  

showi9  moveq  #JOYRIG,d0
  bsr   obdr


   move.b  joyc+2(pc),d1
   lea   i_blk8+4(pc),a1
   btst  #1,d1       *up
   bne.s  joyupw

   move.l  #icon11,(a1)
   bra.s  showi8
joyupw   move.l  #icon8,(a1)  

showi8  moveq  #JOYUP,d0
   bsr   obdr


   move.b  joyc+2(pc),d1
   lea   i_blk7+4(pc),a1
   btst  #0,d1   *down

   bne.s  joydp

   move.l  #icon11,(a1)
   bra.s  showi7
joydp   move.l  #icon7,(a1)  

showi7  moveq  #JOYDWN,d0
  bsr   obdr

   tst.b   flag2    *if in mouse mode skip displaying of button press here
   beq.s  joystol


   move.b  joyc+2(pc),d1
   lea   i_blk5+4(pc),a1
   btst  #7,d1   *fire
   bne.s  joyfp

   move.l  #icon5,(a1)   
   bra.s  showi52
joyfp   move.l  #icon6,(a1)  

showi52  moveq  #JOYBUL,d0
  bsr   obdr

* Right joy button only if on port 0

   move.b  joyc+1(pc),d1
   lea   i_blk6+4(pc),a1
   btst  #7,d1   *2-ond fire button
   bne.s  joyf2p

   move.l  #icon5,(a1)   
   bra.s  showi6
joyf2p   move.l  #icon6,(a1)  

showi6  moveq  #JOYBUR,d0
  bsr   obdr




joystol
  move.w  joyc(pc),joyst   *Store latest state

joytex
   rts

joyst  dc.w  0   *Latest joystick state




moni     * Joystick monitoring, very simple:
  * it is at joyvec address set with   XBIOS 34

    addq.l  #1,a0   *a0 is odd 
    move.w  (a0),joyc    * first byte is for joy 0, second for joy 1
    rts   


	

*AES dialog subrutines


*DRAW DIALOG SUBRUTINE
*In parameter:a0-tree adress

opdial *put tree adress on all places where needed 
  lea fca(pc),a1 
  move.l a0,(a1)
*  move.l a0,oda-fca(a1)
  move.l a0,fda-fca(a1)
  move.l a0,oca-fca(a1)
  move.l a0,oda2-fca(a1)
  move.l a0,oda2f-fca(a1)
  move.l a0,oda3-fca(a1)
*  move.l a0,oboff+2-fca(a1)
*centre objekt
  
  form_center
fca ds.l 1
*Enter coords
  lea cost(pc),a1 
  lea intout+2(pc),a0
  bsr.s copint2
  bsr.s copints
*  lea odp(pc),a1 
*  bsr.s copints
  lea odp2+4(pc),a1
  bsr.s copints
  lea fdf+2(pc),a1
  bsr.s copints
  bsr.s copints
  lea obnu+4(pc),a1
  
copints lea cost(pc),a0
copint2 moveq #3,d0
copil move.w (a0)+,(a1)+
  dbf d0,copil
  rts



*Reserve screen part
resscp
  form_dial
  dc.w 0
cost ds.w 8 
  rts



drdial 
  moveq #0,d0
  bra obdr  *ret via


*Object exit rutine "Form do"
  
fodial
  form_do
  dc.w 0
fda ds.l 1
  move.w intout(pc),excod  *Save exit button
  rts

cldial  bsr.s noredr

*Back screenpart
backsp
  form_dial
fdf dc.w 3
  ds.w 8

  rts

obsel move.w d0,obnu
  move.w #1,status
  bra.s ochl
obdes move.w d1,obnu
  bra.s clrstat

noredr  clr.w status+2  *No redraw by leave dialog
exobdes
  move.w excod(pc),obnu
clrstat  clr.w status  *normal status
ochl 
  objc_change
obnu dc.w 0,0,0,0,0,0
status  dc.w 0,1
oca ds.l 1
  move.w #1,status+2 * redraw needed after again
  rts



doalert     *not used here
  move.l a0,ala
  form_alert
  dc.w 1  *Default
ala  dc.l 0 
  move.w intout(pc),d0
  cmp.w #1,d0 *test pressed key
  rts



obdr move.w d0,odp2
  objc_draw
odp2 dc.w 0,1 *depth=1 used
  ds.w 4
oda2 ds.l 1
  rts


clobdr  *startobject is mainbox 
  objc_draw
odp3 dc.w 0,2 *depth=2 used
clip3  ds.w 4
oda3 ds.l 1
  rts

obdrf move.w d0,odp2f
  bsr AEScall
  dc.w 42
odp2f dc.w 0,0
  ds.w 4
oda2f ds.l 1
  rts


obfind    *Calling after getting mouse pos
  * only if left button was pressed
   btst  #0,intout+7
   bne.s   action 
   clr.l  d0
   bra.s  obfex

action   move.l  intout+2(pc),xypos  *copy current pos
   objc_find
   dc.w  0  *
   dc.w  1  *Depth
xypos  dc.w 0,0
   dc.l   form1

   move.w  intout(pc),d0
obfex   rts




mctrl
  wind_update
  dc.w 3
  rts

mctab
  wind_update
  dc.w 2
  rts

* Setting mouse shape
mafing  moveq #3,d1
  bra.s grafmo
maarr moveq #0,d1
  bra.s grafmo
mabee moveq #2,d1
grafmo move.w d1,mousf
  graf_mouse
mousf dc.w 3
  dc.l 20000 *not used
  rts    



decpri   * Decimal outprint with no leading zeros
* in: d1-value, a1-adress for result(ASCI) max 9999 
  move.l #1000,d2
  moveq #3,d4
hex2  moveq #10,d3
  move.b #-$10,d5 *Space code prepare
hdlp ext.l d1
  divu d2,d1
  beq.s less
  clr.b d5
  bra.s moretz
less tst.b d4  *If is 0!
  bne.s skip
  clr.b d5
skip  move.b d5,d1
moretz add.b #$30,d1
  move.b d1,(a1)+
  swap d1
  divu d3,d2
  dbf d4,hdlp
  rts







*Central rutine for param. adress serve etc.
AEScall  move.l (sp),a1  *reta
  move.w (a1)+,d0 *function number, a1 now hold intinadr (or reta)
  lea AESct-5(pc),a3
funsrl addq.l #5,a3
  cmp.b (a3),d0
  bne.s funsrl
  moveq #4,d1
  clr.l d0
  lea contrl(pc),a2
  move.l a2,a0
fuccl move.b (a3)+,d0
  move.w d0,(a2)+
  dbf d1,fuccl  
  
  lea AESPB(pc),a2
  move.l a1,8(a2) *pintin
  move.w 2(a0),d0  *# of intin
  lsl.w #1,d0  
  add.l d0,a1  *adress of addrin
  move.w 6(a0),d0
  beq.s noadrin
  move.l a1,16(a2) *paddrin
  lsl.w #2,d0  *mult by 4
  add.l d0,a1 
noadrin  move.l a1,(sp)  *Skip datas! -prepare retadress
  move.l a2,d1
  move.w #200,d0
  trap #2  *Call AES function
  rts


AESPB dc.l contrl  * pcontrol
pglobal dc.l global
pintin ds.l 1
pintout dc.l intout
paddrin ds.l 1
paddrout dc.l addrout

*Tables with AES control blocks of (only) used functions
AESct *must contain all in prg. used functions
  dc.b 10,0,1,0,0  *APPL init
  dc.b 19,0,1,0,0  *APPL exit
  dc.b 21,3,5,0,0  *EVNT button
  dc.b 23,0,1,1,0  *Evnt message
  dc.b 25,16,7,1,0  *Evnt multi
  dc.b 42,6,1,1,0  *Objc draw
  dc.b 43,4,1,1,0  *Objc find
  dc.b 44,1,3,1,0  *Objc offset
  dc.b 47,8,1,1,0  *Objc change
  dc.b 50,1,1,1,0  *Form do (dialog)
  dc.b 51,9,1,0,0  *Form dial
*  dc.b 52,1,1,1,0  *Form alert
  dc.b 54,0,5,1,0  *Form center
  dc.b 78,1,1,1,0  *Graf mouse
  dc.b 79,0,5,0,0  *Graf mkstate
*  dc.b 90,0,2,2,0  *Old Fsel for TOS 1.02 and 1.00
*  dc.b 91,0,2,3,0  *Fsel input
  dc.b 107,1,1,0,0 *Wind update
  dc.b 114,1,1,1,0 *RSRC obfix
  dc.b 0
  even





* The RSC, integrated - asm source made with RSCTOASM
* RSC made with ORCS
* Some icon masks are dropped, as are same for diverse icons


rsc_obnum equ 24


	
*	rsc_obs	dc.w	23	* 24 objects in RSC *

form1	dc.w	-1,1,23
	dc.w	20,0,16		*0*
	dc.l	$21100
*	dc.w	$203,1,28,14
	dc.w	$203,1,$41C,$210

	dc.w	2,-1,-1
	dc.w	31,0,0		*1*
	dc.l	i_blk1
	dc.w	$615,$603,$1000,$1800

	dc.w	3,-1,-1
	dc.w	31,0,0		*2*
	dc.l	i_blk2
	dc.w	$717,$603,$1000,$1800

	dc.w	4,-1,-1
	dc.w	31,0,0		*3*
	dc.l	i_blk3
	dc.w	$615,$606,$2000,$2400

	dc.w	5,-1,-1
	dc.w	26,7
	dc.b	0
flag1	dc.b	0		*4*
	dc.l	text1
	dc.w	$713,$20C,7,1

	dc.w	6,-1,-1
	dc.w	31,0,0		*5*
	dc.l	i_blk4
	dc.w	$205,$605,$1000,$1000

	dc.w	7,-1,-1
	dc.w	31,0,0		*6*
	dc.l	i_blk5
	dc.w	$302,$203,$1000,$1000

	dc.w	8,-1,-1
	dc.w	31,0,0		*7*
	dc.l	i_blk6
	dc.w	$108,$203,$1000,$1000

	dc.w	9,-1,-1
	dc.w	31,0,0		*8*
	dc.l	i_blk7
	dc.w	$205,$503,$1000,$1000

	dc.w	10,-1,-1
	dc.w	31,0,0		*9*
	dc.l	i_blk8
	dc.w	$205,8,$1000,$1000

	dc.w	11,-1,-1
	dc.w	31,0,0		*10*
	dc.l	i_blk9
	dc.w	$707,$705,$1000,$1000

	dc.w	12,-1,-1
	dc.w	31,0,0		*11*
	dc.l	i_blk10
	dc.w	$702,$705,$1000,$1000

	dc.w	13,-1,-1
	dc.w	28,0,0		*12*
	dc.l	text2
	dc.w	$201,$70A,8,1

	dc.w	14,-1,-1
	dc.w	28,0,0		*13*
	dc.l	text3
	dc.w	$401,$10C,8,1

	dc.w	15,-1,-1
	dc.w	26,17
	dc.b	0
flag2	dc.b	0		*14*
	dc.l	text4
	dc.w	$70A,$30B,$701,1

	dc.w	16,-1,-1
	dc.w	26,17
	dc.b	0
flag3	dc.b	1		*15*  Preselected
	dc.l	text5
	dc.w	$50D,$30B,2,1

	dc.w	17,-1,-1
	dc.w	28,0,0		*16*
	dc.l	text6
	dc.w	$20D,$304,6,1

	dc.w	18,-1,-1
	dc.w	21,0,0		*17*
	dc.l	ted1
	dc.w	$70D,$605,5,1

	dc.w	19,-1,-1
	dc.w	28,0,0		*18*
	dc.l	text7
	dc.w	$30D,$407,6,1

	dc.w	20,-1,-1
	dc.w	21,0,0		*19*
	dc.l	ted2
	dc.w	$70D,$708,5,1

	dc.w	21,-1,-1
	dc.w	22,0,0		*20*
	dc.l	ted3
	dc.w	$500,$200,$61A,1

	dc.w	22,-1,-1
	dc.w	22,32,0		*21*
	dc.l	ted4
	dc.w	$407,$401,12,1


	dc.w	23,-1,-1
	dc.w	21,0,0		*22*
	dc.l	ted5
	dc.w	$700,$70D,27,$700

	dc.w	0,-1,-1
	dc.w	21,32,0		*23*
	dc.l	ted6
	dc.w	$300,15,$61B,$600


		* Tedinfo blocks *

ted1	dc.l	text8,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,5,1

ted2	dc.l	text9,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,5,1

ted3	dc.l	text10,null,null
	dc.w	3,6,2,$1180
	dc.w	0,-1,26,1

ted4	dc.l	text11,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,12,1


ted5	dc.l	text12,null,null
	dc.w	5,6,0,$1180
	dc.w	0,-1,36,1

ted6	dc.l	text13,null,null
	dc.w	5,6,0,$1180
	dc.w	0,-1,38,1


		* Iconblk data *

i_blk1	dc.l	mask1,icon1,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$18
	dc.w	0,0,0,8

i_blk2	dc.l	mask1,icon1,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$18
	dc.w	0,0,0,8

i_blk3	dc.l	mask3,icon3,null
	dc.w	$1000,0,0
	dc.w	0,0,$20,$24
	dc.w	0,0,0,8

i_blk4	dc.l	mask4,icon4,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$10
	dc.w	0,0,0,8

i_blk5	dc.l	mask6,icon5,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$10
	dc.w	0,0,0,8

i_blk6	dc.l	mask6,icon5,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$10
	dc.w	0,0,0,8

i_blk7	dc.l	mask10,icon11,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$10
	dc.w	0,0,0,8

i_blk8	dc.l	mask10,icon11,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$10
	dc.w	0,0,0,8

i_blk9	dc.l	mask10,icon11,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$10
	dc.w	0,0,0,8

i_blk10	dc.l	mask10,icon11,null
	dc.w	$1000,0,0
	dc.w	0,0,$10,$10
	dc.w	0,0,0,8

		* Icon data *

mask1	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE

icon1	dc.w	$FFFE   *Not pressed mouse button
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$8002
	dc.w	$FFFE




icon2	dc.w	$FFFE   *Pressed mouse button
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE
	dc.w	$FFFE


* Mouse body
mask3	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF
	dc.w	$FFFF,$FFFF

icon3	dc.w	$FFFF,$FFFF
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8000,1
	dc.w	$8005,$A001
	dc.w	$8005,$A001
	dc.w	$8005,$A001
	dc.w	$8005,$A001
	dc.w	$8009,$9001
	dc.w	$8009,$9001
	dc.w	$8009,$9001
	dc.w	$8011,$8801
	dc.w	$8061,$8601
	dc.w	$80C1,$8301
	dc.w	$8000,1
	dc.w	$FFFF,$FFFF

* Joystick center:
mask4	dc.w	0
	dc.w	$3E0
	dc.w	$FF8
	dc.w	$1FFC
	dc.w	$3FFE
	dc.w	$3FFE
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$3FFE
	dc.w	$3FFE
	dc.w	$1FFC
	dc.w	$FF8
	dc.w	$3E0
icon4	dc.w	0
	dc.w	          %1010100000
	dc.w	      %010101010000
	dc.w	      %101010101000
	dc.w	    %1010101010100
	dc.w	  %10101010101010
	dc.w	%101010101010101
	dc.w	%010101010101010
	dc.w	%101010101010101
	dc.w	%010101010101010
	dc.w	%101010101010101
	dc.w	  %10101010101010
	dc.w	    %1010101010100
	dc.w	      %101010101000
	dc.w	      %010101010000
	dc.w	          %1010100000


icon5	dc.w	$3E0   * Unpressed joy button
	dc.w	$C18
	dc.w	$1004
	dc.w	$2002
	dc.w	$2002
	dc.w	$4001
	dc.w	$4001
	dc.w	$4001
	dc.w	$4001
	dc.w	$4001
	dc.w	$2002
	dc.w	$2002
	dc.w	$1004
	dc.w	$C18
	dc.w	$3E0
	dc.w	0

mask6	dc.w	$3E0    * Common for 5 and 6
	dc.w	$FF8
	dc.w	$1FFC
	dc.w	$3FFE
	dc.w	$3FFE
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$3FFE
	dc.w	$3FFE
	dc.w	$1FFC
	dc.w	$FF8
	dc.w	$3E0
	dc.w	0

icon6	dc.w	$3E0   *Pressed  joy button
	dc.w	$FF8
	dc.w	$1FFC
	dc.w	$3FFE
	dc.w	$3FFE
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$7FFF
	dc.w	$3FFE
	dc.w	$3FFE
	dc.w	$1FFC
	dc.w	$FF8
	dc.w	$3E0
	dc.w	0

  * Now arrows:
icon7	dc.w	0
	dc.w	$180
	dc.w	$3C0
	dc.w	$7E0
	dc.w	$FF0
	dc.w	$1FF8
	dc.w	$318C
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180


icon8	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$180
	dc.w	$318C
	dc.w	$1FF8
	dc.w	$FF0
	dc.w	$7E0
	dc.w	$3C0
	dc.w	$180
	dc.w	0

icon9	dc.w	0
	dc.w	0
	dc.w	$40
	dc.w	$60
	dc.w	$30
	dc.w	$38
	dc.w	$3C
	dc.w	$7FFE
	dc.w	$7FFE
	dc.w	$3C
	dc.w	$38
	dc.w	$30
	dc.w	$60
	dc.w	$40
	dc.w	0
	dc.w	0

mask10	dc.w	$FFFF   *Same mask for all 4 arrows !
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF

icon10	dc.w	0
	dc.w	0
	dc.w	$200
	dc.w	$600
	dc.w	$C00
	dc.w	$1C00
	dc.w	$3C00
	dc.w	$7FFE
	dc.w	$7FFE
	dc.w	$3C00
	dc.w	$1C00
	dc.w	$C00
	dc.w	$600
	dc.w	$200
	dc.w	0
	dc.w	0

icon11     dc.w   0,0,0,0,0,0,0,0
                dc.w   0,0,0,0,0,0,0,0   *for inactive joy button


		* Text data *

text1	dc.b	'EXIT',0
text2	dc.b	'Joystick',0
text3	dc.b	'on port:',0
text4	dc.b	'0',0
text5	dc.b	'1',0
text6	dc.b	'V-pos:',0
text7	dc.b	'H-pos:',0
text8	dc.b	' 000',0
text9	dc.b	' 000',0
text10	dc.b	'Mouse and joystick tester',0
text11	dc.b	'By PP  2009',0
text12	dc.b	'Keys: 0-joystick mode  1-mouse mode',0
text13	dc.b	'Enter-EXIT. Press keys little longer.',0
null	dc.b	0,0 
		
	


  SECTION BSS

  
excod ds.w 1
mouprev  ds.l  1  *previous mouse button state
joymorg  ds.l   1

pascnt   ds.w  1
pascnt2   ds.w  1

lastx    ds.w  1
lasty    ds.w  1

* AES 
contrl ds.w 5
global ds.l 16  
intout ds.w 7  *max 7
addrout ds.l 2  *max 2
emb ds.w 8  

joyc  ds.l   1
mmgpbuf  ds.b 128

fin

