*GUI Atari ST program for splitting TOS ROM image files
* By P. Putnik, 2008 April, May



*First RSC object indices

; resource set indices for ROMSPLI2
;
MAINDI   equ 0 ; form/dialog
TITLE    equ 1 ; BOXTEXT in MAINDI
LOADIBU  equ 2 ; BUTTON in MAINDI
OPTBOX   equ 3 ; BOX in MAINDI
IN2PLHBU equ 4 ; BUTTON in MAINDI
IN6PBU   equ 5 ; BUTTON in MAINDI
IN4PTTBU equ 6 ; BUTTON in MAINDI
OPTTIT   equ 7 ; TEXT in MAINDI
LDEDIST  equ 8 ; TEXT in MAINDI
LOADEDIS equ 9 ; BOXTEXT in MAINDI
LENGTHT  equ 10 ; TEXT in MAINDI
SPLITBU  equ 11 ; BUTTON in MAINDI
EXITBU   equ 12 ; BUTTON in MAINDI 
FIXCRCBU equ 13 ; BUTTON in MAINDI


*Devpac !
  include gemdmacr.s 
  include aes2macr.s




progbeg

 
  move.l 4(sp),a4

  pea fin-progbeg+256 *len of program and bss
  move.l (a4),-(sp)  *TPA begin
  move.w #0,-(sp)
  move.w #74,-(sp)
  trap #1
*  lea 12(sp),sp

  lea stack+354,sp



aplinit
  appl_init

*Coordinate conversion-needed by integrated RSC
coordc
  moveq #0,d0

obfloop 
  move.w d0,obfia
  move.w d0,-(sp)

  rsrc_obfix
obfia  dc.w 0
  dc.l form1  *begin adress of objects

  move.w (sp)+,d0
  addq.b #1,d0
  cmp.b #rsc_obnum,d0 *
  bne.s obfloop


 *Calling some supervisor test at start by need
  pea supv(pc)
  move.w #38,-(sp)
  trap #14
  addq.l #6,sp 

   
  *Get aktuell drive 
  move.w #25,-(sp)
  trap #1
  addq.l #2,sp

  lea path(pc),a2  
  add.b #"A",d0
  move.b d0,(a2) 



mcontrl  bsr mctrl *program takes maus controll
  lea form1(pc),a0
  bsr opdial
  bsr resscp *screen part reserve
  bsr drdial

*Main loop of dialog    
mcont
  bsr mafing *needed if is PRG (PRG startet with bee)
  bsr fodial

  move.w excod(pc),d0

  *Here coming actions by button press


   cmp.w #LOADIBU,d0
   beq loadfil

   cmp.w #SPLITBU,d0
   beq split

   cmp.w #FIXCRCBU,d0
   beq fixcrc

   cmp.w #EXITBU,d0
   beq cl2


menu
*  bsr mafing
  bsr exobdes  
  bra mcont

cl2  
  bsr mctab *vrati kontrolu

  bsr noredr *deselect exit button

*  bsr backsp

  

applex 
  appl_exit
  pterm0  *exit PRG


redrdial   bsr drdial
     bra menu  *back to dialog






loadfil 

  bsr mabee
  lea initst(pc),a1
  bsr putext  *put initial extension
*Call fileselector:
pfilesel
  lea fsloadm(pc),a1
  bsr filesel
  tst.b buffr+100
  beq redrdial  *dialog if nothing selected
  bsr mabee
  bsr drdial

*Open selected file
  move.w #0,-(sp)
  pea buffr+100(pc)
  move.w #61,-(sp) *open file
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi filerr
*  bmi redrdial  *no error message so!
  move.w d0,handl

  * Get filelen with fseek

  move.w #2,-(sp)  *from end mode
  move.w d0,-(sp) *handle
  clr.l -(sp)  *end
  move.w #66,-(sp)
  trap #1
  lea 10(sp),sp

  move.l d0,realfill   *real filelen for display
  cmp.l #$40000,d0  *is over 256KB ?
  ble.s max256
  move.l #$40000,d0 

max256
  move.l d0,filelen   *filelen to load

*Back to filebegin
  clr.w -(sp)  *from start mode
  move.w handl(pc),-(sp) *handle
  clr.l -(sp)  *start
  move.w #66,-(sp)
  trap #1
  lea 10(sp),sp


   
  pea conbuf(pc)
  move.l filelen(pc),-(sp)
  move.w handl(pc),-(sp)
  move.w #63,-(sp)
  trap #1
  lea 12(sp),sp
  tst.l d0
  bmi filerr    
  cmp.l filelen(pc),d0  *check for full filelength load
  bne filerr
  bsr closfile


*After it need to put filename to infobox...
* Filename is at buffr...
  lea text11(pc),a2
  lea buffr(pc),a1
  moveq #12,d2
teinc1 move.b (a1)+,(a2)+
  dbf d2,teinc1


*Print out filelength in hex:

  lea text12+1(pc),a1
  move.l realfill(pc),d1
  bsr prhex5


*Copy path and filename for saving:

   lea buffr+100(pc),a0
   lea savfn(pc),a3
   moveq #102,d2
safnc move.l (a0)+,(a3)+
   dbf d2,safnc





   bra redrdial
*   bra menu


filerr
  lea alertde(pc),a0
  bsr doalert
*  bra menu 

*Clear 'Loaded is' text:
  lea text11(pc),a2
  move.b #"-",(a2)+
  clr.b (a2)

  bra redrdial




split   *3 branches

  bsr mabee

  tst.b flag2
  beq to6ortt

 *1 just to Lo/Hi - 2*128KB

*Replace file extension to HI

   lea hiet(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf(pc),a0
   move.l #$20000,d0
lp1 move.b (a0)+,(a1)+ 
   addq.l #1,a0
   subq.l #1,d0
   bne.s lp1

   bsr save128

   lea loet(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf(pc),a0
   move.l #$20000,d0
lp2  addq.l #1,a0
   move.b (a0)+,(a1)+
   subq.l #1,d0
   bne.s lp2

   bsr save128

   bra menu



replfe lea savfn(pc),a1
  *seek 0 terminator:

searzt  tst.b (a1)+
  bne.s searzt
*Now search back for \
searbs2 cmp.b #"\",-(a1)
  bne.s searbs2
  addq.l #1,a1

*Point to extension:
*Max 8 bytes after

  moveq #7,d2
seadot  cmp.b #".",(a1)
  beq.s dotfou
  tst.b (a1)
  beq.s dotfou  *break by 0 terminator
  cmp.b #" ",(a1)  *break by space too
  beq.s dotfou
  addq.l #1,a1
  dbf d2,seadot

dotfou
  moveq #4,d2  *4 or 5 byte to copy
extcol  move.b (a0)+,(a1)+
   dbf d2,extcol

  rts

 


save128

  move.w #0,-(sp)
  pea savfn(pc)
  move.w #60,-(sp) *Fcreate
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi saerr
  move.w d0,handl


  pea tosav
  pea $20000
  move.w d0,-(sp)
  move.w #64,-(sp)
  trap #1
  lea 12(sp),sp

  cmp.l #$20000,d0  *check for full filelength save
  bne saerr2


  bsr closfile
  rts

saerr2 bsr closfile

saerr  *give some alert
  lea alertsav(pc),a0
  bsr doalert


  rts




to6ortt

  tst.b flag3

  beq itstt

*Split to 6 parts of 32KB:

  *Replace file extension to HI0

   lea hie0(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf(pc),a0
   move.l #$8000,d0
lp3 move.b (a0)+,(a1)+ 
   addq.l #1,a0
   subq.l #1,d0
   bne.s lp3

   bsr save32

   lea loe0(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf(pc),a0
   move.l #$8000,d0
lp4  addq.l #1,a0
   move.b (a0)+,(a1)+
   subq.l #1,d0
   bne.s lp4

   bsr save32

   lea hie1(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf+$10000,a0
   move.l #$8000,d0
lp5 move.b (a0)+,(a1)+ 
   addq.l #1,a0
   subq.l #1,d0
   bne.s lp5

   bsr save32

   lea loe1(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf+$10000,a0
   move.l #$8000,d0
lp6  addq.l #1,a0
   move.b (a0)+,(a1)+
   subq.l #1,d0
   bne.s lp6

   bsr save32

   lea hie2(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf+$20000,a0
   move.l #$8000,d0
lp7 move.b (a0)+,(a1)+ 
   addq.l #1,a0
   subq.l #1,d0
   bne.s lp7

   bsr save32

   lea loe2(pc),a0
   bsr replfe

   lea tosav,a1
   lea conbuf+$20000,a0
   move.l #$8000,d0
lp8  addq.l #1,a0
   move.b (a0)+,(a1)+
   subq.l #1,d0
   bne.s lp8
 
   bsr save32

   bra menu


save32

  move.w #0,-(sp)
  pea savfn(pc)
  move.w #60,-(sp) *Fcreate
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi saerr
  move.w d0,handl


  pea tosav
  pea $8000
  move.w d0,-(sp)
  move.w #64,-(sp)
  trap #1
  lea 12(sp),sp

  cmp.l #$8000,d0  *check for full filelength save
  bne saerr2

  bsr closfile
  rts




itstt
*do it in 2 stages to not use too much RAM

*0
   lea tosav,a1
   lea conbuf(pc),a0
   move.l #$10000,d0
lp9 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp9

*Now load second half

   bsr lottsh

  
   lea tosav+$10000,a1
   lea conbuf(pc),a0
   move.l #$10000,d0
lp10 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp10


   lea tte0(pc),a0
   bsr replfe
   bsr save128

 

*1 
    bsr lottfh

   lea tosav,a1
   lea conbuf+1(pc),a0
   move.l #$10000,d0
lp11 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp11

*Now load second half

   bsr lottsh

  
   lea tosav+$10000,a1
   lea conbuf+1(pc),a0
   move.l #$10000,d0
lp12 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp12


   lea tte1(pc),a0
   bsr replfe
   bsr save128


  
*2 
    bsr lottfh

   lea tosav,a1
   lea conbuf+2(pc),a0
   move.l #$10000,d0
lp13 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp13

*Now load second half

   bsr lottsh

  
   lea tosav+$10000,a1
   lea conbuf+2(pc),a0
   move.l #$10000,d0
lp14 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp14


   lea tte2(pc),a0
   bsr replfe
   bsr save128


*3 
    bsr lottfh

   lea tosav,a1
   lea conbuf+3(pc),a0
   move.l #$10000,d0
lp15 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp15

*Now load second half

   bsr lottsh

  
   lea tosav+$10000,a1
   lea conbuf+3(pc),a0
   move.l #$10000,d0
lp16 move.b (a0)+,(a1)+ 
   addq.l #3,a0
   subq.l #1,d0
   bne.s lp16


   lea tte3(pc),a0
   bsr replfe
   bsr save128





  bra menu


lottsh  *load second half of TT ROM to buffer

  move.w #0,-(sp)
  pea buffr+100(pc)
  move.w #61,-(sp) *open file
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi filertt

  move.w d0,handl

  clr.w -(sp)  *from start mode
  move.w handl(pc),-(sp) *handle
  pea $40000  *at 256KB from start
  move.w #66,-(sp)
  trap #1
  lea 10(sp),sp
  tst.l d0
  bmi filertt2 

  pea conbuf(pc)
  pea $40000
  move.w handl(pc),-(sp)
  move.w #63,-(sp)
  trap #1
  lea 12(sp),sp
  tst.l d0
  bmi filertt2   
  cmp.l #$40000,d0  *check for full filelength load
  bne filertt2
  bsr closfile

  rts


lottfh  *load first half of TT ROM to buffer

  move.w #0,-(sp)
  pea buffr+100(pc)
  move.w #61,-(sp) *open file
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi filertt

  move.w d0,handl
 

  pea conbuf(pc)
  pea $40000
  move.w handl(pc),-(sp)
  move.w #63,-(sp)
  trap #1
  lea 12(sp),sp
  tst.l d0
  bmi filertt2   
  cmp.l #$40000,d0  *check for full filelength load
  bne filertt2
  bsr closfile

  rts


filertt2
  bsr closfile
filertt   
*drop caller
  addq.l #4,sp

  bra filerr



supv   *move.l $42e.w,orgphyst

  

 *get TOS version too here
*Good because of different fileselector possible

  move.l 4.w,d1
  clr.b d1  *on round address always
  move.l d1,a1
  move.b 2(a1),d0  *TOS ver major
  move.b 3(a1),d1  *TOS ver minor

  cmp.b #2,d0
  blt.s itstos1
  rts  *ret immed if TOS 2 or more

itstos1 cmp.b #4,d1
  blt.s under14
  rts

under14 st oldtos

  rts




  


closfile  move.w handl(pc),-(sp)
  move.w #62,-(sp)
  trap #1
  addq.l #4,sp
  rts

	

prhex5 move.l d1,d5 
  swap d5
  and.w #$000f,d5
  bsr.s conv1

prhex4 move.w d1,d5 
  and.w #$f000,d5
  moveq #12,d4
  bsr.s conv
prhex3  move.w d1,d5
  and.w #$0f00,d5
  moveq #8,d4
  bsr.s conv
prhex2 move.w d1,d5
  and.w #$00f0,d5
  moveq #4,d4
  bsr.s conv
  move.w d1,d5
 and.w #$000f,d5 
  bra.s conv1
conv  lsr.w d4,d5
conv1  add.b #"0",d5
  cmp.b #"9",d5
  ble.s notlet
  addq.b #7,d5  *slovo A-F
notlet  move.b d5,(a1)+
  rts



fixcrc
  *first check is 256KB long file loaded

   cmp.l #$40000,realfill
   bne loadfia

  bsr mabee
  bsr maincrc

  tst.b crcerf
  beq crcwasok

*Write last 4 bytes into loaded file:

  *Open selected file
  move.w #0,-(sp)
  pea buffr+100(pc)
  move.w #61,-(sp) *open file
  trap #1
  addq.l #8,sp
*Error check
  tst.w d0
  bmi filerr5
  move.w d0,handl
  

*Seek to CRC write pos
  clr.w -(sp)  *from start mode
  move.w handl(pc),-(sp) *handle
  pea   $3FFFC
  move.w #66,-(sp)
  trap #1
  lea 10(sp),sp


  pea conbuf+$3FFFC
  pea 4
  move.w handl(pc),-(sp)
  move.w #64,-(sp)
  trap #1
  lea 12(sp),sp

  cmp.l #4,d0  *check save
  bne saerr5

  bsr closfile
  
  lea alertcrcf(pc),a0
  bsr doalert
  bra menu

filerr5  lea alertde(pc),a0
  bsr doalert
  bra menu 

saerr5 
  bsr closfile
  lea alertsav(pc),a0
  bsr doalert
  bra menu


*CRC calculation part for TOS 2.06 :
*It is taken (disassembled) from TOS 2.06



maincrc    clr.b crcerf
	move.l	#$1FFFE,d7
	move.w	#1,d6
	lea 	conbuf(pc),a5
lE0080A	move.w	#2,-(a7)
	move.l	d7,-(a7)
	move.l	a5,-(a7)
	bsr.s	getcrc
	add.l	#$A,a7
	movea.l	a5,a0
	adda.l	#$3FFFC,a0
	move.b	(a0),d1
	lsl.w	#8,d1
	move.b	2(a0),d1
	cmp.w	d1,d0
*	bne.s	$E00858
	beq.s oddcrc
	st crcerf   *set flag

oddcrc	*Write new CRC to buffer :

	move.b d0,2(a0)
 	lsr.w #8,d0
	move.b d0,(a0)
	
	addq.l	#1,a5
	dbf	d6,lE0080A
	rts

 


crcerf dc.w 0   *error flag


getcrc
	movea.l	4(a7),a0
	move.l	8(a7),d2
	movea.w	$C(a7),a1
	clr.w	d0
	clr.w	d1
	clr.w	d3
	lea	crctable(pc),a2
lE015CC	move.w	d0,d1
	lsl.w	#8,d0
	lsr.w	#8,d1
	move.b	(a0),d3
	adda.l	a1,a0
	eor.b	d3,d1
	add.w	d1,d1
	move.w	0(a2,d1.w),d4
	eor.w	d4,d0
	subq.l	#1,d2
	bne.s	lE015CC
	rts


crctable
	DC.B	0,0,$10,$21,$20,$42,$30,$63
	DC.B	$40,$84,$50,$A5,$60,$C6,$70,$E7
	DC.B	$81,8,$91,$29,$A1,$4A,$B1,$6B
	DC.B	$C1,$8C,$D1,$AD,$E1,$CE,$F1,$EF
	DC.B	$12,$31,2,$10,$32,$73,$22,$52
	DC.B	$52,$B5,$42,$94,$72,$F7,$62,$D6
	DC.B	$93,$39,$83,$18,$B3,$7B,$A3,$5A
	DC.B	$D3,$BD,$C3,$9C,$F3,$FF,$E3,$DE
	DC.B	$24,$62,$34,$43,4,$20,$14,1
	DC.B	$64,$E6,$74,$C7,$44,$A4,$54,$85
	DC.B	$A5,$6A,$B5,$4B,$85,$28,$95,9
	DC.B	$E5,$EE,$F5,$CF,$C5,$AC,$D5,$8D
	DC.B	$36,$53,$26,$72,$16,$11,6,$30
	DC.B	$76,$D7,$66,$F6,$56,$95,$46,$B4
	DC.B	$B7,$5B,$A7,$7A,$97,$19,$87,$38
	DC.B	$F7,$DF,$E7,$FE,$D7,$9D,$C7,$BC
	DC.B	$48,$C4,$58,$E5,$68,$86,$78,$A7
	DC.B	8,$40,$18,$61,$28,2,$38,$23
	DC.B	$C9,$CC,$D9,$ED,$E9,$8E,$F9,$AF
	DC.B	$89,$48,$99,$69,$A9,$A,$B9,$2B
	DC.B	$5A,$F5,$4A,$D4,$7A,$B7,$6A,$96
	DC.B	$1A,$71,$A,$50,$3A,$33,$2A,$12
	DC.B	$DB,$FD,$CB,$DC,$FB,$BF,$EB,$9E
	DC.B	$9B,$79,$8B,$58,$BB,$3B,$AB,$1A
	DC.B	$6C,$A6,$7C,$87,$4C,$E4,$5C,$C5
	DC.B	$2C,$22,$3C,3,$C,$60,$1C,$41
	DC.B	$ED,$AE,$FD,$8F,$CD,$EC,$DD,$CD
	DC.B	$AD,$2A,$BD,$B,$8D,$68,$9D,$49
	DC.B	$7E,$97,$6E,$B6,$5E,$D5,$4E,$F4
	DC.B	$3E,$13,$2E,$32,$1E,$51,$E,$70
	DC.B	$FF,$9F,$EF,$BE,$DF,$DD,$CF,$FC
	DC.B	$BF,$1B,$AF,$3A,$9F,$59,$8F,$78
	DC.B	$91,$88,$81,$A9,$B1,$CA,$A1,$EB
	DC.B	$D1,$C,$C1,$2D,$F1,$4E,$E1,$6F
	DC.B	$10,$80,0,$A1,$30,$C2,$20,$E3
	DC.B	$50,4,$40,$25,$70,$46,$60,$67
	DC.B	$83,$B9,$93,$98,$A3,$FB,$B3,$DA
	DC.B	$C3,$3D,$D3,$1C,$E3,$7F,$F3,$5E
	DC.B	2,$B1,$12,$90,$22,$F3,$32,$D2
	DC.B	$42,$35,$52,$14,$62,$77,$72,$56
	DC.B	$B5,$EA,$A5,$CB,$95,$A8,$85,$89
	DC.B	$F5,$6E,$E5,$4F,$D5,$2C,$C5,$D
	DC.B	$34,$E2,$24,$C3,$14,$A0,4,$81
	DC.B	$74,$66,$64,$47,$54,$24,$44,5
	DC.B	$A7,$DB,$B7,$FA,$87,$99,$97,$B8
	DC.B	$E7,$5F,$F7,$7E,$C7,$1D,$D7,$3C
	DC.B	$26,$D3,$36,$F2,6,$91,$16,$B0
	DC.B	$66,$57,$76,$76,$46,$15,$56,$34
	DC.B	$D9,$4C,$C9,$6D,$F9,$E,$E9,$2F
	DC.B	$99,$C8,$89,$E9,$B9,$8A,$A9,$AB
	DC.B	$58,$44,$48,$65,$78,6,$68,$27
	DC.B	$18,$C0,8,$E1,$38,$82,$28,$A3
	DC.B	$CB,$7D,$DB,$5C,$EB,$3F,$FB,$1E
	DC.B	$8B,$F9,$9B,$D8,$AB,$BB,$BB,$9A
	DC.B	$4A,$75,$5A,$54,$6A,$37,$7A,$16
	DC.B	$A,$F1,$1A,$D0,$2A,$B3,$3A,$92
	DC.B	$FD,$2E,$ED,$F,$DD,$6C,$CD,$4D
	DC.B	$BD,$AA,$AD,$8B,$9D,$E8,$8D,$C9
	DC.B	$7C,$26,$6C,7,$5C,$64,$4C,$45
	DC.B	$3C,$A2,$2C,$83,$1C,$E0,$C,$C1
	DC.B	$EF,$1F,$FF,$3E,$CF,$5D,$DF,$7C
	DC.B	$AF,$9B,$BF,$BA,$8F,$D9,$9F,$F8
	DC.B	$6E,$17,$7E,$36,$4E,$55,$5E,$74
	DC.B	$2E,$93,$3E,$B2,$E,$D1,$1E,$F0
	DC.B	0,$1B,$31,$32,$33,$34,$35,$36
	DC.B	$37,$38,$39,$30,$2D,$3D,8,9
	DC.B	$71,$77,$65,$72,$74,$79,$75,$69
	DC.B	$6F,$70,$5B,$5D,$D,0,$61,$73
	DC.B	$64,$66,$67,$68,$6A,$6B,$6C,$3B
	DC.B	$27,$60,0,$23,$7A,$78,$63,$76
	DC.B	$62,$6E,$6D,$2C,$2E,$2F,0,0
	DC.B	0,$20,0,0,0,0

*CRC part end


loadfia lea alertlof(pc),a0
crccomo  bsr doalert
  bra menu

crcwasok lea alertcrcu(pc),a0
  bra.s crccomo



*AES dialog subrutines


*DRAW DIALOG SUBRUTINE
*In parameter:a0-tree adress

opdial *put tree adress on all places where needed 
  lea fca(pc),a1 
  move.l a0,(a1)
*  move.l a0,oda-fca(a1)
  move.l a0,fda-fca(a1)
  move.l a0,oca-fca(a1)
  move.l a0,oda2-fca(a1)
  move.l a0,oda2f-fca(a1)
  move.l a0,oda3-fca(a1)
*  move.l a0,oboff+2-fca(a1)
*centre objekt
  
  form_center
fca ds.l 1
*Enter coords
  lea cost(pc),a1 
  lea intout+2(pc),a0
  bsr.s copint2
  bsr.s copints
*  lea odp(pc),a1 
*  bsr.s copints
  lea odp2+4(pc),a1
  bsr.s copints
  lea fdf+2(pc),a1
  bsr.s copints
  bsr.s copints
  lea obnu+4(pc),a1
  
copints lea cost(pc),a0
copint2 moveq #3,d0
copil move.w (a0)+,(a1)+
  dbf d0,copil
  rts



*Reserve screen part
resscp
  form_dial
  dc.w 0
cost ds.w 8 
  rts



drdial 
  moveq #0,d0
  bra obdr  *ret via


*Object exit rutine "Form do"
  
fodial
  form_do
  dc.w 0
fda ds.l 1
  move.w intout(pc),excod  *Save exit button
  rts

cldial  bsr.s noredr

*Back screenpart
backsp
  form_dial
fdf dc.w 3
  ds.w 8

  rts

obsel move.w d0,obnu
  move.w #1,status
  bra.s ochl
obdes move.w d1,obnu
  bra.s clrstat

noredr  clr.w status+2  *No redraw by leave dialog
exobdes
  move.w excod(pc),obnu
clrstat  clr.w status  *normal status
ochl 
  objc_change
obnu dc.w 0,0,0,0,0,0
status  dc.w 0,1
oca ds.l 1
  move.w #1,status+2 * redraw needed after again
  rts



doalert
  move.l a0,ala
  form_alert
  dc.w 1  *Default
ala  dc.l 0 
  move.w intout(pc),d0
  cmp.w #1,d0 *test pressed key
  rts



obdr move.w d0,odp2
  objc_draw
odp2 dc.w 0,3 *depth=3 used
  ds.w 4
oda2 ds.l 1
  rts


clobdr  *startobject is mainbox 
  objc_draw
odp3 dc.w 0,2 *depth=2 used
clip3  ds.w 4
oda3 ds.l 1
  rts

obdrf move.w d0,odp2f
  bsr AEScall
  dc.w 42
odp2f dc.w 0,0
  ds.w 4
oda2f ds.l 1
  rts


mctrl
  wind_update
  dc.w 3
  rts

mctab
  wind_update
  dc.w 2
  rts

mafing moveq #3,d1
  bra.s grafmo
maarr moveq #0,d1
  bra.s grafmo
mabee moveq #2,d1
grafmo move.w d1,mousf
  graf_mouse
mousf dc.w 3
  dc.l 20000 *not used
  rts    






*Central rutine for param. adress serve etc.
AEScall  move.l (sp),a1  *reta
  move.w (a1)+,d0 *function number, a1 now hold intinadr (or reta)
  lea AESct-5(pc),a3
funsrl addq.l #5,a3
  cmp.b (a3),d0
  bne.s funsrl
  moveq #4,d1
  clr.l d0
  lea contrl(pc),a2
  move.l a2,a0
fuccl move.b (a3)+,d0
  move.w d0,(a2)+
  dbf d1,fuccl  
  
  lea AESPB(pc),a2
  move.l a1,8(a2) *pintin
  move.w 2(a0),d0  *# of intin
  lsl.w #1,d0  
  add.l d0,a1  *adress of addrin
  move.w 6(a0),d0
  beq.s noadrin
  move.l a1,16(a2) *paddrin
  lsl.w #2,d0  *mult by 4
  add.l d0,a1 
noadrin  move.l a1,(sp)  *Skip datas! -prepare retadress
  move.l a2,d1
  move.w #200,d0
  trap #2  *Call AES function
  rts


AESPB dc.l contrl  * pcontrol
pglobal dc.l global
pintin ds.l 1
pintout dc.l intout
paddrin ds.l 1
paddrout dc.l addrout

*Tables with AES control blocks of (only) used functions
AESct *must contents all in prg. used functions
  dc.b 10,0,1,0,0  *APPL init
  dc.b 19,0,1,0,0  *APPL exit
  dc.b 21,3,5,0,0  *EVNT button
  dc.b 23,0,1,1,0  *Evnt message
  dc.b 42,6,1,1,0  *Objc draw
  dc.b 43,4,1,1,0  *Objc find
  dc.b 44,1,3,1,0  *Objc offset
  dc.b 47,8,1,1,0  *Objc change
  dc.b 50,1,1,1,0  *Form do (dialog)
  dc.b 51,9,1,0,0  *Form dial
  dc.b 52,1,1,1,0  *Form alert
  dc.b 54,0,5,1,0  *Form center
  dc.b 78,1,1,1,0  *Graf mouse
  dc.b 79,0,5,0,0  *Graf mkstate
  dc.b 90,0,2,2,0  *Old Fsel for TOS 1.02 and 1.00
  dc.b 91,0,2,3,0  *Fsel input
  dc.b 107,1,1,0,0 *Wind update
  dc.b 114,1,1,1,0 *RSRC obfix
  dc.b 0
  even


filesel  clr.l buffr 
   
   tst.b oldtos
  bne.s fiselold

  move.l a1,fsmadr
  fsel_i  
*  bsr AEScall
*  dc.w 91,0,2,3,0 *Only for new TOS!!!
  dc.l path
  dc.l buffr
fsmadr ds.l 1  
  tst.w intout
  beq.s fisend
  tst.w intout+2
  beq.s fisend
  
fsok  lea buffr+100(pc),a1
  lea path(pc),a0
  bsr.s pdcopy
*Now drop attributes of select
droat 
  subq.l #1,a0
  cmp.b #"\",-(a1)  *is subdir end marker
  bne.s droat
  addq.l #1,a1  *move forward
  lea 2(a0),a2  *store ext (with . ) begin from path

  lea buffr(pc),a0
  tst.b (a0) *check for nothing selected or written
  beq.s fis2
  bra.s pdcopy
  
fisend 
fis2  clr.l buffr+100
  rts


fiselold  *AES 90 for older TOS

  fsel_input
  dc.l path
  dc.l buffr

  tst.w intout
  beq.s fisend
  tst.w intout+2
  beq.s fisend
  bra.s fsok



pdcopy 
  tst.b (a0)
  beq.s pdret 
  move.b (a0)+,(a1)+
  bra.s pdcopy

pdret move.b (a0),(a1)  *For case that longer was there prior
  rts


*Insert extension on path end
*a1 - pointer
putext lea path(pc),a0
searz  tst.b (a0)+
  bne.s searz
*Now search back for \
searbs cmp.b #"\",-(a0)
  bne.s searbs
  addq.l #1,a0

  moveq #5,d1  *copy 4-5 chars and zero term.
initc move.b (a1)+,(a0)+
  dbf d1,initc
  clr.b (a0)
  rts  


*The RSC integrated - source made with RSCTOASM


rsc_obnum equ 14

rsc_obs	dc.w	13	* 14 objects in RSC *

form1	dc.w	-1,1,13
	dc.w	20,0,16		*0*
	dc.l	$21100
	dc.w	0,$201,46,$50C

	dc.w	2,-1,-1
	dc.w	22,0,0		*1*
	dc.l	ted1
	dc.w	3,$400,39,$401

	dc.w	3,-1,-1
	dc.w	26,5
	dc.b	0
flag1	dc.b	0		*2*
	dc.l	text1
	dc.w	29,$502,16,$401

	dc.w	7,4,6
	dc.w	20,0,0		*3*
	dc.l	$FF1101
	dc.w	1,$203,27,7

	dc.w	5,-1,-1
	dc.w	26,17
	dc.b	0
flag2	dc.b	1		*4*  preselected
	dc.l	text2
	dc.w	5,1,17,$201

	dc.w	6,-1,-1
	dc.w	26,17
	dc.b	0
flag3	dc.b	0		*5*
	dc.l	text3
	dc.w	1,$103,25,$301

	dc.w	3,-1,-1
	dc.w	26,17
	dc.b	0
flag4	dc.b	0		*6*
	dc.l	text4
	dc.w	5,$405,16,$201

	dc.w	8,-1,-1
	dc.w	21,0,0		*7*
	dc.l	ted2
	dc.w	9,$602,11,1

	dc.w	9,-1,-1
	dc.w	21,0,0		*8*
	dc.l	ted3
	dc.w	32,$404,10,1

	dc.w	10,-1,-1
	dc.w	22,0,0		*9*
	dc.l	ted4
	dc.w	30,$505,14,1

	dc.w	11,-1,-1
	dc.w	21,0,0		*10*
	dc.l	ted5
	dc.w	34,$706,6,1

	dc.w	12,-1,-1
	dc.w	26,5
	dc.b	0
flag5	dc.b	0		*11*
	dc.l	text5
	dc.w	32,$308,11,$201

	dc.w	13,-1,-1
	dc.w	26,5
	dc.b	0
flag6	dc.b	0		*12*
	dc.l	text6
	dc.w	36,$40A,9,$401

	dc.w	0,-1,-1
	dc.w	26,37
	dc.b	0
flag7	dc.b	0		*13*
	dc.l	text7
	dc.w	13,11,20,1

		* Tedinfo blocks *

ted1	dc.l	text8,null,null
	dc.w	3,6,2,$1113
	dc.w	0,-1,29,1

ted2	dc.l	text9,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,12,1

ted3	dc.l	text10,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,11,1

ted4	dc.l	text11,null,null
	dc.w	3,6,2,$1180
	dc.w	0,-1,15,1

ted5	dc.l	text12,null,null
	dc.w	3,6,0,$1180
	dc.w	0,-1,7,1

		* Text data *

text1	dc.b	'LOAD IMAGE FILE',0
text2	dc.b	'In 2 parts - L/H',0
text3	dc.b	'In 6 parts L/H <=TOS 1.04',0
text4	dc.b	'In 4 parts - TT',0
text5	dc.b	' SPLIT ! ',0
text6	dc.b	' E X I T ',0
text7	dc.b	'Fix CRC for TOS 2.06',0
text8	dc.b	'Atari TOS ROM splitter by PP',0
text9	dc.b	' Split in: ',0
text10	dc.b	'Loaded is:',0
text11	dc.b	'      -       ',0
text12	dc.b	'    KB',0
null	dc.b	0,0 




alertde	dc.b	'[3][Load error!][Damn!]',0 
alertsav	dc.b	'[3][Save error!][Damn!]',0

alertcrcu   dc.b	'[0][    CRC was OK|Nothing is changed  ][Thanks]',0 

alertcrcf   dc.b	'[0][CRC is fixed !][Thanks]',0 

alertlof     dc.b 	'[3][First load ROM!][Yes]',0



initst dc.b "*.*",0,0

  
fsloadm dc.b "LOAD ROM...",0

*Extensions for save:

loet dc.b ".LO",0
hiet dc.b ".HI",0

loe0 dc.b ".LO0",0
hie0 dc.b ".HI0",0
loe1 dc.b ".LO1",0
hie1 dc.b ".HI1",0
loe2 dc.b ".LO2",0
hie2 dc.b ".HI2",0

tte0 dc.b ".TT0",0
tte1 dc.b ".TT1",0
tte2 dc.b ".TT2",0
tte3 dc.b ".TT3",0





   even

oldtos dc.w 0
errflag ds.w 0

*Put here current drive.... :
path dc.b  "D:\*.*",0,0,0

  even

  SECTION BSS

  ds.b 512  *place for path

savfn ds.b 512  *for save filename

excod ds.w 1


contrl ds.w 5
global ds.l 16  
intout ds.w 7  *max 7
addrout ds.l 2  *max 2
emb ds.w 8  


filelen ds.l 1
realfill ds.l 1
handl ds.w 1
orgphyst ds.l 1
buffr ds.b 512

conbuf ds.b $40000  *for 256KB
tosav ds.b $20000 *128K


stack ds.b 368

fin



