

; Timeset for Atari ST(E) machines with battery powered
; IKBD chip
; But is good without battery too

; There is a problem when year is 2000 and above
; because IKBD chip is not prepared for it
; Workaround is to write 20 years less, and by reading 
; after restart, power on  to  adding 20 years




*VT52 control codes:

*ESC is 27 dec.

*Cursor up   ESC A
*Cursor down  ESC B
*Cursor right  ESC C
*Cursor left  ESC D

*Clear screen  ESC E
*Home cursor  ESC H  (to upper left corner)
*Cursor up and insert  ESC I
*Erase to end of page  ESC J
*Erase to end of line  ESC K

*Insert line  ESC L
*Delete line  ESC M

*Set cursor pos   ESC Y  plus  Y and X pos (increased both by 32)

*Foreground color  ESC b  plus color #
*Background color  ESC c  plus color #

*Erase to start of page ESC d

*Show cursor  ESC e
*Hide cursor  ESC f

*Save cursor  ESC j
*Restore cursor  ESC k

*Erase line  ESC l
*Erase to line start  ESC o

*Reverse video  ESC p
*Normal video  ESC q

*Wrap at end of line  ESC v
*DIscard end of line  ESC w





enter  macro
  move.w #10,-(sp)
  trap #1
  addq.l #2,sp
  addq.l #6,(sp)
  endm

*Start

* Clear screen:
  lea clrs(pc),a1
  bsr pm

;Read Hardware Clock  
copyb  move.w #$17,-(sp)
  trap #14
  addq.l #2,sp 
  move.l d0,d1
  and.l #$001f0000,d1  ;Is Datum=0 ?
toch  beq.s entnew
  
;Write date & time in GEMDOS Clock
  move.w d0,-(sp) ;Save time
  swap d0

* Need to add 20 to year value:

  add.w #$2800,d0  *bits 25-31 are for year

  move.w d0,-(sp)
  move.w #$2b,-(sp)
  trap #1
  addq.l #4,sp
  move.w #$2d,-(sp)
  trap #1
  addq.l #4,sp

copye  bsr prtt
  lea ask(pc),a1
  bsr pm

*Some 5 sec time-out for correction
  move.w #15000,d7 *for delay

inpl  pea $600ff
  trap #1
  addq.l #4,sp

  tst.b d0
  beq.s pssl

  cmp.b #13,d0
  beq exit

  cmp.b #32,d0
  beq entnew
  
pssl  dbf d7,inpl 
  bra exit
 

entnew
  lea mess(pc),a1
  bsr pm
  lea eday(pc),a1
  bsr pm
  move.l #buff,a0
  move.l a0,-(sp)
  enter
  lea emon(pc),a1
  bsr pm
  enter
  lea eyear(pc),a1
  bsr pm 
  enter
  lea ehour(pc),a1
  bsr pm
  enter
  lea emin(pc),a1
  bsr pm
  move.w #10,-(sp)
  trap #1
  addq.l #2,sp
  move.l (sp)+,a0
  sub.l #22,a0
  bsr.s cve
  move d1,d3
  bsr.s cve
  move d1,d2
  bsr.s cve
*  sub.w #80,d1  ; old, before 2000 code
  add.w #20,d1  *for years after 2000
  lsl.w #5,d2
  lsl.w #5,d1
  lsl.w #4,d1
  add.w d2,d3
  add.w d3,d1
  move.w d1,-(sp)
  move.l a0,-(sp) 
  move.w d1,-(sp)
  move.w #$2b,-(sp)
  trap #1
  addq.l #4,sp
  move.l (sp)+,a0
  bsr.s cve
  move d1,d2
  bsr.s cve
  lsl.w #5,d1
  lsl.w #5,d2
  lsl.w #6,d2
  add.w d2,d1
  move.w d1,-(sp)
  move.w d1,-(sp)
  move.w #$2d,-(sp)
  trap #1
  addq.l #4,sp
  move.w (sp)+,d0
  move.w (sp)+,d1

*Here sub 20 from year to ensure correct IKBD work
  sub.w #$2800,d1

  swap d1
  move.w d0,d1

  move.l d1,-(sp)
  move.w #$16,-(sp)
  trap #14
  addq.l #6,sp ;Set Hardware Clock!
  bsr.s prtt
  bra end

cve  clr.l d0
  move.b (a0)+,d0
  sub.b #$30,d0
  move d0,d1
  move.b (a0)+,d0
  sub.b #$30,d0
  bmi.s non
  mulu #10,d1
  add d0,d1
non addq.l #4,a0
  rts

pm move.l a1,-(sp)
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp
  rts  

;Prttime  
prtt  move.w #$2a,-(sp)
  trap #1
  addq.l #2,sp
  move d0,d1
  andi #$1f,d1
  bsr conv
  move.w d2,day
  lsr.w #5,d0
  move d0,d1
  andi #$f,d1
  bsr conv
  move.w d2,month
  move.w d0,d1
  lsr.w #4,d1
  andi #$7f,d1
  bsr conv 
*  add.l #$31390800,d2  ; old before 2K
  move.l #$32300000,d0 ; new
  sub.w #$0200,d2  ; new
  move.w d2,d0  ; new
*  move.l d2,year
  move.l d0,year  ; new
  move.w #$2c,-(sp)
  trap #1
  addq.l #2,sp
  lsr.w #5,d0
  move d0,d1
  andi #$3f,d1
  bsr conv
  move.w d2,min
  move d0,d1
  lsr.w #6,d1
  andi #$1f,d1
  bsr conv
  move.w d2,clock
  pea message(pc)
  move.w #9,-(sp)
  trap #1
  addq.l #6,sp
  rts

end move.w #1,-(sp)
  trap #1  *wait keypress
  addq.l #2,sp
 
*To system  
exit  move.w #0,-(sp)
  trap #1 ; return to desktop


pmes move.w #9,-(sp)
  trap #1
  addq.l #6,sp
  move.w #1,-(sp)
  trap #1
  addq.l #2,sp
  rts




conv move.w #$2f00,d2
incm  add.w #$100,d2
  sub.w #10,d1
  bpl.s incm 
  add.w #$3a,d1
  add.w d1,d2
  rts 



clrs  dc.b 27,"E",0
*invclr dc.b 27,'E',27,'c',0,27,'b',15,0

    even

message dc.b 13,10,10,10,"Date:",7
  
day dc.b 1,1,"-",7
month dc.b 1,1,"-",7
year dc.b 1,1,1,1,13,10
  dc.b  7,"Time:"
clock dc.b 1,1,":",7
min dc.b 1,1,13,10,0,0
mess dc.b 13,10,10,10,"Please enter current time!",13,10,10,0
eday dc.b "day:",0,0
emon dc.b 13,10,"month:",0,0
eyear dc.b 13,10,"year(without century):",0,0
ehour dc.b 13,10,"hour:",0
emin dc.b 13,10,"minute:",0
ask dc.b 13,10,"Press RETURN to accept",13,10," or SPACE to change "
  dc.b "time!",13,10,0
buff dc.b 4,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0
