/********************************************************************
 FILENAME: MAINMS.CPP
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

 Copyright (c) 1994 by Jake Hill:
 If you use any part of this code in your own project, please credit
 me in your documentation and source code.  Thanks.
********************************************************************/

#include "TRIG.HPP"
#include "VIEW.HPP"
#include "KEYBOARD.HPP"

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

void main(int argc, char *argv[])
{
   short Px, Py, Ph;
   long FrameCount = 0L;
   unsigned short Pangle;
   char *WadFile = "DOOM.WAD";
   short Level = 0, Step = 8, Turn = 1024;

   View Map;
   if (argc == 2)
      Level = atoi(argv[1]);
   else if (argc == 3)
   {
      WadFile = argv[1];
      Level   = atoi(argv[2]);
   }
   Map.OpenWad(WadFile, Level);

   SetKeyboardInt();

   Map.GetView(&Px, &Py, &Ph, &Pangle);
   Map.SetView(Px,Py,Ph,Pangle);
   Map.DrawView();

   float T1,T2,dT;
   struct _dostime_t t1,t2;
   _dos_gettime(&t1);

   while ( key != 1 )
   {
      FrameCount++;

      if ( key_flags & FLAG_UP )
      {
         Px += xCosA( Step, Pangle );
         Py += xSinA( Step, Pangle );
      }
      if ( key_flags & FLAG_DOWN )
      {
         Px -= xCosA( Step, Pangle );
         Py -= xSinA( Step, Pangle );
      }

      if ( (key_flags & FLAG_SRIGHT) == FLAG_SRIGHT )
      {
         Px += xCosA( Step, Pangle-0x4000 );
         Py += xSinA( Step, Pangle-0x4000 );
      }
      else
      if ( key_flags & FLAG_RIGHT )
         Pangle -= Turn;

      if ( (key_flags & FLAG_SLEFT) == FLAG_SLEFT )
      {
         Px += xCosA( Step, Pangle+0x4000 );
         Py += xSinA( Step, Pangle+0x4000 );
      }
      else
      if ( key_flags & FLAG_LEFT )
         Pangle += Turn;

      if ( key == KEY_PLUS )
         Ph += 10;
      if ( key == KEY_MINUS )
         Ph -= 10;

      Map.SetView(Px,Py,Ph,Pangle);
      Map.DrawView();
   }

   _dos_gettime(&t2);
   Map.Close();

   T1 = t1.hsecond+(t1.second*100)+(t1.minute*6000);
   T2 = t2.hsecond+(t2.second*100)+(t2.minute*6000);
   dT = T2 - T1;
   float fps = (float) FrameCount / ( (float) dT / 100 );

   ResetKeyboardInt();

   printf("\n");
   printf("FPS = %f\n",fps);
   printf("Elapsed Time = %4.2f\n",dT/100);
};