#include "c_includes.h"
/*
 * cbzone_parseopts.c
 *  -- Todd W Mummert, December 1990, CMU
 *
 * ATARI Mods - Roland Givan Summer/Autumn/Winter 1993,94
 * I've really had to hack around at this file to make it suitable
 * for the Atari. Not pretty ;-(
 *
 * RCS Info
 *  $Header: c_parseopts.c,v 1.1 91/01/12 02:03:36 mummert Locked $
 *
 * Parse the options, read the MOTD, etc...
 *
 * The prints in these routines will never go the game window, as it
 * does not exist.  cbzone cannot be backgrounded from the beginning
 * since the execl will block on tty output.  To allow this we create
 * yet another flag that specifies that motd is not to be read.
 */

#ifdef ATARI
#define PRACTICE opt->practice = True;
#ifdef LATTICE
/* For the dfind() */
#include <dos.h>
#else
/* For stat() */
#include <sys/types.h>
#include <sys/stat.h>
#endif
#endif
#ifdef ATARI
extern int more(char *);
extern void version_dialog(char *);
#else
#define PRACTICE
#endif

#ifndef ATARI
int pager(file)
     char* file;
{
  char buf[100], *pager, *getenv();
  static char defaultpager[] = PAGER;
  FILE *f;

  if ((pager = getenv("PAGER")) == NULL)
    pager = defaultpager;
  sprintf(buf,"%s%s",TANKDIR,file);
  if ((f=fopen(buf,"r")) != NULL) {
    fclose(f);
    switch (fork()) {
    case 0:
      execl(pager,pager,buf,0);
      fprintf(stderr,"Exec of %s failed\n", pager);
      return 1;
    case -1:
      fprintf(stderr,"Unable to fork process\n");
      return 1;
    default:
      wait(0);
      break;
    }
  }
  else {
    fprintf(stderr,"File %s not found or unreadable.\n", buf);
    return 1;
  }
  return 0;
}
#else
int pager(file)
     char* file;
{
  char buf[100];

  sprintf(buf,"%s%s",TANKDIR,file);
  return(more(buf));
}
#endif

int getoptionint(s)
     char *s;
{
  char rest[100];
  int num;
  if (sscanf(s, "%d%s", &num, rest) != 1) {
    printf("Error in optional argument %s; use -help for help.\n",
           s);
#ifdef ATARI
    bale_out();
#else
    exit(0);
#endif
  }
  return(num);
}

/*
 * the following routine may be called in one of two ways...
 *  either w/ the display set or without...if without, then we
 *  will need to parse all the options...otherwise the resources should
 *  have taken care of most of them for us.
 *
 *  now even if the display is set, we may get options that were
 *  ambiguous.
 *
 *  since options are more than one letter, we can't use getopt.
 */
#ifndef ATARI
#define MAXOPTIONS 16	/* No idea why this is not 18! RMG */
#else
#define MAXOPTIONS 20	/* 20, now we have added 'fast' and 'no warn'. RMG */
#endif
#define OPTIONINT 7
void parseopt(argc, argv, status)
     int argc;
     char* argv[];
     Bool status;
{
  int i;
  Bool early_exit = False;

#ifdef LATTICE
/* These are for the dfind */
  struct FILEINFO info;
  		int attr=0;
#else
/* This is for STAT */
  struct stat statbuf;
#endif
  static char* optionnames[] = {
    "-xrm", "-delay", "-blocks", "-landers", "-tanks", "-missiles",
    "-salvos", "-coptersonly", "-quiet", "-scores", "-original",
    "-version", "-help", "-nooutput", "-mono", "-cursor",
    "-defaultcolormap", "-nofullscreen"
#ifdef ATARI
	,"-fast","-nowarn"
#endif
	};
#ifdef ATARI
  opt->loud = True;
  opt->fast = False;
  opt->output = True;
  opt->nowarn = False;

/* Set some defaults. Command line options will be in *addition* to these
not insead of */
  opt->original=False;
  opt->mblocks = 8;
  opt->copters = False;
  opt->mlanders = 1;
  opt->mmissiles = 1;
  opt->mtanks = 1;
  opt->msalvos = 1;
  opt->practice = False;

#ifndef LATTICE
  if (stat("CBZONEF.PRG",&statbuf)==0){
	opt->fast = True;
  }
#else
  if (dfind(&info,FAST_NAME,attr)==0){
    opt->fast = True;
  }
#endif

#endif
  for (argc--, argv++; argc>0; argc--, argv++) {
    for (i=0; i<MAXOPTIONS; i++)
      if (!strncmp(*argv,optionnames[i],strlen(*argv)))
        break;
    if (i < OPTIONINT) {
      argc--; argv++;
    }
    switch(i) {
    case 0:                     /* xrm */
      break;
    case 1:                     /* delay */
      opt->delay = getoptionint(*argv);
      break;
    case 2:                     /* blocks*/
      opt->mblocks = getoptionint(*argv);
	  PRACTICE
      break;
    case 3:                     /* landers */
      opt->mlanders = getoptionint(*argv);
	  PRACTICE
      break;
    case 4:                     /* tanks */
      opt->mtanks = getoptionint(*argv);
	  PRACTICE
      break;
    case 5:                     /* missiles */
      opt->mmissiles = getoptionint(*argv);
	  PRACTICE
      break;
    case 6:                     /* salvos */
      opt->msalvos = getoptionint(*argv);
	  PRACTICE
      break;
    case 7:                     /* copter practice */
      opt->copters = True;
	  PRACTICE
      break;
    case 8:                     /* quiet mode */
      opt->loud = False;
      break;
    case 9:                     /* scores only */
      opt->scores = True;
      break;
    case 10:                    /* original */
      opt->original = True;
      break;
    case 11:                    /* version */
      opt->version = True;
      break;
    case 12:                    /* help */
      opt->help = True;
      break;
    case 13:                    /* nooutput */
      opt->output = False;
      break;
    case 14:                    /* monocolor */
      opt->mono = True;
      break;
    case 15:                    /* cursor */
      opt->cursor = True;
      break;
    case 16:                    /* default colormap */
      opt->defaultcolormap = True;
      break;
    case 17:                    /* fullscreen */
      opt->fullscreen = False;
      break;
#ifdef ATARI
    case 18:
      opt->fast = True;		/* Turn off lots of junk */
      break;			/* This option might be useful for non Ataris too */
	case 19:
	  opt->nowarn = True;	/* Turn off warnings to do with hardware differences - see COOKIES.C, GEMSETUP.C */
	  break;
#endif
    }
  }

  if (opt->scores || opt->help || opt->version)
    early_exit = True;
  if (opt->output) {
#ifdef ATARI
    if (opt->help){
      pager("readme.st");
    }
    pager("cbzone.mot");
#else
    pager("cbzone.motd");
#endif

    if (opt->scores){
      scores(-1);
    }

    if (opt->version){ 
#ifdef ATARI
      version_dialog(VERSION);
#else
      printf("\nVersion \"%s\"\n", VERSION);
#endif
    }

#ifdef ATARI
    if (opt->help && pager("cbzone.hel"))
		help_dialog();
#else
    if (opt->help && pager("cbzone.help"))
      printf("Sorry help information not available.\n");
#endif

  } /* end if opt->output */

  if (early_exit){
#ifdef ATARI
	bale_out();
#else
    exit(0);
#endif
  }

  if (!status)
    return;

  if (opt->original) {
    opt->mblocks = 8;
    opt->copters = False;
    opt->mlanders = 1;
    opt->mmissiles = 1;
    opt->mtanks = 1;
#ifndef ATARI		/* Don't see why this should always be
			   a practice game! */
    opt->practice = True;
#else
    opt->practice = False;
#endif
    opt->msalvos = 1;
  }

  opt->menemies = (opt->mtanks > opt->mmissiles ?
                   opt->mtanks : opt->mmissiles);

  if (opt->copters){
    opt->mtanks = 0;
#ifdef ATARI
	/* *really* only have copters. RMG */
	opt->mlanders = 0;
	opt->msalvos = 1;
	opt->menemies = 1;
	opt->mblocks = 0;
	opt->mlanders = 0;
	opt->mmissiles = 1;
#endif
  }

  if (!opt->menemies) {
#ifndef ATARI
    printf("Must have at least one missile or tank.\n");
    exit(1);
#else
	opt->original=True;	/* just do a -original game. RMG */
    /* Do an ordinary 'original' game */
    opt->mblocks = 8;
    opt->copters = False;
    opt->mlanders = 1;
    opt->mmissiles = 1;
    opt->mtanks = 1;
    opt->msalvos = 1;
    opt->menemies = (opt->mtanks > opt->mmissiles ?
       	           opt->mtanks : opt->mmissiles);
    opt->practice = False;
#endif
  }

  if (opt->msalvos == -1)
    opt->msalvos = opt->menemies;
  opt->mobjects = opt->mblocks + opt->mlanders + 2*opt->menemies +
    opt->msalvos + 1;
  opt->estart = 1;
  opt->lstart = opt->estart + opt->menemies;
  opt->sstart = opt->lstart + opt->mlanders;
  opt->bstart = opt->sstart + opt->menemies + opt->msalvos;

  if (opt->mmissiles == MMISSILES &&
      opt->mtanks == MTANKS &&
      opt->mlanders == MLANDERS &&
      opt->mblocks == MBLOCKS &&
      opt->delay <= DELAY &&
      opt->msalvos == opt->menemies)
    opt->practice = False;
#ifndef ATARI
/* Don't see why this is here either.. RMG */
  else
    opt->practice = True;
#endif
}
