/* NEW MENU PROGRAM - Steve Ollett, 05-December 2001.
 * ===================================================================
 * Test Menu and Window Handling Routine.
 * Features of Program: 
 * a) Opening and closing window from menubar.
 * b) Closing, Moving, sizing, full/shrinking and topping window.
 * Adapted from Atari AES demo program, and Lattice C sample menu 
 * program.
 * =================================================================== */


/* INCLUDES
 * =================================================================== */
#include <stdlib.h>
#include <stdio.h>
#include <aes.h> 
#include <vdi.h>
#include <osbind.h>
#include <portab.h>
/* Resource file for Menubar */
#include "new_menu.h"			


/* DEFINES
 * =================================================================== */
#define VOID 	void


/* VDI Variables 
 * =================================================================== */
WORD 	contrl[12], intin[128], intout[128], ptsin[128], ptsout[128];
WORD	work_in[12], work_out[57];
WORD	vhandle, xres, yres, nplanes;
WORD 	phys_handle;


/* AES Variables 
 * =================================================================== */
WORD 	gl_apid, gl_hchar, gl_wchar, gl_hbox, gl_wbox;


/* OBJECT Tree Pointers 
 * =================================================================== */

/* RSC File menubar pointer  */
OBJECT *menu_ptr;				

/* Evnt_mesag() variable     */
WORD	msg[8];					

/* Window Handle             */
WORD 	wid;						

/* dummy variable            */
WORD	dummy;					

/* Menu item variables		 */
WORD 	checked;
WORD 	dimmed;

/* Variables for window RECTangle co-ordinates/sizes */
GRECT	desk;	
GRECT	CurRect;
GRECT	r;


/* Start_up
 * =================================================================== */
void 
Start_up( void )
{
	/* Load up Resource File etc. 
	   If RSC file not loaded, error dialog and end program */
	if (appl_init() )
		exit ( EXIT_FAILURE );
	if ( !rsrc_load ( "new_menu.rsc") )
	{
		form_alert ( 1,"[1][| Resource File Error ][ Quit ]");
		exit ( EXIT_FAILURE );
	}
	
	/* Get Details of Menubar */
	rsrc_gaddr(R_TREE, menu1, &menu_ptr);
	
	/* Switch ON Menubar */
	menu_bar(menu_ptr, 1);

	/* Ghost out 'Close' Option under 'File' on Menubar */ 		
	menu_ienable (menu_ptr, mclose, 0);

	phys_handle = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	
	/* Open Virtual Workstation */
	open_vwork();

	/* Set Mouse pointer as an Arrow */
	graf_mouse(ARROW, 0L);

	/* Get the full size of the Desktop */
	wind_get(0, WF_FULLXYWH, &desk.g_x, &desk.g_y, &desk.g_w, &desk.g_h);
	
	/* Co-ordinates and size of window to be opened */
	CurRect.g_x = desk.g_x;
	CurRect.g_y = desk.g_y;
	CurRect.g_w = 200; /* was 300 */
	CurRect.g_h = 150; /* was 200 */
}


/* InitWindow()
 * ===================================================================
 */
void
InitWindow( void )
{
		
	wid=0;
	/* Creates window with it's attributes, together with it's full screen
	   size defined */
	wid=wind_create(NAME|CLOSE|FULL|MOVE|INFO|SIZE|UPARROW|DNARROW|VSLIDE
			|LFARROW|RTARROW|HSLIDE, desk.g_x, desk.g_y, desk.g_w,
			desk.g_h);
	
	/* Add text to Name and Info bars of the window when it is open*/
	if (wid > 0) 
	{
		wind_set( wid, WF_NAME, " TEST WINDOW ");
		wind_set( wid, WF_INFO, " Info: ");	
	}
	/* Opens the window 'wid' with sizes specified in Start_up() */
	wind_open( wid, CurRect.g_x, CurRect.g_y, CurRect.g_w, CurRect.g_h);
}


/* DoFull()
 * ===================================================================
 */
void
DoFull ( WORD id)
{
	/* GRECT - Get co-ordinates of RECTangle */
	GRECT curr;		/* CURRent rectangle 		*/
	GRECT full;		/* FULL screen rectangle 	*/
	GRECT prev;		/* PREVious rectangle 		*/

	if ( id == wid ) {
		
		/* Gets size of current window/rectangle */
		wind_get ( id, WF_CURRXYWH, &curr.g_x, &curr.g_y, &curr.g_w, &curr.g_h);
		
		/* Gets size of full screen window/rectangle */
		wind_get ( id, WF_FULLXYWH, &full.g_x, &full.g_y, &full.g_w, &full.g_h);

		/* If both of the above are the same size, then gets size of previous rectangle.
		   Draws shrink box to size of smaller, previous sized rectangle.
		   Then sets the previous rectangle to currect rectangle.  */
		if ( rc_equal ( &curr, &full ) ) {
			wind_get ( id, WF_PREVXYWH, &prev.g_x, &prev.g_y, &prev.g_w, &prev.g_h);
				graf_shrinkbox( prev.g_x, prev.g_y, prev.g_w, prev.g_h, 
						full.g_x, full.g_y, full.g_w, full.g_h );
			wind_set ( id, WF_CURRXYWH, prev.g_x, prev.g_y, prev.g_w, prev.g_h );
		}
		/* If the above isn't the case, then it draws a grow box from the current size
	 	   up to the full screen size, and sets the current rectangle to full. */
		else {
			graf_growbox ( curr.g_x, curr.g_y, curr.g_w, curr.g_h,
					full.g_x, full.g_y, full.g_w, full.g_h );
			wind_set (id, WF_CURRXYWH, full.g_x, full.g_y, full.g_w, full.g_h);
		}
	}
}


/* DoSizer()
 * ===================================================================
 */
void
DoSizer ( WORD msg[] )
{
	GRECT rect;
	
	if ( msg[3] == wid ) {
		/* Gets size of current window */
		wind_set ( msg[3], WF_CURRXYWH, msg[4], msg[5], msg[6], msg[7] );
		/* Gets size of what it was previously */
		wind_set ( msg[3], WF_PREVXYWH, &rect.g_x, &rect.g_y, &rect.g_w, &rect.g_h );
		/* If the window is now bigger than it was then it will redraw the contents */
		if ((rect.g_w > msg[6] ) && ( rect.g_h >= msg[7] ) ||
			( rect.g_w >= msg[6] ) && ( rect.g_h > msg[7] ) )
				DoRedraw ( msg );
	}
}


/* DoRedraw()
 * ===================================================================
 */
DoRedraw ( WORD msg[] )
{
	GRECT r;
	GRECT rect;
	WORD xy[4];

	r.g_x = msg[4];
	r.g_y = msg[5];
	r.g_w = msg[6];
	r.g_h = msg[7];

	wind_update ( 1 );
	if ( msg[3] == wid ) {
		/* Get current area of window */
		wind_get ( msg[3], WF_FIRSTXYWH, &rect.g_x, &rect.g_y, &rect.g_w, &rect.g_h );
		while (rect.g_w && rect.g_h ) {
			if ( rc_intersect ( &r, &rect ) )
			{
				/* Hide mouse while contents are redrawn */
				graf_mouse ( M_OFF, 0L );

				/* set virtual workscreen area to match area and size of
	  			   current window */			
				xy[0] = rect.g_x;
				xy[1] = rect.g_y;
				xy[2] = rect.g_x + rect.g_w - 1;
				xy[3] = rect.g_y + rect.g_h - 1;
				
				/* Clip area of screen not fitting within window */
				vs_clip (vhandle, 1, xy );

				vswr_mode (vhandle, MD_REPLACE);

				/* Draw filled bar inside window */
				vsf_interior (vhandle, 4);
				vsf_style (vhandle, 1);
				vsf_perimeter (vhandle, 0);
				v_bar (vhandle, xy);
		
				/* Show mouse again now drawing complete */		
				graf_mouse ( M_ON, 0L );
			}
			wind_get ( msg[3], WF_NEXTXYWH, &rect.g_x, &rect.g_y, &rect.g_w, &rect.g_h);
		}
	}
	wind_update ( 0 );	
}


/* Open_vwork()
 * ===================================================================
 */
WORD
open_vwork( void )
{
	WORD i;

	work_in[0] = Getrez()+2;
	for ( i = 1; i < 10; work_in[i++] = 1 )
	;
	work_in[10] = 2;
	vhandle = phys_handle;
	v_opnvwk (work_in, &vhandle, work_out );
	xres = work_out[0];
	yres = work_out[1];

	vq_extnd(vhandle, 1, work_out );
	nplanes = work_out[4];

	return ( vhandle );
}



/* close_vwork()
 * ===================================================================
 */
VOID
close_vwork(void)
{
	if (vhandle != -1 )
	{
		v_clsvwk (vhandle);
		vhandle = -1;
	}
}


/* End_prg()
 * =================================================================== */
void 
End_prg( void )
{
	/* If 'Quit' and window still open, delete window */
	if ( wid> 0)
		{
		wind_delete (wid);
		}

	/* Turn OFF Menubar */
	menu_bar (menu_ptr, FALSE);

	/* Mouse Pointer set to 'Arrow' */	
	graf_mouse (ARROW, 0L);

	/* Clear Resource file from memory */
	rsrc_free();

	/* Close virtual workstation */
	close_vwork();

	/* Exit application back to desktop */
	appl_exit();
}
	

/* Do_loop
 * =================================================================== */
void 
Do_loop( void )
{
WORD 	button;
BOOLEAN	done;

/* While 'done' equals 'false' check for:-
   1. Menu items selected.
   2. Window elements being selected. */

done = FALSE;
	do
	{		
	evnt_mesag( msg );
	
	wind_update ( BEG_UPDATE );

		if( msg[0] == MN_SELECTED )
		{
			switch ( msg[4] )
			{
					
			case mquit:
				button = form_alert(1,"[1][ | Exit Program? ][OK|Cancel]");
				if (button == 1)
					done = TRUE;
				break;

			case mabout:
				form_alert(1,"[1][ | New Menu Program | ---------------- | By S. Ollett | 05-Dec-2001 ][ OK ]");
				break;

			case mopen:
				if (!wid)
					{
					InitWindow();
					menu_ienable (menu_ptr, mopen, 0);
					menu_ienable (menu_ptr, mclose, 1);
					}
				break;

			case mclose:
				if(wid) 
					{
					wind_get( wid, WF_CURRXYWH, &CurRect.g_x, &CurRect.g_y,
 					&CurRect.g_w, &CurRect.g_h);
					wind_close (wid);
					wind_delete (wid);
					wid=0;
						
					menu_ienable (menu_ptr, mclose, 0);
					menu_ienable (menu_ptr, mopen, 1);
					}
				break;

			case mcheckme:
				checked^=1;
				menu_icheck(menu_ptr,mcheckme,checked);
				break;
	
			case mdimme:
				dimmed^=0;
				menu_ienable(menu_ptr,mdimme,dimmed);
				break;	

			case mnotes:
				form_alert(1,"[0][  New Menu Program  |  ----------------  | Updates to include:  | Dialog Handling. ][ OK ]");
				break;
			
			default:
				break;	
			}			
		}

		menu_tnormal (menu_ptr, msg[3], TRUE);

		if ( msg[0] !=MN_SELECTED ) 
		{
			switch (msg[0] ) 
			{

			case WM_FULLED:
				DoFull ( msg[3] );
				wind_set( wid, WF_INFO, " Info: Window Fulled ");
				break;

			case WM_REDRAW:
				DoRedraw ( msg );
				wind_set( wid, WF_INFO, " Info: Window Redrawn ");
				break;

			case WM_ARROWED:
			case WM_HSLID:
			case WM_VSLID:
				break;

			case WM_MOVED:
				if ( msg[3] == wid ) 
				{
					wind_set ( wid, WF_CURRXYWH, msg[4], msg[5], msg[6], msg[7] );
					wind_set( wid, WF_INFO, " Info: Window Moved ");	
				}
				break;

			case WM_CLOSED:
				if ( msg[3] == wid ) 
				{
					wind_get ( wid, WF_CURRXYWH, &CurRect.g_x, &CurRect.g_y,
 					&CurRect.g_w, &CurRect.g_h);		
					wind_close ( wid );
					wind_delete ( wid );
					wid = 0;
					menu_ienable ( menu_ptr, mclose, 0);
					menu_ienable ( menu_ptr, mopen, 1);
				}
				break;
					
			case WM_SIZED:
				DoSizer ( msg );
				wind_set( wid, WF_INFO, " Info: Window Sized ");
				break;					
	
			case WM_TOPPED:
				if ( msg[3] == wid )
				{
					wind_set ( wid, WF_TOP );
					wind_set( wid, WF_INFO, " Info: Window Topped ");

				}
				break;
	
			default:
				break;
			}
		}
	
		wind_update (END_UPDATE);
			
		}while(!done);
}

			

/* MAIN()
 * =================================================================== */
VOID
main(void)
{	
	Start_up();
	Do_loop();
	End_prg();
}
